/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.convert.entity.InOutNoticeOrderConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.entity.IInOutNoticeOrderService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InOutNoticeOrderServiceImpl
extends BaseServiceImpl<InOutNoticeOrderDto, InOutNoticeOrderEo, IInOutNoticeOrderDomain>
implements IInOutNoticeOrderService {
    @Autowired
    BaseOrderFacade baseOrderFacade;

    public InOutNoticeOrderServiceImpl(IInOutNoticeOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InOutNoticeOrderDto, InOutNoticeOrderEo> converter() {
        return InOutNoticeOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> cancel(String documentNo) {
        List inOutNoticeOrderEos = ((IInOutNoticeOrderDomain)this.domain).queryByDocumentNo(documentNo);
        AssertUtils.notEmpty((Collection)inOutNoticeOrderEos, (String)"\u901a\u77e5\u5355\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728");
        final InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        BaseOrderCommonCancelBo baseOrderCommonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(documentNo).relevanceNo(inOutNoticeOrderEo.getRelevanceNo()).sourceType(inOutNoticeOrderEo.getBusinessType()).businessType(inOutNoticeOrderEo.getBusinessType()).build();
        baseOrderCommonCancelBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutNoticeOrderContext) {
                    ((InOutNoticeOrderContext)context).setInOutNoticeOrderEo(inOutNoticeOrderEo);
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        if ("in".equals(inOutNoticeOrderEo.getOrderType())) {
            this.baseOrderFacade.inNoticeOrderCancel(baseOrderCommonCancelBo);
        } else {
            this.baseOrderFacade.outNoticeOrderCancel(baseOrderCommonCancelBo);
        }
        return RestResponse.VOID;
    }
}

