/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.abstracts;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.ds.BaseMapper;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.ReceiveDeliveryNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReceiveDeliveryNoticeOrderAble
implements ReceiveDeliveryNoticeOrderAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractReceiveDeliveryNoticeOrderAble.class);
    @Resource
    GenerateCodeUtil generateCodeUtil;
    @Resource
    public IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    public IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    public IBaseOrderAddressDomain baseOrderAddressDomain;

    @Override
    public void doGenerate(ReceiveDeliveryNoticeOrderContext context) {
        log.info("\u751f\u6210\u6536\u53d1\u8d27\u901a\u77e5\u5355,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)context));
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = this.getReceiveDeliveryNoticeOrderEo(context);
        List<ReceiveDeliveryNoticeOrderDetailEo> detailEoList = this.getReceiveDeliveryNoticeOrderDetailEos(context, receiveDeliveryNoticeOrderEo);
        context.setReceiveDeliveryNoticeOrderEo(receiveDeliveryNoticeOrderEo);
        context.setReceiveDeliveryNoticeOrderDetailEoList(detailEoList);
        this.wrapperGenerate(context);
        context.execBefore();
        log.info("\u751f\u6210\u6536\u53d1\u8d27\u901a\u77e5\u5355,\u53c2\u6570context:{}", (Object)JSONObject.toJSONString((Object)context));
        if (!context.isOnlyGenResult() || !context.getAutoComplete().booleanValue()) {
            this.receiveDeliveryNoticeOrderDomain.insert((BaseEo)context.getReceiveDeliveryNoticeOrderEo());
            this.receiveDeliveryNoticeOrderDetailDomain.insertBatch(context.getReceiveDeliveryNoticeOrderDetailEoList());
        }
        Optional.ofNullable(context.getBaseOrderAddressEoList()).map(docu -> docu.stream().peek(d -> d.setDocumentNo(receiveDeliveryNoticeOrderEo.getRelevanceNo())).collect(Collectors.toList())).ifPresent(arg_0 -> ((IBaseOrderAddressDomain)this.baseOrderAddressDomain).insertBatch(arg_0));
        context.execAfter();
        this.wrapperGenerateAfter(context);
    }

    public List<ReceiveDeliveryNoticeOrderDetailEo> getReceiveDeliveryNoticeOrderDetailEos(ReceiveDeliveryNoticeOrderContext context, ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo) {
        return context.getOrderBasicsDetailReqDtoList().stream().map(d -> {
            ReceiveDeliveryNoticeOrderDetailEo detailEo = (ReceiveDeliveryNoticeOrderDetailEo)BeanUtil.copyProperties((Object)d, ReceiveDeliveryNoticeOrderDetailEo.class, (String[])new String[0]);
            detailEo.setDocumentNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
            detailEo.setPreOrderNo(receiveDeliveryNoticeOrderEo.getPreOrderNo());
            detailEo.setRelevanceNo(receiveDeliveryNoticeOrderEo.getRelevanceNo());
            detailEo.setExternalOrderNo(receiveDeliveryNoticeOrderEo.getExternalOrderNo());
            detailEo.setPlanQuantity(d.getQuantity());
            detailEo.setLineNo(d.getLineNo());
            detailEo.setCancelQuantity(BigDecimal.ZERO);
            if (context.getAutoComplete().booleanValue()) {
                detailEo.setWaitQuantity(BigDecimal.ZERO);
                detailEo.setDoneQuantity(d.getQuantity());
            } else {
                detailEo.setDoneQuantity(BigDecimal.ZERO);
                detailEo.setWaitQuantity(d.getQuantity());
            }
            detailEo.setInitFlag(YesNoEnum.YES.getValue());
            detailEo.setExtension(d.getExtension());
            detailEo.setPreOrderItemId(d.getPreOrderItemId());
            detailEo.setItemStatus(StringUtils.isNotBlank((CharSequence)d.getItemStatus()) ? d.getItemStatus() : CsPlannedOrderItemStatusEnum.COMMON.getCode());
            return detailEo;
        }).collect(Collectors.toList());
    }

    private ReceiveDeliveryNoticeOrderEo getReceiveDeliveryNoticeOrderEo(ReceiveDeliveryNoticeOrderContext context) {
        context.setDocumentNo(this.getDocumentNo(context));
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = Optional.ofNullable(context.getReceiveDeliveryNoticeOrderEo()).orElse(new ReceiveDeliveryNoticeOrderEo());
        BeanUtil.copyProperties((Object)context, (Object)receiveDeliveryNoticeOrderEo, (String[])new String[0]);
        receiveDeliveryNoticeOrderEo.setRelevanceTableName(context.getRelevanceTableName().getCode());
        receiveDeliveryNoticeOrderEo.setBusinessType(context.getBusinessType());
        receiveDeliveryNoticeOrderEo.setOrderStatus(context.getOrderStatus().getCode());
        receiveDeliveryNoticeOrderEo.setOrderType(BaseOrderOperateTypeEnum.DELIVERY.equals((Object)context.getOperateTypeEnum()) ? "delivery" : "receive");
        receiveDeliveryNoticeOrderEo.setTotalQuantity(context.getTotalQuantity() == null ? BigDecimal.ZERO : context.getTotalQuantity());
        return receiveDeliveryNoticeOrderEo;
    }

    private String getDocumentNo(ReceiveDeliveryNoticeOrderContext context) {
        if (BaseOrderOperateTypeEnum.RECEIVE.equals((Object)context.getOperateTypeEnum())) {
            return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.RECEIVE_NOTICE_ORDER.getCode()));
        }
        return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.DELIVERY_NOTICE_ORDER.getCode()));
    }

    protected abstract void wrapperGenerate(ReceiveDeliveryNoticeOrderContext var1);

    protected abstract void wrapperGenerateAfter(ReceiveDeliveryNoticeOrderContext var1);

    @Override
    public void doClose(ReceiveDeliveryNoticeOrderContext context) {
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context.getReceiveDeliveryNoticeOrderEo();
        ReceiveDeliveryNoticeOrderEo updateEo = new ReceiveDeliveryNoticeOrderEo();
        updateEo.setId(receiveDeliveryNoticeOrderEo.getId());
        updateEo.setOrderStatus(BaseOrderStatusEnum.FINISH_OVER.getCode());
        this.receiveDeliveryNoticeOrderDomain.getMapper().updateById((BaseEo)updateEo);
        this.doCloseInventory(context);
        this.updateDetailQuantity(context);
    }

    protected abstract void doCloseInventory(ReceiveDeliveryNoticeOrderContext var1);

    @Override
    public boolean validClose(ReceiveDeliveryNoticeOrderContext context) {
        return this.checkData(context);
    }

    private boolean checkData(ReceiveDeliveryNoticeOrderContext context) {
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)context.getDocumentNo())).last(" limit 1")).one();
        AssertUtil.isTrue((null != receiveDeliveryNoticeOrderEo ? 1 : 0) != 0, (String)"\u67e5\u8be2\u4e0d\u5230\u6536\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        context.setReceiveDeliveryNoticeOrderEo(receiveDeliveryNoticeOrderEo);
        context.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)receiveDeliveryNoticeOrderEo.getRelevanceTableName()));
        return true;
    }

    @Override
    public boolean validCancel(ReceiveDeliveryNoticeOrderContext context) {
        return this.checkData(context);
    }

    @Override
    public void complete(ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext) {
        log.info("complete\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)receiveDeliveryNoticeOrderContext));
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).last(" limit 1")).one();
        AssertUtils.isTrue((boolean)Objects.nonNull(receiveDeliveryNoticeOrderEo), (String)"\u8c03\u7528\u5b8c\u6210\u5355\u636e\u4e0d\u5b58\u5728");
        List detailEoList = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)receiveDeliveryNoticeOrderContext.getDocumentNo())).list();
        log.info("complete--detailEoList\uff1a{}", (Object)JSON.toJSONString((Object)detailEoList));
        Map<String, BigDecimal> orderDetailReqDtoMap = receiveDeliveryNoticeOrderContext.getOrderBasicsDetailReqDtoList().stream().collect(Collectors.groupingBy(r -> r.getPreOrderItemId() + "_" + r.getLineNo(), Collectors.mapping(BaseOrderDetailReqDto::getQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        detailEoList.forEach(detailEo -> Optional.ofNullable(orderDetailReqDtoMap.get(String.format("%s_%s", detailEo.getPreOrderItemId(), detailEo.getLineNo()))).ifPresent(q -> {
            detailEo.setDoneQuantity(BigDecimalUtils.add((BigDecimal)detailEo.getDoneQuantity(), (BigDecimal)q));
            detailEo.setWaitQuantity(DataExtractUtils.ifLtZeroSetZero((BigDecimal)detailEo.getWaitQuantity().subtract((BigDecimal)q)));
        }));
        if (!receiveDeliveryNoticeOrderContext.isNoticeEnd() && this.checkEnd(receiveDeliveryNoticeOrderContext, detailEoList)) {
            receiveDeliveryNoticeOrderContext.setNoticeEnd(true);
        }
        receiveDeliveryNoticeOrderEo.setOrderStatus(this.getCompleteStatus(receiveDeliveryNoticeOrderContext));
        this.receiveDeliveryNoticeOrderDomain.getMapper().updateById((BaseEo)receiveDeliveryNoticeOrderEo);
        detailEoList.forEach(arg_0 -> ((BaseMapper)this.receiveDeliveryNoticeOrderDetailDomain.getMapper()).updateById(arg_0));
    }

    private boolean checkEnd(ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext, List<ReceiveDeliveryNoticeOrderDetailEo> detailEoList) {
        return detailEoList.stream().noneMatch(r -> BigDecimalUtils.gtZero((BigDecimal)r.getWaitQuantity())) || receiveDeliveryNoticeOrderContext.isNoticeEndModule() && detailEoList.stream().collect(Collectors.groupingBy(ReceiveDeliveryNoticeOrderDetailEo::getSkuCode, Collectors.mapping(r -> BigDecimalUtils.subtract((BigDecimal)r.getPlanQuantity(), (BigDecimal)r.getDoneQuantity()), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))).values().stream().allMatch(BigDecimalUtils::eqZero);
    }

    protected abstract String getCompleteStatus(ReceiveDeliveryNoticeOrderContext var1);

    public void updateDetailQuantity(ReceiveDeliveryNoticeOrderContext context) {
        List<ReceiveDeliveryNoticeOrderDetailEo> receiveDeliveryNoticeOrderDetailEoList = this.loadDetailList(context);
        for (ReceiveDeliveryNoticeOrderDetailEo receiveDeliveryNoticeOrderDetailEo : receiveDeliveryNoticeOrderDetailEoList) {
            receiveDeliveryNoticeOrderDetailEo.setCancelQuantity(receiveDeliveryNoticeOrderDetailEo.getWaitQuantity());
            receiveDeliveryNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
        }
        receiveDeliveryNoticeOrderDetailEoList.forEach(out -> {
            InOutNoticeOrderDetailEo outUpdate = new InOutNoticeOrderDetailEo();
            outUpdate.setId(out.getId());
            outUpdate.setCancelQuantity(out.getCancelQuantity());
            outUpdate.setWaitQuantity(out.getWaitQuantity());
            this.receiveDeliveryNoticeOrderDetailDomain.updateSelective((BaseEo)out);
        });
    }

    public List<ReceiveDeliveryNoticeOrderDetailEo> loadDetailList(ReceiveDeliveryNoticeOrderContext context) {
        List receiveDeliveryNoticeOrderDetailEoList = Optional.ofNullable(context.getReceiveDeliveryNoticeOrderDetailEoList()).filter(CollectionUtils::isNotEmpty).orElseGet(() -> ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)context.getDocumentNo())).list());
        context.setReceiveDeliveryNoticeOrderDetailEoList(receiveDeliveryNoticeOrderDetailEoList);
        return receiveDeliveryNoticeOrderDetailEoList;
    }
}

