/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.transcation;

import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class TransactionCallBackService {
    private static final Logger log = LoggerFactory.getLogger(TransactionCallBackService.class);

    public void execute(final TransactionCallBackAction action) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            try {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                    public void afterCommit() {
                        if (null != action) {
                            action.callback();
                        }
                    }
                });
            }
            catch (Exception e) {
                log.error("\u4e8b\u7269\u56de\u8c03\u5904\u7406\u5f02\u5e38: {}", (Object)e.getMessage());
                if (null != action) {
                    action.callback();
                }
            }
        } else if (null != action) {
            action.callback();
        }
    }
}

