/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.impl;

import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.abstracts.AbstractInOutResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class InResultOrderAbleImpl
extends AbstractInOutResultOrderAble {
    @Resource
    private ICalcInventoryService calcInventoryService;

    @Override
    protected void wrapperGenerateAfter(InOutResultOrderContext context) {
        this.formIn(context);
    }

    private void formIn(InOutResultOrderContext context) {
        if (!context.getUpdateInventory().booleanValue()) {
            return;
        }
        if (this.isInTransit(context)) {
            TransferInDto transferInDto = new TransferInDto();
            this.wrapper(context, (CalcDto)transferInDto);
            if (CollectionUtils.isEmpty((Collection)transferInDto.getDetails())) {
                return;
            }
            transferInDto.setReleaseDetails(transferInDto.getDetails());
            transferInDto.setValidNegative(Boolean.FALSE);
            this.calcInventoryService.transferIn(transferInDto);
        } else {
            FormInDto formInDto = new FormInDto();
            this.wrapper(context, (CalcDto)formInDto);
            if (CollectionUtils.isEmpty((Collection)formInDto.getDetails())) {
                return;
            }
            if (!this.canNoticeInventoryProcess(context)) {
                formInDto.setIgnoreFutureIn(Boolean.valueOf(true));
            } else {
                formInDto.setReleaseDetails(formInDto.getDetails());
            }
            formInDto.setValidNegative(Boolean.FALSE);
            this.calcInventoryService.formIn(formInDto);
        }
    }

    private boolean isInTransit(InOutResultOrderContext context) {
        return (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)context.getRelevanceTableName()) && context.getCanProcessTransit() != false || CsRelevanceTableNameEnum.IN_DISPATCHER_ORDER.equals((Object)context.getRelevanceTableName())) && this.canNoticeInventoryProcess(context);
    }

    @Override
    protected String getCompleteStatus() {
        return BaseOrderStatusEnum.IRO_DONE_IN.getCode();
    }

    @Override
    protected void setUnhookWarehouse(InOutResultOrderContext context) {
        context.setLogicWarehouseCode(context.getInOutResultOrderEo().getInLogicWarehouseCode());
        context.setLogicWarehouseName(context.getInOutResultOrderEo().getInLogicWarehouseName());
        context.setPhysicsWarehouseCode(context.getInOutResultOrderEo().getInPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(context.getInOutResultOrderEo().getInPhysicsWarehouseName());
    }

    @Override
    protected void unhookAfter(InOutResultOrderContext context) {
        context.setLogicWarehouseCode(context.getInOutResultOrderEo().getInLogicWarehouseCode());
        context.setLogicWarehouseName(context.getInOutResultOrderEo().getInLogicWarehouseName());
        context.setPhysicsWarehouseCode(context.getInOutResultOrderEo().getInPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(context.getInOutResultOrderEo().getInPhysicsWarehouseName());
        this.formIn(context);
    }

    protected void wrapper(InOutResultOrderContext context, CalcDto transferInDto) {
        context.wrapperInventoryOd(transferInDto);
        ArrayList detailDtos = new ArrayList(context.getInOutResultOrderDetailEoList().stream().filter(e -> e.getDoneQuantity().compareTo(BigDecimal.ZERO) != 0).map(detail -> this.getCalcDetailDto(context, (InOutResultOrderDetailEo)detail)).collect(Collectors.toMap(r -> r.getLineNo() + "_" + r.getSkuCode() + "_" + r.getBatch(), Function.identity(), (o, o1) -> {
            o.setNum(BigDecimalUtils.add((BigDecimal)o.getNum(), (BigDecimal)o1.getNum()));
            return o;
        })).values());
        transferInDto.setDetails(detailDtos);
    }

    @Override
    protected String getHangUpStatus() {
        return BaseOrderStatusEnum.IRO_HANG_UP.getCode();
    }

    @Override
    protected void wrapperGenerate(InOutResultOrderContext context) {
        context.getInOutResultOrderEo().setInLogicWarehouseCode(context.getLogicWarehouseCode());
        context.getInOutResultOrderEo().setInLogicWarehouseName(context.getLogicWarehouseName());
        context.getInOutResultOrderEo().setInPhysicsWarehouseCode(context.getPhysicsWarehouseCode());
        context.getInOutResultOrderEo().setInPhysicsWarehouseName(context.getPhysicsWarehouseName());
    }

    @Override
    public boolean validClose(InOutResultOrderContext context) {
        return false;
    }

    @Override
    public void doClose(InOutResultOrderContext context) {
    }

    @Override
    public boolean validCancel(InOutResultOrderContext context) {
        return super.validCancel(context);
    }

    @Override
    public void doCancel(InOutResultOrderContext context) {
    }
}

