/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commons.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.service.commons.CommonService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommonServiceImpl
implements CommonService {
    private static final Logger logger = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;

    @Override
    public Long getUserOrganizationId() {
        RestResponse restResponse;
        Long userId = this.context.userId();
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7id\uff0cuserId:{}", (Object)userId);
        if (null != userId && null != (restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId())).getData()) {
            logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7id\uff0corganizationId:{}", restResponse.getData());
            return (Long)restResponse.getData();
        }
        return null;
    }

    @Override
    public Long getOrganizationIdByUserId(Long userId) {
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(userId);
        if (null != restResponse.getData()) {
            return (Long)restResponse.getData();
        }
        return null;
    }

    @Override
    public List<Long> getUserLogicWarehouseIds() {
        List<Long> warehouseIds = new ArrayList<Long>();
        Long userId = this.context.userId();
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684userId:{}", (Object)userId);
        if (Objects.isNull(userId)) {
            return warehouseIds;
        }
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        logger.info("\u6839\u636euserId\u67e5\u8be2\u5230\u7ec4\u7ec7id\uff1a{}", (Object)orgId);
        if (Objects.isNull(orgId)) {
            return warehouseIds;
        }
        List list = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().select(new String[]{"id"}).eq((Object)"organization_id", (Object)orgId)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            warehouseIds = list.stream().map(BaseEo::getId).collect(Collectors.toList());
        }
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u903b\u8f91\u4ed3\u5e93id\u96c6\u5408\uff0c\u8fd4\u53c2\uff1a{}", (Object)JSON.toJSONString(warehouseIds));
        return warehouseIds;
    }

    @Override
    public void getSetUserName() {
        if (StringUtils.isBlank((CharSequence)this.context.userName())) {
            this.context.userName("system");
        }
    }

    @Override
    public void getSetUserName(String createPerson) {
        if (StringUtils.isBlank((CharSequence)this.context.userName())) {
            this.context.userName(StringUtils.isNotBlank((CharSequence)createPerson) ? createPerson : "system");
        }
    }
}

