/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.IFormInAble;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FormInAbleImpl
extends BaseAble
implements IFormInAble {
    private static final Logger log = LoggerFactory.getLogger(FormInAbleImpl.class);

    @Override
    public void formIn(FormInDto dto) {
        dto.setValidNegative(Boolean.FALSE);
        log.info("warehouse inventory formIn(\u5355\u636e\u5165\u5e93), param:{}", (Object)JSON.toJSONString((Object)dto));
        dto.setNoneBatch(Boolean.valueOf(false));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        ArrayList details = Lists.newArrayList();
        details.addAll(dto.getDetails());
        if (!dto.getIgnoreFutureIn().booleanValue()) {
            this.checkDetails(dto.getReleaseDetails());
            details.addAll(dto.getReleaseDetails());
        }
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(details);
        this.checkSku(details);
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        if (!dto.getIgnoreFutureIn().booleanValue()) {
            for (CalcInventoryDetailDto detail : logicTotalCalcDto.getDetails()) {
                CalcDetailDto releaseDetail = dto.getReleaseDetails().stream().filter(o -> StringUtils.equals((CharSequence)o.getLogicWarehouseCode(), (CharSequence)detail.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detail.getSkuCode())).findFirst().orElse(null);
                if (null == releaseDetail) continue;
                detail.setChangeFutureIn(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
            }
        }
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    public CalcInventoryDto createLogicCalcDto(FormInDto dto) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setBusinessType(dto.getBusinessType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setValidNegative(dto.getValidNegative());
        calcInventoryDto.setRemark(dto.getDesc());
        ArrayList details = Lists.newArrayList();
        for (CalcDetailDto pd : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc());
            detailDto.setChangeBalance(pd.getNum());
            detailDto.setChangeAvailable(pd.getNum());
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setBatch(pd.getBatch());
            detailDto.setValidNegative(dto.getValidNegative());
            detailDto.setExpireTime(pd.getExpireDate());
            detailDto.setProduceTime(pd.getProduceDate());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }
}

