/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.convert.entity.ReceiveDeliveryNoticeOrderConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderDto;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.entity.IReceiveDeliveryNoticeOrderService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReceiveDeliveryNoticeOrderServiceImpl
extends BaseServiceImpl<ReceiveDeliveryNoticeOrderDto, ReceiveDeliveryNoticeOrderEo, IReceiveDeliveryNoticeOrderDomain>
implements IReceiveDeliveryNoticeOrderService {
    private static final Logger log = LoggerFactory.getLogger(ReceiveDeliveryNoticeOrderServiceImpl.class);
    @Autowired
    BaseOrderFacade baseOrderFacade;

    public ReceiveDeliveryNoticeOrderServiceImpl(IReceiveDeliveryNoticeOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ReceiveDeliveryNoticeOrderDto, ReceiveDeliveryNoticeOrderEo> converter() {
        return ReceiveDeliveryNoticeOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<ReceiveDeliveryNoticeOrderDto> create(final ReceiveDeliveryNoticeOrderDto dto) {
        ReceiveDeliveryNoticeOrderFacadeBo noticeOrderFacadeBo = (ReceiveDeliveryNoticeOrderFacadeBo)BeanUtil.copyProperties((Object)dto, ReceiveDeliveryNoticeOrderFacadeBo.class, (String[])new String[0]);
        noticeOrderFacadeBo.setPreOrderNo(dto.getPreOrderNo());
        noticeOrderFacadeBo.setRelevanceNo(dto.getRelevanceNo());
        noticeOrderFacadeBo.setBusinessType(dto.getBusinessType());
        noticeOrderFacadeBo.setRemark(dto.getRemark());
        noticeOrderFacadeBo.setLogicWarehouseCode(dto.getReceiveLogicWarehouseCode());
        noticeOrderFacadeBo.setLogicWarehouseName(dto.getReceiveLogicWarehouseName());
        noticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(dto.getReceiveDeliveryNoticeOrderDetailDtos().stream().map(detail -> {
            BaseOrderDetailReqDto csBasicsOrderDetailReqDto = (BaseOrderDetailReqDto)BeanUtil.copyProperties((Object)detail, BaseOrderDetailReqDto.class, (String[])new String[0]);
            csBasicsOrderDetailReqDto.setQuantity(detail.getPlanQuantity());
            if (StringUtils.isBlank((CharSequence)csBasicsOrderDetailReqDto.getSkuCode())) {
                csBasicsOrderDetailReqDto.setSkuCode(detail.getLongCode());
            }
            if (StringUtils.isBlank((CharSequence)csBasicsOrderDetailReqDto.getSkuName())) {
                csBasicsOrderDetailReqDto.setSkuName(detail.getCargoName());
            }
            csBasicsOrderDetailReqDto.setExpireTime(detail.getExpireTime());
            csBasicsOrderDetailReqDto.setProduceTime(detail.getProduceTime());
            csBasicsOrderDetailReqDto.setPreOrderItemId(detail.getTradeOrderItemId());
            return csBasicsOrderDetailReqDto;
        }).collect(Collectors.toList()));
        noticeOrderFacadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                if (null != dto.getSendWms()) {
                    context.setSendWms(dto.getSendWms());
                }
                if (null != dto.getAutoComplete()) {
                    context.setAutoComplete(dto.getAutoComplete());
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        ReceiveDeliveryNoticeOrderContext receiveDeliveryNoticeOrderContext = this.baseOrderFacade.receiveNoticeOrderGen(noticeOrderFacadeBo);
        ReceiveDeliveryNoticeOrderDto respDto = (ReceiveDeliveryNoticeOrderDto)this.converter().toDto((BaseEo)receiveDeliveryNoticeOrderContext.getReceiveDeliveryNoticeOrderEo());
        return new RestResponse((Object)respDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> cancel(String documentNo) {
        List receiveDeliveryNoticeOrderEos = ((IReceiveDeliveryNoticeOrderDomain)this.domain).queryByDocumentNo(documentNo);
        AssertUtils.notEmpty((Collection)receiveDeliveryNoticeOrderEos, (String)"\u901a\u77e5\u5355\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728");
        final ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEos.get(0);
        BaseOrderCommonCancelBo baseOrderCommonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(documentNo).relevanceNo(receiveDeliveryNoticeOrderEo.getRelevanceNo()).sourceType(receiveDeliveryNoticeOrderEo.getBusinessType()).businessType(receiveDeliveryNoticeOrderEo.getBusinessType()).build();
        baseOrderCommonCancelBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof ReceiveDeliveryNoticeOrderContext) {
                    ((ReceiveDeliveryNoticeOrderContext)context).setReceiveDeliveryNoticeOrderEo(receiveDeliveryNoticeOrderEo);
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        if ("receive".equals(receiveDeliveryNoticeOrderEo.getOrderType())) {
            this.baseOrderFacade.receiveNoticeOrderCancel(baseOrderCommonCancelBo);
        } else {
            this.baseOrderFacade.deliveryNoticeOrderCancel(baseOrderCommonCancelBo);
        }
        return RestResponse.VOID;
    }
}

