/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FormOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.IFormOutAble;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FormOutAbleImpl
extends BaseAble
implements IFormOutAble {
    private static final Logger log = LoggerFactory.getLogger(FormOutAbleImpl.class);

    @Override
    public void formOut(FormOutDto dto) {
        log.info("warehouse inventory formOut(\u5355\u636e\u51fa\u5e93), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        if (null == dto.getIsSaleOrder()) {
            dto.setIsSaleOrder(Boolean.FALSE);
        }
        List details = dto.getDetails();
        List inventoryPreemptionEos = this.inventoryPreemptionDomain.queryBySourceNo(dto.getSourceNo());
        if (CollectionUtil.isEmpty((Collection)inventoryPreemptionEos) && !dto.getIgnorePreempt().booleanValue()) {
            throw new BizException(StrUtil.format((CharSequence)"\u8be5\u5355\u636e[%s]\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55", (Object[])new Object[]{dto.getSourceNo()}));
        }
        ArrayList<CalcDetailDto> releaseDetails = dto.getIgnorePreempt() != false ? new ArrayList(10) : this.updatePreempt(details, inventoryPreemptionEos);
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto, releaseDetails);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(details);
        this.checkSku(details);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    private CalcInventoryDto createLogicCalcDto(FormOutDto dto, List<CalcDetailDto> releaseDetails) {
        CalcInventoryDetailDto detailDto;
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setBusinessType(dto.getBusinessType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setValidNegative(dto.getValidNegative());
        calcInventoryDto.setRemark(dto.getDesc());
        ArrayList details = Lists.newArrayList();
        for (CalcDetailDto releaseDetail : releaseDetails) {
            detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc() + "-\u91ca\u653e\u9884\u5360");
            detailDto.setChangePreempt(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
            if (dto.getIsSaleOrder().booleanValue()) {
                detailDto.setChangeAllocate(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
            }
            detailDto.setChangeAvailable(releaseDetail.getNum());
            detailDto.setWarehouseCode(releaseDetail.getLogicWarehouseCode());
            detailDto.setSkuCode(releaseDetail.getSkuCode());
            detailDto.setBatch(releaseDetail.getBatch());
            detailDto.setValidNegative(Boolean.valueOf(false));
            details.add(detailDto);
        }
        for (CalcDetailDto pd : dto.getDetails()) {
            detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc() + "-\u51fa\u5e93");
            detailDto.setChangeBalance(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            detailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setBatch(pd.getBatch());
            detailDto.setExpireTime(pd.getExpireDate());
            detailDto.setProduceTime(pd.getProduceDate());
            detailDto.setValidNegative(dto.getValidNegative());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }
}

