/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.enums.InventoryInOutEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryLogEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryOperateLogEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcAble;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CalcAbleImpl
extends BaseAble
implements ICalcAble {
    private static final Logger log = LoggerFactory.getLogger(CalcAbleImpl.class);

    @Override
    public void calcLogic(CalcInventoryDto calcDto, List<LogicWarehouseEo> logicWarehouseEos, List<LogicInventoryEo> logicInventoryEos) {
        if (null == calcDto) {
            return;
        }
        List<CalcUpdateInventoryDto> updateDtoList = this.mergeLogic(calcDto, calcDto.getDetails(), logicInventoryEos);
        updateDtoList = this.ignoreZero(updateDtoList);
        this.validateLogicInventory(updateDtoList, logicInventoryEos);
        this.setLogicCurrentInventory(updateDtoList, logicInventoryEos);
        this.logicInventoryDomain.updateInventory(updateDtoList);
    }

    @Override
    public void calcBatchLogic(List<CalcInventoryDto> calcDtoList, List<LogicWarehouseEo> logicWarehouseEos, List<LogicInventoryEo> logicInventoryEos) {
        List<Object> batchUpdateDtoList = Lists.newArrayList();
        for (CalcInventoryDto inventoryDto : calcDtoList) {
            batchUpdateDtoList.addAll(this.mergeLogic(inventoryDto, inventoryDto.getDetails(), logicInventoryEos));
        }
        batchUpdateDtoList = this.mergeUpdateList(batchUpdateDtoList);
        batchUpdateDtoList = this.ignoreZero(batchUpdateDtoList);
        log.info("batchUpdateDtoList: {}", (Object)JSON.toJSONString((Object)batchUpdateDtoList));
        this.validateLogicInventory(batchUpdateDtoList, logicInventoryEos);
        this.setLogicCurrentInventory(batchUpdateDtoList, logicInventoryEos);
        this.logicInventoryDomain.updateInventory((List)batchUpdateDtoList);
    }

    private List<CalcUpdateInventoryDto> mergeUpdateList(List<CalcUpdateInventoryDto> updateList) {
        HashMap map = Maps.newHashMap();
        for (CalcUpdateInventoryDto calcUpdateInventoryDto : updateList) {
            CalcUpdateInventoryDto updateInventoryDto = map.getOrDefault(calcUpdateInventoryDto.getInventoryId(), null);
            if (null == updateInventoryDto) {
                map.put(calcUpdateInventoryDto.getInventoryId(), calcUpdateInventoryDto);
                continue;
            }
            updateInventoryDto.setChangeAvailable(BigDecimalUtils.add((BigDecimal)updateInventoryDto.getChangeAvailable(), (BigDecimal)calcUpdateInventoryDto.getChangeAvailable()));
            updateInventoryDto.setChangePreempt(BigDecimalUtils.add((BigDecimal)updateInventoryDto.getChangePreempt(), (BigDecimal)calcUpdateInventoryDto.getChangePreempt()));
            updateInventoryDto.setChangeBalance(BigDecimalUtils.add((BigDecimal)updateInventoryDto.getChangeBalance(), (BigDecimal)calcUpdateInventoryDto.getChangeBalance()));
            updateInventoryDto.setChangeFutureIn(BigDecimalUtils.add((BigDecimal)updateInventoryDto.getChangeFutureIn(), (BigDecimal)calcUpdateInventoryDto.getChangeFutureIn()));
            updateInventoryDto.setChangeIntransit(BigDecimalUtils.add((BigDecimal)updateInventoryDto.getChangeIntransit(), (BigDecimal)calcUpdateInventoryDto.getChangeIntransit()));
            updateInventoryDto.setChangeLockInventory(BigDecimalUtils.add((BigDecimal)updateInventoryDto.getChangeLockInventory(), (BigDecimal)calcUpdateInventoryDto.getChangeLockInventory()));
            updateInventoryDto.setChangeAllocate(BigDecimalUtils.add((BigDecimal)updateInventoryDto.getChangeAllocate(), (BigDecimal)calcUpdateInventoryDto.getChangeAllocate()));
            if (!calcUpdateInventoryDto.getValidNegative().booleanValue()) {
                updateInventoryDto.setValidNegative(Boolean.valueOf(false));
            }
            map.put(calcUpdateInventoryDto.getInventoryId(), updateInventoryDto);
        }
        return Lists.newArrayList(map.values());
    }

    @Override
    public void calcLogicTotal(CalcInventoryDto calcDto, List<LogicWarehouseEo> logicWarehouseEos, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        List<CalcUpdateInventoryDto> updateDtoList = this.mergeLogicTotal(calcDto, calcDto.getDetails(), logicInventoryTotalEos);
        updateDtoList = this.ignoreZero(updateDtoList);
        this.validateLogicTotalInventory(updateDtoList, logicInventoryTotalEos);
        this.setLogicTotalCurrentInventory(updateDtoList, logicInventoryTotalEos);
        if (CollectionUtils.isNotEmpty(updateDtoList)) {
            this.logicInventoryTotalDomain.updateInventory(updateDtoList);
        }
    }

    @Override
    public void calcBatchLogicTotal(List<CalcInventoryDto> calcDtoList, List<LogicWarehouseEo> logicWarehouseEos, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        List<Object> batchUpdateDtoList = Lists.newArrayList();
        ArrayList calcLogicTotalInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcLogicTotalInventoryEos, logicInventoryTotalEos, LogicInventoryTotalEo.class);
        for (CalcInventoryDto inventoryDto : calcDtoList) {
            batchUpdateDtoList.addAll(this.mergeLogicTotal(inventoryDto, inventoryDto.getDetails(), calcLogicTotalInventoryEos));
        }
        batchUpdateDtoList = this.mergeUpdateList(batchUpdateDtoList);
        batchUpdateDtoList = this.ignoreZero(batchUpdateDtoList);
        log.info("batchUpdateDtoList: {}", (Object)JSON.toJSONString((Object)batchUpdateDtoList));
        this.validateLogicTotalInventory(batchUpdateDtoList, calcLogicTotalInventoryEos);
        this.setLogicTotalCurrentInventory(batchUpdateDtoList, calcLogicTotalInventoryEos);
        this.logicInventoryTotalDomain.updateInventory((List)batchUpdateDtoList);
    }

    private List<CalcUpdateInventoryDto> mergeLogic(CalcInventoryDto calcInventoryDto, List<CalcInventoryDetailDto> detailDtoList, List<LogicInventoryEo> logicInventoryEos) {
        log.info("mergeLogic: {}", (Object)JSON.toJSONString(detailDtoList));
        HashMap map = Maps.newHashMap();
        for (CalcInventoryDetailDto detailDto : detailDtoList) {
            String key = this.getKey(detailDto.getWarehouseCode(), detailDto.getSkuCode(), detailDto.getBatch());
            log.info("detailDto: {},key\uff1a{}", (Object)JSON.toJSONString((Object)detailDto), (Object)key);
            LogicInventoryEo logicInventoryEo = logicInventoryEos.stream().filter(o -> org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)detailDto.getWarehouseCode()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detailDto.getSkuCode()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)detailDto.getBatch())).findFirst().orElse(null);
            String errMsg = String.format("\u903b\u8f91\u4ed3, \u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u903b\u8f91\u4ed3\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801: %s, \u6279\u6b21: %s", detailDto.getWarehouseCode(), detailDto.getSkuCode(), detailDto.getBatch());
            AssertUtils.isFalse((null == logicInventoryEo ? 1 : 0) != 0, (String)errMsg);
            detailDto.setInventoryId(logicInventoryEo.getId());
            CalcUpdateInventoryDto updateDto = map.getOrDefault(key, new CalcUpdateInventoryDto(logicInventoryEo.getId(), detailDto.getWarehouseCode(), detailDto.getSkuCode()));
            updateDto.setBatch(detailDto.getBatch());
            updateDto.setChangeAvailable(BigDecimalUtils.add((BigDecimal)updateDto.getChangeAvailable(), (BigDecimal)detailDto.getChangeAvailable()));
            updateDto.setChangePreempt(BigDecimalUtils.add((BigDecimal)updateDto.getChangePreempt(), (BigDecimal)detailDto.getChangePreempt()));
            updateDto.setChangeBalance(BigDecimalUtils.add((BigDecimal)updateDto.getChangeBalance(), (BigDecimal)detailDto.getChangeBalance()));
            updateDto.setChangeFutureIn(BigDecimalUtils.add((BigDecimal)updateDto.getChangeFutureIn(), (BigDecimal)detailDto.getChangeFutureIn()));
            updateDto.setChangeIntransit(BigDecimalUtils.add((BigDecimal)updateDto.getChangeIntransit(), (BigDecimal)detailDto.getChangeIntransit()));
            updateDto.setChangeLockInventory(BigDecimalUtils.add((BigDecimal)updateDto.getChangeLockInventory(), (BigDecimal)detailDto.getChangeLockInventory()));
            updateDto.setChangeAllocate(BigDecimalUtils.add((BigDecimal)updateDto.getChangeAllocate(), (BigDecimal)detailDto.getChangeAllocate()));
            updateDto.setExpireTime(detailDto.getExpireTime());
            updateDto.setProduceTime(detailDto.getProduceTime());
            if (null == detailDto.getValidNegative()) {
                detailDto.setValidNegative(Boolean.valueOf(true));
            }
            if (null == calcInventoryDto.getValidNegative()) {
                calcInventoryDto.setValidNegative(Boolean.valueOf(true));
            }
            if (!detailDto.getValidNegative().booleanValue() || !calcInventoryDto.getValidNegative().booleanValue()) {
                updateDto.setValidNegative(Boolean.valueOf(false));
            }
            updateDto.setLendInventory(BigDecimalUtils.add((BigDecimal)updateDto.getLendInventory(), (BigDecimal)detailDto.getLendInventory()));
            map.put(key, updateDto);
        }
        return Lists.newArrayList(map.values());
    }

    private List<CalcUpdateInventoryDto> mergeLogicTotal(CalcInventoryDto calcInventoryDto, List<CalcInventoryDetailDto> detailDtoList, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        log.info("mergeLogicTotal: {}", (Object)JSON.toJSONString(detailDtoList));
        HashMap map = Maps.newHashMap();
        for (CalcInventoryDetailDto detailDto : detailDtoList) {
            String key = this.getTotalKey(detailDto.getWarehouseCode(), detailDto.getSkuCode());
            LogicInventoryTotalEo logicInventoryTotalEo = logicInventoryTotalEos.stream().filter(o -> org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)detailDto.getWarehouseCode()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detailDto.getSkuCode())).findFirst().orElse(null);
            AssertUtils.isFalse((null == logicInventoryTotalEo ? 1 : 0) != 0, (String)"\u903b\u8f91\u603b\u4ed3, \u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u6e20\u9053\u4ed3\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801: %s", (Object[])new Object[]{detailDto.getWarehouseCode(), detailDto.getSkuCode()});
            detailDto.setInventoryId(logicInventoryTotalEo.getId());
            CalcUpdateInventoryDto updateDto = map.getOrDefault(key, new CalcUpdateInventoryDto(logicInventoryTotalEo.getId(), detailDto.getWarehouseCode(), detailDto.getSkuCode()));
            updateDto.setLendInventory(BigDecimalUtils.add((BigDecimal)updateDto.getLendInventory(), (BigDecimal)detailDto.getLendInventory()));
            updateDto.setChangeAvailable(BigDecimalUtils.add((BigDecimal)updateDto.getChangeAvailable(), (BigDecimal)detailDto.getChangeAvailable()));
            updateDto.setChangePreempt(BigDecimalUtils.add((BigDecimal)updateDto.getChangePreempt(), (BigDecimal)detailDto.getChangePreempt()));
            updateDto.setChangeBalance(BigDecimalUtils.add((BigDecimal)updateDto.getChangeBalance(), (BigDecimal)detailDto.getChangeBalance()));
            updateDto.setChangeFutureIn(BigDecimalUtils.add((BigDecimal)updateDto.getChangeFutureIn(), (BigDecimal)detailDto.getChangeFutureIn()));
            updateDto.setChangeIntransit(BigDecimalUtils.add((BigDecimal)updateDto.getChangeIntransit(), (BigDecimal)detailDto.getChangeIntransit()));
            updateDto.setChangeLockInventory(BigDecimalUtils.add((BigDecimal)updateDto.getChangeLockInventory(), (BigDecimal)detailDto.getChangeLockInventory()));
            updateDto.setChangeAllocate(BigDecimalUtils.add((BigDecimal)updateDto.getChangeAllocate(), (BigDecimal)detailDto.getChangeAllocate()));
            if (null == detailDto.getValidNegative()) {
                detailDto.setValidNegative(Boolean.valueOf(true));
            }
            if (null == calcInventoryDto.getValidNegative()) {
                calcInventoryDto.setValidNegative(Boolean.valueOf(true));
            }
            if (!detailDto.getValidNegative().booleanValue() || !calcInventoryDto.getValidNegative().booleanValue()) {
                updateDto.setValidNegative(Boolean.valueOf(false));
            }
            map.put(key, updateDto);
        }
        return Lists.newArrayList(map.values());
    }

    private List<CalcUpdateInventoryDto> ignoreZero(List<CalcUpdateInventoryDto> updateDtoList) {
        return updateDtoList;
    }

    private void validateLogicInventory(List<CalcUpdateInventoryDto> updateList, List<LogicInventoryEo> logicInventoryEos) {
        log.info("validateLogicInventory updateList:{}", (Object)JSON.toJSONString(updateList));
        log.info("validateLogicInventory logicInventoryEos:{}", (Object)JSON.toJSONString(logicInventoryEos));
        ArrayList errorList = Lists.newArrayList();
        for (CalcUpdateInventoryDto updateDto : updateList) {
            LogicInventoryEo logicInventoryEo = logicInventoryEos.stream().filter(o -> org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)updateDto.getWarehouseCode()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)updateDto.getSkuCode()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)updateDto.getBatch())).findFirst().orElse(null);
            if (null == logicInventoryEo) {
                errorList.add(String.format("\u903b\u8f91\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s, \u6279\u6b21: %s", updateDto.getWarehouseCode(), updateDto.getSkuCode(), updateDto.getBatch()));
                continue;
            }
            BigDecimal available = BigDecimal.ZERO;
            if (BigDecimalUtils.gtZero((BigDecimal)logicInventoryEo.getAvailable()).booleanValue()) {
                available = logicInventoryEo.getAvailable();
            }
            BigDecimal afterAvailable = BigDecimalUtils.add((BigDecimal)available, (BigDecimal)updateDto.getChangeAvailable());
            if (BigDecimalUtils.gtZero((BigDecimal)updateDto.getLendInventory()).booleanValue()) {
                afterAvailable = BigDecimalUtils.add((BigDecimal)updateDto.getLendInventory(), (BigDecimal)afterAvailable);
                log.info("\u501f\u7528\u5e93\u5b58:{}", (Object)updateDto.getLendInventory());
            }
            if (!updateDto.getValidNegative().booleanValue() || !BigDecimalUtils.ltZero((BigDecimal)afterAvailable).booleanValue()) continue;
            errorList.add(String.format("\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s, \u6279\u6b21: %s [\u5f53\u524d\u53ef\u7528\u5e93\u5b58: %s]", logicInventoryEo.getWarehouseCode(), logicInventoryEo.getSkuCode(), logicInventoryEo.getBatch(), logicInventoryEo.getAvailable()));
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            throw new BizException(org.apache.commons.lang3.StringUtils.join((Iterable)errorList, (String)","));
        }
    }

    private void validateLogicTotalInventory(List<CalcUpdateInventoryDto> updateList, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        ArrayList errorList = Lists.newArrayList();
        for (CalcUpdateInventoryDto updateDto : updateList) {
            BigDecimal afterAvailable;
            LogicInventoryTotalEo logicInventoryTotalEo = logicInventoryTotalEos.stream().filter(o -> org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)updateDto.getWarehouseCode()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)updateDto.getSkuCode())).findFirst().orElse(null);
            if (null == logicInventoryTotalEo) {
                errorList.add(String.format("\u903b\u8f91\u603b\u4ed3\uff0c\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s", updateDto.getWarehouseCode(), updateDto.getSkuCode()));
                continue;
            }
            if (BigDecimalUtils.gtZero((BigDecimal)updateDto.getLendInventory()).booleanValue()) {
                BigDecimal available = BigDecimal.ZERO;
                if (BigDecimalUtils.gtZero((BigDecimal)logicInventoryTotalEo.getAvailable()).booleanValue()) {
                    available = logicInventoryTotalEo.getAvailable();
                }
                afterAvailable = BigDecimalUtils.add((BigDecimal)available, (BigDecimal)updateDto.getChangeAvailable());
                afterAvailable = BigDecimalUtils.add((BigDecimal)updateDto.getLendInventory(), (BigDecimal)afterAvailable);
                log.info("\u501f\u7528\u5e93\u5b58:{}", (Object)updateDto.getLendInventory());
                if (updateDto.getValidNegative().booleanValue() && BigDecimalUtils.ltZero((BigDecimal)BigDecimalUtils.add((BigDecimal)logicInventoryTotalEo.getAvailable(), (BigDecimal)updateDto.getLendInventory())).booleanValue()) {
                    errorList.add(String.format("\u53ef\u7528\u5e93\u5b58\u52a0\u501f\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s [\u5f53\u524d\u53ef\u7528\u5e93\u5b58: %s]", logicInventoryTotalEo.getWarehouseCode(), logicInventoryTotalEo.getSkuCode(), logicInventoryTotalEo.getAvailable()));
                }
            } else {
                afterAvailable = BigDecimalUtils.add((BigDecimal)logicInventoryTotalEo.getAvailable(), (BigDecimal)updateDto.getChangeAvailable());
            }
            if (!updateDto.getValidNegative().booleanValue() || !BigDecimalUtils.ltZero((BigDecimal)afterAvailable).booleanValue()) continue;
            errorList.add(String.format("\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u903b\u8f91\u4ed3\u7f16\u7801: %s, SKU\u7f16\u7801: %s [\u5f53\u524d\u53ef\u7528\u5e93\u5b58: %s]", logicInventoryTotalEo.getWarehouseCode(), logicInventoryTotalEo.getSkuCode(), logicInventoryTotalEo.getAvailable()));
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            throw new BizException(org.apache.commons.lang3.StringUtils.join((Iterable)errorList, (String)";"));
        }
    }

    private void setLogicCurrentInventory(List<CalcUpdateInventoryDto> updateDtoList, List<LogicInventoryEo> logicInventoryEos) {
        String currentUserName = null == this.context.userName() ? "system" : this.context.userName();
        Map logicInventoryEoMap = logicInventoryEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CalcUpdateInventoryDto updateInventoryDto : updateDtoList) {
            LogicInventoryEo logicInventoryEo = (LogicInventoryEo)logicInventoryEoMap.get(updateInventoryDto.getInventoryId());
            updateInventoryDto.setBeforeBalance(logicInventoryEo.getBalance());
            updateInventoryDto.setBeforeAvailable(logicInventoryEo.getAvailable());
            updateInventoryDto.setBeforePreempt(logicInventoryEo.getPreempt());
            updateInventoryDto.setBeforeLockInventory(logicInventoryEo.getLockInventory());
            updateInventoryDto.setBeforeAllocate(logicInventoryEo.getAllocate());
            updateInventoryDto.setBeforeIntransit(logicInventoryEo.getIntransit());
            updateInventoryDto.setBeforeFutureIn(logicInventoryEo.getFutureIn());
            updateInventoryDto.setUpdatePerson(currentUserName);
        }
    }

    private void setLogicTotalCurrentInventory(List<CalcUpdateInventoryDto> updateDtoList, List<LogicInventoryTotalEo> logicInventoryTotalEos) {
        String currentUserName = null == this.context.userName() ? "system" : this.context.userName();
        Map logicInventoryTotalEoMap = logicInventoryTotalEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CalcUpdateInventoryDto updateInventoryDto : updateDtoList) {
            LogicInventoryTotalEo logicInventoryTotalEo = (LogicInventoryTotalEo)logicInventoryTotalEoMap.get(updateInventoryDto.getInventoryId());
            updateInventoryDto.setBeforeBalance(logicInventoryTotalEo.getBalance());
            updateInventoryDto.setBeforeAvailable(logicInventoryTotalEo.getAvailable());
            updateInventoryDto.setBeforePreempt(logicInventoryTotalEo.getPreempt());
            updateInventoryDto.setBeforeLockInventory(logicInventoryTotalEo.getLockInventory());
            updateInventoryDto.setBeforeAllocate(logicInventoryTotalEo.getAllocate());
            updateInventoryDto.setBeforeIntransit(logicInventoryTotalEo.getIntransit());
            updateInventoryDto.setBeforeFutureIn(logicInventoryTotalEo.getFutureIn());
            updateInventoryDto.setUpdatePerson(currentUserName);
        }
    }

    @Override
    public void createLogicLogs(CalcInventoryDto calcDto, List<LogicWarehouseEo> warehouseEos, List<LogicInventoryEo> logicInventoryEos, List<InventoryOperateLogEo> operateLogEos, List<InventoryLogEo> logEos) {
        if (null == calcDto) {
            return;
        }
        Date now = new Date();
        Map logicInventoryEoMap = logicInventoryEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map logicWarehouseEoMap = warehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        for (CalcInventoryDetailDto detailDto : calcDto.getDetails()) {
            InventoryOperateLogEo operateLogEo;
            LogicInventoryEo logicInventoryEo = (LogicInventoryEo)logicInventoryEoMap.get(detailDto.getInventoryId());
            LogicWarehouseEo warehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(detailDto.getWarehouseCode());
            InventoryLogEo logEo = this.initLogicLogEo(calcDto, logicInventoryEo, warehouseEo);
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeBalance()).booleanValue()) {
                operateLogEo = this.buildLogicOperateLogEo("balance", warehouseEo, logicInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicInventoryEo.getBalance());
                operateLogEo.setChangeInventory(detailDto.getChangeBalance());
                logicInventoryEo.setBalance(BigDecimalUtils.add((BigDecimal)logicInventoryEo.getBalance(), (BigDecimal)detailDto.getChangeBalance()));
                operateLogEo.setAfterInventory(logicInventoryEo.getBalance());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailDto.getOperate())) {
                    operateLogEo.setRemark(detailDto.getOperate());
                }
                operateLogEos.add(operateLogEo);
                logEo.setBeforeBalance(operateLogEo.getBeforeInventory());
                logEo.setChangeBalance(operateLogEo.getChangeInventory());
                logEo.setAfterBalance(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeAvailable()).booleanValue()) {
                operateLogEo = this.buildLogicOperateLogEo("available", warehouseEo, logicInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicInventoryEo.getAvailable());
                operateLogEo.setChangeInventory(detailDto.getChangeAvailable());
                logicInventoryEo.setAvailable(BigDecimalUtils.add((BigDecimal)logicInventoryEo.getAvailable(), (BigDecimal)detailDto.getChangeAvailable()));
                operateLogEo.setAfterInventory(logicInventoryEo.getAvailable());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailDto.getOperate())) {
                    operateLogEo.setRemark(detailDto.getOperate());
                }
                operateLogEos.add(operateLogEo);
                logEo.setBeforeAvailable(operateLogEo.getBeforeInventory());
                logEo.setChangeAvailable(operateLogEo.getChangeInventory());
                logEo.setAfterAvailable(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangePreempt()).booleanValue()) {
                operateLogEo = this.buildLogicOperateLogEo("preempt", warehouseEo, logicInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicInventoryEo.getPreempt());
                operateLogEo.setChangeInventory(detailDto.getChangePreempt());
                logicInventoryEo.setPreempt(BigDecimalUtils.add((BigDecimal)logicInventoryEo.getPreempt(), (BigDecimal)detailDto.getChangePreempt()));
                operateLogEo.setAfterInventory(logicInventoryEo.getPreempt());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailDto.getOperate())) {
                    operateLogEo.setRemark(detailDto.getOperate());
                }
                operateLogEos.add(operateLogEo);
                logEo.setBeforePreempt(operateLogEo.getBeforeInventory());
                logEo.setChangePreempt(operateLogEo.getChangeInventory());
                logEo.setAfterPreempt(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeFutureIn()).booleanValue()) {
                operateLogEo = this.buildLogicOperateLogEo("future_in", warehouseEo, logicInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicInventoryEo.getFutureIn());
                operateLogEo.setChangeInventory(detailDto.getChangeFutureIn());
                logicInventoryEo.setFutureIn(BigDecimalUtils.add((BigDecimal)logicInventoryEo.getFutureIn(), (BigDecimal)detailDto.getChangeFutureIn()));
                operateLogEo.setAfterInventory(logicInventoryEo.getFutureIn());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailDto.getOperate())) {
                    operateLogEo.setRemark(detailDto.getOperate());
                }
                operateLogEos.add(operateLogEo);
                logEo.setBeforeFutureIn(operateLogEo.getBeforeInventory());
                logEo.setChangeFutureIn(operateLogEo.getChangeInventory());
                logEo.setAfterFutureIn(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeIntransit()).booleanValue()) {
                operateLogEo = this.buildLogicOperateLogEo("intransit", warehouseEo, logicInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicInventoryEo.getIntransit());
                operateLogEo.setChangeInventory(detailDto.getChangeIntransit());
                logicInventoryEo.setIntransit(BigDecimalUtils.add((BigDecimal)logicInventoryEo.getIntransit(), (BigDecimal)detailDto.getChangeIntransit()));
                operateLogEo.setAfterInventory(logicInventoryEo.getIntransit());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailDto.getOperate())) {
                    operateLogEo.setRemark(detailDto.getOperate());
                }
                operateLogEos.add(operateLogEo);
                logEo.setBeforeIntransit(operateLogEo.getBeforeInventory());
                logEo.setChangeIntransit(operateLogEo.getChangeInventory());
                logEo.setAfterIntransit(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeLockInventory()).booleanValue()) {
                operateLogEo = this.buildLogicOperateLogEo("lock_inventory", warehouseEo, logicInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicInventoryEo.getLockInventory());
                operateLogEo.setChangeInventory(detailDto.getChangeLockInventory());
                logicInventoryEo.setLockInventory(BigDecimalUtils.add((BigDecimal)logicInventoryEo.getLockInventory(), (BigDecimal)detailDto.getChangeLockInventory()));
                operateLogEo.setAfterInventory(logicInventoryEo.getLockInventory());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailDto.getOperate())) {
                    operateLogEo.setRemark(detailDto.getOperate());
                }
                operateLogEos.add(operateLogEo);
                logEo.setBeforeLockInventory(operateLogEo.getBeforeInventory());
                logEo.setChangeLockInventory(operateLogEo.getChangeInventory());
                logEo.setAfterLockInventory(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeAllocate()).booleanValue()) {
                operateLogEo = this.buildLogicOperateLogEo("allocate", warehouseEo, logicInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicInventoryEo.getAllocate());
                operateLogEo.setChangeInventory(detailDto.getChangeAllocate());
                logicInventoryEo.setAllocate(BigDecimalUtils.add((BigDecimal)logicInventoryEo.getAllocate(), (BigDecimal)detailDto.getChangeAllocate()));
                operateLogEo.setAfterInventory(logicInventoryEo.getAllocate());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailDto.getOperate())) {
                    operateLogEo.setRemark(detailDto.getOperate());
                }
                operateLogEos.add(operateLogEo);
                logEo.setBeforeAllocate(operateLogEo.getBeforeInventory());
                logEo.setChangeAllocate(operateLogEo.getChangeInventory());
                logEo.setAfterAllocate(operateLogEo.getAfterInventory());
            }
            logEo.setRemark(calcDto.getRemark());
            logEos.add(logEo);
        }
    }

    @Override
    public void createLogicTotalLogs(CalcInventoryDto calcDto, List<LogicWarehouseEo> warehouseEos, List<LogicInventoryTotalEo> logicInventoryTotalEos, List<InventoryOperateLogEo> operateLogEos, List<InventoryLogEo> logEos) {
        Date now = new Date();
        log.info("createLogicTotalLogs\u5165\u53c2calcDto:{},logicInventoryTotalEos\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)calcDto), (Object)JSON.toJSONString(logicInventoryTotalEos));
        Map logicInventoryTotalEoMap = logicInventoryTotalEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map logicWarehouseEoMap = warehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        for (CalcInventoryDetailDto detailDto : calcDto.getDetails()) {
            InventoryOperateLogEo operateLogEo;
            LogicInventoryTotalEo logicTotalInventoryEo = (LogicInventoryTotalEo)logicInventoryTotalEoMap.get(detailDto.getInventoryId());
            LogicWarehouseEo warehouseEo = (LogicWarehouseEo)logicWarehouseEoMap.get(detailDto.getWarehouseCode());
            InventoryLogEo logEo = this.initLogicTotalLogEo(calcDto, logicTotalInventoryEo, warehouseEo);
            logEo.setCreateTime(now);
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeBalance()).booleanValue()) {
                operateLogEo = this.buildLogicTotalOperateLogEo("balance", warehouseEo, logicTotalInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicTotalInventoryEo.getBalance());
                operateLogEo.setChangeInventory(detailDto.getChangeBalance());
                logicTotalInventoryEo.setBalance(BigDecimalUtils.add((BigDecimal)logicTotalInventoryEo.getBalance(), (BigDecimal)detailDto.getChangeBalance()));
                operateLogEo.setAfterInventory(logicTotalInventoryEo.getBalance());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                operateLogEos.add(operateLogEo);
                logEo.setBeforeBalance(operateLogEo.getBeforeInventory());
                logEo.setChangeBalance(operateLogEo.getChangeInventory());
                logEo.setAfterBalance(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeAvailable()).booleanValue()) {
                operateLogEo = this.buildLogicTotalOperateLogEo("available", warehouseEo, logicTotalInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicTotalInventoryEo.getAvailable());
                operateLogEo.setChangeInventory(detailDto.getChangeAvailable());
                logicTotalInventoryEo.setAvailable(BigDecimalUtils.add((BigDecimal)logicTotalInventoryEo.getAvailable(), (BigDecimal)detailDto.getChangeAvailable()));
                operateLogEo.setAfterInventory(logicTotalInventoryEo.getAvailable());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                operateLogEos.add(operateLogEo);
                logEo.setBeforeAvailable(operateLogEo.getBeforeInventory());
                logEo.setChangeAvailable(operateLogEo.getChangeInventory());
                logEo.setAfterAvailable(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangePreempt()).booleanValue()) {
                operateLogEo = this.buildLogicTotalOperateLogEo("preempt", warehouseEo, logicTotalInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicTotalInventoryEo.getPreempt());
                operateLogEo.setChangeInventory(detailDto.getChangePreempt());
                logicTotalInventoryEo.setPreempt(BigDecimalUtils.add((BigDecimal)logicTotalInventoryEo.getPreempt(), (BigDecimal)detailDto.getChangePreempt()));
                operateLogEo.setAfterInventory(logicTotalInventoryEo.getPreempt());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                operateLogEos.add(operateLogEo);
                logEo.setBeforePreempt(operateLogEo.getBeforeInventory());
                logEo.setChangePreempt(operateLogEo.getChangeInventory());
                logEo.setAfterPreempt(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeFutureIn()).booleanValue()) {
                operateLogEo = this.buildLogicTotalOperateLogEo("future_in", warehouseEo, logicTotalInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicTotalInventoryEo.getFutureIn());
                operateLogEo.setChangeInventory(detailDto.getChangeFutureIn());
                logicTotalInventoryEo.setFutureIn(BigDecimalUtils.add((BigDecimal)logicTotalInventoryEo.getFutureIn(), (BigDecimal)detailDto.getChangeFutureIn()));
                operateLogEo.setAfterInventory(logicTotalInventoryEo.getFutureIn());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                operateLogEos.add(operateLogEo);
                logEo.setBeforeFutureIn(operateLogEo.getBeforeInventory());
                logEo.setChangeFutureIn(operateLogEo.getChangeInventory());
                logEo.setAfterFutureIn(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeIntransit()).booleanValue()) {
                operateLogEo = this.buildLogicTotalOperateLogEo("intransit", warehouseEo, logicTotalInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicTotalInventoryEo.getIntransit());
                operateLogEo.setChangeInventory(detailDto.getChangeIntransit());
                logicTotalInventoryEo.setIntransit(BigDecimalUtils.add((BigDecimal)logicTotalInventoryEo.getIntransit(), (BigDecimal)detailDto.getChangeIntransit()));
                operateLogEo.setAfterInventory(logicTotalInventoryEo.getIntransit());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                operateLogEos.add(operateLogEo);
                logEo.setBeforeIntransit(operateLogEo.getBeforeInventory());
                logEo.setChangeIntransit(operateLogEo.getChangeInventory());
                logEo.setAfterIntransit(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeLockInventory()).booleanValue()) {
                operateLogEo = this.buildLogicTotalOperateLogEo("lock_inventory", warehouseEo, logicTotalInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicTotalInventoryEo.getLockInventory());
                operateLogEo.setChangeInventory(detailDto.getChangeLockInventory());
                logicTotalInventoryEo.setLockInventory(BigDecimalUtils.add((BigDecimal)logicTotalInventoryEo.getLockInventory(), (BigDecimal)detailDto.getChangeLockInventory()));
                operateLogEo.setAfterInventory(logicTotalInventoryEo.getLockInventory());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                operateLogEos.add(operateLogEo);
                logEo.setBeforeLockInventory(operateLogEo.getBeforeInventory());
                logEo.setChangeLockInventory(operateLogEo.getChangeInventory());
                logEo.setAfterLockInventory(operateLogEo.getAfterInventory());
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeAllocate()).booleanValue()) {
                operateLogEo = this.buildLogicTotalOperateLogEo("allocate", warehouseEo, logicTotalInventoryEo, calcDto, now);
                operateLogEo.setBeforeInventory(logicTotalInventoryEo.getAllocate());
                operateLogEo.setChangeInventory(detailDto.getChangeAllocate());
                logicTotalInventoryEo.setAllocate(BigDecimalUtils.add((BigDecimal)logicTotalInventoryEo.getAllocate(), (BigDecimal)detailDto.getChangeAllocate()));
                operateLogEo.setAfterInventory(logicTotalInventoryEo.getAllocate());
                operateLogEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)operateLogEo.getChangeInventory()) != false ? InventoryInOutEnum.IN.getCode() : InventoryInOutEnum.OUT.getCode());
                operateLogEos.add(operateLogEo);
                logEo.setBeforeAllocate(operateLogEo.getBeforeInventory());
                logEo.setChangeAllocate(operateLogEo.getChangeInventory());
                logEo.setAfterAllocate(operateLogEo.getAfterInventory());
            }
            logEo.setRemark(calcDto.getRemark());
            logEos.add(logEo);
        }
    }

    private InventoryOperateLogEo buildLogicOperateLogEo(String changeType, LogicWarehouseEo warehouseEo, LogicInventoryEo logicInventoryEo, CalcInventoryDto calcDto, Date now) {
        InventoryOperateLogEo operateLogEo = new InventoryOperateLogEo();
        operateLogEo.setId(Long.valueOf(IdWorker.getId()));
        operateLogEo.setSkuCode(logicInventoryEo.getSkuCode());
        operateLogEo.setSkuName(logicInventoryEo.getSkuName());
        operateLogEo.setBatch(logicInventoryEo.getBatch());
        operateLogEo.setBatchType(logicInventoryEo.getBatchType());
        operateLogEo.setWarehouseId(warehouseEo.getId());
        operateLogEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        operateLogEo.setWarehouseName(warehouseEo.getWarehouseName());
        operateLogEo.setWarehouseClassify(warehouseEo.getWarehouseClassify());
        operateLogEo.setSourceNo(calcDto.getSourceNo());
        operateLogEo.setSourceType(calcDto.getSourceType());
        operateLogEo.setBusinessType(calcDto.getBusinessType());
        operateLogEo.setExternalOrderNo(calcDto.getExternalOrderNo());
        operateLogEo.setRemark(calcDto.getRemark());
        operateLogEo.setChangeType(changeType);
        operateLogEo.setChangeTime(now);
        operateLogEo.setCreatePerson(ServiceContext.getContext().getRequestUserCode());
        operateLogEo.setCreateTime(now);
        return operateLogEo;
    }

    private InventoryOperateLogEo buildLogicTotalOperateLogEo(String changeType, LogicWarehouseEo warehouseEo, LogicInventoryTotalEo logicInventoryTotalEo, CalcInventoryDto calcDto, Date now) {
        InventoryOperateLogEo operateLogEo = new InventoryOperateLogEo();
        operateLogEo.setId(Long.valueOf(IdWorker.getId()));
        operateLogEo.setSkuCode(logicInventoryTotalEo.getSkuCode());
        operateLogEo.setSkuName(logicInventoryTotalEo.getSkuName());
        operateLogEo.setWarehouseId(warehouseEo.getId());
        operateLogEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        operateLogEo.setWarehouseName(warehouseEo.getWarehouseName());
        operateLogEo.setWarehouseClassify(warehouseEo.getWarehouseClassify());
        operateLogEo.setSourceNo(calcDto.getSourceNo());
        operateLogEo.setSourceType(calcDto.getSourceType());
        operateLogEo.setBusinessType(calcDto.getBusinessType());
        operateLogEo.setExternalOrderNo(calcDto.getExternalOrderNo());
        operateLogEo.setRemark(calcDto.getRemark());
        operateLogEo.setChangeType(changeType);
        operateLogEo.setChangeTime(now);
        return operateLogEo;
    }

    private InventoryLogEo initLogicLogEo(CalcInventoryDto dto, LogicInventoryEo logicInventoryEo, LogicWarehouseEo warehouseEo) {
        InventoryLogEo logEo = new InventoryLogEo();
        String warehouseClassify = warehouseEo.getWarehouseClassify();
        if (StringUtils.isBlank((String)warehouseClassify)) {
            warehouseClassify = CsWarehouseClassifyEnum.LOGIC.getCode();
        }
        logEo.setWarehouseClassify(warehouseClassify);
        logEo.setSkuCode(logicInventoryEo.getSkuCode());
        logEo.setSkuName(logicInventoryEo.getSkuName());
        logEo.setBatch(logicInventoryEo.getBatch());
        logEo.setBatchType(logicInventoryEo.getBatchType());
        logEo.setInOutFlag(dto.getFlag());
        logEo.setWarehouseId(warehouseEo.getId());
        logEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        logEo.setWarehouseType(warehouseEo.getWarehouseType());
        logEo.setWarehouseName(warehouseEo.getWarehouseName());
        logEo.setRemark(dto.getRemark());
        logEo.setSourceNo(dto.getSourceNo());
        logEo.setSourceType(dto.getSourceType());
        logEo.setExternalOrderNo(dto.getExternalOrderNo());
        logEo.setBeforeActivityAllocate(logicInventoryEo.getActivityAllocate());
        logEo.setAfterActivityAllocate(logicInventoryEo.getActivityAllocate());
        logEo.setChangeActivityAllocate(BigDecimal.ZERO);
        logEo.setBeforeAllocate(logicInventoryEo.getAllocate());
        logEo.setAfterAllocate(logicInventoryEo.getAllocate());
        logEo.setChangeAllocate(BigDecimal.ZERO);
        logEo.setBeforeAvailable(logicInventoryEo.getAvailable());
        logEo.setAfterAvailable(logicInventoryEo.getAvailable());
        logEo.setChangeAvailable(BigDecimal.ZERO);
        logEo.setBeforeBalance(logicInventoryEo.getBalance());
        logEo.setAfterBalance(logicInventoryEo.getBalance());
        logEo.setChangeBalance(BigDecimal.ZERO);
        logEo.setBeforePreempt(logicInventoryEo.getPreempt());
        logEo.setAfterPreempt(logicInventoryEo.getPreempt());
        logEo.setChangePreempt(BigDecimal.ZERO);
        logEo.setBeforeCompleted(logicInventoryEo.getCompleted());
        logEo.setAfterCompleted(logicInventoryEo.getCompleted());
        logEo.setChangeCompleted(BigDecimal.ZERO);
        logEo.setBeforeFutureIn(logicInventoryEo.getFutureIn());
        logEo.setAfterFutureIn(logicInventoryEo.getFutureIn());
        logEo.setChangeFutureIn(BigDecimal.ZERO);
        logEo.setBeforeIntransit(logicInventoryEo.getIntransit());
        logEo.setAfterIntransit(logicInventoryEo.getIntransit());
        logEo.setChangeIntransit(BigDecimal.ZERO);
        logEo.setBeforeLockInventory(logicInventoryEo.getLockInventory());
        logEo.setAfterLockInventory(logicInventoryEo.getLockInventory());
        logEo.setChangeLockInventory(BigDecimal.ZERO);
        logEo.setBeforeTransfer(logicInventoryEo.getTransfer());
        logEo.setAfterTransfer(logicInventoryEo.getTransfer());
        logEo.setChangeTransfer(BigDecimal.ZERO);
        logEo.setBusinessType(dto.getBusinessType());
        return logEo;
    }

    private InventoryLogEo initLogicTotalLogEo(CalcInventoryDto dto, LogicInventoryTotalEo logicInventoryTotalEo, LogicWarehouseEo warehouseEo) {
        InventoryLogEo logEo = new InventoryLogEo();
        logEo.setId(Long.valueOf(IdWorker.getId()));
        String warehouseClassify = warehouseEo.getWarehouseClassify();
        if (StringUtils.isBlank((String)warehouseClassify)) {
            warehouseClassify = CsWarehouseClassifyEnum.LOGIC.getCode();
        }
        logEo.setWarehouseClassify(warehouseClassify);
        logEo.setSkuCode(logicInventoryTotalEo.getSkuCode());
        logEo.setSkuName(logicInventoryTotalEo.getSkuName());
        logEo.setInOutFlag(dto.getFlag());
        logEo.setWarehouseId(warehouseEo.getId());
        logEo.setWarehouseCode(warehouseEo.getWarehouseCode());
        logEo.setWarehouseType(warehouseEo.getWarehouseType());
        logEo.setWarehouseName(warehouseEo.getWarehouseName());
        logEo.setRemark(dto.getRemark());
        logEo.setSourceNo(dto.getSourceNo());
        logEo.setSourceType(dto.getSourceType());
        logEo.setExternalOrderNo(dto.getExternalOrderNo());
        logEo.setBeforeActivityAllocate(logicInventoryTotalEo.getActivityAllocate());
        logEo.setAfterActivityAllocate(logicInventoryTotalEo.getActivityAllocate());
        logEo.setChangeActivityAllocate(BigDecimal.ZERO);
        logEo.setBeforeAllocate(logicInventoryTotalEo.getAllocate());
        logEo.setAfterAllocate(logicInventoryTotalEo.getAllocate());
        logEo.setChangeAllocate(BigDecimal.ZERO);
        logEo.setBeforeAvailable(logicInventoryTotalEo.getAvailable());
        logEo.setAfterAvailable(logicInventoryTotalEo.getAvailable());
        logEo.setChangeAvailable(BigDecimal.ZERO);
        logEo.setBeforeBalance(logicInventoryTotalEo.getBalance());
        logEo.setAfterBalance(logicInventoryTotalEo.getBalance());
        logEo.setChangeBalance(BigDecimal.ZERO);
        logEo.setBeforePreempt(logicInventoryTotalEo.getPreempt());
        logEo.setAfterPreempt(logicInventoryTotalEo.getPreempt());
        logEo.setChangePreempt(BigDecimal.ZERO);
        logEo.setBeforeCompleted(logicInventoryTotalEo.getCompleted());
        logEo.setAfterCompleted(logicInventoryTotalEo.getCompleted());
        logEo.setChangeCompleted(BigDecimal.ZERO);
        logEo.setBeforeFutureIn(logicInventoryTotalEo.getFutureIn());
        logEo.setAfterFutureIn(logicInventoryTotalEo.getFutureIn());
        logEo.setChangeFutureIn(BigDecimal.ZERO);
        logEo.setBeforeIntransit(logicInventoryTotalEo.getIntransit());
        logEo.setAfterIntransit(logicInventoryTotalEo.getIntransit());
        logEo.setChangeIntransit(BigDecimal.ZERO);
        logEo.setBeforeLockInventory(logicInventoryTotalEo.getLockInventory());
        logEo.setAfterLockInventory(logicInventoryTotalEo.getLockInventory());
        logEo.setChangeLockInventory(BigDecimal.ZERO);
        logEo.setBeforeTransfer(logicInventoryTotalEo.getTransfer());
        logEo.setAfterTransfer(logicInventoryTotalEo.getTransfer());
        logEo.setChangeTransfer(BigDecimal.ZERO);
        logEo.setCreatePerson(ServiceContext.getContext().getRequestUserCode());
        return logEo;
    }

    @Override
    public void sendInventoryLogs(List<InventoryLogEo> sendMqLogs) {
        log.info("sendInventoryLogs : {}", sendMqLogs);
        if (CollectionUtils.isEmpty(sendMqLogs)) {
            log.info("====> \u8be5\u6b21\u53d8\u52a8 \u6ca1\u6709\u6709\u6548\u6d41\u6c34\u53d8\u66f4");
            return;
        }
        List<Object> sendDataList = Lists.newArrayList();
        for (InventoryLogEo inventoryLogEo : sendMqLogs) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inventoryLogEo.getBatch())) continue;
            CsInventoryLogRespDto logRespDto = new CsInventoryLogRespDto();
            BeanUtils.copyProperties((Object)inventoryLogEo, (Object)logRespDto);
            logRespDto.setCargoCode(inventoryLogEo.getSkuCode());
            logRespDto.setCargoName(inventoryLogEo.getSkuName());
            logRespDto.setExternalSourceNo(inventoryLogEo.getExternalOrderNo());
            BigDecimal otherChangePreempt = BigDecimalUtils.subtract((BigDecimal)inventoryLogEo.getChangePreempt(), (BigDecimal)inventoryLogEo.getChangeAllocate());
            logRespDto.setSupplyChangeNum(BigDecimalUtils.subtract((BigDecimal)inventoryLogEo.getChangeBalance(), (BigDecimal)otherChangePreempt));
            if (BigDecimalUtils.eqZero((BigDecimal)logRespDto.getSupplyChangeNum()).booleanValue() && BigDecimalUtils.eqZero((BigDecimal)logRespDto.getChangePreempt()).booleanValue()) {
                log.info("\u8fc7\u6ee4\u4f9b\u8d27\u6d41\u6c34\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)inventoryLogEo));
                continue;
            }
            sendDataList.add(logRespDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sendDataList = sendDataList.stream().sorted(Comparator.comparing(CsInventoryLogRespDto::getId)).collect(Collectors.toList())))) {
            if ("single".equals(this.mqInventoryChangePushMode)) {
                for (CsInventoryLogRespDto csInventoryLogRespDto : sendDataList) {
                    MessageVo messageVo = new MessageVo();
                    messageVo.setData((Object)JSONObject.toJSONString((Object)csInventoryLogRespDto));
                    log.info("mqService=>sendInventoryChange=> topic: {}, tag: {}, messageVo: {}", new Object[]{this.mqInventoryChangeTopic, this.mqInventoryChangeTag, JSON.toJSONString((Object)messageVo)});
                    this.commonsMqService.publishMessage(this.mqInventoryChangeTopic, this.mqInventoryChangeTag, (Object)messageVo);
                }
            } else {
                MessageVo messageVo = new MessageVo();
                messageVo.setData((Object)JSONObject.toJSONString(sendDataList));
                log.info("mqService=>sendInventoryChange=> topic: {}, tag: {}, messageVo: {}", new Object[]{this.mqInventoryChangeTopic, this.mqInventoryChangeTag, JSON.toJSONString((Object)messageVo)});
                this.commonsMqService.publishMessage(this.mqInventoryChangeTopic, this.mqInventoryChangeTag, (Object)messageVo);
            }
        }
    }
}

