/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.transcation;

import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class TransactionAfterService {
    private static final Logger log = LoggerFactory.getLogger(TransactionAfterService.class);

    public void execute(final TransactionCallBackAction action) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            try {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                    public void afterCompletion(int status) {
                        if (null != action) {
                            action.callback();
                        }
                    }
                });
            }
            catch (Exception e) {
                log.error("TransactionAfterService \u5f02\u5e38: {}", (Object)e.getMessage());
                if (null != action) {
                    action.callback();
                }
            }
        } else if (null != action) {
            action.callback();
        }
    }
}

