/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.impl;

import com.alibaba.fastjson.JSONObject;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.abstracts.AbstractReceiveDeliveryResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeliveryResultOrderAbleImpl
extends AbstractReceiveDeliveryResultOrderAble {
    private static final Logger log = LoggerFactory.getLogger(DeliveryResultOrderAbleImpl.class);

    @Override
    protected void wrapperGenerateAfter(ReceiveDeliveryResultOrderContext context) {
    }

    @Override
    protected void wrapperGenerate(ReceiveDeliveryResultOrderContext context) {
        context.getReceiveDeliveryResultOrderEo().setDeliveryLogicWarehouseCode(context.getLogicWarehouseCode());
        context.getReceiveDeliveryResultOrderEo().setDeliveryLogicWarehouseName(context.getLogicWarehouseName());
        context.getReceiveDeliveryResultOrderEo().setDeliveryPhysicsWarehouseCode(context.getPhysicsWarehouseCode());
        context.getReceiveDeliveryResultOrderEo().setDeliveryPhysicsWarehouseName(context.getPhysicsWarehouseName());
        if (CollectionUtils.isNotEmpty(context.getShippingInfoReqDtoList()) && StringUtils.isNotBlank((CharSequence)context.getReceiveDeliveryResultOrderEo().getShippingCompanyCode())) {
            CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = context.getShippingInfoReqDtoList().get(0);
            context.getReceiveDeliveryResultOrderEo().setShippingCompanyCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
            context.getReceiveDeliveryResultOrderEo().setShippingType(StringUtils.isNotBlank((CharSequence)csWmsShippingInfoReqDto.getShippingType()) ? csWmsShippingInfoReqDto.getShippingType() : csWmsShippingInfoReqDto.getLogisticsType());
            context.getReceiveDeliveryResultOrderEo().setShippingCompany(csWmsShippingInfoReqDto.getShippingCompanyName());
            context.getReceiveDeliveryResultOrderEo().setShippingCode(context.getShippingInfoReqDtoList().stream().map(cs -> (String)DataExtractUtils.ifNullElse((Object)cs.getShippingNo(), (Object)cs.getConsignNo())).filter(StringUtils::isNotBlank).collect(Collectors.joining(",")));
            context.getReceiveDeliveryResultOrderEo().setShippingJson((String)DataExtractUtils.ifNullElse((Object)context.getReceiveDeliveryResultOrderEo().getShippingJson(), (Object)JSONObject.toJSONString(context.getShippingInfoReqDtoList())));
        }
    }

    @Override
    public boolean validClose(ReceiveDeliveryResultOrderContext context) {
        return false;
    }

    @Override
    public void doClose(ReceiveDeliveryResultOrderContext context) {
    }

    @Override
    public boolean validCancel(ReceiveDeliveryResultOrderContext context) {
        return false;
    }

    @Override
    public void doCancel(ReceiveDeliveryResultOrderContext context) {
    }
}

