/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.abstracts.AbstractReceiveDeliveryNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeliveryNoticeOrderAbleImpl
extends AbstractReceiveDeliveryNoticeOrderAble {
    private static final Logger log = LoggerFactory.getLogger(DeliveryNoticeOrderAbleImpl.class);
    @Resource
    ICalcInventoryService calcInventoryService;
    @Resource
    IInventoryPreemptionDomain inventoryPreemptionDomain;

    @Override
    protected void wrapperGenerateAfter(ReceiveDeliveryNoticeOrderContext context) {
    }

    private void preempt(ReceiveDeliveryNoticeOrderContext context) {
        PreemptDto preemptDto = new PreemptDto();
        this.wrapper(context, (CalcDto)preemptDto);
        preemptDto.setNoneLineNo(Boolean.TRUE);
        preemptDto.setIsSaleOrder(context.getIsSaleOrder());
        preemptDto.setValidNegative(context.getValidNegative());
        preemptDto.setShoutBatch(context.getShoutBatch());
        preemptDto.setIsSaleOrder(context.getIsSaleOrder());
        preemptDto.setLendEnable(context.isLendEnable());
        if (!context.getShoutBatch().booleanValue()) {
            preemptDto.setNoneBatch(Boolean.valueOf(true));
        }
        preemptDto.setExistsForError(context.getExistsForError());
        ReceiveDeliveryNoticeOrderEo noticeOrderEo = context.getReceiveDeliveryNoticeOrderEo();
        if (Objects.nonNull(noticeOrderEo) && StrUtil.isBlank((CharSequence)preemptDto.getBusinessType())) {
            preemptDto.setBusinessType(noticeOrderEo.getBusinessType());
        }
        preemptDto.setNoneBatch(Boolean.valueOf(StringUtils.isBlank((CharSequence)context.getOrderBasicsDetailReqDtoList().get(0).getBatch())));
        List<InventoryPreemptionEo> inventoryPreemptionEos = this.inventoryPreemptionDomain.queryBySourceNo(Optional.ofNullable(context.getRelevanceNo()).orElse(context.getDocumentNo()));
        if (CollectionUtils.isNotEmpty((Collection)inventoryPreemptionEos)) {
            boolean hasBatch = context.getOrderBasicsDetailReqDtoList().stream().anyMatch(o -> StringUtils.isNotBlank((CharSequence)o.getBatch()));
            Map<String, BigDecimal> reqDecimalMap = inventoryPreemptionEos.stream().collect(Collectors.groupingBy(r -> this.getMatchKey(context, r.getSkuCode(), r.getBatch(), hasBatch), Collectors.mapping(eo -> BigDecimalUtils.subtract((BigDecimal)eo.getPreemptNum(), (BigDecimal)eo.getReleaseNum()), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            if (!context.getOrderBasicsDetailReqDtoList().stream().collect(Collectors.groupingBy(r -> this.getMatchKey(context, r.getSkuCode(), r.getBatch(), hasBatch), Collectors.mapping(BaseOrderDetailReqDto::getQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))).entrySet().stream().allMatch(k -> BigDecimalUtils.equals((BigDecimal)((BigDecimal)reqDecimalMap.get(k.getKey())), (BigDecimal)((BigDecimal)k.getValue())))) {
                inventoryPreemptionEos = this.calcInventoryService.updatePreempt(preemptDto);
            }
        } else {
            inventoryPreemptionEos = this.calcInventoryService.updatePreempt(preemptDto);
        }
        List<BaseOrderDetailReqDto> orderBasicsDetailReqDtoList = context.getOrderBasicsDetailReqDtoList();
        Map<String, BaseOrderDetailReqDto> skuOptMap = orderBasicsDetailReqDtoList.stream().collect(Collectors.toMap(BaseOrderDetailReqDto::getSkuCode, o -> o, (o1, o2) -> o1));
        Map<String, BaseOrderDetailReqDto> skuOptBatchMap = orderBasicsDetailReqDtoList.stream().collect(Collectors.toMap(b -> b.getSkuCode() + b.getBatch(), o -> o, (o1, o2) -> o1));
        HashMap<Long, BaseOrderDetailReqDto> preTradeIdMap = new HashMap<Long, BaseOrderDetailReqDto>(10);
        for (BaseOrderDetailReqDto r2 : orderBasicsDetailReqDtoList) {
            if (!Objects.nonNull(r2.getPreOrderItemId())) continue;
            preTradeIdMap.putIfAbsent(r2.getPreOrderItemId(), r2);
        }
        context.setOrderBasicsDetailReqDtoList(inventoryPreemptionEos.stream().map(in -> {
            BaseOrderDetailReqDto reqDto;
            if (context.getIsBatchManage().booleanValue()) {
                reqDto = (BaseOrderDetailReqDto)BeanUtil.copyProperties(skuOptBatchMap.getOrDefault(in.getSkuCode() + in.getBatch(), (BaseOrderDetailReqDto)skuOptMap.get(in.getSkuCode())), BaseOrderDetailReqDto.class, (String[])new String[0]);
                reqDto.setBatch(in.getBatch());
            } else {
                reqDto = Objects.nonNull(in.getPreOrderItemId()) && !preTradeIdMap.isEmpty() ? (BaseOrderDetailReqDto)BeanUtil.copyProperties(preTradeIdMap.get(in.getPreOrderItemId()), BaseOrderDetailReqDto.class, (String[])new String[0]) : (BaseOrderDetailReqDto)BeanUtil.copyProperties(skuOptMap.get(in.getSkuCode()), BaseOrderDetailReqDto.class, (String[])new String[0]);
                reqDto.setBatch(null);
            }
            reqDto.setQuantity(in.getPreemptNum());
            reqDto.setLineNo(in.getLineNo());
            return reqDto;
        }).collect(Collectors.toList()));
        context.setReceiveDeliveryNoticeOrderDetailEoList(this.getReceiveDeliveryNoticeOrderDetailEos(context, context.getReceiveDeliveryNoticeOrderEo()));
    }

    @NotNull
    private String getMatchKey(ReceiveDeliveryNoticeOrderContext context, String skuCode, String batch, boolean hasBatch) {
        return context.getLogicWarehouseCode() + "_" + skuCode + (hasBatch ? "_" + batch : "");
    }

    private void wrapper(ReceiveDeliveryNoticeOrderContext context, CalcDto transferInDto) {
        context.wrapperInventoryOd(transferInDto);
        List detailDtos = context.getOrderBasicsDetailReqDtoList().stream().map(detail -> this.getCalcDetailDto(context, (BaseOrderDetailReqDto)detail)).collect(Collectors.toList());
        transferInDto.setDetails(detailDtos);
    }

    private CalcDetailDto getCalcDetailDto(ReceiveDeliveryNoticeOrderContext context, BaseOrderDetailReqDto detail) {
        CalcDetailDto detailDto = new CalcDetailDto();
        detailDto.setBatch(detail.getBatch());
        detailDto.setLineNo(detail.getLineNo());
        detailDto.setPreOrderItemId(detail.getPreOrderItemId());
        detailDto.setLogicWarehouseCode(context.getLogicWarehouseCode());
        detailDto.setSkuCode(detail.getSkuCode());
        detailDto.setNum(detail.getQuantity());
        if (context.isLendEnable()) {
            detailDto.setLendDto(detail.getLendDto());
        }
        return detailDto;
    }

    @Override
    protected void wrapperGenerate(ReceiveDeliveryNoticeOrderContext context) {
        context.getReceiveDeliveryNoticeOrderEo().setDeliveryLogicWarehouseCode(context.getLogicWarehouseCode());
        context.getReceiveDeliveryNoticeOrderEo().setDeliveryLogicWarehouseName(context.getLogicWarehouseName());
        context.getReceiveDeliveryNoticeOrderEo().setDeliveryPhysicsWarehouseCode(context.getPhysicsWarehouseCode());
        context.getReceiveDeliveryNoticeOrderEo().setDeliveryPhysicsWarehouseName(context.getPhysicsWarehouseName());
        context.getReceiveDeliveryNoticeOrderEo().setWarehouseCode(context.getLogicWarehouseCode());
        context.getReceiveDeliveryNoticeOrderEo().setJumpDocumentType(context.getJumpDocumentType());
        context.getReceiveDeliveryNoticeOrderEo().setJumpDocumentName(context.getJumpDocumentName());
        context.getReceiveDeliveryNoticeOrderEo().setDisplayBusinessType(context.getDisplayBusinessType());
        context.getReceiveDeliveryNoticeOrderEo().setDisplayBusinessName(context.getDisplayBusinessName());
        if (!context.getUpdateInventory().booleanValue()) {
            return;
        }
        if (this.canNoticeInventoryProcess(context)) {
            this.preempt(context);
        }
    }

    @Override
    public void merge(ReceiveDeliveryNoticeOrderContext context) {
    }

    @Override
    protected void doCloseInventory(ReceiveDeliveryNoticeOrderContext context) {
        this.releasePreempt(context);
    }

    @Override
    protected String getCompleteStatus(ReceiveDeliveryNoticeOrderContext inOutNoticeOrderContext) {
        return inOutNoticeOrderContext.isNoticeEnd() ? BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode() : BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode();
    }

    @Override
    public void doCancel(ReceiveDeliveryNoticeOrderContext context) {
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context.getReceiveDeliveryNoticeOrderEo();
        ReceiveDeliveryNoticeOrderEo updateEo = new ReceiveDeliveryNoticeOrderEo();
        updateEo.setId(receiveDeliveryNoticeOrderEo.getId());
        updateEo.setOrderStatus(BaseOrderStatusEnum.DNO_CANCEL.getCode());
        this.receiveDeliveryNoticeOrderDomain.getMapper().updateById((BaseEo)updateEo);
        this.releasePreempt(context);
        this.updateDetailQuantity(context);
    }

    private void releasePreempt(ReceiveDeliveryNoticeOrderContext context) {
        if (!context.getUpdateInventory().booleanValue()) {
            return;
        }
        this.loadDetailList(context);
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(context.getReceiveDeliveryNoticeOrderEo().getRelevanceNo());
        releasePreemptParam.setSourceType((String)DataExtractUtils.ifNullElse((Object)context.getSourceType(), (Object)context.getReceiveDeliveryNoticeOrderEo().getBusinessType()));
        releasePreemptParam.setBusinessType((String)DataExtractUtils.ifNullElse((Object)context.getBusinessType(), (Object)DataExtractUtils.ifNullElse((Object)context.getReceiveDeliveryNoticeOrderEo().getDisplayBusinessType(), (Object)context.getReceiveDeliveryNoticeOrderEo().getBusinessType())));
        releasePreemptParam.setIsSaleOrder(context.getIsSaleOrder());
        releasePreemptParam.setDetails(context.getReceiveDeliveryNoticeOrderDetailEoList().stream().filter(r -> BigDecimalUtils.gtZero((BigDecimal)r.getWaitQuantity())).map(detail -> {
            CalcDetailDto detailDto = new CalcDetailDto();
            detailDto.setBatch(detail.getBatch());
            detailDto.setLineNo(detail.getLineNo());
            detailDto.setPreOrderItemId(detail.getPreOrderItemId());
            detailDto.setLogicWarehouseCode(context.getLogicWarehouseCode());
            detailDto.setSkuCode(detail.getSkuCode());
            detailDto.setNum(detail.getWaitQuantity());
            return detailDto;
        }).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)releasePreemptParam.getDetails())) {
            return;
        }
        this.calcInventoryService.releasePreempt(releasePreemptParam);
    }
}

