/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.impl;

import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.FormOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.abstracts.AbstractInOutResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OutResultOrderAbleImpl
extends AbstractInOutResultOrderAble {
    private static final Logger log = LoggerFactory.getLogger(OutResultOrderAbleImpl.class);
    @Resource
    private ICalcInventoryService calcInventoryService;

    @Override
    protected void wrapperGenerateAfter(InOutResultOrderContext context) {
        if (!context.getUpdateInventory().booleanValue()) {
            return;
        }
        if (this.isProcessInTransit(context)) {
            TransferOutDto transferInDto = new TransferOutDto();
            this.wrapperInventoryVo(context, (CalcDto)transferInDto);
            if (CollectionUtils.isEmpty((Collection)transferInDto.getDetails())) {
                return;
            }
            transferInDto.setValidNegative(context.getValidNegative());
            if (context.isAppendRecord()) {
                transferInDto.setNoneLineNo(Boolean.valueOf(true));
                transferInDto.setIgnorePreempt(Boolean.valueOf(true));
                transferInDto.setValidNegative(Boolean.valueOf(false));
            } else {
                transferInDto.setIgnorePreempt(Boolean.valueOf(context.isIgnorePreempt()));
            }
            transferInDto.setInLogicWarehouseCode(context.getTransferInLogicWarehouseCode());
            this.calcInventoryService.transferOut(transferInDto);
        } else {
            FormOutDto formInDto = new FormOutDto();
            this.wrapperInventoryVo(context, (CalcDto)formInDto);
            if (CollectionUtils.isEmpty((Collection)formInDto.getDetails())) {
                return;
            }
            formInDto.setValidNegative(context.getValidNegative());
            if (context.isAppendRecord() || !this.canNoticeInventoryProcess(context)) {
                formInDto.setNoneLineNo(Boolean.valueOf(true));
                formInDto.setIgnorePreempt(Boolean.valueOf(true));
                formInDto.setValidNegative(Boolean.valueOf(false));
            } else {
                formInDto.setIgnorePreempt(Boolean.valueOf(context.isIgnorePreempt()));
            }
            formInDto.setIsSaleOrder(context.getIsSaleOrder());
            this.calcInventoryService.formOut(formInDto);
        }
    }

    private boolean isProcessInTransit(InOutResultOrderContext context) {
        return CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)context.getRelevanceTableName()) && context.getCanProcessTransit() != false && !context.isOnlyProcessResult() && !context.isAppendRecord() && this.canNoticeInventoryProcess(context);
    }

    private void wrapperInventoryVo(InOutResultOrderContext context, CalcDto transferInDto) {
        context.wrapperInventoryOd(transferInDto);
        ArrayList detailDtos = new ArrayList(context.getInOutResultOrderDetailEoList().stream().filter(e -> e.getDoneQuantity().compareTo(BigDecimal.ZERO) != 0).map(detail -> this.getCalcDetailDto(context, (InOutResultOrderDetailEo)detail)).collect(Collectors.toMap(r -> r.getLineNo() + "_" + r.getSkuCode() + "_" + r.getBatch(), Function.identity(), (o, o1) -> {
            o.setNum(BigDecimalUtils.add((BigDecimal)o.getNum(), (BigDecimal)o1.getNum()));
            return o;
        })).values());
        transferInDto.setDetails(detailDtos);
    }

    @Override
    protected String getHangUpStatus() {
        return BaseOrderStatusEnum.ORO_HANG_UP.getCode();
    }

    @Override
    protected void wrapperGenerate(InOutResultOrderContext context) {
        context.getInOutResultOrderEo().setOutLogicWarehouseCode(context.getLogicWarehouseCode());
        context.getInOutResultOrderEo().setOutLogicWarehouseName(context.getLogicWarehouseName());
        context.getInOutResultOrderEo().setOutPhysicsWarehouseCode(context.getPhysicsWarehouseCode());
        context.getInOutResultOrderEo().setOutPhysicsWarehouseName(context.getPhysicsWarehouseName());
    }

    @Override
    public boolean validClose(InOutResultOrderContext context) {
        return false;
    }

    @Override
    public void doClose(InOutResultOrderContext context) {
    }

    @Override
    public boolean validCancel(InOutResultOrderContext context) {
        return super.validCancel(context);
    }

    @Override
    public void doCancel(InOutResultOrderContext context) {
        InOutResultOrderEo inOutResultOrderEo = context.getInOutResultOrderEo();
        InOutResultOrderEo updateEo = new InOutResultOrderEo();
        updateEo.setId(inOutResultOrderEo.getId());
        updateEo.setOrderStatus(BaseOrderStatusEnum.ORO_CANCEL.getCode());
        this.inOutResultOrderDomain.getMapper().updateById((BaseEo)inOutResultOrderEo);
    }

    @Override
    protected String getCompleteStatus() {
        return BaseOrderStatusEnum.ORO_DONE_OUT.getCode();
    }

    @Override
    protected void setUnhookWarehouse(InOutResultOrderContext context) {
        context.setLogicWarehouseCode(context.getInOutResultOrderEo().getOutLogicWarehouseCode());
        context.setLogicWarehouseName(context.getInOutResultOrderEo().getOutLogicWarehouseName());
        context.setPhysicsWarehouseCode(context.getInOutResultOrderEo().getOutPhysicsWarehouseCode());
        context.setPhysicsWarehouseName(context.getInOutResultOrderEo().getOutPhysicsWarehouseName());
    }

    @Override
    protected void unhookAfter(InOutResultOrderContext context) {
        this.wrapperGenerateAfter(context);
    }
}

