/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.domain.impl.share;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.dao.das.share.IDgChannelWarehouseDas;
import com.yunxi.dg.base.center.report.dao.das.share.IDgVirtualWarehouseDas;
import com.yunxi.dg.base.center.report.domain.share.IDgVirtualWarehouseDomain;
import com.yunxi.dg.base.center.report.dto.share.DgChannelWarehouseDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualWarehouseDto;
import com.yunxi.dg.base.center.report.dto.share.DgVirtualWarehousePageReqDto;
import com.yunxi.dg.base.center.report.eo.share.DgVirtualWarehouseEo;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DgVirtualWarehouseDomainImpl
extends BaseDomainImpl<DgVirtualWarehouseEo>
implements IDgVirtualWarehouseDomain {
    @Resource
    private IDgVirtualWarehouseDas das;
    @Autowired
    IDgChannelWarehouseDas dgChannelWarehouseDas;

    public ICommonDas<DgVirtualWarehouseEo> commonDas() {
        return this.das;
    }

    @Override
    public List<DgVirtualWarehouseDto> queryList(DgVirtualWarehousePageReqDto dto) {
        List dtoList = this.das.queryList(dto);
        List virtualWarehouseCodes = dtoList.stream().map(DgVirtualWarehouseDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List groupIds = dtoList.stream().map(DgVirtualWarehouseDto::getGroupId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> channelWarehouseMap = Maps.newHashMap();
        Map<Object, Object> virtualWarehouseMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(virtualWarehouseCodes)) {
            List dgChannelWarehouseDtoList = this.dgChannelWarehouseDas.queryByVirtualWarehouseCodes(virtualWarehouseCodes);
            channelWarehouseMap = dgChannelWarehouseDtoList.stream().collect(Collectors.groupingBy(DgChannelWarehouseDto::getRelVirtualWarehouseCode));
        }
        if (CollectionUtil.isNotEmpty(groupIds)) {
            List groupVirtualWarehouseEos = this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgVirtualWarehouseEo.class).in(DgVirtualWarehouseEo::getGroupId, groupIds)).eq(DgVirtualWarehouseEo::getWarehouseType, (Object)"1")).eq(DgVirtualWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            virtualWarehouseMap = groupVirtualWarehouseEos.stream().collect(Collectors.groupingBy(DgVirtualWarehouseEo::getGroupId));
        }
        for (DgVirtualWarehouseDto respDto : dtoList) {
            List dgVirtualWarehouseEos;
            List mapChannelWarehouseDtoList = (List)channelWarehouseMap.get(respDto.getWarehouseCode());
            if (CollectionUtil.isNotEmpty((Collection)mapChannelWarehouseDtoList)) {
                String relChannelWarehouseName = mapChannelWarehouseDtoList.stream().map(DgChannelWarehouseDto::getWarehouseName).collect(Collectors.joining(","));
                respDto.setRelChannelWarehouseName(relChannelWarehouseName);
            }
            if (!CollectionUtil.isNotEmpty((Collection)(dgVirtualWarehouseEos = (List)virtualWarehouseMap.get(respDto.getGroupId())))) continue;
            String subWarehouseName = dgVirtualWarehouseEos.stream().map(DgVirtualWarehouseEo::getWarehouseName).collect(Collectors.joining(","));
            respDto.setSubWarehouseName(subWarehouseName);
        }
        return dtoList;
    }
}

