/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.FilePlaceRecordConverter;
import com.yunxi.dg.base.center.report.domain.entity.IFilePlaceRecordDomain;
import com.yunxi.dg.base.center.report.dto.entity.FilePlaceRecordDto;
import com.yunxi.dg.base.center.report.dto.entity.FilePlaceRecordPageReqDto;
import com.yunxi.dg.base.center.report.eo.FilePlaceRecordEo;
import com.yunxi.dg.base.center.report.service.entity.IFilePlaceRecordService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class FilePlaceRecordServiceImpl
extends BaseServiceImpl<FilePlaceRecordDto, FilePlaceRecordEo, IFilePlaceRecordDomain>
implements IFilePlaceRecordService {
    private static final Logger log = LoggerFactory.getLogger(FilePlaceRecordServiceImpl.class);
    @Resource
    private IContext context;

    public FilePlaceRecordServiceImpl(IFilePlaceRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<FilePlaceRecordDto, FilePlaceRecordEo> converter() {
        return FilePlaceRecordConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<FilePlaceRecordDto>> queryPage(FilePlaceRecordPageReqDto queryDto) {
        LocalDateTime localDateTime;
        LocalDate localDate;
        if (queryDto.getFromDt() != null) {
            Date fromDt = queryDto.getFromDt();
            localDate = fromDt.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            localDateTime = localDate.atStartOfDay();
            queryDto.setFromDt(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        }
        if (queryDto.getToDt() != null) {
            Date toDt = queryDto.getToDt();
            localDate = toDt.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            localDateTime = localDate.atTime(23, 59, 59);
            queryDto.setToDt(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        }
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IFilePlaceRecordDomain)this.domain).filter().like(StringUtils.isNotBlank((CharSequence)queryDto.getPlaceFileName()), (Object)"place_file_name", (Object)("%" + queryDto.getPlaceFileName() + "%"))).in(CollectionUtil.isNotEmpty((Collection)queryDto.getPlaceModuleCodeList()), (Object)"place_module_code", (Collection)queryDto.getPlaceModuleCodeList())).like(StringUtils.isNotBlank((CharSequence)queryDto.getCreatePersonName()), (Object)"create_person_name", (Object)("%" + queryDto.getCreatePersonName() + "%"))).like(StringUtils.isNotBlank((CharSequence)queryDto.getCreatePerson()), (Object)"create_person", (Object)("%" + queryDto.getCreatePerson() + "%"))).ge(ObjectUtils.isNotEmpty((Object)queryDto.getFromDt()), (Object)"create_time", (Object)queryDto.getFromDt())).le(ObjectUtils.isNotEmpty((Object)queryDto.getToDt()), (Object)"create_time", (Object)queryDto.getToDt())).eq(ObjectUtils.isNotEmpty((Object)queryDto.getStatus()), (Object)"status", (Object)queryDto.getStatus())).eq(ObjectUtils.isNotEmpty((Object)queryDto.getPlaceCostMonth()), (Object)"place_cost_month", (Object)queryDto.getPlaceCostMonth())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getPlaceLinkFileTaskCode()), (Object)"place_link_file_task_code", (Object)queryDto.getPlaceLinkFileTaskCode())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getPhysicalWarehouseCode()), (Object)"physical_warehouse_code", (Object)queryDto.getPhysicalWarehouseCode())).orderByDesc((Object)"create_time")).page(queryDto.getPageNum(), queryDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)eoPageInfo, (Object)dtoPageInfo, (String[])new String[]{"list"});
        List list = BeanUtil.copyToList((Collection)eoPageInfo.getList(), FilePlaceRecordDto.class);
        dtoPageInfo.setList(list);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public void logicDeleteHistory(FilePlaceRecordPageReqDto reqDto) {
        log.info("\u903b\u8f91\u5220\u9664\u5386\u53f2\u5f52\u6863\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtils.isFalse((StringUtils.isBlank((CharSequence)reqDto.getPlaceModuleCode()) || StringUtils.isBlank((CharSequence)reqDto.getPlaceCostMonth()) ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u5f52\u6863\u6a21\u5757\u53ca\u5f52\u6863\u8d39\u7528\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        List placeRecordEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IFilePlaceRecordDomain)this.domain).filter().eq((Object)"place_module_code", (Object)reqDto.getPlaceModuleCode())).eq((Object)"place_cost_month", (Object)reqDto.getPlaceCostMonth())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getPhysicalWarehouseCode()), (Object)"physical_warehouse_code", (Object)reqDto.getPhysicalWarehouseCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)placeRecordEoList)) {
            List ids = placeRecordEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            ((IFilePlaceRecordDomain)this.domain).logicDeleteByIds(ids);
        }
    }

    @Override
    public void logicDeleteConfineCreatePerson(Long id) {
        log.info("\u903b\u8f91\u5220\u9664\u6570\u636e\u5f52\u6863\u8bb0\u5f55\u8868\u6570\u636e\uff0c\u9650\u5236\u521b\u5efa\u4eba\uff1a{}", (Object)id);
        FilePlaceRecordEo recordEo = (FilePlaceRecordEo)((IFilePlaceRecordDomain)this.domain).selectByPrimaryKey(id);
        AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)recordEo), (String)"\u627e\u4e0d\u5230\u5220\u9664\u8bb0\u5f55");
        AssertUtils.isFalse((!recordEo.getCreatePerson().equals(this.context.userName()) ? 1 : 0) != 0, (String)"\u5220\u9664\u5931\u8d25\uff0c\u53ea\u80fd\u64cd\u4f5c\u81ea\u5df1\u5f52\u6863\u7684\u6587\u6863");
        ((IFilePlaceRecordDomain)this.domain).logicDeleteById(recordEo.getId());
    }
}

