/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.response.ApportionmentConfigExtRespDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentOrderBizTypeRespDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentOrganizationRespDto;
import com.dtyunxi.finance.api.query.IApportionmentConfigQueryApi;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.BusinessTypeCodeEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.DailyDeliveryReportDealDetailConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportDealDetailDomain;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportDealDetailEo;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DailyDeliveryReportDealDetailServiceImpl
extends BaseServiceImpl<DailyDeliveryReportDealDetailDto, DailyDeliveryReportDealDetailEo, IDailyDeliveryReportDealDetailDomain>
implements IDailyDeliveryReportDealDetailService {
    private static final Logger logger = LoggerFactory.getLogger(DailyDeliveryReportDealDetailServiceImpl.class);
    @Resource
    private IApportionmentConfigQueryApi apportionmentConfigQueryApi;

    public DailyDeliveryReportDealDetailServiceImpl(IDailyDeliveryReportDealDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DailyDeliveryReportDealDetailDto, DailyDeliveryReportDealDetailEo> converter() {
        return DailyDeliveryReportDealDetailConverter.INSTANCE;
    }

    @Override
    public PageInfo<DailyDeliveryReportDealDetailDto> queryPage(DailyDeliveryReportDealDetailDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u4ea4\u6613\u4f59\u91cf\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo pageInfo = ((IDailyDeliveryReportDealDetailDomain)this.domain).queryPage(dto);
        if (ObjectUtil.isNotEmpty((Object)pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(info -> {
                info.setDealTypeStr(BusinessTypeCodeEnum.getMsgByCode((String)info.getDealType()));
                info.setApportionRemain(info.getDealQuantity().subtract(info.getApportionAlready()));
            });
        }
        return pageInfo;
    }

    @Override
    public List<DailyDeliveryReportDealDetailDto> queryList(DailyDeliveryReportDealDetailDto dto) {
        return ((IDailyDeliveryReportDealDetailDomain)this.domain).queryList(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAdd(List<DailyDeliveryReportDealDetailDto> dtoList) {
        logger.info("\u6279\u91cf\u65b0\u589e\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u4ea4\u6613\u4f59\u91cf\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(dtoList));
        List dealRelationIds = dtoList.stream().map(DailyDeliveryReportDealDetailDto::getDealRelationId).collect(Collectors.toList());
        List dealDetailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDailyDeliveryReportDealDetailDomain)this.domain).filter().in((Object)"deal_relation_id", dealRelationIds)).eq((Object)"fee_module", (Object)dtoList.get(0).getFeeModule())).list();
        Map dealDetailEoMap = Optional.ofNullable(dealDetailEoList).map(m -> m.stream().collect(Collectors.toMap(DailyDeliveryReportDealDetailEo::getDealRelationId, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        for (DailyDeliveryReportDealDetailDto dto : dtoList) {
            if (dealDetailEoMap.containsKey(dto.getDealRelationId())) {
                logger.info("\u5355\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u5904\u7406");
                continue;
            }
            DailyDeliveryReportDealDetailEo dailyDeliveryReportDealDetailEo = (DailyDeliveryReportDealDetailEo)BeanUtil.copyProperties((Object)dto, DailyDeliveryReportDealDetailEo.class, (String[])new String[]{"id", "extension", "createPerson", "createTime", "updatePerson", "updateTime", "dr"});
            ((IDailyDeliveryReportDealDetailDomain)this.domain).insert((BaseEo)dailyDeliveryReportDealDetailEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void buildByFeeModule(DailyDeliveryReportDealDetailDto dto) {
        logger.info("\u6839\u636e\u8d39\u7528\u6a21\u5757\u751f\u6210\u4ea4\u6613\u4f59\u91cf\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getFeeModule()), (String)"\u8d39\u7528\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a");
        ApportionmentConfigExtRespDto configExtRespDto = (ApportionmentConfigExtRespDto)RestResponseHelper.extractData((RestResponse)this.apportionmentConfigQueryApi.queryByCostModuleCode(dto.getFeeModule()));
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)configExtRespDto), (String)("\u627e\u4e0d\u5230\u6a21\u5757\u5206\u644a\u914d\u7f6e\u4fe1\u606f\uff1a" + dto.getFeeModule()));
        logger.info("\u8bfb\u53d6\u5206\u644a\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)configExtRespDto));
        if (CollectionUtil.isNotEmpty((Collection)configExtRespDto.getOrderBizTypeList())) {
            List dealTypeList = configExtRespDto.getOrderBizTypeList().stream().map(ApportionmentOrderBizTypeRespDto::getBizType).collect(Collectors.toList());
            dto.setDealTypeList(dealTypeList);
        }
        if (CollectionUtil.isNotEmpty((Collection)configExtRespDto.getOrganizationList())) {
            List excludeInInventoryOrgList = configExtRespDto.getOrganizationList().stream().map(ApportionmentOrganizationRespDto::getOrganizationName).collect(Collectors.toList());
            dto.setExcludeInInventoryOrgList(excludeInInventoryOrgList);
        }
        Map<String, Date> map = this.setDealTimeScope(dto.getBookkeepingMonth(), configExtRespDto.getTradeApportionmentDeadline());
        dto.setDealTimeStart(map.get("startDate"));
        dto.setDealTimeEnd(map.get("endDate"));
        logger.info("\u6784\u5efa\u67e5\u8be2\u5185\u90e8\u4ea4\u6613\u4f59\u91cf\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        List dailyDeliveryReportDealDetailDtoList = ((IDailyDeliveryReportDealDetailDomain)this.domain).queryBuildByDeliveryResultOrderDetail(dto);
        if (CollectionUtil.isEmpty((Collection)dailyDeliveryReportDealDetailDtoList)) {
            logger.info("\u65e0\u4f59\u91cf\u660e\u7ec6\u6570\u636e");
            return;
        }
        dailyDeliveryReportDealDetailDtoList.forEach(detail -> {
            detail.setBookkeepingMonth(dto.getBookkeepingMonth());
            detail.setFeeModule(dto.getFeeModule());
            detail.setApportionAlready(BigDecimal.ZERO);
            detail.setApportionRemain(BigDecimal.ZERO);
        });
        this.batchAdd(dailyDeliveryReportDealDetailDtoList);
    }

    private Map<String, Date> setDealTimeScope(String bookkeepingMonth, Integer tradeApportionmentDeadline) {
        String[] parts = bookkeepingMonth.split("-");
        int year = Integer.parseInt(parts[0]);
        int month = Integer.parseInt(parts[1]);
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        calendar.set(year, month - 1, 1, 23, 59, 59);
        calendar.set(14, 999);
        calendar.add(2, 1);
        calendar.add(5, tradeApportionmentDeadline - 1);
        Date endDate = calendar.getTime();
        HashMap<String, Date> resultMap = new HashMap<String, Date>();
        resultMap.put("startDate", startDate);
        resultMap.put("endDate", endDate);
        return resultMap;
    }
}

