/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.BusinessTypeCodeEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.DailyDeliveryReportCostBelongDetailConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportCostBelongDetailDomain;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportCostBelongDetailEo;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DailyDeliveryReportCostBelongDetailServiceImpl
extends BaseServiceImpl<DailyDeliveryReportCostBelongDetailDto, DailyDeliveryReportCostBelongDetailEo, IDailyDeliveryReportCostBelongDetailDomain>
implements IDailyDeliveryReportCostBelongDetailService {
    private static final Logger logger = LoggerFactory.getLogger(DailyDeliveryReportCostBelongDetailServiceImpl.class);

    public DailyDeliveryReportCostBelongDetailServiceImpl(IDailyDeliveryReportCostBelongDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DailyDeliveryReportCostBelongDetailDto, DailyDeliveryReportCostBelongDetailEo> converter() {
        return DailyDeliveryReportCostBelongDetailConverter.INSTANCE;
    }

    @Override
    public PageInfo<DailyDeliveryReportCostBelongDetailDto> queryPage(DailyDeliveryReportCostBelongDetailDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u8ba1\u8d39\u5f52\u5c5e\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo pageInfo = ((IDailyDeliveryReportCostBelongDetailDomain)this.domain).queryPage(dto);
        if (ObjectUtil.isNotEmpty((Object)pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(info -> {
                info.setCostTypeStr(DailyDeliveryReportCostBelongDetailCostTypeEnum.getDesc((String)info.getCostType()));
                if (StringUtils.isNotBlank((CharSequence)info.getBusinessType())) {
                    info.setBusinessTypeStr(BusinessTypeCodeEnum.getMsgByCode((String)info.getBusinessType()));
                }
                if (StringUtils.isNotBlank((CharSequence)info.getDealType())) {
                    info.setDealTypeStr(BusinessTypeCodeEnum.getMsgByCode((String)info.getDealType()));
                }
            });
        }
        return pageInfo;
    }

    @Override
    public List<DailyDeliveryReportCostBelongDetailDto> queryList(DailyDeliveryReportCostBelongDetailDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u8ba1\u8d39\u5f52\u5c5e\u660e\u7ec6\u5217\u8868\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        return ((IDailyDeliveryReportCostBelongDetailDomain)this.domain).queryList(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAdd(List<DailyDeliveryReportCostBelongDetailDto> dtoList) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u8ba1\u8d39\u5f52\u5c5e\u660e\u7ec6\u6279\u91cf\u65b0\u589e\uff1a{}", (Object)JSON.toJSONString(dtoList));
        List costBelongDetailEoList = BeanUtil.copyToList(dtoList, DailyDeliveryReportCostBelongDetailEo.class);
        ((IDailyDeliveryReportCostBelongDetailDomain)this.domain).insertBatch(costBelongDetailEoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDeleteByStockApportionIds(List<Long> stockApportionIds) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u8ba1\u8d39\u5f52\u5c5e\u660e\u7ec6\u6839\u636e\u5206\u644a\u5355\u636eid\u6279\u91cf\u903b\u8f91\u5220\u9664\uff1a{}", (Object)JSON.toJSONString(stockApportionIds));
        List costBelongDetailEoList = ((ExtQueryChainWrapper)((IDailyDeliveryReportCostBelongDetailDomain)this.domain).filter().in((Object)"stock_apportion_id", stockApportionIds)).list();
        if (CollectionUtil.isNotEmpty((Collection)costBelongDetailEoList)) {
            List ids = costBelongDetailEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            ((IDailyDeliveryReportCostBelongDetailDomain)this.domain).logicDeleteByIdsBatch(ids);
        }
    }
}

