/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.core.util.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDto;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.service.calc.IReleasePreemptAble;
import com.yunxi.dg.base.center.share.service.calc.impl.WarehouseCommonAble;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReleasePreemptAble
extends WarehouseCommonAble
implements IReleasePreemptAble {
    private static final Logger log = LoggerFactory.getLogger(ReleasePreemptAble.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void releasePreempt(ReleasePreemptDto dto) {
        log.info("ShReleasePreemptAble:releasePreempt ==> dto:{}", (Object)JSON.toJsonString((Object)dto));
        this.checkParam((OperationDto)dto);
        List<InventoryPreemptionEo> preemptionEos = this.queryPreemptEos(dto);
        if (CollectionUtils.isEmpty(preemptionEos)) {
            return;
        }
        dto.setExternalOrderNo(preemptionEos.get(0).getExternalOrderNo());
        List<String> cargoCodes = preemptionEos.stream().map(InventoryPreemptionEo::getSkuCode).distinct().collect(Collectors.toList());
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(cargoCodes);
        Map<String, List<InventoryPreemptionEo>> preemptClassifyMap = preemptionEos.stream().collect(Collectors.groupingBy(InventoryPreemptionEo::getWarehouseClassify));
        List<InventoryPreemptionEo> channelPreemptEos = preemptClassifyMap.get(WarehouseClassifyEnum.CHANNEL.getCode());
        AssertUtils.notEmpty(channelPreemptEos, (String)"\u6e20\u9053\u4ed3\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728");
        List<String> channelWarehouseCodes = channelPreemptEos.stream().map(InventoryPreemptionEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List<ChannelWarehouseEo> channelWarehouseEos = this.queryChannelWarehouseByCode(channelWarehouseCodes);
        String channelWarehouseCode = channelWarehouseEos.get(0).getWarehouseCode();
        CalcInventoryDto channelCalcDto = this.createChannelCalcDto(dto, channelPreemptEos);
        List<InventoryPreemptionEo> virtualPreemptEos = preemptClassifyMap.get(WarehouseClassifyEnum.VIRTUAL.getCode());
        AssertUtils.notEmpty(virtualPreemptEos, (String)"\u4f9b\u8d27\u4ed3\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728");
        List<String> virtualWarehouseCodes = virtualPreemptEos.stream().map(InventoryPreemptionEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List<VirtualWarehouseEo> virtualWarehouseEos = this.queryVirtualWarehouseByCodes(virtualWarehouseCodes);
        List<VirtualInventoryEo> virtualInventoryEos = this.queryVirtualInventoryEos(skuDtoList, virtualWarehouseEos);
        ArrayList calcVirtualInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcVirtualInventoryEos, virtualInventoryEos, VirtualInventoryEo.class);
        CalcInventoryDto virtualCalcDto = this.createVirtualCalcDto(dto, virtualPreemptEos);
        List<String> preemptVirtualWarehouseCodes = virtualCalcDto.getDetails().stream().map(CalcInventoryDetailDto::getWarehouseCode).distinct().collect(Collectors.toList());
        Map<String, List<ChannelWarehouseEo>> virtualToChannelMap = this.queryChannelWarehouseByVirtualWarehouseCodes(preemptVirtualWarehouseCodes);
        HashSet otherWarehouseEos = Sets.newHashSet();
        for (String preemptVirtualWarehouseCode : preemptVirtualWarehouseCodes) {
            List<ChannelWarehouseEo> channelWarehouseEoList = virtualToChannelMap.get(preemptVirtualWarehouseCode);
            otherWarehouseEos.addAll(channelWarehouseEoList.stream().filter(o -> !StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)channelWarehouseCode)).distinct().collect(Collectors.toList()));
        }
        channelWarehouseEos.addAll(otherWarehouseEos);
        List<ChannelInventoryEo> channelInventoryEos = this.queryChannelInventoryEos(skuDtoList, channelWarehouseEos);
        ArrayList calcChannelInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcChannelInventoryEos, channelInventoryEos, ChannelInventoryEo.class);
        CalcInventoryDto otherChannelCalcDto = this.createOtherChannelCalcDto(virtualToChannelMap, virtualCalcDto, channelWarehouseCode);
        virtualCalcDto.setValidNegative(Boolean.valueOf(false));
        channelCalcDto.setValidNegative(Boolean.valueOf(false));
        otherChannelCalcDto.setValidNegative(Boolean.valueOf(false));
        this.calcAble.calcChannelAndOtherChannel(channelCalcDto, otherChannelCalcDto, calcChannelInventoryEos);
        this.calcAble.calcVirtual(virtualCalcDto, calcVirtualInventoryEos);
        this.updateInventoryPreemptionValidBatch(EnableDisableEnum.DISABLE.getCode(), preemptionEos);
    }

    @Override
    public CalcInventoryDto createChannelCalcDto(ReleasePreemptDto dto, List<InventoryPreemptionEo> preemptionEos) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setValidNegative(Boolean.valueOf(false));
        calcInventoryDto.setType("channel");
        ArrayList details = Lists.newArrayList();
        for (InventoryPreemptionEo preemptionEo : preemptionEos) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate("\u91ca\u653e\u9884\u5360");
            detailDto.setChangeAvailable(preemptionEo.getPreemptNum());
            detailDto.setChangePreempt(BigDecimalUtils.negate((BigDecimal)preemptionEo.getPreemptNum()));
            detailDto.setWarehouseCode(preemptionEo.getWarehouseCode());
            detailDto.setSkuCode(preemptionEo.getSkuCode());
            detailDto.setValidNegative(Boolean.valueOf(false));
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    @Override
    public CalcInventoryDto createVirtualCalcDto(ReleasePreemptDto dto, List<InventoryPreemptionEo> preemptionEos) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setValidNegative(Boolean.valueOf(false));
        calcInventoryDto.setType("virtual");
        ArrayList details = Lists.newArrayList();
        for (InventoryPreemptionEo preemptionEo : preemptionEos) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate("\u91ca\u653e\u9884\u5360");
            detailDto.setChangeAvailable(preemptionEo.getPreemptNum());
            detailDto.setChangePreempt(BigDecimalUtils.negate((BigDecimal)preemptionEo.getPreemptNum()));
            detailDto.setWarehouseCode(preemptionEo.getWarehouseCode());
            detailDto.setSkuCode(preemptionEo.getSkuCode());
            detailDto.setValidNegative(Boolean.valueOf(false));
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    private List<InventoryPreemptionEo> queryPreemptEos(ReleasePreemptDto param) {
        String sourceNo = param.getSourceNo();
        if (param.getIsReleaseByExternalOrderNo().booleanValue()) {
            AssertUtils.notBlank((String)param.getExternalOrderNo(), (String)"\u5916\u90e8\u5355\u53f7\u4e0d\u5b58\u5728");
            sourceNo = param.getExternalOrderNo();
        }
        List<InventoryPreemptionEo> preemptionEos = this.queryPreemptEos(Lists.newArrayList((Object[])new String[]{sourceNo}), null);
        if (param.isErrorForNotFoundPreempt.booleanValue()) {
            AssertUtils.notEmpty(preemptionEos, (String)String.format("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u9884\u5360\u8bb0\u5f55 param: %s", JSON.toJsonString((Object)param)));
        }
        return preemptionEos;
    }
}

