/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.share.domain.entity.IInventoryShareOperateLogDomain;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.eo.InventoryShareOperateLogEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedItemEo;
import com.yunxi.dg.base.center.share.eo.RelShareInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.service.calc.ICalcAble;
import com.yunxi.dg.base.center.share.service.calc.impl.WarehouseCommonAble;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CalcAble
extends WarehouseCommonAble
implements ICalcAble {
    private static final Logger log = LoggerFactory.getLogger(CalcAble.class);
    @Autowired
    IInventoryShareOperateLogDomain inventoryShareOperateLogDomain;
    @Autowired
    IContext context;

    @Override
    public void calcChannel(CalcInventoryDto calcDto, List<ChannelInventoryEo> channelInventoryEos) {
        calcDto.setType("channel");
        List<CalcUpdateInventoryDto> updateDtoList = this.mergeChannel(calcDto, calcDto.getDetails(), channelInventoryEos);
        updateDtoList = this.ignoreZero(updateDtoList);
        this.validateChannelInventory(updateDtoList, channelInventoryEos);
        this.setChannelCurrentInventory(updateDtoList, channelInventoryEos);
        List<InventoryShareOperateLogEo> inventoryOperateLogEos = this.buildChannelOperateLogEos(calcDto, channelInventoryEos);
        if (CollectionUtils.isNotEmpty(updateDtoList)) {
            this.channelInventoryDomain.updateInventory(updateDtoList);
        }
        if (CollectionUtils.isNotEmpty(inventoryOperateLogEos)) {
            this.inventoryShareOperateLogDomain.insertLogList(inventoryOperateLogEos);
        }
    }

    @Override
    public void calcChannelAndOtherChannel(CalcInventoryDto calcDto, CalcInventoryDto otherCalcDto, List<ChannelInventoryEo> channelInventoryEos) {
        calcDto.setType("channel");
        otherCalcDto.setType("channel");
        List<CalcUpdateInventoryDto> updateDtoList = this.mergeChannel(calcDto, calcDto.getDetails(), channelInventoryEos);
        if (null == calcDto.getValidNegative() || calcDto.getValidNegative().booleanValue()) {
            Boolean otherChannelValidNegative = this.queryOtherChannelValidNegative();
            otherCalcDto.setValidNegative(otherChannelValidNegative);
        }
        List<CalcUpdateInventoryDto> otherUpdateDtoList = this.mergeChannel(otherCalcDto, otherCalcDto.getDetails(), channelInventoryEos);
        updateDtoList.addAll(otherUpdateDtoList);
        updateDtoList = this.mergeUpdateList(updateDtoList);
        updateDtoList = this.ignoreZero(updateDtoList);
        this.validateChannelInventory(updateDtoList, channelInventoryEos);
        this.setChannelCurrentInventory(updateDtoList, channelInventoryEos);
        List<InventoryShareOperateLogEo> inventoryOperateLogEos = this.buildChannelOperateLogEos(calcDto, channelInventoryEos);
        inventoryOperateLogEos.addAll(this.buildChannelOperateLogEos(otherCalcDto, channelInventoryEos));
        if (CollectionUtils.isNotEmpty(updateDtoList)) {
            this.channelInventoryDomain.updateInventory(updateDtoList);
        }
        if (CollectionUtils.isNotEmpty(inventoryOperateLogEos)) {
            this.inventoryShareOperateLogDomain.insertLogList(inventoryOperateLogEos);
        }
    }

    @Override
    public void calcBatchChannelAndOtherChannel(List<CalcInventoryDto> calcDtoList, List<CalcInventoryDto> otherCalcDtoList, List<ChannelInventoryEo> channelInventoryEos) {
        log.info("calcBatchChannelAndOtherChannel calcDtoList: {}", (Object)JSON.toJSONString(calcDtoList));
        log.info("calcBatchChannelAndOtherChannel otherCalcDtoList: {}", (Object)JSON.toJSONString(otherCalcDtoList));
        List<Object> batchUpdateDtoList = Lists.newArrayList();
        ArrayList batchInventoryOperateLogEos = Lists.newArrayList();
        ArrayList<ChannelInventoryEo> calcChannelInventoryEos = new ArrayList<ChannelInventoryEo>();
        CubeBeanUtils.copyCollection(calcChannelInventoryEos, channelInventoryEos, ChannelInventoryEo.class);
        for (CalcInventoryDto calcDto : calcDtoList) {
            calcDto.setType("channel");
            List<CalcUpdateInventoryDto> updateDtoList = this.mergeChannel(calcDto, calcDto.getDetails(), channelInventoryEos);
            batchUpdateDtoList.addAll(updateDtoList);
            batchInventoryOperateLogEos.addAll(this.buildChannelOperateLogEos(calcDto, channelInventoryEos));
        }
        Boolean otherChannelValidNegative = this.queryOtherChannelValidNegative();
        for (CalcInventoryDto otherCalcDto : otherCalcDtoList) {
            otherCalcDto.setType("channel");
            if (null == otherCalcDto.getValidNegative() || otherCalcDto.getValidNegative().booleanValue()) {
                otherCalcDto.setValidNegative(otherChannelValidNegative);
            }
            List<CalcUpdateInventoryDto> otherUpdateDtoList = this.mergeChannel(otherCalcDto, otherCalcDto.getDetails(), channelInventoryEos);
            batchUpdateDtoList.addAll(otherUpdateDtoList);
            batchInventoryOperateLogEos.addAll(this.buildChannelOperateLogEos(otherCalcDto, channelInventoryEos));
        }
        batchUpdateDtoList = this.mergeUpdateList((List<CalcUpdateInventoryDto>)batchUpdateDtoList);
        batchUpdateDtoList = this.ignoreZero((List<CalcUpdateInventoryDto>)batchUpdateDtoList);
        this.validateChannelInventory(batchUpdateDtoList, calcChannelInventoryEos);
        this.setChannelCurrentInventory(batchUpdateDtoList, calcChannelInventoryEos);
        if (CollectionUtils.isNotEmpty(batchUpdateDtoList)) {
            this.channelInventoryDomain.updateInventory(batchUpdateDtoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)batchInventoryOperateLogEos)) {
            this.inventoryShareOperateLogDomain.insertLogList((List)batchInventoryOperateLogEos);
        }
    }

    @Override
    public void calcVirtual(CalcInventoryDto calcDto, List<VirtualInventoryEo> virtualInventoryEos) {
        calcDto.setType("virtual");
        List<CalcUpdateInventoryDto> updateDtoList = this.mergeVirtual(calcDto, calcDto.getDetails(), virtualInventoryEos);
        updateDtoList = this.ignoreZero(updateDtoList);
        this.validateVirtualInventory(updateDtoList, virtualInventoryEos);
        this.setVirtualCurrentInventory(updateDtoList, virtualInventoryEos);
        List<InventoryShareOperateLogEo> inventoryOperateLogEos = this.buildVirtualOperateLogEos(calcDto, virtualInventoryEos);
        if (CollectionUtils.isNotEmpty(updateDtoList)) {
            this.virtualInventoryDomain.updateInventory(updateDtoList);
        }
        if (CollectionUtils.isNotEmpty(inventoryOperateLogEos)) {
            this.inventoryShareOperateLogDomain.insertLogList(inventoryOperateLogEos);
        }
    }

    @Override
    public void calcBatchVirtual(List<CalcInventoryDto> calcDtoList, List<VirtualInventoryEo> virtualInventoryEos) {
        log.info("calcBatchVirtual calcDtoList: {}", (Object)JSON.toJSONString(calcDtoList));
        List<Object> batchUpdateDtoList = Lists.newArrayList();
        ArrayList batchInventoryOperateLogEos = Lists.newArrayList();
        ArrayList calcVirtualInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcVirtualInventoryEos, virtualInventoryEos, VirtualInventoryEo.class);
        for (CalcInventoryDto calcDto : calcDtoList) {
            calcDto.setType("virtual");
            List<CalcUpdateInventoryDto> updateDtoList = this.mergeVirtual(calcDto, calcDto.getDetails(), virtualInventoryEos);
            batchUpdateDtoList.addAll(updateDtoList);
            batchInventoryOperateLogEos.addAll(this.buildVirtualOperateLogEos(calcDto, virtualInventoryEos));
        }
        batchUpdateDtoList = this.mergeUpdateList((List<CalcUpdateInventoryDto>)batchUpdateDtoList);
        batchUpdateDtoList = this.ignoreZero((List<CalcUpdateInventoryDto>)batchUpdateDtoList);
        log.info("batchUpdateDtoList: {}", (Object)JSON.toJSONString((Object)batchUpdateDtoList));
        this.validateVirtualInventory(batchUpdateDtoList, calcVirtualInventoryEos);
        this.setVirtualCurrentInventory(batchUpdateDtoList, calcVirtualInventoryEos);
        if (CollectionUtils.isNotEmpty(batchUpdateDtoList)) {
            this.virtualInventoryDomain.updateInventory(batchUpdateDtoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)batchInventoryOperateLogEos)) {
            this.inventoryShareOperateLogDomain.insertLogList((List)batchInventoryOperateLogEos);
        }
    }

    @Override
    public void calcLogicToVirtual(List<RelShareInventoryEo> relShareInventoryEos, List<CsInventoryLogRespDto> logicLogs, List<InventorySharedEo> inventorySharedEos, List<InventorySharedItemEo> inventorySharedItemEos, List<ItemSkuDto> skuDtoList) {
        List<Object> updateDtoList = Lists.newArrayList();
        String currentUserName = null == this.context.userName() ? "system" : this.context.userName();
        for (CsInventoryLogRespDto logicLog : logicLogs) {
            String logicWarehouseCode = logicLog.getWarehouseCode();
            BigDecimal supplyNum = BigDecimalUtils.subtract((BigDecimal)logicLog.getAfterBalance(), (BigDecimal)BigDecimalUtils.subtract((BigDecimal)logicLog.getAfterPreempt(), (BigDecimal)logicLog.getAfterAllocate()));
            for (InventorySharedEo inventorySharedEo : inventorySharedEos) {
                InventorySharedItemEo inventorySharedItemEo;
                BigDecimal rate = inventorySharedEo.getSharedNumerical();
                if (BigDecimalUtils.leZero((BigDecimal)rate).booleanValue() || BigDecimalUtils.gt((BigDecimal)rate, (BigDecimal)BigDecimalUtils.ONE_HUNDRED).booleanValue()) {
                    log.error("\u4f9b\u8d27\u6bd4\u7387\u5c0f\u4e8e 0 \u6216\u8005 \u5927\u4e8e 100, \u4e2d\u65ad\u4f9b\u8d27 , \u6bd4\u7387 : {}%, \u7b56\u7565\u7f16\u7801: {}", (Object)rate, (Object)inventorySharedEo.getSharedCode());
                    continue;
                }
                if (!"all".equals(inventorySharedEo.getSharedItemScope()) && null == (inventorySharedItemEo = (InventorySharedItemEo)inventorySharedItemEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSharedCode(), (CharSequence)inventorySharedEo.getSharedCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)logicLog.getCargoCode())).findFirst().orElse(null))) {
                    log.info("\u903b\u8f91\u4ed3\u7f16\u7801:{}, \u8d27\u54c1\u7f16\u7801: {}, \u4e0d\u5728\u4f9b\u8d27\u7b56\u7565: {}, \u4f9b\u8d27\u8303\u56f4", new Object[]{logicWarehouseCode, logicLog.getCargoCode(), inventorySharedEo.getSharedCode()});
                    continue;
                }
                RelShareInventoryEo relShareInventoryEo = relShareInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getShareWarehouseCode(), (CharSequence)logicWarehouseCode) && StringUtils.equals((CharSequence)o.getReceiveWarehouseCode(), (CharSequence)inventorySharedEo.getVirtualWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)logicLog.getCargoCode())).findFirst().orElse(null);
                if (null == relShareInventoryEo) continue;
                CalcUpdateInventoryDto updateDto = new CalcUpdateInventoryDto();
                updateDto.setInventoryId(relShareInventoryEo.getId());
                updateDto.setCargoCode(relShareInventoryEo.getSkuCode());
                updateDto.setBeforeAvailable(relShareInventoryEo.getAvailable());
                updateDto.setBeforeBalance(relShareInventoryEo.getBalance());
                BigDecimal num = BigDecimalUtils.multiply((BigDecimal)supplyNum, (BigDecimal)BigDecimalUtils.divide((BigDecimal)rate, (BigDecimal)BigDecimalUtils.ONE_HUNDRED, (int)4));
                num = this.getRealNum(num);
                BigDecimal changeBalance = BigDecimalUtils.subtract((BigDecimal)num, (BigDecimal)relShareInventoryEo.getBalance());
                updateDto.setChangeBalance(changeBalance);
                updateDto.setChangeAvailable(changeBalance);
                updateDto.setUpdatePerson(currentUserName);
                updateDtoList.add(updateDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(updateDtoList = this.ignoreZero((List<CalcUpdateInventoryDto>)updateDtoList)))) {
            this.relShareInventoryDomain.updateInventory((List)updateDtoList);
        }
    }

    @Override
    public void calcLogicRelVirtual(CalcInventoryDto calcVirtualDto, List<RelShareInventoryEo> relShareInventoryEos) {
        List<Object> updateDtoList = Lists.newArrayList();
        String currentUserName = null == this.context.userName() ? "system" : this.context.userName();
        List detailDtoList = calcVirtualDto.getDetails();
        for (CalcInventoryDetailDto detailDto : detailDtoList) {
            RelShareInventoryEo relShareInventoryEo = relShareInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getReceiveWarehouseCode(), (CharSequence)detailDto.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detailDto.getSkuCode())).findFirst().orElse(null);
            if (null == relShareInventoryEo) continue;
            CalcUpdateInventoryDto updateDto = new CalcUpdateInventoryDto();
            updateDto.setInventoryId(relShareInventoryEo.getId());
            updateDto.setBeforeAvailable(relShareInventoryEo.getAvailable());
            updateDto.setBeforeBalance(relShareInventoryEo.getBalance());
            BigDecimal num = detailDto.getChangeBalance();
            updateDto.setChangeBalance(num);
            updateDto.setChangeAvailable(num);
            updateDto.setUpdatePerson(currentUserName);
            updateDtoList.add(updateDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)(updateDtoList = this.ignoreZero((List<CalcUpdateInventoryDto>)updateDtoList)))) {
            this.relShareInventoryDomain.updateInventory((List)updateDtoList);
        }
    }

    private List<CalcUpdateInventoryDto> mergeChannel(CalcInventoryDto calcInventoryDto, List<CalcInventoryDetailDto> detailDtoList, List<ChannelInventoryEo> channelInventoryEos) {
        log.info("mergeChannel: {}", (Object)JSON.toJSONString((Object)calcInventoryDto));
        HashMap map = Maps.newHashMap();
        for (CalcInventoryDetailDto detailDto : detailDtoList) {
            String key = String.format("%s_%s", detailDto.getWarehouseCode(), detailDto.getSkuCode());
            ChannelInventoryEo channelInventoryEo = channelInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)detailDto.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detailDto.getSkuCode())).findFirst().orElse(null);
            AssertUtils.notNull((Object)channelInventoryEo, (String)"\u6e20\u9053\u4ed3\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u6e20\u9053\u4ed3\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801: %s", (Object[])new Object[]{detailDto.getWarehouseCode(), detailDto.getSkuCode()});
            detailDto.setInventoryId(channelInventoryEo.getId());
            CalcUpdateInventoryDto updateDto = map.getOrDefault(key, new CalcUpdateInventoryDto(channelInventoryEo.getId(), detailDto.getWarehouseCode(), detailDto.getSkuCode()));
            updateDto.setChangeAvailable(BigDecimalUtils.add((BigDecimal)updateDto.getChangeAvailable(), (BigDecimal)detailDto.getChangeAvailable()));
            updateDto.setChangePreempt(BigDecimalUtils.add((BigDecimal)updateDto.getChangePreempt(), (BigDecimal)detailDto.getChangePreempt()));
            updateDto.setChangeBalance(BigDecimalUtils.add((BigDecimal)updateDto.getChangeBalance(), (BigDecimal)detailDto.getChangeBalance()));
            if (!detailDto.getValidNegative().booleanValue() || !calcInventoryDto.getValidNegative().booleanValue()) {
                updateDto.setValidNegative(Boolean.valueOf(false));
            }
            map.put(key, updateDto);
        }
        return Lists.newArrayList(map.values());
    }

    private void validateChannelInventory(List<CalcUpdateInventoryDto> updateList, List<ChannelInventoryEo> channelInventoryEos) {
        ArrayList errorList = Lists.newArrayList();
        for (CalcUpdateInventoryDto updateDto : updateList) {
            ChannelInventoryEo channelInventoryEo = channelInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)updateDto.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)updateDto.getCargoCode())).findFirst().orElse(null);
            if (null == channelInventoryEo) {
                errorList.add(String.format("\u6e20\u9053\u4ed3\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u6e20\u9053\u4ed3\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801: %s", updateDto.getWarehouseCode(), updateDto.getCargoCode()));
                continue;
            }
            BigDecimal afterAvailable = BigDecimalUtils.add((BigDecimal)channelInventoryEo.getAvailable(), (BigDecimal)updateDto.getChangeAvailable());
            if (!updateDto.getValidNegative().booleanValue() || !BigDecimalUtils.ltZero((BigDecimal)afterAvailable).booleanValue()) continue;
            errorList.add(String.format("\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u6e20\u9053\u4ed3:%s(%s), \u8d27\u54c1\u7f16\u7801: %s\uff0c [\u5f53\u524d\u53ef\u7528\u5e93\u5b58: %s]", channelInventoryEo.getWarehouseName(), channelInventoryEo.getWarehouseCode(), channelInventoryEo.getSkuCode(), channelInventoryEo.getAvailable()));
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            throw new CsInventoryException("09527", StringUtils.join((Iterable)errorList, (String)","), new Object[0]);
        }
    }

    private List<CalcUpdateInventoryDto> mergeVirtual(CalcInventoryDto calcInventoryDto, List<CalcInventoryDetailDto> detailDtoList, List<VirtualInventoryEo> virtualInventoryEos) {
        log.info("mergeVirtual: {}", (Object)JSON.toJSONString((Object)calcInventoryDto));
        HashMap map = Maps.newHashMap();
        for (CalcInventoryDetailDto detailDto : detailDtoList) {
            String key = String.format("%s_%s", detailDto.getWarehouseCode(), detailDto.getSkuCode());
            VirtualInventoryEo virtualInventoryEo = virtualInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)detailDto.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detailDto.getSkuCode())).findFirst().orElse(null);
            AssertUtils.notNull((Object)virtualInventoryEo, (String)"\u4f9b\u8d27\u4ed3\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u4f9b\u8d27\u4ed3\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801: %s", (Object[])new Object[]{detailDto.getWarehouseCode(), detailDto.getSkuCode()});
            detailDto.setInventoryId(virtualInventoryEo.getId());
            CalcUpdateInventoryDto updateDto = map.getOrDefault(key, new CalcUpdateInventoryDto(virtualInventoryEo.getId(), detailDto.getWarehouseCode(), detailDto.getSkuCode()));
            updateDto.setChangeAvailable(BigDecimalUtils.add((BigDecimal)updateDto.getChangeAvailable(), (BigDecimal)detailDto.getChangeAvailable()));
            updateDto.setChangePreempt(BigDecimalUtils.add((BigDecimal)updateDto.getChangePreempt(), (BigDecimal)detailDto.getChangePreempt()));
            updateDto.setChangeBalance(BigDecimalUtils.add((BigDecimal)updateDto.getChangeBalance(), (BigDecimal)detailDto.getChangeBalance()));
            if (!detailDto.getValidNegative().booleanValue() || !calcInventoryDto.getValidNegative().booleanValue()) {
                updateDto.setValidNegative(Boolean.valueOf(false));
            }
            map.put(key, updateDto);
        }
        return Lists.newArrayList(map.values());
    }

    private void validateVirtualInventory(List<CalcUpdateInventoryDto> updateList, List<VirtualInventoryEo> virtualInventoryEos) {
        ArrayList errorList = Lists.newArrayList();
        for (CalcUpdateInventoryDto updateDto : updateList) {
            VirtualInventoryEo virtualInventoryEo = virtualInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)updateDto.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)updateDto.getCargoCode())).findFirst().orElse(null);
            if (null == virtualInventoryEo) {
                errorList.add(String.format("\u4f9b\u8d27\u4ed3\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u4f9b\u8d27\u4ed3\u7f16\u7801: %s, \u8d27\u54c1\u7f16\u7801: %s", updateDto.getWarehouseCode(), updateDto.getCargoCode()));
                continue;
            }
            BigDecimal afterAvailable = BigDecimalUtils.add((BigDecimal)virtualInventoryEo.getAvailable(), (BigDecimal)updateDto.getChangeAvailable());
            if (!updateDto.getValidNegative().booleanValue() || !BigDecimalUtils.ltZero((BigDecimal)afterAvailable).booleanValue()) continue;
            errorList.add(String.format("\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u4f9b\u8d27\u4ed3:%s(%s), \u8d27\u54c1\u7f16\u7801: %s [\u5f53\u524d\u53ef\u7528\u5e93\u5b58: %s]", virtualInventoryEo.getWarehouseName(), virtualInventoryEo.getWarehouseCode(), virtualInventoryEo.getSkuCode(), virtualInventoryEo.getAvailable()));
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            throw new CsInventoryException("09527", StringUtils.join((Iterable)errorList, (String)","), new Object[0]);
        }
    }

    private List<CalcUpdateInventoryDto> mergeUpdateList(List<CalcUpdateInventoryDto> updateList) {
        log.info("mergeUpdateList before: {}", (Object)JSON.toJSONString(updateList));
        HashMap map = Maps.newHashMap();
        for (CalcUpdateInventoryDto calcUpdateInventoryDto : updateList) {
            CalcUpdateInventoryDto updateInventoryDto = map.getOrDefault(calcUpdateInventoryDto.getInventoryId(), null);
            if (null == updateInventoryDto) {
                map.put(calcUpdateInventoryDto.getInventoryId(), calcUpdateInventoryDto);
                continue;
            }
            updateInventoryDto.setChangeAvailable(BigDecimalUtils.add((BigDecimal)updateInventoryDto.getChangeAvailable(), (BigDecimal)calcUpdateInventoryDto.getChangeAvailable()));
            updateInventoryDto.setChangePreempt(BigDecimalUtils.add((BigDecimal)updateInventoryDto.getChangePreempt(), (BigDecimal)calcUpdateInventoryDto.getChangePreempt()));
            updateInventoryDto.setChangeBalance(BigDecimalUtils.add((BigDecimal)updateInventoryDto.getChangeBalance(), (BigDecimal)calcUpdateInventoryDto.getChangeBalance()));
            updateInventoryDto.setValidNegative(calcUpdateInventoryDto.getValidNegative());
            map.put(calcUpdateInventoryDto.getInventoryId(), updateInventoryDto);
        }
        log.info("mergeUpdateList after: {}", (Object)JSON.toJSONString(map.values()));
        return Lists.newArrayList(map.values());
    }

    private List<CalcUpdateInventoryDto> ignoreZero(List<CalcUpdateInventoryDto> updateDtoList) {
        return updateDtoList;
    }

    private void setChannelCurrentInventory(List<CalcUpdateInventoryDto> updateDtoList, List<ChannelInventoryEo> channelInventoryEos) {
        String currentUserName = null == this.context.userName() ? "system" : this.context.userName();
        Map channelInventoryEoMap = channelInventoryEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CalcUpdateInventoryDto updateInventoryDto : updateDtoList) {
            ChannelInventoryEo channelInventoryEo = (ChannelInventoryEo)channelInventoryEoMap.get(updateInventoryDto.getInventoryId());
            updateInventoryDto.setBeforeBalance(channelInventoryEo.getBalance());
            updateInventoryDto.setBeforeAvailable(channelInventoryEo.getAvailable());
            updateInventoryDto.setBeforePreempt(channelInventoryEo.getPreempt());
            updateInventoryDto.setUpdatePerson(currentUserName);
        }
    }

    private void setVirtualCurrentInventory(List<CalcUpdateInventoryDto> updateDtoList, List<VirtualInventoryEo> virtualInventoryEos) {
        String currentUserName = null == this.context.userName() ? "system" : this.context.userName();
        Map virtualInventoryEoMap = virtualInventoryEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CalcUpdateInventoryDto updateInventoryDto : updateDtoList) {
            VirtualInventoryEo channelInventoryEo = (VirtualInventoryEo)virtualInventoryEoMap.get(updateInventoryDto.getInventoryId());
            updateInventoryDto.setBeforeBalance(channelInventoryEo.getBalance());
            updateInventoryDto.setBeforeAvailable(channelInventoryEo.getAvailable());
            updateInventoryDto.setBeforePreempt(channelInventoryEo.getPreempt());
            updateInventoryDto.setUpdatePerson(currentUserName);
        }
    }

    private List<InventoryShareOperateLogEo> buildChannelOperateLogEos(CalcInventoryDto calcDto, List<ChannelInventoryEo> channelInventoryEos) {
        Date now = new Date();
        ArrayList logEos = Lists.newArrayList();
        Map channelInventoryEoMap = channelInventoryEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CalcInventoryDetailDto detailDto : calcDto.getDetails()) {
            InventoryShareOperateLogEo logEo;
            ChannelInventoryEo channelInventoryEo = (ChannelInventoryEo)channelInventoryEoMap.get(detailDto.getInventoryId());
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeBalance()).booleanValue()) {
                logEo = this.buildChannelOperateLogEo("balance", channelInventoryEo, calcDto, detailDto, now);
                logEo.setBeforeInventory(channelInventoryEo.getBalance());
                logEo.setChangeInventory(detailDto.getChangeBalance());
                channelInventoryEo.setBalance(BigDecimalUtils.add((BigDecimal)channelInventoryEo.getBalance(), (BigDecimal)detailDto.getChangeBalance()));
                logEo.setAfterInventory(channelInventoryEo.getBalance());
                logEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)logEo.getChangeInventory()) != false ? CsInventoryInOutEnum.IN.getCode() : CsInventoryInOutEnum.OUT.getCode());
                logEos.add(logEo);
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeAvailable()).booleanValue()) {
                logEo = this.buildChannelOperateLogEo("available", channelInventoryEo, calcDto, detailDto, now);
                logEo.setBeforeInventory(channelInventoryEo.getAvailable());
                logEo.setChangeInventory(detailDto.getChangeAvailable());
                channelInventoryEo.setAvailable(BigDecimalUtils.add((BigDecimal)channelInventoryEo.getAvailable(), (BigDecimal)detailDto.getChangeAvailable()));
                logEo.setAfterInventory(channelInventoryEo.getAvailable());
                logEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)logEo.getChangeInventory()) != false ? CsInventoryInOutEnum.IN.getCode() : CsInventoryInOutEnum.OUT.getCode());
                logEos.add(logEo);
            }
            if (BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangePreempt()).booleanValue()) continue;
            logEo = this.buildChannelOperateLogEo("preempt", channelInventoryEo, calcDto, detailDto, now);
            logEo.setBeforeInventory(channelInventoryEo.getPreempt());
            logEo.setChangeInventory(detailDto.getChangePreempt());
            channelInventoryEo.setPreempt(BigDecimalUtils.add((BigDecimal)channelInventoryEo.getPreempt(), (BigDecimal)detailDto.getChangePreempt()));
            logEo.setAfterInventory(channelInventoryEo.getPreempt());
            logEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)logEo.getChangeInventory()) != false ? CsInventoryInOutEnum.IN.getCode() : CsInventoryInOutEnum.OUT.getCode());
            logEos.add(logEo);
        }
        return logEos;
    }

    private List<InventoryShareOperateLogEo> buildVirtualOperateLogEos(CalcInventoryDto calcDto, List<VirtualInventoryEo> virtualInventoryEos) {
        Date now = new Date();
        ArrayList logEos = Lists.newArrayList();
        Map virtualInventoryEoMap = virtualInventoryEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CalcInventoryDetailDto detailDto : calcDto.getDetails()) {
            InventoryShareOperateLogEo logEo;
            VirtualInventoryEo virtualInventoryEo = (VirtualInventoryEo)virtualInventoryEoMap.get(detailDto.getInventoryId());
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeBalance()).booleanValue()) {
                logEo = this.buildVirtualOperateLogEo("balance", virtualInventoryEo, calcDto, detailDto, now);
                logEo.setBeforeInventory(virtualInventoryEo.getBalance());
                logEo.setChangeInventory(detailDto.getChangeBalance());
                virtualInventoryEo.setBalance(BigDecimalUtils.add((BigDecimal)virtualInventoryEo.getBalance(), (BigDecimal)detailDto.getChangeBalance()));
                logEo.setAfterInventory(virtualInventoryEo.getBalance());
                logEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)logEo.getChangeInventory()) != false ? CsInventoryInOutEnum.IN.getCode() : CsInventoryInOutEnum.OUT.getCode());
                logEos.add(logEo);
            }
            if (!BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangeAvailable()).booleanValue()) {
                logEo = this.buildVirtualOperateLogEo("available", virtualInventoryEo, calcDto, detailDto, now);
                logEo.setBeforeInventory(virtualInventoryEo.getAvailable());
                logEo.setChangeInventory(detailDto.getChangeAvailable());
                virtualInventoryEo.setAvailable(BigDecimalUtils.add((BigDecimal)virtualInventoryEo.getAvailable(), (BigDecimal)detailDto.getChangeAvailable()));
                logEo.setAfterInventory(virtualInventoryEo.getAvailable());
                logEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)logEo.getChangeInventory()) != false ? CsInventoryInOutEnum.IN.getCode() : CsInventoryInOutEnum.OUT.getCode());
                logEos.add(logEo);
            }
            if (BigDecimalUtils.eqZero((BigDecimal)detailDto.getChangePreempt()).booleanValue()) continue;
            logEo = this.buildVirtualOperateLogEo("preempt", virtualInventoryEo, calcDto, detailDto, now);
            logEo.setBeforeInventory(virtualInventoryEo.getPreempt());
            logEo.setChangeInventory(detailDto.getChangePreempt());
            virtualInventoryEo.setPreempt(BigDecimalUtils.add((BigDecimal)virtualInventoryEo.getPreempt(), (BigDecimal)detailDto.getChangePreempt()));
            logEo.setAfterInventory(virtualInventoryEo.getPreempt());
            logEo.setInOutFlag(BigDecimalUtils.gtZero((BigDecimal)logEo.getChangeInventory()) != false ? CsInventoryInOutEnum.IN.getCode() : CsInventoryInOutEnum.OUT.getCode());
            logEos.add(logEo);
        }
        return logEos;
    }

    private InventoryShareOperateLogEo buildChannelOperateLogEo(String changeType, ChannelInventoryEo channelInventoryEo, CalcInventoryDto calcDto, CalcInventoryDetailDto detailDto, Date now) {
        InventoryShareOperateLogEo logEo = new InventoryShareOperateLogEo();
        logEo.setSkuCode(channelInventoryEo.getSkuCode());
        logEo.setSkuName(channelInventoryEo.getSkuName());
        logEo.setWarehouseId(channelInventoryEo.getWarehouseId());
        logEo.setWarehouseCode(channelInventoryEo.getWarehouseCode());
        logEo.setWarehouseName(channelInventoryEo.getWarehouseName());
        logEo.setWarehouseType(String.valueOf(channelInventoryEo.getWarehouseType()));
        logEo.setWarehouseClassify(calcDto.getType());
        logEo.setSourceNo(calcDto.getSourceNo());
        logEo.setSourceType(calcDto.getSourceType());
        logEo.setExternalOrderNo(calcDto.getExternalOrderNo());
        logEo.setRemark(detailDto.getOperate());
        logEo.setChangeType(changeType);
        logEo.setChangeTime(now);
        return logEo;
    }

    private InventoryShareOperateLogEo buildVirtualOperateLogEo(String changeType, VirtualInventoryEo virtualInventoryEo, CalcInventoryDto calcDto, CalcInventoryDetailDto detailDto, Date now) {
        InventoryShareOperateLogEo logEo = new InventoryShareOperateLogEo();
        logEo.setSkuCode(virtualInventoryEo.getSkuCode());
        logEo.setSkuName(virtualInventoryEo.getSkuName());
        logEo.setWarehouseId(virtualInventoryEo.getWarehouseId());
        logEo.setWarehouseCode(virtualInventoryEo.getWarehouseCode());
        logEo.setWarehouseName(virtualInventoryEo.getWarehouseName());
        logEo.setWarehouseType(String.valueOf(virtualInventoryEo.getWarehouseType()));
        logEo.setWarehouseClassify(calcDto.getType());
        logEo.setSourceNo(calcDto.getSourceNo());
        logEo.setSourceType(calcDto.getSourceType());
        logEo.setExternalOrderNo(calcDto.getExternalOrderNo());
        logEo.setRemark(detailDto.getOperate());
        logEo.setChangeType(changeType);
        logEo.setChangeTime(now);
        return logEo;
    }
}

