/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDto;
import com.yunxi.dg.base.center.share.enums.VirtualWarehouseTypeEnum;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedItemEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedWarehouseEo;
import com.yunxi.dg.base.center.share.eo.RelShareInventoryEo;
import com.yunxi.dg.base.center.share.eo.RelVirtualWarehouseEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.service.calc.ISupplyAble;
import com.yunxi.dg.base.center.share.service.calc.impl.WarehouseCommonAble;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SupplyAble
extends WarehouseCommonAble
implements ISupplyAble {
    private static final Logger log = LoggerFactory.getLogger(SupplyAble.class);
    @Autowired
    ICsLogicInventoryTotalQueryApi csLogicInventoryTotalQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void supplyByLogicLog(List<CsInventoryLogRespDto> logicLogs) {
        log.info("supplyByLogicLog: warehouse able supplyByLogicLog ==> param:{}", (Object)JSON.toJSONString(logicLogs));
        if (CollectionUtils.isEmpty(logicLogs)) {
            log.info("hasValidChange===>\u6d41\u6c34\u65e5\u5fd7\u5bf9\u8c61\u4e3a\u7a7a");
            return;
        }
        if (!this.hasValidChange(logicLogs)) {
            return;
        }
        if (CollectionUtils.isEmpty(logicLogs = this.filterLogs(logicLogs))) {
            log.info("filterLogs===>\u6d41\u6c34\u65e5\u5fd7\u5bf9\u8c61\u4e3a\u7a7a");
            return;
        }
        List<String> logicWarehouseCodes = logicLogs.stream().map(CsInventoryLogRespDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List<String> cargoCodes = logicLogs.stream().map(CsInventoryLogRespDto::getCargoCode).distinct().collect(Collectors.toList());
        List<InventorySharedWarehouseEo> inventorySharedWarehouseEos = this.queryShareVirtualWarehouseEos(logicWarehouseCodes);
        if (CollectionUtils.isEmpty(inventorySharedWarehouseEos)) {
            return;
        }
        List shareCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getSharedCode).distinct().collect(Collectors.toList());
        List inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"shared_code", shareCodes)).eq((Object)"shared_status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedEos)) {
            log.info("supplyByLogicLog: \u903b\u8f91\u4ed3\u7f16\u7801\uff1a{}, \u5171\u4eab\u7f16\u7801 {}, \u6ca1\u6709\u6709\u6548\u5171\u4eab\u7b56\u7565", logicWarehouseCodes, shareCodes);
            return;
        }
        List inventorySharedItemEos = this.inventorySharedItemDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedItemEo.class).in(InventorySharedItemEo::getSharedCode, shareCodes)).in(InventorySharedItemEo::getSkuCode, cargoCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        List<String> virtualWarehouseCodes = inventorySharedEos.stream().map(InventorySharedEo::getVirtualWarehouseCode).distinct().collect(Collectors.toList());
        List<VirtualWarehouseEo> virtualWarehouseEos = this.queryEnableVirtualWarehouseByCodes(virtualWarehouseCodes);
        AssertUtils.notEmpty(virtualWarehouseEos, (String)"\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u4f9b\u8d27\u4ed3");
        List groupIds = virtualWarehouseEos.stream().map(VirtualWarehouseEo::getGroupId).distinct().collect(Collectors.toList());
        AssertUtils.notEmpty(groupIds, (String)String.format("\u4f9b\u8d27\u4ed3:%s \u6ca1\u6709\u6709\u6548\u4f9b\u8d27\u7ec4", virtualWarehouseCodes));
        List groupVirtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VirtualWarehouseEo.class).in(VirtualWarehouseEo::getGroupId, groupIds)).eq(VirtualWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        virtualWarehouseCodes = groupVirtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        Map<String, List<ChannelWarehouseEo>> virtualToChannelMap = this.queryChannelWarehouseByVirtualWarehouseCodes(virtualWarehouseCodes, false);
        log.info("\u4f9b\u8d27\u6e20\u9053\u5173\u7cfb virtualToChannelMap: {}", (Object)JSON.toJSONString(virtualToChannelMap));
        HashSet allChannelWarehouseEos = Sets.newHashSet();
        for (List<ChannelWarehouseEo> eos : virtualToChannelMap.values()) {
            allChannelWarehouseEos.addAll(eos);
        }
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(cargoCodes);
        List<RelShareInventoryEo> relShareInventoryEos = this.queryLogicToVirtualInventory(skuDtoList, virtualWarehouseEos, logicWarehouseCodes);
        ArrayList channelWarehouseEos = Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)allChannelWarehouseEos));
        this.calcAble.calcLogicToVirtual(relShareInventoryEos, logicLogs, inventorySharedEos, inventorySharedItemEos, skuDtoList);
        this.reloadVirtual(groupVirtualWarehouseEos, skuDtoList, logicLogs.get(0));
        if (CollectionUtils.isNotEmpty((Collection)channelWarehouseEos)) {
            this.reloadChannel(channelWarehouseEos, skuDtoList, logicLogs.get(0));
        }
    }

    @Override
    public void reloadVirtual(List<VirtualWarehouseEo> virtualWarehouseEos, List<ItemSkuDto> skuDtoList, CsInventoryLogRespDto logicLog) {
        List virtualWarehouseCodes = virtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedEo.class).in(InventorySharedEo::getVirtualWarehouseCode, virtualWarehouseCodes)).eq(InventorySharedEo::getSharedStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedEos)) {
            return;
        }
        List sharedCodes = inventorySharedEos.stream().map(InventorySharedEo::getSharedCode).distinct().collect(Collectors.toList());
        List inventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedWarehouseEo.class).in(InventorySharedWarehouseEo::getSharedCode, sharedCodes)).eq(InventorySharedWarehouseEo::getStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedWarehouseEos)) {
            return;
        }
        List<String> logicWarehouseCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List<RelShareInventoryEo> relShareInventoryEos = this.queryRelLogicInventoryEos(virtualWarehouseEos, skuDtoList, logicWarehouseCodes);
        List<VirtualInventoryEo> virtualInventoryEos = this.queryVirtualInventoryEos(skuDtoList, virtualWarehouseEos);
        CalcInventoryDto virtualCalcDto = this.createVirtualCalcDto(logicLog, virtualInventoryEos, relShareInventoryEos, virtualWarehouseEos, inventorySharedWarehouseEos, inventorySharedEos);
        virtualCalcDto.setValidNegative(Boolean.valueOf(false));
        this.calcAble.calcVirtual(virtualCalcDto, virtualInventoryEos);
    }

    @Override
    public void reloadChannel(List<ChannelWarehouseEo> channelWarehouseEos, List<ItemSkuDto> itemSkuRespDtoList, CsInventoryLogRespDto logicLog) {
        if (CollectionUtils.isEmpty(channelWarehouseEos)) {
            return;
        }
        List<ChannelInventoryEo> channelInventoryEos = this.queryChannelInventoryEos(itemSkuRespDtoList, channelWarehouseEos);
        List channelWarehouseIds = channelWarehouseEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).in(RelVirtualWarehouseEo::getChannelWarehouseId, channelWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
            CalcInventoryDto clearChannelCalcDto = this.createClearChannelCalcDto(channelInventoryEos);
            this.calcAble.calcChannel(clearChannelCalcDto, channelInventoryEos);
            return;
        }
        List virtualWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).distinct().collect(Collectors.toList());
        List virtualWarehouseEos = this.virtualWarehouseDomain.selectByIds(virtualWarehouseIds);
        List<VirtualInventoryEo> virtualInventoryEos = this.queryVirtualInventoryEos(itemSkuRespDtoList, virtualWarehouseEos, false, true);
        log.info("reload channel inventory ref virtualInventoryEos size:{}", (Object)virtualInventoryEos.size());
        CalcInventoryDto channelCalcDto = this.createChannelCalcDto(logicLog, channelInventoryEos, virtualInventoryEos, relVirtualWarehouseEos);
        channelCalcDto.setValidNegative(Boolean.valueOf(false));
        this.calcAble.calcChannel(channelCalcDto, channelInventoryEos);
    }

    @Override
    public void refreshChannelInventory(List<String> channelWarehouseCodes, List<String> cargoCodes) {
        Map<String, List<VirtualWarehouseEo>> channelToVirtualMap = this.queryVirtualWarehouseByChannelWarehouseCodes(channelWarehouseCodes, false);
        if (MapUtils.isEmpty(channelToVirtualMap)) {
            this.clearChannelInventory(channelWarehouseCodes, cargoCodes);
            return;
        }
        HashSet virtualWarehouseEos = Sets.newHashSet();
        for (List<VirtualWarehouseEo> virtualWarehouseEoList : channelToVirtualMap.values()) {
            virtualWarehouseEos.addAll(virtualWarehouseEoList);
        }
        List<String> virtualWarehouseCodes = virtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        this.refreshVirtualInventory(virtualWarehouseCodes, cargoCodes);
    }

    @Override
    public void refreshVirtualInventory(List<String> virtualWarehouseCodes, List<String> cargoCodes) {
        List inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"virtual_warehouse_code", virtualWarehouseCodes)).eq((Object)"shared_status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedEos)) {
            log.info("\u4f9b\u8d27\u7b56\u7565\u67e5\u8be2\u4e0d\u5b58\u5728\uff0c\u4f9b\u8d27\u4ed3\u7f16\u7801: {}", virtualWarehouseCodes);
            return;
        }
        List shareCodes = inventorySharedEos.stream().map(InventorySharedEo::getSharedCode).distinct().collect(Collectors.toList());
        List inventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedWarehouseEo.class).in(InventorySharedWarehouseEo::getSharedCode, shareCodes)).eq(InventorySharedWarehouseEo::getStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedWarehouseEos)) {
            log.info("\u903b\u8f91\u4ed3\u4f9b\u8d27\u5173\u7cfb\u4e0d\u5b58\u5728\uff0c\u4f9b\u8d27\u4ed3\u7f16\u7801: {}, \u5171\u4eab\u7b56\u7565\u7f16\u7801: {}", virtualWarehouseCodes, shareCodes);
            return;
        }
        List<String> logicWarehouseCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getWarehouseCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(logicWarehouseCodes)) {
            return;
        }
        CsLogicInventoryTotalQueryDto csLogicInventoryTotalQueryDto = new CsLogicInventoryTotalQueryDto();
        csLogicInventoryTotalQueryDto.setWarehouseCodes(logicWarehouseCodes);
        csLogicInventoryTotalQueryDto.setCargoCodes(cargoCodes);
        List csLogicInventoryTotalRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryTotalQueryApi.queryByList((List)Lists.newArrayList((Object[])new CsLogicInventoryTotalQueryDto[]{csLogicInventoryTotalQueryDto})));
        List<CsInventoryLogRespDto> logicLogs = this.initByLogicInventory(csLogicInventoryTotalRespDtoList);
        this.clearAndSupplyByLogicLog(virtualWarehouseCodes, logicWarehouseCodes, cargoCodes, logicLogs);
    }

    @Override
    public void clearAndSupplyByLogicLog(List<String> virtualWarehouseCodes, List<String> logicWarehouseCodes, List<String> cargoCodes, List<CsInventoryLogRespDto> logicLogs) {
        long start = System.currentTimeMillis();
        this.relShareInventoryDomain.clearInventory(logicWarehouseCodes, virtualWarehouseCodes, cargoCodes);
        log.info("clear rel inventory exec time: {}", (Object)start);
        log.info("clear inventory successful...............");
        List partitionList = Lists.partition(logicLogs, (int)200);
        for (List csInventoryLogRespDtoList : partitionList) {
            this.supplyByLogicLog(csInventoryLogRespDtoList);
        }
        log.info("supplyByLogicLog exec time: {}", (Object)LogUtils.getExecuteTime((long)start));
    }

    @Override
    public void clearVirtualInventory(List<String> virtualWarehouseCodes, List<String> cargoCodes) {
        List<VirtualWarehouseEo> virtualWarehouseEos = this.queryVirtualWarehouseByCodes(virtualWarehouseCodes);
        List<ItemSkuDto> itemSkuRespDtoList = this.queryItemSkuListByCodes(cargoCodes);
        List<VirtualInventoryEo> virtualInventoryEos = this.queryVirtualInventoryEos(itemSkuRespDtoList, virtualWarehouseEos);
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setRemark("\u5237\u65b0\u5e93\u5b58");
        ArrayList details = Lists.newArrayList();
        for (VirtualInventoryEo virtualInventoryEo : virtualInventoryEos) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setInventoryId(virtualInventoryEo.getId());
            detailDto.setWarehouseCode(virtualInventoryEo.getWarehouseCode());
            detailDto.setSkuCode(virtualInventoryEo.getSkuCode());
            detailDto.setChangeBalance(BigDecimalUtils.subtract((BigDecimal)BigDecimal.ZERO, (BigDecimal)virtualInventoryEo.getBalance()));
            BigDecimal currentAvailable = BigDecimalUtils.subtract((BigDecimal)BigDecimal.ZERO, (BigDecimal)virtualInventoryEo.getPreempt());
            BigDecimal changeAvailable = BigDecimalUtils.subtract((BigDecimal)currentAvailable, (BigDecimal)virtualInventoryEo.getAvailable());
            detailDto.setChangeAvailable(changeAvailable);
            detailDto.setOperate("\u5237\u65b0\u5e93\u5b58");
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        calcInventoryDto.setValidNegative(Boolean.valueOf(false));
        this.calcAble.calcVirtual(calcInventoryDto, virtualInventoryEos);
        Map<String, List<ChannelWarehouseEo>> virtualToChannelMap = this.queryChannelWarehouseByVirtualWarehouseCodes(virtualWarehouseCodes, false);
        HashSet channelWarehouseEos = Sets.newHashSet();
        for (Map.Entry<String, List<ChannelWarehouseEo>> entry : virtualToChannelMap.entrySet()) {
            channelWarehouseEos.addAll((Collection)entry.getValue());
        }
        this.reloadChannel(Lists.newArrayList((Iterable)channelWarehouseEos), itemSkuRespDtoList, null);
    }

    @Override
    public void clearChannelInventory(List<String> channelWarehouseCodes, List<String> cargoCodes) {
        List<ChannelWarehouseEo> channelWarehouseEos = this.queryChannelWarehouseByCode(channelWarehouseCodes);
        List<ChannelInventoryEo> channelInventoryEos = this.queryChannelInventoryEos(Lists.newArrayList(), channelWarehouseEos);
        CalcInventoryDto clearChannelCalcDto = this.createClearChannelCalcDto(channelInventoryEos);
        clearChannelCalcDto.setValidNegative(Boolean.valueOf(false));
        this.calcAble.calcChannel(clearChannelCalcDto, channelInventoryEos);
    }

    @Override
    public void refreshRelChannelAndVirtual(List<String> channelWarehouseCodes, List<String> virtualWarehouseCodes) {
        this.putRedisVirtualToChannel(virtualWarehouseCodes, null);
        this.putRedisChannelToVirtual(channelWarehouseCodes, null);
    }

    @Override
    public List<VirtualWarehouseEo> queryVirtualWarehouseEos(List<String> virtualWarehouseCodes) {
        return this.queryVirtualWarehouseByCodes(virtualWarehouseCodes);
    }

    @Override
    public void reloadChannel(List<String> channelWarehouseCodes, List<String> skuCodeList) {
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(skuCodeList);
        List<ChannelWarehouseEo> channelWarehouseEos = this.queryChannelWarehouseByCode(channelWarehouseCodes);
        this.reloadChannel(channelWarehouseEos, skuDtoList, null);
    }

    private CalcInventoryDto createVirtualCalcDto(CsInventoryLogRespDto logicLog, List<VirtualInventoryEo> virtualInventoryEos, List<RelShareInventoryEo> relShareInventoryEos, List<VirtualWarehouseEo> virtualWarehouseEos, List<InventorySharedWarehouseEo> inventorySharedWarehouseEos, List<InventorySharedEo> inventorySharedEos) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        String remark = "";
        if (null != logicLog) {
            calcInventoryDto.setSourceNo(logicLog.getSourceNo());
            calcInventoryDto.setSourceType(logicLog.getSourceType());
            calcInventoryDto.setExternalOrderNo(logicLog.getExternalSourceNo());
            remark = logicLog.getRemark() + "-";
        }
        calcInventoryDto.setType("virtual");
        ArrayList details = Lists.newArrayList();
        HashSet masterVirtualInventoryEos = Sets.newHashSet();
        HashMap masterVirtualInventoryMap = Maps.newHashMap();
        for (VirtualInventoryEo virtualInventoryEo : virtualInventoryEos) {
            VirtualWarehouseEo virtualWarehouseEo = this.filterVirtualWarehouseByCode(virtualWarehouseEos, virtualInventoryEo.getWarehouseCode());
            if (null == virtualWarehouseEo) continue;
            if (VirtualWarehouseTypeEnum.SUB.getCode().equals(virtualWarehouseEo.getWarehouseType())) {
                VirtualWarehouseEo masterVirtualWarehouseEo = virtualWarehouseEos.stream().filter(o -> Objects.equals(o.getGroupId(), virtualWarehouseEo.getGroupId()) && VirtualWarehouseTypeEnum.OVERALL.getCode().equals(o.getWarehouseType())).findFirst().orElse(null);
                if (null == masterVirtualWarehouseEo) continue;
                String masterVirtualWarehouseCode = masterVirtualWarehouseEo.getWarehouseCode();
                List subVirtualInventoryEos = masterVirtualInventoryMap.getOrDefault(masterVirtualWarehouseCode, Lists.newArrayList());
                subVirtualInventoryEos.add(virtualInventoryEo);
                masterVirtualInventoryMap.put(masterVirtualWarehouseCode, subVirtualInventoryEos);
                continue;
            }
            masterVirtualInventoryEos.add(virtualInventoryEo);
        }
        for (VirtualInventoryEo virtualInventoryEo : masterVirtualInventoryEos) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setInventoryId(virtualInventoryEo.getId());
            detailDto.setOperate(remark + "\u903b\u8f91\u4ed3\u6d41\u6c34\u4e0a\u62a5");
            detailDto.setSkuCode(virtualInventoryEo.getSkuCode());
            detailDto.setWarehouseCode(virtualInventoryEo.getWarehouseCode());
            List subVirtualInventoryEos = masterVirtualInventoryMap.getOrDefault(virtualInventoryEo.getWarehouseCode(), Lists.newArrayList());
            BigDecimal sumSubVirtualInventoryBalance = BigDecimal.ZERO;
            for (VirtualInventoryEo subVirtualInventoryEo : subVirtualInventoryEos) {
                if (!StringUtils.equals((CharSequence)virtualInventoryEo.getSkuCode(), (CharSequence)subVirtualInventoryEo.getSkuCode())) continue;
                sumSubVirtualInventoryBalance = BigDecimalUtils.add((BigDecimal)sumSubVirtualInventoryBalance, (BigDecimal)subVirtualInventoryEo.getBalance());
            }
            List filterRelShareInventoryEos = relShareInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)virtualInventoryEo.getSkuCode()) && StringUtils.equals((CharSequence)o.getReceiveWarehouseCode(), (CharSequence)virtualInventoryEo.getWarehouseCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filterRelShareInventoryEos)) continue;
            BigDecimal supplyNum = BigDecimal.ZERO;
            for (RelShareInventoryEo relShareInventoryEo : filterRelShareInventoryEos) {
                InventorySharedWarehouseEo inventorySharedWarehouseEo;
                InventorySharedEo inventorySharedEo = inventorySharedEos.stream().filter(o -> StringUtils.equals((CharSequence)relShareInventoryEo.getReceiveWarehouseCode(), (CharSequence)o.getVirtualWarehouseCode())).findFirst().orElse(null);
                if (null == inventorySharedEo || null == (inventorySharedWarehouseEo = (InventorySharedWarehouseEo)inventorySharedWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSharedCode(), (CharSequence)inventorySharedEo.getSharedCode()) && StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)relShareInventoryEo.getShareWarehouseCode())).findFirst().orElse(null))) continue;
                supplyNum = BigDecimalUtils.add((BigDecimal)supplyNum, (BigDecimal)relShareInventoryEo.getBalance());
            }
            BigDecimal changeBalance = BigDecimalUtils.subtract((BigDecimal)supplyNum, (BigDecimal)virtualInventoryEo.getBalance());
            changeBalance = BigDecimalUtils.subtract((BigDecimal)changeBalance, (BigDecimal)sumSubVirtualInventoryBalance);
            BigDecimal currentAvailable = BigDecimalUtils.subtract((BigDecimal)BigDecimalUtils.add((BigDecimal)virtualInventoryEo.getBalance(), (BigDecimal)changeBalance), (BigDecimal)virtualInventoryEo.getPreempt());
            BigDecimal changeAvailable = BigDecimalUtils.subtract((BigDecimal)currentAvailable, (BigDecimal)virtualInventoryEo.getAvailable());
            detailDto.setChangeAvailable(changeAvailable);
            detailDto.setChangeBalance(changeBalance);
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    private CalcInventoryDto createChannelCalcDto(CsInventoryLogRespDto logicLog, List<ChannelInventoryEo> channelInventoryEos, List<VirtualInventoryEo> virtualInventoryEos, List<RelVirtualWarehouseEo> relVirtualWarehouseEos) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        String remark = "\u5237\u65b0\u5e93\u5b58";
        if (null != logicLog) {
            calcInventoryDto.setSourceNo(logicLog.getSourceNo());
            calcInventoryDto.setSourceType(logicLog.getSourceType());
            calcInventoryDto.setExternalOrderNo(logicLog.getExternalSourceNo());
            remark = logicLog.getRemark() + "-\u903b\u8f91\u4ed3\u6d41\u6c34\u4e0a\u62a5";
        }
        calcInventoryDto.setType("channel");
        ArrayList details = Lists.newArrayList();
        Map<Long, List<RelVirtualWarehouseEo>> relVirtualWarehouseMap = relVirtualWarehouseEos.stream().collect(Collectors.groupingBy(RelVirtualWarehouseEo::getChannelWarehouseId));
        for (ChannelInventoryEo channelInventoryEo : channelInventoryEos) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setInventoryId(channelInventoryEo.getId());
            detailDto.setOperate(remark);
            detailDto.setSkuCode(channelInventoryEo.getSkuCode());
            detailDto.setWarehouseCode(channelInventoryEo.getWarehouseCode());
            List<RelVirtualWarehouseEo> filterRelShareInventoryEos = relVirtualWarehouseMap.get(channelInventoryEo.getWarehouseId());
            Map virtualInventoryMap = virtualInventoryEos.stream().collect(Collectors.toMap(o -> o.getWarehouseId() + "_" + o.getSkuCode(), Function.identity()));
            BigDecimal supplyNum = BigDecimal.ZERO;
            for (RelVirtualWarehouseEo relVirtualWarehouseEo : filterRelShareInventoryEos) {
                BigDecimal rate = relVirtualWarehouseEo.getShareRatio();
                if (BigDecimalUtils.leZero((BigDecimal)rate).booleanValue() || BigDecimalUtils.gt((BigDecimal)rate, (BigDecimal)BigDecimalUtils.ONE_HUNDRED).booleanValue()) {
                    log.error("\u4f9b\u8d27\u5230\u6e20\u9053  \u4f9b\u8d27\u6bd4\u7387\u5c0f\u4e8e 0 \u6216\u8005 \u5927\u4e8e 100, \u4e2d\u65ad\u4f9b\u8d27 , \u6bd4\u7387 : {}%", (Object)rate);
                    continue;
                }
                VirtualInventoryEo virtualInventoryEo = (VirtualInventoryEo)virtualInventoryMap.get(relVirtualWarehouseEo.getVirtualWarehouseId() + "_" + channelInventoryEo.getSkuCode());
                if (null == virtualInventoryEo) continue;
                BigDecimal num = BigDecimalUtils.multiply((BigDecimal)virtualInventoryEo.getAvailable(), (BigDecimal)BigDecimalUtils.divide((BigDecimal)rate, (BigDecimal)BigDecimalUtils.ONE_HUNDRED, (int)4));
                num = this.getRealNum(num);
                supplyNum = BigDecimalUtils.add((BigDecimal)supplyNum, (BigDecimal)num);
            }
            BigDecimal changeAvailable = BigDecimalUtils.subtract((BigDecimal)supplyNum, (BigDecimal)channelInventoryEo.getAvailable());
            BigDecimal currentBalance = BigDecimalUtils.add((BigDecimal)supplyNum, (BigDecimal)channelInventoryEo.getPreempt());
            BigDecimal changeBalance = BigDecimalUtils.subtract((BigDecimal)currentBalance, (BigDecimal)channelInventoryEo.getBalance());
            detailDto.setChangeBalance(changeBalance);
            detailDto.setChangeAvailable(changeAvailable);
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    private CalcInventoryDto createClearChannelCalcDto(List<ChannelInventoryEo> channelInventoryEos) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setType("channel");
        ArrayList details = Lists.newArrayList();
        for (ChannelInventoryEo channelInventoryEo : channelInventoryEos) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setInventoryId(channelInventoryEo.getId());
            detailDto.setOperate("\u5237\u65b0\u5e93\u5b58");
            detailDto.setSkuCode(channelInventoryEo.getSkuCode());
            detailDto.setWarehouseCode(channelInventoryEo.getWarehouseCode());
            BigDecimal changeBalance = BigDecimalUtils.subtract((BigDecimal)BigDecimal.ZERO, (BigDecimal)channelInventoryEo.getBalance());
            detailDto.setChangeBalance(changeBalance);
            BigDecimal currentAvailable = BigDecimalUtils.subtract((BigDecimal)BigDecimal.ZERO, (BigDecimal)channelInventoryEo.getPreempt());
            BigDecimal changeAvailable = BigDecimalUtils.subtract((BigDecimal)currentAvailable, (BigDecimal)channelInventoryEo.getAvailable());
            detailDto.setChangeAvailable(changeAvailable);
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    private boolean hasValidChange(List<CsInventoryLogRespDto> logicLogs) {
        for (CsInventoryLogRespDto logicLog : logicLogs) {
            if (StringUtils.isBlank((CharSequence)logicLog.getWarehouseCode())) {
                log.info("hasValidChange===>\u903b\u8f91\u4ed3Code\u4e3a\u7a7a");
                return false;
            }
            if (!StringUtils.isBlank((CharSequence)logicLog.getCargoCode())) continue;
            log.info("hasValidChange===>\u8d27\u54c1Code\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    private List<CsInventoryLogRespDto> filterLogs(List<CsInventoryLogRespDto> logicLogs) {
        ArrayList list = Lists.newArrayList();
        for (CsInventoryLogRespDto logicLog : logicLogs) {
            if (null != logicLog.getId()) {
                String cacheKey = String.format("supply_logic_inventory_log_%s_%s", logicLog.getWarehouseCode(), logicLog.getCargoCode());
                Long cacheLogId = (Long)this.cacheService.getCache(cacheKey, Long.class);
                if (null != cacheLogId && cacheLogId > logicLog.getId()) {
                    log.info("\u6d41\u6c34\u5df2\u8fc7\u671f\uff0c\u7f13\u5b58\u6d41\u6c34ID\uff1a{}, \u5f53\u524d\u6d41\u6c34ID: {}, \u4e0d\u6267\u884c\u8be5\u6761\u6d41\u6c34: {}", new Object[]{cacheLogId, logicLog.getId(), LogUtils.buildLogContent((Object)logicLog)});
                    continue;
                }
                this.cacheService.setCache(cacheKey, (Object)logicLog.getId(), 86400);
            }
            list.add(logicLog);
        }
        return list;
    }

    private List<CsInventoryLogRespDto> initByLogicInventory(List<CsLogicInventoryTotalRespDto> logicInventoryRespDtoList) {
        ArrayList csInventoryLogRespDtoList = Lists.newArrayList();
        for (CsLogicInventoryTotalRespDto logicInventory : logicInventoryRespDtoList) {
            if (BigDecimalUtils.eqZero((BigDecimal)logicInventory.getBalance()).booleanValue()) continue;
            CsInventoryLogRespDto logInventory = new CsInventoryLogRespDto();
            BeanUtils.copyProperties((Object)logicInventory, (Object)logInventory);
            logInventory.setId(null);
            logInventory.setRemark("\u5e93\u5b58\u540c\u6b65");
            logInventory.setBeforeActivityAllocate(BigDecimal.ZERO);
            logInventory.setAfterActivityAllocate(logicInventory.getActivityAllocate());
            logInventory.setChangeActivityAllocate(logicInventory.getActivityAllocate());
            logInventory.setBeforeAllocate(BigDecimal.ZERO);
            logInventory.setAfterAllocate(logicInventory.getAllocate());
            logInventory.setChangeAllocate(logicInventory.getAllocate());
            logInventory.setBeforeAvailable(BigDecimal.ZERO);
            logInventory.setAfterAvailable(logicInventory.getAvailable());
            logInventory.setChangeAvailable(logicInventory.getAvailable());
            logInventory.setBeforeBalance(BigDecimal.ZERO);
            logInventory.setAfterBalance(logicInventory.getBalance());
            logInventory.setChangeBalance(logicInventory.getBalance());
            logInventory.setBeforePreempt(BigDecimal.ZERO);
            logInventory.setAfterPreempt(logicInventory.getPreempt());
            logInventory.setChangePreempt(logicInventory.getPreempt());
            logInventory.setBeforeIntransit(BigDecimal.ZERO);
            logInventory.setAfterIntransit(logicInventory.getIntransit());
            logInventory.setChangeIntransit(logicInventory.getIntransit());
            logInventory.setBeforeTransfer(BigDecimal.ZERO);
            logInventory.setAfterTransfer(logicInventory.getTransfer());
            logInventory.setChangeTransfer(logicInventory.getTransfer());
            csInventoryLogRespDtoList.add(logInventory);
        }
        return csInventoryLogRespDtoList;
    }
}

