/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDto;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.service.calc.IPreemptAble;
import com.yunxi.dg.base.center.share.service.calc.impl.WarehouseCommonAble;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PreemptAble
extends WarehouseCommonAble
implements IPreemptAble {
    private static final Logger log = LoggerFactory.getLogger(PreemptAble.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void preempt(PreemptDto dto) {
        log.info("ShPreemptAble:preempt ==> dto:{}", (Object)JSON.toJSONString((Object)dto));
        this.checkParam((OperationDto)dto);
        this.checkParamDetails((OperationDto)dto);
        if (!this.checkExistPreempt(dto.getSourceNo()).booleanValue()) {
            if (!dto.getHasRecordForError().booleanValue()) {
                return;
            }
            throw new BizException("09527", String.format("\u8be5\u5355\u636e[%s]\u5df2\u5b58\u5728\u6709\u6548\u9884\u5360\u8bb0\u5f55", dto.getSourceNo()));
        }
        String channelWarehouseCode = ((OperationDetailDto)dto.getDetails().get(0)).getWarehouseCode();
        List<ChannelWarehouseEo> channelWarehouseEos = this.queryChannelWarehouseEos(Lists.newArrayList((Object[])new OperationDto[]{dto}));
        AssertUtils.notEmpty(channelWarehouseEos, (String)"\u6e20\u9053\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{channelWarehouseCode});
        List<ItemSkuDto> skuDtoList = this.queryItemSkuList(Lists.newArrayList((Object[])new OperationDto[]{dto}));
        AssertUtils.notEmpty(skuDtoList, (String)"\u8d27\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        List<Object> relVirtualWarehouseEos = this.queryVirtualWarehouseByChannelWarehouseCode(Lists.newArrayList((Object[])new String[]{channelWarehouseCode}));
        if (dto.getIsShoutVirtualWarehouse().booleanValue()) {
            AssertUtils.notBlank((String)dto.getShoutVirtualWarehouseCode(), (String)"\u6307\u5b9a\u4f9b\u8d27\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            relVirtualWarehouseEos = relVirtualWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)dto.getShoutVirtualWarehouseCode())).collect(Collectors.toList());
            AssertUtils.notEmpty(relVirtualWarehouseEos, (String)"\u6307\u5b9a\u4f9b\u8d27\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        }
        List<VirtualInventoryEo> virtualInventoryEos = this.queryVirtualInventoryEos(skuDtoList, relVirtualWarehouseEos);
        ArrayList calcVirtualInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcVirtualInventoryEos, virtualInventoryEos, VirtualInventoryEo.class);
        ArrayList insertPreemptEos = Lists.newArrayList();
        CalcInventoryDto channelCalcDto = this.createChannelCalcDto(dto);
        CalcInventoryDto virtualCalcDto = this.createVirtualCalcDto(dto, virtualInventoryEos, relVirtualWarehouseEos);
        List<String> preemptVirtualWarehouseCodes = virtualCalcDto.getDetails().stream().map(CalcInventoryDetailDto::getWarehouseCode).distinct().collect(Collectors.toList());
        Map<String, List<ChannelWarehouseEo>> virtualToChannelMap = this.queryChannelWarehouseByVirtualWarehouseCodes(preemptVirtualWarehouseCodes);
        HashSet otherWarehouseEos = Sets.newHashSet();
        for (String preemptVirtualWarehouseCode : preemptVirtualWarehouseCodes) {
            List<ChannelWarehouseEo> channelWarehouseEoList = virtualToChannelMap.get(preemptVirtualWarehouseCode);
            otherWarehouseEos.addAll(channelWarehouseEoList.stream().filter(o -> !StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)channelWarehouseCode)).distinct().collect(Collectors.toList()));
        }
        channelWarehouseEos.addAll(otherWarehouseEos);
        List<ChannelInventoryEo> channelInventoryEos = this.queryChannelInventoryEos(skuDtoList, channelWarehouseEos);
        ArrayList calcChannelInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcChannelInventoryEos, channelInventoryEos, ChannelInventoryEo.class);
        CalcInventoryDto otherChannelCalcDto = this.createOtherChannelCalcDto(virtualToChannelMap, virtualCalcDto, channelWarehouseCode);
        List<InventoryPreemptionEo> insertChannelPreemptEos = this.createChannelPreemptEos(channelCalcDto, channelWarehouseEos, skuDtoList, channelInventoryEos);
        insertPreemptEos.addAll(insertChannelPreemptEos);
        List<InventoryPreemptionEo> insertVirtualPreemptEos = this.createVirtualPreemptEos(virtualCalcDto, relVirtualWarehouseEos, skuDtoList, virtualInventoryEos);
        insertPreemptEos.addAll(insertVirtualPreemptEos);
        this.calcAble.calcChannelAndOtherChannel(channelCalcDto, otherChannelCalcDto, calcChannelInventoryEos);
        this.calcAble.calcVirtual(virtualCalcDto, calcVirtualInventoryEos);
        if (CollectionUtils.isNotEmpty(insertChannelPreemptEos)) {
            this.inventoryPreemptionDomain.insertPreemptList((List)insertPreemptEos);
        }
    }

    @Override
    public CalcInventoryDto createChannelCalcDto(PreemptDto dto) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setValidNegative(dto.getValidNegative());
        calcInventoryDto.setType("channel");
        ArrayList details = Lists.newArrayList();
        for (OperationDetailDto pd : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate("\u9884\u5360");
            detailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)pd.getNum()));
            detailDto.setChangePreempt(pd.getNum());
            detailDto.setWarehouseCode(pd.getWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setValidNegative(pd.getValidNegative());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    @Override
    public CalcInventoryDto createVirtualCalcDto(PreemptDto dto, List<VirtualInventoryEo> virtualInventoryEos, List<VirtualWarehouseEo> virtualWarehouseEos) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setValidNegative(dto.getValidNegative());
        calcInventoryDto.setType("virtual");
        ArrayList details = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        for (OperationDetailDto pd : dto.getDetails()) {
            VirtualInventoryEo inv2;
            List virtualInventoryEosTmp = virtualInventoryEos.stream().filter(vir -> vir.getSkuCode().equals(pd.getSkuCode())).sorted(Comparator.comparing(VirtualInventoryEo::getAvailable).reversed()).collect(Collectors.toList());
            BigDecimal tempChange = pd.getNum();
            Boolean validNegative = pd.getValidNegative() == null || pd.getValidNegative() != false;
            if (!dto.getValidNegative().booleanValue()) {
                validNegative = false;
            }
            for (VirtualInventoryEo inv2 : virtualInventoryEosTmp) {
                VirtualWarehouseEo virtualWarehouseEo = this.filterVirtualWarehouseByCode(virtualWarehouseEos, inv2.getWarehouseCode());
                if (null == virtualWarehouseEo || EnableDisableEnum.DISABLE.getCode().equals(virtualWarehouseEo.getWarehouseStatus())) {
                    log.info("\u4f9b\u8d27\u4ed3: {}, \u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object)inv2.getWarehouseCode());
                    continue;
                }
                if (BigDecimalUtils.gtZero((BigDecimal)inv2.getAvailable()).booleanValue()) {
                    CalcInventoryDetailDto detail;
                    if (BigDecimalUtils.gt((BigDecimal)tempChange, (BigDecimal)inv2.getAvailable()).booleanValue()) {
                        tempChange = BigDecimalUtils.subtract((BigDecimal)tempChange, (BigDecimal)inv2.getAvailable());
                        detail = this.createCalcInventoryDetail(inv2.getWarehouseCode(), inv2.getSkuCode(), inv2.getAvailable(), inv2);
                        detail.setValidNegative(validNegative);
                        details.add(detail);
                    } else {
                        detail = this.createCalcInventoryDetail(inv2.getWarehouseCode(), inv2.getSkuCode(), tempChange, inv2);
                        detail.setValidNegative(validNegative);
                        details.add(detail);
                        tempChange = BigDecimal.ZERO;
                    }
                    if (!BigDecimalUtils.leZero((BigDecimal)tempChange).booleanValue()) continue;
                    break;
                }
                log.info("\u5e93\u5b58\u5c0f\u4e8e\u7b49\u4e8e\u4e0d\u53c2\u4e0e\u9884\u5360\uff1aVirtualInventoryEo={}", (Object)JSONObject.toJSONString((Object)inv2));
            }
            if (!BigDecimalUtils.gtZero((BigDecimal)tempChange).booleanValue()) continue;
            if (CollectionUtils.isEmpty((Collection)details)) {
                VirtualInventoryEo inv3 = (VirtualInventoryEo)virtualInventoryEosTmp.get(0);
                CalcInventoryDetailDto detail = this.createCalcInventoryDetail(inv3.getWarehouseCode(), inv3.getSkuCode(), pd.getNum(), inv3);
                detail.setValidNegative(validNegative);
                details.add(detail);
                continue;
            }
            boolean isExist = false;
            for (CalcInventoryDetailDto changeVo : details) {
                if (!StringUtils.equals((CharSequence)changeVo.getSkuCode(), (CharSequence)pd.getSkuCode())) continue;
                isExist = true;
                changeVo.setChangePreempt(BigDecimalUtils.add((BigDecimal)changeVo.getChangePreempt(), (BigDecimal)tempChange));
                changeVo.setChangeAvailable(BigDecimalUtils.add((BigDecimal)changeVo.getChangeAvailable(), (BigDecimal)BigDecimalUtils.negate((BigDecimal)tempChange)));
                break;
            }
            if (isExist) continue;
            inv2 = (VirtualInventoryEo)virtualInventoryEosTmp.get(0);
            CalcInventoryDetailDto detail = this.createCalcInventoryDetail(inv2.getWarehouseCode(), inv2.getSkuCode(), pd.getNum(), inv2);
            detail.setValidNegative(validNegative);
            details.add(detail);
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            throw new BizException("09527", StringUtils.join((Iterable)errorList, (String)","));
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    private CalcInventoryDetailDto createCalcInventoryDetail(String virtualWarehouseCode, String cargoCode, BigDecimal num, VirtualInventoryEo virtualInventoryEo) {
        CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
        detailDto.setOperate("\u9884\u5360");
        detailDto.setWarehouseCode(virtualWarehouseCode);
        detailDto.setSkuCode(cargoCode);
        detailDto.setChangePreempt(num);
        detailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)num));
        if (null != virtualInventoryEo) {
            detailDto.setInventoryId(virtualInventoryEo.getId());
            virtualInventoryEo.setAvailable(BigDecimalUtils.add((BigDecimal)virtualInventoryEo.getAvailable(), (BigDecimal)detailDto.getChangeAvailable()));
        }
        return detailDto;
    }
}

