/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.yunxi.dg.base.center.share.dto.calc.DisplacePreemptDto;
import com.yunxi.dg.base.center.share.service.calc.IDisplacePreemptAble;
import com.yunxi.dg.base.center.share.service.calc.impl.WarehouseCommonAble;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DisplacePreemptAble
extends WarehouseCommonAble
implements IDisplacePreemptAble {
    private static final Logger log = LoggerFactory.getLogger(DisplacePreemptAble.class);
    @Resource
    ICommonsMqService commonsMqService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void displacePreempt(DisplacePreemptDto dto) {
        log.info("warehouse able displacePreempt ==> param:{}", (Object)JSON.toJSONString((Object)dto));
        this.checkDisplacePreemptParam(dto);
        this.commonsMqService.publishDelayMessageAsync("INVENTORY_SHARE_DISPLACE_PREEMPT_TOPIC", "DISPLACE_PREEMPT_ASYNC_PROCESS", (Object)dto, Long.valueOf(2L));
    }

    private void checkDisplacePreemptParam(DisplacePreemptDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getDisplaceSourceNo(), (String)"\u539f\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)dto.getShPreemptParams(), (String)"\u5b50\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

