/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptAndOutDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDto;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedWarehouseEo;
import com.yunxi.dg.base.center.share.eo.RelShareInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.service.calc.IReleasePreemptAble;
import com.yunxi.dg.base.center.share.service.calc.IReleasePreemptAndOutAble;
import com.yunxi.dg.base.center.share.service.calc.impl.WarehouseCommonAble;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReleasePreemptAndOutAble
extends WarehouseCommonAble
implements IReleasePreemptAndOutAble {
    private static final Logger log = LoggerFactory.getLogger(ReleasePreemptAndOutAble.class);
    @Autowired
    IReleasePreemptAble releasePreemptAble;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void releasePreemptAndOut(ReleasePreemptAndOutDto dto) {
        log.info("ShReleasePreemptAndOutAble:releasePreemptAndOut ==> dto:{}", (Object)JSON.toJsonString((Object)dto));
        this.checkParam((OperationDto)dto);
        this.checkParamDetails((OperationDto)dto);
        String logicWarehouseCode = dto.getLogicWarehouseCode();
        List<InventoryPreemptionEo> preemptionEos = this.queryPreemptEos(Lists.newArrayList((Object[])new String[]{dto.getSourceNo()}), null);
        if (CollectionUtils.isEmpty(preemptionEos) && CsInventorySourceTypeEnum.OUT_SALE.getCode().equals(dto.getSourceType())) {
            log.info("\u9884\u5360\u5355\u5df2\u7ecf\u6210\u529f\u89e3\u5360\uff1a{}", (Object)JSON.toJsonString(preemptionEos));
            return;
        }
        if (CollectionUtils.isEmpty(preemptionEos)) {
            AssertUtils.notEmpty(preemptionEos, (String)String.format("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u9884\u5360\u8bb0\u5f55 dto: %s", JSON.toJsonString((Object)dto)));
        }
        ArrayList virtualCalcInventoryList = Lists.newArrayList();
        ArrayList channelCalcInventoryList = Lists.newArrayList();
        ArrayList otherChannelCalcInventoryList = Lists.newArrayList();
        List<String> cargoCodes = preemptionEos.stream().map(InventoryPreemptionEo::getSkuCode).distinct().collect(Collectors.toList());
        cargoCodes.addAll(dto.getDetails().stream().map(OperationDetailDto::getSkuCode).collect(Collectors.toList()));
        cargoCodes = cargoCodes.stream().distinct().collect(Collectors.toList());
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(cargoCodes);
        Map<String, List<InventoryPreemptionEo>> preemptClassifyMap = preemptionEos.stream().collect(Collectors.groupingBy(InventoryPreemptionEo::getWarehouseClassify));
        List<InventoryPreemptionEo> channelPreemptEos = preemptClassifyMap.get(WarehouseClassifyEnum.CHANNEL.getCode());
        AssertUtils.notEmpty(channelPreemptEos, (String)"\u6e20\u9053\u4ed3\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728");
        List<String> channelWarehouseCodes = channelPreemptEos.stream().map(InventoryPreemptionEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List<InventoryPreemptionEo> virtualPreemptEos = preemptClassifyMap.get(WarehouseClassifyEnum.VIRTUAL.getCode());
        List<String> virtualWarehouseCodes = virtualPreemptEos.stream().map(InventoryPreemptionEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List<InventorySharedWarehouseEo> inventorySharedWarehouseEos = this.queryShareVirtualWarehouseEos(Lists.newArrayList((Object[])new String[]{logicWarehouseCode}));
        if (CollectionUtils.isEmpty(inventorySharedWarehouseEos)) {
            log.info("\u903b\u8f91\u4ed3\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u4f9b\u8d27\u5173\u7cfb");
            return;
        }
        List shareCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getSharedCode).distinct().collect(Collectors.toList());
        List inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"shared_code", shareCodes)).eq((Object)"shared_status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedEos)) {
            log.info("\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u4f9b\u8d27\u7b56\u7565");
            return;
        }
        this.updateInventoryPreemptionValidBatch(EnableDisableEnum.DISABLE.getCode(), preemptionEos);
        virtualWarehouseCodes.addAll(inventorySharedEos.stream().map(InventorySharedEo::getVirtualWarehouseCode).distinct().collect(Collectors.toList()));
        virtualWarehouseCodes = virtualWarehouseCodes.stream().distinct().collect(Collectors.toList());
        Map<String, List<ChannelWarehouseEo>> virtualToChannelMap = this.queryChannelWarehouseByVirtualWarehouseCodes(virtualWarehouseCodes);
        for (Map.Entry<String, List<ChannelWarehouseEo>> entry : virtualToChannelMap.entrySet()) {
            for (ChannelWarehouseEo channelWarehouseEo : entry.getValue()) {
                channelWarehouseCodes.add(channelWarehouseEo.getWarehouseCode());
            }
        }
        channelWarehouseCodes = channelWarehouseCodes.stream().distinct().collect(Collectors.toList());
        List<ChannelWarehouseEo> channelWarehouseEos = this.queryChannelWarehouseByCode(channelWarehouseCodes);
        List<VirtualWarehouseEo> virtualWarehouseEos = this.queryVirtualWarehouseByCodes(virtualWarehouseCodes);
        List<ChannelInventoryEo> channelInventoryEos = this.queryChannelInventoryEos(skuDtoList, channelWarehouseEos);
        ArrayList calcChannelInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcChannelInventoryEos, channelInventoryEos, ChannelInventoryEo.class);
        List<VirtualInventoryEo> virtualInventoryEos = this.queryVirtualInventoryEos(skuDtoList, virtualWarehouseEos);
        ArrayList calcVirtualInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcVirtualInventoryEos, virtualInventoryEos, VirtualInventoryEo.class);
        List<RelShareInventoryEo> relShareInventoryEos = this.queryRelLogicInventoryEos(virtualWarehouseEos, skuDtoList, Lists.newArrayList((Object[])new String[]{logicWarehouseCode}));
        ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
        releasePreemptDto.setSourceNo(dto.getSourceNo());
        releasePreemptDto.setSourceType(dto.getSourceType());
        releasePreemptDto.setExternalOrderNo(dto.getExternalOrderNo());
        this.doReleasePreempt(releasePreemptDto, channelPreemptEos, virtualPreemptEos, virtualToChannelMap, channelCalcInventoryList, virtualCalcInventoryList, otherChannelCalcInventoryList);
        this.doOut(dto, virtualWarehouseEos, channelPreemptEos, virtualPreemptEos, virtualToChannelMap, relShareInventoryEos, channelCalcInventoryList, virtualCalcInventoryList, otherChannelCalcInventoryList);
        this.calcAble.calcBatchChannelAndOtherChannel(channelCalcInventoryList, otherChannelCalcInventoryList, calcChannelInventoryEos);
        this.calcAble.calcBatchVirtual(virtualCalcInventoryList, calcVirtualInventoryEos);
    }

    private void doReleasePreempt(ReleasePreemptDto releasePreemptDto, List<InventoryPreemptionEo> channelPreemptionEos, List<InventoryPreemptionEo> virtualPreemptionEos, Map<String, List<ChannelWarehouseEo>> allVirtualToChannelMap, List<CalcInventoryDto> channelCalcInventoryDtoList, List<CalcInventoryDto> virtualCalcInventoryDtoList, List<CalcInventoryDto> otherChannelCalcInventoryDtoList) {
        List<InventoryPreemptionEo> channelPreemptEos = channelPreemptionEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSourceNo(), (CharSequence)releasePreemptDto.getSourceNo())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(channelPreemptEos)) {
            return;
        }
        String channelWarehouseCode = ((InventoryPreemptionEo)channelPreemptEos.get(0)).getWarehouseCode();
        CalcInventoryDto channelCalcDto = this.releasePreemptAble.createChannelCalcDto(releasePreemptDto, channelPreemptEos);
        channelCalcDto.setValidNegative(Boolean.valueOf(false));
        channelCalcInventoryDtoList.add(channelCalcDto);
        List<InventoryPreemptionEo> virtualPreemptEos = virtualPreemptionEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSourceNo(), (CharSequence)releasePreemptDto.getSourceNo())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(virtualPreemptEos)) {
            return;
        }
        CalcInventoryDto virtualCalcDto = this.releasePreemptAble.createVirtualCalcDto(releasePreemptDto, virtualPreemptEos);
        virtualCalcDto.setValidNegative(Boolean.valueOf(false));
        virtualCalcInventoryDtoList.add(virtualCalcDto);
        List virtualWarehouseCodes = virtualPreemptEos.stream().map(InventoryPreemptionEo::getWarehouseCode).distinct().collect(Collectors.toList());
        HashMap virtualToChannelMap = Maps.newHashMap();
        for (String virtualWarehouseCode : virtualWarehouseCodes) {
            List<ChannelWarehouseEo> channelWarehouseEoList = allVirtualToChannelMap.get(virtualWarehouseCode);
            virtualToChannelMap.put(virtualWarehouseCode, channelWarehouseEoList);
        }
        CalcInventoryDto otherChannelCalcDto = this.createOtherChannelCalcDto(virtualToChannelMap, virtualCalcDto, channelWarehouseCode);
        otherChannelCalcDto.setValidNegative(Boolean.valueOf(false));
        otherChannelCalcInventoryDtoList.add(otherChannelCalcDto);
    }

    private void doOut(ReleasePreemptAndOutDto dto, List<VirtualWarehouseEo> virtualWarehouseEos, List<InventoryPreemptionEo> channelPreemptionEos, List<InventoryPreemptionEo> virtualPreemptionEos, Map<String, List<ChannelWarehouseEo>> allVirtualToChannelMap, List<RelShareInventoryEo> relShareInventoryEos, List<CalcInventoryDto> channelCalcInventoryDtoList, List<CalcInventoryDto> virtualCalcInventoryDtoList, List<CalcInventoryDto> otherChannelCalcInventoryDtoList) {
        String channelWarehouseCode = channelPreemptionEos.get(0).getWarehouseCode();
        CalcInventoryDto virtualCalcDto = this.createVirtualCalcDto(dto, virtualPreemptionEos, virtualWarehouseEos);
        CalcInventoryDto channelCalcDto = this.createChannelCalcDto(dto, channelPreemptionEos);
        CalcInventoryDto otherChannelCalcDto = this.createOtherChannelCalcDto(allVirtualToChannelMap, virtualCalcDto, channelWarehouseCode);
        this.calcAble.calcLogicRelVirtual(virtualCalcDto, relShareInventoryEos);
        channelCalcDto.setValidNegative(Boolean.valueOf(false));
        channelCalcInventoryDtoList.add(channelCalcDto);
        virtualCalcDto.setValidNegative(Boolean.valueOf(false));
        virtualCalcInventoryDtoList.add(virtualCalcDto);
        otherChannelCalcDto.setValidNegative(Boolean.valueOf(false));
        otherChannelCalcInventoryDtoList.add(otherChannelCalcDto);
    }

    private CalcInventoryDto createChannelCalcDto(ReleasePreemptAndOutDto dto, List<InventoryPreemptionEo> channelPreemptEos) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setType("channel");
        calcInventoryDto.setValidNegative(Boolean.valueOf(false));
        ArrayList details = Lists.newArrayList();
        String channelWarehouseCode = channelPreemptEos.get(0).getWarehouseCode();
        for (OperationDetailDto detailParam : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate("\u51fa\u5e93");
            detailDto.setChangeBalance(BigDecimalUtils.negate((BigDecimal)detailParam.getNum()));
            detailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)detailParam.getNum()));
            detailDto.setWarehouseCode(channelWarehouseCode);
            detailDto.setSkuCode(detailParam.getSkuCode());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }

    private CalcInventoryDto createVirtualCalcDto(ReleasePreemptAndOutDto dto, List<InventoryPreemptionEo> virtualPreemptEos, List<VirtualWarehouseEo> virtualWarehouseEos) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setType("virtual");
        calcInventoryDto.setValidNegative(Boolean.valueOf(false));
        String virtualWarehouseCode = virtualPreemptEos.get(0).getWarehouseCode();
        VirtualWarehouseEo currentVirtualWarehouseEo = this.filterVirtualWarehouseByCode(virtualWarehouseEos, virtualWarehouseCode);
        ArrayList details = Lists.newArrayList();
        for (OperationDetailDto detailParam : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate("\u51fa\u5e93");
            detailDto.setChangeBalance(BigDecimalUtils.negate((BigDecimal)detailParam.getNum()));
            detailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)detailParam.getNum()));
            detailDto.setWarehouseCode(virtualWarehouseCode);
            detailDto.setSkuCode(detailParam.getSkuCode());
            details.add(detailDto);
            for (VirtualWarehouseEo virtualWarehouseEo : virtualWarehouseEos) {
                if (StringUtils.equals((CharSequence)virtualWarehouseEo.getWarehouseCode(), (CharSequence)currentVirtualWarehouseEo.getWarehouseCode()) || Objects.equals(virtualWarehouseEo.getGroupId(), currentVirtualWarehouseEo.getGroupId())) continue;
                CalcInventoryDetailDto otherDetailDto = new CalcInventoryDetailDto();
                otherDetailDto.setOperate("\u51fa\u5e93-\u66f4\u65b0\u5176\u4ed6\u4f9b\u8d27\u4ed3");
                otherDetailDto.setChangeBalance(BigDecimalUtils.negate((BigDecimal)detailParam.getNum()));
                otherDetailDto.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)detailParam.getNum()));
                otherDetailDto.setWarehouseCode(virtualWarehouseEo.getWarehouseCode());
                otherDetailDto.setSkuCode(detailParam.getSkuCode());
                details.add(otherDetailDto);
            }
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }
}

