/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.mode.impl.bd;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateCargoRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderBizTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderLevelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.SplitStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderItemDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.mode.IDgSplitSaleOrderModeDomain;
import com.yunxi.dg.base.center.trade.dto.entity.SaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitChildOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderBySkuReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.proxy.data.api.IPcpDictProxy;
import com.yunxi.dg.base.center.trade.proxy.data.entity.DictDto;
import com.yunxi.dg.base.center.trade.proxy.data.enums.DictEnum;
import com.yunxi.dg.base.center.trade.utils.DgBeanUtils;
import com.yunxi.dg.base.center.trade.utils.SplitLevelUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"perform.order.domain.bd.enable"}, havingValue="true")
@Component
public class DgOrigSplitSaleOrderDomainImpl
implements IDgSplitSaleOrderModeDomain {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String NEED_INVENTORY = "NEED_INVENTORY";
    private static final String NOT_NEED_INVENTORY = "NOT_NEED_INVENTORY";
    @Resource
    private IDgSaleOrderDas saleOrderDas;
    @Resource
    private IDgSaleOrderDomain saleOrderDomain;
    @Resource
    private IDgSaleOrderAddrDomain saleOrderAddrDomain;
    @Resource
    private IDgSaleOrderItemDas saleOrderItemDas;
    @Resource
    private IDgSaleOrderItemDomain saleOrderItemDomain;
    @Autowired
    protected IPcpDictProxy pcpDictProxy;

    @Override
    public List<DgPerformOrderRespDto> splitOrder(DgSplitOrderReqDto reqDto) {
        DgSaleOrderEo saleOrderEo = this.checkSplitOrder(reqDto);
        this.logger.info("[\u62c6\u5355]\u8ba2\u5355({})\u8bf7\u6c42\u62c6\u5355\u53c2\u6570\u4e3a\uff1a{}", (Object)saleOrderEo.getSaleOrderNo(), (Object)JSON.toJSONString((Object)reqDto));
        ArrayList splitChildOrderList = Lists.newArrayList();
        reqDto.getOrderList().forEach(dgDgSplitChildOrderReqDto -> {
            DgSaleOrderEo childOrder = this.createChildOrder(saleOrderEo, dgDgSplitChildOrderReqDto.getGoodsList(), dgDgSplitChildOrderReqDto.getLogicWarehouse(), reqDto.getInitOrderStatus(), reqDto.getInitOmsOrderStatus(), dgDgSplitChildOrderReqDto.getOrderType());
            splitChildOrderList.add(childOrder);
            this.createChildOrderItem(saleOrderEo, childOrder, (DgSplitChildOrderReqDto)dgDgSplitChildOrderReqDto);
            this.copyOrderAddress(saleOrderEo.getId(), childOrder.getId());
        });
        List<DgSplitOrderItemReqDto> dgSplitOrderItemReqDtos = reqDto.getOrderList().stream().map(DgSplitChildOrderReqDto::getGoodsList).flatMap(Collection::stream).collect(Collectors.toList());
        DgSaleOrderEo childOrderForRemain = this.createChildOrderForRemain(saleOrderEo, dgSplitOrderItemReqDtos, reqDto.getInitOrderStatus(), reqDto.getInitOmsOrderStatus(), reqDto.getRemainOrderType());
        if (childOrderForRemain != null) {
            splitChildOrderList.add(childOrderForRemain);
        }
        this.changeOrignalOrder(saleOrderEo, reqDto.getOriOrderStatus());
        return splitChildOrderList.stream().map(DgBeanUtils.origOrderEo2PerformOrderDtoFunc).collect(Collectors.toList());
    }

    private DgSaleOrderEo checkSplitOrder(DgSplitOrderReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)reqDto.getSaleOrderNo()) && reqDto.getSaleOrderId() == null) {
            throw new BizException(DgPcpTradeExceptionCode.ARGS_NOT_EMPTY.getCode(), "\u8ba2\u5355id\u548c\u8ba2\u5355code\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (reqDto.getSaleOrderId() != null) {
            queryWrapper.eq(BaseEo::getId, (Object)reqDto.getSaleOrderId());
        } else if (StringUtils.isNotBlank((CharSequence)reqDto.getSaleOrderNo())) {
            queryWrapper.eq(DgSaleOrderEo::getSaleOrderNo, (Object)reqDto.getSaleOrderNo());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.saleOrderDas.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtils.notNull((Object)saleOrderEo, (String)"\u8be5\u9500\u552e\u5355\u4e0d\u5b58\u5728\uff01");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List saleOrderItemEos = this.saleOrderItemDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
        List<DgSplitOrderItemReqDto> dgSplitOrderItemReqDtos = reqDto.getOrderList().stream().map(DgSplitChildOrderReqDto::getGoodsList).flatMap(Collection::stream).collect(Collectors.toList());
        Boolean canSplit = this.checkSplitLegal(dgSplitOrderItemReqDtos, saleOrderEo, saleOrderItemEos, reqDto.getOrderList().size());
        if (!canSplit.booleanValue()) {
            throw new BizException(DgPcpTradeExceptionCode.SPLIT_ORDER_NUM_EXCEPTION.getCode(), String.format("\u5f53\u524d\u8ba2\u5355(%s)\u62c6\u5355\u6709\u8bef\uff01", saleOrderEo.getSaleOrderNo()));
        }
        Map<Long, BigDecimal> splitOrderItemCountMap = reqDto.getOrderList().stream().map(DgSplitChildOrderReqDto::getGoodsList).flatMap(Collection::stream).collect(Collectors.groupingBy(DgSplitOrderItemReqDto::getOriginalOrderGoodsId, Collectors.collectingAndThen(Collectors.toList(), item -> item.parallelStream().map(DgSplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add))));
        this.logger.info("[\u624b\u5de5\u62c6\u5355]\u7edf\u8ba1\u6bcf\u4e2a\u5546\u54c1sku\u7684\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(splitOrderItemCountMap));
        saleOrderItemEos.forEach(saleOrderItemEo -> {
            BigDecimal splitOrderItemCount = (BigDecimal)splitOrderItemCountMap.get(saleOrderItemEo.getId());
            if (splitOrderItemCount != null && splitOrderItemCount.compareTo(saleOrderItemEo.getItemNum()) > 0) {
                this.logger.error("[\u624b\u5de5\u62c6\u5355]\u62c6\u5355\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5546\u54c1saleOrderItemId={}\u8bf7\u6c42\u62c6\u5206\u7684\u6570\u91cf\u4e3a\uff1a{}\uff0c\u539f\u8ba2\u5355\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{saleOrderItemEo.getId(), splitOrderItemCount, saleOrderItemEo.getItemNum()});
                throw DgPcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
            }
        });
        return saleOrderEo;
    }

    private void createChildOrderItem(DgSaleOrderEo saleOrderEo, DgSaleOrderEo childOrder, DgSplitChildOrderReqDto splitChildOrderReqDto) {
        this.saleOrderItemDomain.createSplitOrderItem(saleOrderEo, childOrder, splitChildOrderReqDto.getGoodsList());
    }

    private DgSaleOrderEo createChildOrder(DgSaleOrderEo saleOrderEo, List<DgSplitOrderItemReqDto> splitGoodsList) {
        return this.createChildOrder(saleOrderEo, splitGoodsList, null, null, null, null);
    }

    private DgSaleOrderEo createChildOrder(DgSaleOrderEo originalSaleOrderEo, List<DgSplitOrderItemReqDto> splitGoodsList, DgSplitChildOrderReqDto.LogicWarehouse logicWarehouse, String childOrderStatus, String childOmsOrderStatus, String orderType) {
        AssertUtils.notEmpty(splitGoodsList, (String)"\u62c6\u5206\u5546\u54c1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List orderItemIdList = splitGoodsList.stream().map(DgSplitOrderItemReqDto::getOriginalOrderGoodsId).collect(Collectors.toList());
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, orderItemIdList);
        List saleOrderItemEos = this.saleOrderItemDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        Map skusMap = saleOrderItemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        DgSaleOrderEo childOrderEo = new DgSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)childOrderEo, (Object)originalSaleOrderEo, (String[])new String[]{"id", "createTime", "updateTime", "orderStatus", "omsSaleOrderStatus", "optLabel"});
        childOrderEo.setOriginOrderId(originalSaleOrderEo.getId());
        childOrderEo.setOriginalOrderNo(originalSaleOrderEo.getSaleOrderNo());
        childOrderEo.setOrderSource(DgSaleOrderSourceEnum.SPLIT.getType());
        childOrderEo.setSaleCreateTime(new Date());
        if (StringUtils.isBlank((CharSequence)originalSaleOrderEo.getMainOrderNo())) {
            childOrderEo.setMainOrderNo(originalSaleOrderEo.getSaleOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)childOrderStatus)) {
            childOrderEo.setOrderStatus(childOrderStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)childOmsOrderStatus)) {
            childOrderEo.setOmsSaleOrderStatus(childOmsOrderStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)orderType)) {
            childOrderEo.setOrderType(orderType);
        }
        String splitLevel = SplitLevelUtils.getSplitLevel(originalSaleOrderEo.getSplitLevel());
        childOrderEo.setSplitLevel(splitLevel);
        if (logicWarehouse != null) {
            childOrderEo.setLogicalWarehouseId(logicWarehouse.getDeliveryLogicWarehouseId());
            childOrderEo.setLogicalWarehouseCode(logicWarehouse.getDeliveryLogicWarehouseCode());
            childOrderEo.setLogicalWarehouseName(logicWarehouse.getDeliveryLogicWarehouseName());
            childOrderEo.setDeliveryLogicalWarehouseCode(logicWarehouse.getSgLogicWarehouseCode());
        }
        BigDecimal totalItemCount = splitGoodsList.stream().map(DgSplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal goodsTotalAmount = BigDecimal.ZERO;
        BigDecimal orderTotalAmount = BigDecimal.ZERO;
        BigDecimal payTotalAmount = BigDecimal.ZERO;
        for (DgSplitOrderItemReqDto dgSplitOrderItemReqDto : splitGoodsList) {
            DgSaleOrderItemEo orderItemEo = (DgSaleOrderItemEo)skusMap.get(dgSplitOrderItemReqDto.getOriginalOrderGoodsId());
            if (Objects.isNull(orderItemEo)) {
                this.logger.warn("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355\u4e2d\uff08saleOrderId={}\uff09\u4e0d\u5b58\u5728skuCode={}\u7684\u5546\u54c1", (Object)originalSaleOrderEo.getId(), (Object)dgSplitOrderItemReqDto.getGoodsSku());
                AssertUtils.notNull((Object)orderItemEo, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
            }
            BigDecimal price = Objects.isNull(orderItemEo.getPrice()) ? BigDecimal.ZERO : orderItemEo.getPrice();
            BigDecimal itemNum = Objects.isNull(dgSplitOrderItemReqDto.getGoodsNum()) ? BigDecimal.ZERO : dgSplitOrderItemReqDto.getGoodsNum();
            BigDecimal totalAmount = price.multiply(itemNum).setScale(2, 4);
            goodsTotalAmount = goodsTotalAmount.add(totalAmount);
            orderTotalAmount = orderTotalAmount.add(totalAmount);
            if (!Objects.equals(orderItemEo.getGift(), DgGiftEnum.NOT_GIFT.getType())) continue;
            payTotalAmount = payTotalAmount.add(totalAmount);
        }
        childOrderEo.setGoodsTotalAmount(goodsTotalAmount);
        childOrderEo.setOrderTotalAmount(payTotalAmount);
        childOrderEo.setPayAmount(payTotalAmount);
        childOrderEo.setGoodsTotalNum(totalItemCount);
        this.logger.info("[\u62c6\u5355]\u521b\u5efa\u5b50\u8ba2\u5355\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)childOrderEo));
        return this.saleOrderDomain.createChildOrder(childOrderEo);
    }

    private DgSaleOrderEo createChildOrderForRemain(DgSaleOrderEo saleOrderEo, List<DgSplitOrderItemReqDto> dgSplitOrderItemReqDtos, String initOrderStatus, String childOmsOrderStatus, String orderType) {
        this.logger.debug("[\u624b\u52a8\u62c6\u5355]\u8ba2\u5355({})\u5269\u4f59\u5546\u54c1\u8fdb\u884c\u5408\u5355\uff0c\u5408\u6210\u4e00\u5f20\u5b50\u5355", (Object)saleOrderEo.getSaleOrderNo());
        Map<Long, List<DgSplitOrderItemReqDto>> skuSplitMap = dgSplitOrderItemReqDtos.stream().collect(Collectors.groupingBy(DgSplitOrderItemReqDto::getOriginalOrderGoodsId));
        HashMap splitOrderItemIdCountMap = new HashMap();
        skuSplitMap.forEach((orderItemId, splitOrderList) -> {
            BigDecimal orderItemIdCount = splitOrderList.stream().map(DgSplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            splitOrderItemIdCountMap.put(orderItemId, orderItemIdCount);
        });
        this.logger.info("[\u624b\u52a8\u62c6\u5355]\u6c47\u603b\u5404\u4e2a\u5546\u54c1\u62c6\u5355\u7684\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString(splitOrderItemIdCountMap));
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List oriSaleOrderItemEos = this.saleOrderItemDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        AssertUtils.notEmpty((Collection)oriSaleOrderItemEos, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
        ArrayList remainFoodsList = Lists.newArrayList();
        oriSaleOrderItemEos.forEach(saleOrderItemEo -> {
            BigDecimal splitCount = (BigDecimal)splitOrderItemIdCountMap.get(saleOrderItemEo.getId());
            DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
            dgSplitOrderItemReqDto.setGoodsSku(saleOrderItemEo.getSkuCode());
            dgSplitOrderItemReqDto.setIsGiftFlag(saleOrderItemEo.getGift());
            dgSplitOrderItemReqDto.setBatch(saleOrderItemEo.getBatchNo());
            dgSplitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemEo.getId());
            if (splitCount != null) {
                if (saleOrderItemEo.getItemNum().compareTo(splitCount) > 0) {
                    BigDecimal remainItemCount = saleOrderItemEo.getItemNum().subtract(splitCount);
                    dgSplitOrderItemReqDto.setGoodsNum(remainItemCount);
                    remainFoodsList.add(dgSplitOrderItemReqDto);
                }
            } else {
                BigDecimal remainItemCount = saleOrderItemEo.getItemNum();
                dgSplitOrderItemReqDto.setGoodsNum(remainItemCount);
                remainFoodsList.add(dgSplitOrderItemReqDto);
            }
        });
        this.logger.info("[\u624b\u52a8\u62c6\u5355]\u5269\u4f59\u7684\u8ba2\u5355\u5546\u54c1\u7684\u62c6\u5355\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)remainFoodsList));
        if (CollectionUtils.isEmpty((Collection)remainFoodsList)) {
            this.logger.info("[\u624b\u52a8\u62c6\u5355]\u8ba2\u5355\u5546\u54c1\u5df2\u88ab\u5168\u90e8\u62c6\u5206\u5b8c\uff0c\u6ca1\u6709\u5269\u4f59\u5546\u54c1\uff0c\u65e0\u9700\u518d\u6784\u9020\u5b50\u5355");
            return null;
        }
        DgSaleOrderEo childOrder = this.createChildOrder(saleOrderEo, remainFoodsList, null, initOrderStatus, childOmsOrderStatus, orderType);
        this.saleOrderItemDomain.createSplitOrderItem(saleOrderEo, childOrder, remainFoodsList);
        this.copyOrderAddress(saleOrderEo.getId(), childOrder.getId());
        return childOrder;
    }

    private void copyOrderAddress(Long oriSaleOrderId, Long childSaleOrderId) {
        AssertUtils.notNull((Object)oriSaleOrderId, (String)"oriSaleOrderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)childSaleOrderId, (String)"childSaleOrderId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.saleOrderAddrDomain.copyOrderAddress(oriSaleOrderId, childSaleOrderId);
    }

    private void changeOrignalOrder(DgSaleOrderEo saleOrderEo, String changeOrderStatus) {
        this.logger.debug("[\u62c6\u5355]\u5f00\u59cb\u4fee\u6539\u539f\u8ba2\u5355\u7684\u72b6\u6001");
        DgSaleOrderEo updateSaleOrderEo = new DgSaleOrderEo();
        if (StringUtils.isNotBlank((CharSequence)changeOrderStatus)) {
            updateSaleOrderEo.setOrderStatus(changeOrderStatus);
        }
        if (DgSaleOrderLevelEnum.ORIGINAL.getType().equals(saleOrderEo.getOrderLevel())) {
            updateSaleOrderEo.setOrderLevel(DgSaleOrderLevelEnum.MAIN.getType());
        }
        updateSaleOrderEo.setSplitStatus(SplitStatusEnum.SPLIT.getType());
        updateSaleOrderEo.setId(saleOrderEo.getId());
        this.logger.info("[\u62c6\u5355]\u4fee\u6539\u539f\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u62c6\u5206\uff0c\u4fee\u6539\u8bf7\u6c42\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updateSaleOrderEo));
        int update = this.saleOrderDomain.updateSaleOrderById(saleOrderEo.getId(), updateSaleOrderEo);
        if (update != 1) {
            throw DgPcpTradeExceptionCode.SPLIT_ORDER_FAIL.builderException();
        }
    }

    private Boolean checkSplitLegal(List<DgSplitOrderItemReqDto> dgSplitOrderItemReqDtos, DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> saleOrderItemEos, int splitOrderCount) {
        BigDecimal splitTotalItemCount = dgSplitOrderItemReqDtos.stream().map(DgSplitOrderItemReqDto::getGoodsNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal oriOrderItemCount = saleOrderItemEos.stream().map(DgSaleOrderItemEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (saleOrderItemEos.size() == dgSplitOrderItemReqDtos.size() && splitTotalItemCount.compareTo(oriOrderItemCount) == 0 && splitOrderCount == 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderBySku(Long orderId, String splitSku) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)splitSku, (String)"\u62c6\u5355\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.logger.info("[\u62c6\u5355]\u8ba2\u5355\uff08{}\uff09\u901a\u8fc7sku\u8fdb\u884c\u62c6\u5355\u64cd\u4f5c\uff0cskucode={}", (Object)orderId, (Object)splitSku);
        DgSaleOrderEo saleOrderEo = this.saleOrderDomain.queryEoById(orderId);
        this.checkSplitOrderBySkuParams(splitSku, saleOrderEo);
        LambdaQueryWrapper querySplitOrderItem = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)querySplitOrderItem.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId)).eq(DgSaleOrderItemEo::getSkuCode, (Object)splitSku);
        List orderItemEos = this.saleOrderItemDas.getMapper().selectList((Wrapper)querySplitOrderItem);
        List<DgSplitOrderItemReqDto> dgSplitOrderItemReqDtos = orderItemEos.stream().map(saleOrderItemEo -> {
            DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
            dgSplitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemEo.getId());
            dgSplitOrderItemReqDto.setGoodsNum(saleOrderItemEo.getItemNum());
            dgSplitOrderItemReqDto.setGoodsSku(saleOrderItemEo.getSkuCode());
            dgSplitOrderItemReqDto.setIsGiftFlag(saleOrderItemEo.getGift());
            return dgSplitOrderItemReqDto;
        }).collect(Collectors.toList());
        ArrayList childOrderEos = Lists.newArrayList();
        DgSaleOrderEo childOrder = this.createChildOrder(saleOrderEo, dgSplitOrderItemReqDtos);
        childOrderEos.add(childOrder);
        this.saleOrderItemDomain.createSplitOrderItem(saleOrderEo, childOrder, dgSplitOrderItemReqDtos);
        DgSaleOrderEo childOrderForRemain = this.createChildOrderForRemain(saleOrderEo, dgSplitOrderItemReqDtos, DgSaleOrderStatusEnum.WAIT_CHECK.getCode(), DgOmsSaleOrderStatus.CREATED.getCode(), null);
        if (childOrderForRemain != null) {
            childOrderEos.add(childOrderForRemain);
        }
        this.changeOrignalOrder(saleOrderEo, DgSaleOrderStatusEnum.SPLIT.getCode());
        return childOrderEos.stream().map(DgBeanUtils.origOrderEo2PerformOrderDtoFunc).collect(Collectors.toList());
    }

    private void checkSplitOrderBySkuParams(String splitSku, DgSaleOrderEo saleOrderEo) {
        this.logger.info("[\u6279\u91cf\u62c6\u5355]\u5f00\u59cb\u6821\u9a8c\u53c2\u6570\uff0c\u5f53\u524d\u8ba2\u5355({})\u80fd\u5426\u62c6skucode={}", (Object)saleOrderEo.getSaleOrderNo(), (Object)splitSku);
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
        List saleOrderItemEos = this.saleOrderItemDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        queryOrderItemWrapper.eq(DgSaleOrderItemEo::getSkuCode, (Object)splitSku);
        List splitSaleOrderItemEos = this.saleOrderItemDas.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        if (CollectionUtils.isEmpty((Collection)splitSaleOrderItemEos)) {
            this.logger.error("[\u6279\u91cf\u62c6\u5355]\u5f53\u524d\u8ba2\u5355({})\u4e0d\u5b58\u5728\u8be5sku({})", (Object)saleOrderEo.getSaleOrderNo(), (Object)splitSku);
            throw DgPcpTradeExceptionCode.SPLIT_ORDER_SKU_NOT_EXIT.builderException();
        }
        List<DgSplitOrderItemReqDto> dgSplitOrderItemReqDtos = splitSaleOrderItemEos.stream().map(saleOrderItemEo -> {
            DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
            dgSplitOrderItemReqDto.setBatch(saleOrderItemEo.getBatchNo());
            dgSplitOrderItemReqDto.setGoodsSku(saleOrderItemEo.getSkuCode());
            dgSplitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemEo.getId());
            dgSplitOrderItemReqDto.setIsGiftFlag(saleOrderItemEo.getGift());
            dgSplitOrderItemReqDto.setGoodsNum(saleOrderItemEo.getItemNum());
            return dgSplitOrderItemReqDto;
        }).collect(Collectors.toList());
        Boolean canSplit = this.checkSplitLegal(dgSplitOrderItemReqDtos, saleOrderEo, saleOrderItemEos, 1);
        if (!canSplit.booleanValue()) {
            throw new BizException(DgPcpTradeExceptionCode.SPLIT_ORDER_NUM_EXCEPTION.getCode(), String.format("\u5f53\u524d\u8ba2\u5355(%s)\u62c6\u5355\u89c4\u5219\u4e0d\u5408\u6cd5\uff01", saleOrderEo.getSaleOrderNo()));
        }
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderByVirtual(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        List<DgSaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemDomain.queryOrderItemByOrderId(orderId);
        Map<String, List<String>> virtualConfigMap = this.getVirtualConfig();
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setSaleOrderId(orderId);
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setRemainOrderType(DgSaleOrderTypeEnum.COMMON_ORDER.getType());
        HashMap splitChildOrderReqDtoMap = Maps.newHashMap();
        saleOrderItemRespDtos.forEach(saleOrderItemRespDto -> {
            if (((List)virtualConfigMap.get(NEED_INVENTORY)).contains(saleOrderItemRespDto.getSkuCode())) {
                this.generSplitParams(NEED_INVENTORY, splitChildOrderReqDtoMap, (SaleOrderItemDto)saleOrderItemRespDto);
            } else if (((List)virtualConfigMap.get(NOT_NEED_INVENTORY)).contains(saleOrderItemRespDto.getSkuCode())) {
                this.generSplitParams(NOT_NEED_INVENTORY, splitChildOrderReqDtoMap, (SaleOrderItemDto)saleOrderItemRespDto);
            }
        });
        List splitChildOrderReqDtos = splitChildOrderReqDtoMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        splitOrderReqDto.setOrderList(splitChildOrderReqDtos);
        this.logger.info("[\u865a\u62df\u5546\u54c1\u62c6\u5355]\u62c6\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(splitChildOrderReqDtos));
        return this.splitOrder(splitOrderReqDto);
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderBySourceResult(String sgOrderNo) {
        return null;
    }

    private Map<String, List<String>> getVirtualConfig() {
        DictEnum dictEnum = DictEnum.VIRTUAL_GOODS_REQUIRING_INVENTORY_MANAGEMENT;
        RestResponse<DictDto> dictDtoRestResponse = this.pcpDictProxy.queryByGroupCodeAndCode(dictEnum.getGroupCode(), dictEnum.getCode());
        DictDto dictDto = (DictDto)RestResponseHelper.extractData(dictDtoRestResponse);
        DictEnum dictEnum2 = DictEnum.VIRTUAL_GOODS_WITHOUT_INVENTORY_MANAGEMENT;
        RestResponse<DictDto> dictDto2RestResponse = this.pcpDictProxy.queryByGroupCodeAndCode(dictEnum2.getGroupCode(), dictEnum2.getCode());
        DictDto dictDto2 = (DictDto)RestResponseHelper.extractData(dictDto2RestResponse);
        ArrayList requireInventorySkuCodeList = Lists.newArrayList();
        ArrayList withoutInventorySkuCodeList = Lists.newArrayList();
        if (Objects.nonNull(dictDto)) {
            Object[] requiringInventorySkuCodes = Optional.ofNullable(dictDto.getValue()).orElse("").split(",");
            requireInventorySkuCodeList.addAll(Lists.newArrayList((Object[])requiringInventorySkuCodes));
        }
        if (Objects.nonNull(dictDto2)) {
            Object[] withoutInventorySkuCodes = Optional.ofNullable(dictDto2.getValue()).orElse("").split(",");
            withoutInventorySkuCodeList.addAll(Lists.newArrayList((Object[])withoutInventorySkuCodes));
        }
        HashMap virtualConfigMap = Maps.newHashMap();
        virtualConfigMap.put(NEED_INVENTORY, requireInventorySkuCodeList);
        virtualConfigMap.put(NOT_NEED_INVENTORY, withoutInventorySkuCodeList);
        return virtualConfigMap;
    }

    private void generSplitParams(String type, Map<String, DgSplitChildOrderReqDto> splitChildOrderReqDtoMap, SaleOrderItemDto saleOrderItemRespDto) {
        splitChildOrderReqDtoMap.compute(type, (key, splitChildOrderReqDto) -> {
            if (splitChildOrderReqDto == null) {
                splitChildOrderReqDto = new DgSplitChildOrderReqDto();
                if (StringUtils.equals((CharSequence)NEED_INVENTORY, (CharSequence)type)) {
                    splitChildOrderReqDto.setOrderType(DgSaleOrderTypeEnum.CONSIGNMENT_ORDER.getType());
                } else if (StringUtils.equals((CharSequence)NOT_NEED_INVENTORY, (CharSequence)type)) {
                    splitChildOrderReqDto.setOrderType(DgSaleOrderTypeEnum.VIRTUAL_ORDER.getType());
                }
            }
            DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
            dgSplitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemRespDto.getId());
            dgSplitOrderItemReqDto.setGoodsNum(saleOrderItemRespDto.getItemNum());
            Optional.ofNullable(splitChildOrderReqDto.getGoodsList()).orElseGet(Collections::emptyList).add(dgSplitOrderItemReqDto);
            return splitChildOrderReqDto;
        });
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderBySkus(DgSplitOrderBySkuReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getSaleOrderId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)reqDto.getSkuCodeList(), (String)"skuCodeList \u4e0d\u80fd\u4e3a\u7a7a");
        List<DgSaleOrderItemRespDto> saleOrderItemRespDtoList = this.saleOrderItemDomain.queryNormalItemsBySkuCodes(reqDto.getSaleOrderId(), reqDto.getSkuCodeList());
        AssertUtils.notEmpty(saleOrderItemRespDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        Integer childOrderItemCountThreahold = saleOrderItemRespDtoList.size();
        if (reqDto.getSplitSkuNum() != null) {
            childOrderItemCountThreahold = reqDto.getSplitSkuNum();
        }
        ArrayList orderList = Lists.newArrayList();
        List dgSplitOrderItemReqDtos = saleOrderItemRespDtoList.stream().map(saleOrderItemRespDto -> {
            DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
            dgSplitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemRespDto.getId());
            dgSplitOrderItemReqDto.setGoodsNum(saleOrderItemRespDto.getItemNum());
            dgSplitOrderItemReqDto.setIsGiftFlag(saleOrderItemRespDto.getGift());
            return dgSplitOrderItemReqDto;
        }).collect(Collectors.toList());
        List partition = Lists.partition(dgSplitOrderItemReqDtos, (int)childOrderItemCountThreahold);
        partition.forEach(orderItemList -> {
            DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
            splitChildOrderReqDto.setGoodsList(orderItemList);
            orderList.add(splitChildOrderReqDto);
        });
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setSaleOrderId(reqDto.getSaleOrderId());
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setOrderList((List)orderList);
        this.logger.info("[\u6307\u5b9asku\u62c6\u5355]\u6307\u5b9asku\u62c6\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        return this.splitOrder(splitOrderReqDto);
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderByExchange(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        List<DgSaleOrderItemRespDto> saleOrderItemRespDtoList = this.saleOrderItemDomain.queryOrderItemByOrderId(orderId);
        AssertUtils.notEmpty(saleOrderItemRespDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        List splitSaleOrderItemRespDtos = saleOrderItemRespDtoList.stream().filter(saleOrderItemRespDto -> DgSaleOrderBizTypeEnum.YHDX.getCode().equals(saleOrderItemRespDto.getItemAttr())).collect(Collectors.toList());
        List dgSplitOrderItemReqDtoList = splitSaleOrderItemRespDtos.stream().map(saleOrderItemRespDto -> {
            DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
            dgSplitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemRespDto.getId());
            dgSplitOrderItemReqDto.setGoodsNum(saleOrderItemRespDto.getItemNum());
            dgSplitOrderItemReqDto.setIsGiftFlag(saleOrderItemRespDto.getGift());
            return dgSplitOrderItemReqDto;
        }).collect(Collectors.toList());
        DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
        splitChildOrderReqDto.setGoodsList(dgSplitOrderItemReqDtoList);
        splitChildOrderReqDto.setOrderType(DgSaleOrderTypeEnum.EXCHANGE_FIX_ORDER.getType());
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setSaleOrderId(orderId);
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setRemainOrderType(DgSaleOrderTypeEnum.COMMON_ORDER.getType());
        splitOrderReqDto.setOrderList((List)Lists.newArrayList((Object[])new DgSplitChildOrderReqDto[]{splitChildOrderReqDto}));
        this.logger.info("[\u4ee5\u6362\u4ee3\u4fee\u62c6\u5355]\u4ee5\u6362\u4ee3\u4fee\u62c6\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        return this.splitOrder(splitOrderReqDto);
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderByAppointResult(DgPerformOrderRespDto respDto, InventoryOperateRespDto inventoryOperateRespDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty((Collection)inventoryOperateRespDto.getFailList())) {
            List<DgSaleOrderItemRespDto> saleOrderItemRespDtoList = this.saleOrderItemDomain.queryNormalItemByOrderId(respDto.getId());
            AssertUtils.notEmpty(saleOrderItemRespDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
            if (inventoryOperateRespDto.getFailList().size() == saleOrderItemRespDtoList.size()) {
                throw DgPcpTradeExceptionCode.SPLIT_ORDER_BY_LACK_FAIL.builderException();
            }
            List skuCodeList = inventoryOperateRespDto.getFailList().stream().map(InventoryOperateCargoRespDto::getLongCode).collect(Collectors.toList());
            List splitOrderItemList = saleOrderItemRespDtoList.stream().filter(saleOrderItemRespDto -> skuCodeList.contains(saleOrderItemRespDto.getSkuCode())).collect(Collectors.toList());
            List dgSplitOrderItemReqDtoList = splitOrderItemList.stream().map(saleOrderItemRespDto -> {
                DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
                dgSplitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemRespDto.getId());
                dgSplitOrderItemReqDto.setGoodsNum(saleOrderItemRespDto.getItemNum());
                dgSplitOrderItemReqDto.setIsGiftFlag(saleOrderItemRespDto.getGift());
                return dgSplitOrderItemReqDto;
            }).collect(Collectors.toList());
            DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
            splitChildOrderReqDto.setGoodsList(dgSplitOrderItemReqDtoList);
            DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
            splitOrderReqDto.setSaleOrderId(respDto.getId());
            splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
            splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
            splitOrderReqDto.setOrderList((List)Lists.newArrayList((Object[])new DgSplitChildOrderReqDto[]{splitChildOrderReqDto}));
            this.logger.info("[\u6307\u5b9a\u4ed3\u5e93\u62c6\u5355]\u6307\u5b9a\u4ed3\u5e93\u62c6\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
            return this.splitOrder(splitOrderReqDto);
        }
        this.logger.warn("[\u6307\u5b9a\u4ed3\u5e93\u62c6\u5355]\u8ba2\u5355\u5546\u54c1\u6ca1\u6709\u7f3a\u8d27\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateRespDto));
        return null;
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderByMultiWarehouse(DgPerformOrderRespDto saleOrderRespDto, DgBizPerformOrderReqDto bizSaleOrderReqDto) {
        AssertUtils.notNull((Object)bizSaleOrderReqDto, (String)"\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a");
        List<DgSaleOrderItemRespDto> saleOrderItemRespDtoList = this.saleOrderItemDomain.queryOrderItemByOrderId(saleOrderRespDto.getId());
        Map<String, List<SaleOrderItemDto>> orderItemResultMap = saleOrderItemRespDtoList.stream().collect(Collectors.groupingBy(SaleOrderItemDto::getLogicalWarehouseCode));
        AssertUtils.isTrue((orderItemResultMap.size() > 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u8ba2\u5355\u4e0d\u80fd\u8fdb\u884c\u62c6\u5355");
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        ArrayList orderList = Lists.newArrayList();
        splitOrderReqDto.setSaleOrderId(saleOrderRespDto.getId());
        orderItemResultMap.forEach((deliveryLogicWarehouseCode, orderItemList) -> {
            DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
            DgSplitChildOrderReqDto.LogicWarehouse logicWarehouse = new DgSplitChildOrderReqDto.LogicWarehouse();
            logicWarehouse.setDeliveryLogicWarehouseCode(deliveryLogicWarehouseCode);
            logicWarehouse.setSgLogicWarehouseCode(deliveryLogicWarehouseCode);
            splitChildOrderReqDto.setLogicWarehouse(logicWarehouse);
            List dgSplitOrderItemReqDtos = orderItemList.stream().map(orderItem -> {
                DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
                dgSplitOrderItemReqDto.setOriginalOrderGoodsId(orderItem.getId());
                dgSplitOrderItemReqDto.setGoodsNum(orderItem.getItemNum());
                return dgSplitOrderItemReqDto;
            }).collect(Collectors.toList());
            splitChildOrderReqDto.setGoodsList(dgSplitOrderItemReqDtos);
            orderList.add(splitChildOrderReqDto);
        });
        splitOrderReqDto.setOrderList((List)orderList);
        this.logger.info("[\u62c6\u5355]\u4e00\u5355\u591a\u4ed3\u62c6\u5355\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        return this.splitOrder(splitOrderReqDto);
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderByGift(Long saleOrderId) {
        List<DgSaleOrderItemRespDto> saleOrderItemRespDtoList = this.saleOrderItemDomain.queryOrderItemByOrderId(saleOrderId);
        List<SaleOrderItemDto> splitOrderItemList = saleOrderItemRespDtoList.stream().filter(saleOrderItemRespDto -> DgGiftEnum.GIFT.getType().equals(saleOrderItemRespDto.getGift())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(splitOrderItemList)) {
            return null;
        }
        ArrayList splitChildOrderReqDtoList = Lists.newArrayList();
        splitOrderItemList.forEach(saleOrderItemRespDto -> {
            for (int i = 0; i < saleOrderItemRespDto.getItemNum().intValue(); ++i) {
                DgSplitOrderItemReqDto dgSplitOrderItemReqDto = new DgSplitOrderItemReqDto();
                dgSplitOrderItemReqDto.setOriginalOrderGoodsId(saleOrderItemRespDto.getId());
                dgSplitOrderItemReqDto.setGoodsNum(new BigDecimal(1));
                dgSplitOrderItemReqDto.setIsGiftFlag(saleOrderItemRespDto.getGift());
                DgSplitChildOrderReqDto splitChildOrderReqDto = new DgSplitChildOrderReqDto();
                splitChildOrderReqDto.setGoodsList((List)Lists.newArrayList((Object[])new DgSplitOrderItemReqDto[]{dgSplitOrderItemReqDto}));
                splitChildOrderReqDtoList.add(splitChildOrderReqDto);
            }
        });
        DgSplitOrderReqDto splitOrderReqDto = new DgSplitOrderReqDto();
        splitOrderReqDto.setSaleOrderId(saleOrderId);
        splitOrderReqDto.setInitOmsOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setInitOrderStatus(DgOmsSaleOrderStatus.CREATED.getCode());
        splitOrderReqDto.setOrderList((List)splitChildOrderReqDtoList);
        this.logger.info("[\u8d60\u54c1\u62c6\u5355]\u8d60\u54c1\u62c6\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderReqDto));
        return this.splitOrder(splitOrderReqDto);
    }

    @Override
    public List<DgPerformOrderRespDto> splitOrderBySourceResult(DgPerformOrderRespDto respDto, SourceOrderResultRespDto sourceOrderResultRespDto) {
        return null;
    }
}

