/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.cache;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.cache.AbstractCache;
import com.yunxi.dg.base.center.trade.cache.CachesStrategy;
import com.yunxi.dg.base.center.trade.utils.ReflectionUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component
public class CacheWrapper
extends AbstractCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheWrapper.class);

    CacheWrapper(ICacheService cacheService, CacheManager cacheManager) {
        this.cacheService = cacheService;
        this.cacheManager = cacheManager;
    }

    public <T extends BaseEo> T queryCache(Object queryKey, Class<T> clzz, Supplier<T> supplier, SFunction<T, ?> ... columns) {
        AssertUtils.notNull((Object)queryKey, (String)"\u67e5\u8be2\u7684key\u4e0d\u80fd\u4e3a\u7a7a");
        String cacheKey = this.getLocalCache(String.valueOf(queryKey), String.class, CachesStrategy.LOCAL_KEY);
        BaseEo cacheEntity = (BaseEo)this.getLocalCache(cacheKey, clzz, CachesStrategy.TEMP);
        if (Objects.nonNull(cacheEntity)) {
            return (T)cacheEntity;
        }
        cacheEntity = (BaseEo)this.getCache(cacheKey, clzz);
        if (Objects.nonNull(cacheEntity)) {
            LOGGER.info("[\u7f13\u5b58]\u67e5\u8be2\u7f13\u5b58\u670d\u52a1\u5668\u83b7\u53d6\u5bf9\u8c61\uff1a{}, key={}", (Object)JSON.toJSONString((Object)cacheEntity), (Object)cacheKey);
            this.cacheLocal(cacheEntity, columns);
            return (T)cacheEntity;
        }
        BaseEo bean = (BaseEo)supplier.get();
        if (Objects.nonNull(bean)) {
            LOGGER.info("[\u7f13\u5b58]\u67e5\u8be2\u6570\u636e\u5e93\u670d\u52a1\u5668\u83b7\u53d6\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)bean));
            this.pushServerCache(bean, columns);
            return (T)bean;
        }
        LOGGER.warn("[\u7f13\u5b58]\u67e5\u8be2\u6570\u636e\u5e93\u670d\u52a1\u65e0\u6cd5\u83b7\u53d6\u5bf9\u8c61\uff1a{}", queryKey);
        return null;
    }

    public void removeCache(Object queryKey) {
        String cacheKey = this.getLocalCache(String.valueOf(queryKey), String.class, CachesStrategy.LOCAL_KEY);
        this.cleanLocalCache(String.valueOf(queryKey), CachesStrategy.TEMP);
        this.cleanCache(cacheKey);
    }

    private <T extends BaseEo> void pushServerCache(T bean, SFunction<T, ?> ... columns) {
        Long id = bean.getId();
        if (id != null) {
            this.cacheLocal(bean, columns);
            this.setCache(String.valueOf(id), bean, CachesStrategy.LOCAL_KEY.getTtl());
        }
    }

    private <T extends BaseEo> void cacheLocal(T cacheEntity, SFunction<T, ?> ... columns) {
        this.cacheLocalKey(cacheEntity, columns);
        Long id = cacheEntity.getId();
        if (id != null) {
            this.setLocalCache(String.valueOf(id), cacheEntity, CachesStrategy.TEMP);
        }
    }

    private <T extends BaseEo> void cacheLocalKey(T cacheEntity, SFunction<T, ?> ... columns) {
        Map<String, String> localKeyAndServerKeyMap = this.getLocalKeyAndServerKeyMap(cacheEntity, columns);
        if (localKeyAndServerKeyMap != null) {
            localKeyAndServerKeyMap.forEach((queryKey, cacheKey) -> this.setLocalCache((String)queryKey, cacheKey, CachesStrategy.LOCAL_KEY));
        }
    }

    private <T extends BaseEo> Map<String, String> getLocalKeyAndServerKeyMap(T cacheEntity, SFunction<T, ?> ... columns) {
        Long id = cacheEntity.getId();
        if (Objects.isNull(id)) {
            LOGGER.warn("[\u7f13\u5b58]\u9700\u8981\u7f13\u5b58\u7684entity\u5bf9\u8c61id\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u7f13\u5b58");
            return null;
        }
        ConcurrentMap cacheMap = Maps.newConcurrentMap();
        List<Object> columnValue = this.getColumnValue(cacheEntity, columns);
        columnValue.forEach(columnVal -> cacheMap.put(String.valueOf(columnVal), String.valueOf(id)));
        return cacheMap;
    }

    private <T extends BaseEo> List<Object> getColumnValue(T cacheEntity, SFunction<T, ?> ... columns) {
        List<String> columnNames = this.getColumnNames(columns);
        List<Object> valueList = columnNames.parallelStream().map(column -> ReflectionUtils.getValueByMethodName(cacheEntity.getClass(), cacheEntity, column)).filter(Objects::nonNull).collect(Collectors.toList());
        return valueList;
    }
}

