/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgOrderLabelItemDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgOrderLabelRecordDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderLabelItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderLabelItemEo;
import com.yunxi.dg.base.center.trade.eo.DgOrderLabelRecordEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgOrderLabelItemDomainImpl
extends BaseDomainImpl<DgOrderLabelItemEo>
implements IDgOrderLabelItemDomain {
    private static final Logger log = LoggerFactory.getLogger(DgOrderLabelItemDomainImpl.class);
    @Resource
    private IDgOrderLabelItemDas das;
    @Resource
    private IDgOrderLabelRecordDas orderLabelRecordDas;

    public ICommonDas<DgOrderLabelItemEo> commonDas() {
        return this.das;
    }

    @Override
    public List<DgOrderLabelItemDto> queryByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgOrderLabelItemEo::getOrderId, (Object)orderId);
        List saleOrderEos = this.das.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgOrderLabelItemDto.class);
        return resultList;
    }

    @Override
    public void addOrderLabelItems(List<DgOrderLabelItemDto> addReqDtos) {
        if (CollectionUtils.isNotEmpty(addReqDtos)) {
            ArrayList orderLabelItemEos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)orderLabelItemEos, addReqDtos, DgOrderLabelItemEo.class);
            this.das.insertBatch((List)orderLabelItemEos);
        }
    }

    @Override
    public Long addOrderLabelItem(DgOrderLabelItemDto addReqDto) {
        DgOrderLabelItemEo orderLabelItemEo = new DgOrderLabelItemEo();
        CubeBeanUtils.copyProperties((Object)orderLabelItemEo, (Object)addReqDto, (String[])new String[0]);
        this.das.insert((BaseEo)orderLabelItemEo);
        return orderLabelItemEo.getId();
    }

    @Override
    public Long addOrderLabelItem(Long orderId, Long orderItemId, DgOrderLabelEnum addReqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)orderItemId, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u5546\u54c1\u884cID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLabelItemEo record = new DgOrderLabelItemEo();
        record.setOrderId(orderId);
        record.setOrderItemId(orderItemId);
        record.setLabelCode(addReqDto.getCode());
        record.setDisplay(addReqDto.getDisplay());
        DgOrderLabelItemEo eo = (DgOrderLabelItemEo)this.das.selectOne((BaseEo)record);
        if (Objects.nonNull(eo)) {
            log.warn(String.format("[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u5df2\u5b58\u5728%s\u6807\u8bc6", orderId, orderItemId, addReqDto.getCode()));
            return null;
        }
        DgOrderLabelItemEo orderLabelItemEo = new DgOrderLabelItemEo();
        orderLabelItemEo.setLabelCode(addReqDto.getCode());
        orderLabelItemEo.setOrderId(orderId);
        orderLabelItemEo.setOrderItemId(orderItemId);
        orderLabelItemEo.setDisplay(addReqDto.getDisplay());
        this.das.insert((BaseEo)orderLabelItemEo);
        return orderLabelItemEo.getId();
    }

    @Override
    public void removeOrderLabelItemById(Long id) {
        this.das.logicDeleteById(id);
    }

    @Override
    public void removeOrderLabelItemById(Long orderId, Long orderItemId, DgOrderLabelEnum reqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u5220\u9664\u8ba2\u5355\u5546\u54c1\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)orderItemId, (String)"[\u5220\u9664\u8ba2\u5355\u5546\u54c1\u6807\u8bc6]\u5546\u54c1\u884cID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto, (String)"[\u5220\u9664\u8ba2\u5355\u5546\u54c1\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLabelItemEo record = new DgOrderLabelItemEo();
        record.setOrderId(orderId);
        record.setOrderItemId(orderItemId);
        record.setLabelCode(reqDto.getCode());
        record.setDisplay(reqDto.getDisplay());
        DgOrderLabelItemEo orderLabelItemEo = (DgOrderLabelItemEo)this.das.selectOne((BaseEo)record);
        if (Objects.isNull(orderLabelItemEo)) {
            log.warn(String.format("[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u672a\u627e\u5230\u8be5%s\u6807\u8bc6", orderId, orderItemId, reqDto.getCode()));
            return;
        }
        this.das.logicDeleteById(orderLabelItemEo.getId());
    }

    @Override
    public List<DgOrderLabelItemRespDto> queryByParam(DgOrderLabelItemReqDto orderLabelItemReqDto) {
        List saleOrderEos;
        AssertUtils.notNull((Object)orderLabelItemReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (Objects.nonNull(orderLabelItemReqDto.getLabelCode())) {
            queryWrapper.eq(DgOrderLabelItemEo::getLabelCode, (Object)orderLabelItemReqDto.getLabelCode());
        }
        if (Objects.nonNull(orderLabelItemReqDto.getOrderId())) {
            queryWrapper.eq(DgOrderLabelItemEo::getOrderId, (Object)orderLabelItemReqDto.getOrderId());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderLabelItemReqDto.getOrderIds())) {
            queryWrapper.in(DgOrderLabelItemEo::getOrderId, (Collection)orderLabelItemReqDto.getOrderIds());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderEos = this.das.getMapper().selectList((Wrapper)queryWrapper)))) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgOrderLabelItemRespDto.class);
        return resultList;
    }

    @Override
    public Long addOrderLabelRecord(Long orderId, DgOrderLabelEnum addReqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLabelRecordEo record = new DgOrderLabelRecordEo();
        record.setOrderId(orderId);
        record.setLabelCode(addReqDto.getCode());
        record.setDisplay(addReqDto.getDisplay());
        DgOrderLabelRecordEo eo = (DgOrderLabelRecordEo)this.orderLabelRecordDas.selectOne((BaseEo)record);
        if (Objects.nonNull(eo)) {
            log.warn(String.format("[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u672a\u627e\u5230\u8be5\u6807\u8bc6", orderId, addReqDto.getCode()));
            return null;
        }
        DgOrderLabelRecordEo orderLabelRecordEo = new DgOrderLabelRecordEo();
        orderLabelRecordEo.setLabelCode(addReqDto.getCode());
        orderLabelRecordEo.setOrderId(orderId);
        orderLabelRecordEo.setDisplay(addReqDto.getDisplay());
        this.orderLabelRecordDas.insert((BaseEo)orderLabelRecordEo);
        return orderLabelRecordEo.getId();
    }
}

