/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.impl.tc;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.yunxi.dg.base.center.trade.cache.CacheWrapper;
import com.yunxi.dg.base.center.trade.domain.order.event.SaleOrderInfoUpdateEvent;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractSaleOrderDomain {
    public static final String EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSaleOrderDomain.class);
    @Autowired
    private ApplicationEventPublisher publisher;

    protected abstract ICommonDas<DgSaleOrderEo> baseDas();

    protected abstract CacheWrapper cacheWrapper();

    public SaleOrderRespDto querySaleOrderByNo(String orderNo) {
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoByNo(orderNo);
        SaleOrderRespDto saleOrderRespDto = new SaleOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)saleOrderEo, (BaseVo)saleOrderRespDto);
        return saleOrderRespDto;
    }

    public DgSaleOrderEo queryDgSaleOrderEoByNo(String orderNo) {
        AssertUtils.notBlank(orderNo, "orderNo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getSaleOrderNo, (Object)orderNo);
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.baseDas().getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtils.notNull(saleOrderEo, "%s \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", orderNo);
        return saleOrderEo;
    }

    public DgSaleOrderEo queryDgSaleOrderEoById(Long orderId) {
        AssertUtils.notNull(orderId, "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.baseDas().selectByPrimaryKey(orderId);
        AssertUtils.notNull(saleOrderEo, "%s \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", orderId);
        return saleOrderEo;
    }

    public int updateSaleOrderById(Long orderId, DgSaleOrderEo updateEo) {
        AssertUtils.notNull(orderId, "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache(orderId);
        }
        updateEo.setId(orderId);
        int updateSelective = this.baseDas().updateSelective((BaseEo)updateEo);
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache(orderId);
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.publisher.publishEvent((Object)new SaleOrderInfoUpdateEvent(orderId));
        }
        return updateSelective;
    }

    public void removeCache(Long orderId) {
        AssertUtils.notNull(orderId, "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache(orderId);
        }
    }

    public int updateSelectiveSqlFilterById(Long orderId, DgSaleOrderEo updateEo) {
        AssertUtils.notNull(orderId, "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache(orderId);
        }
        updateEo.setId(orderId);
        int updateSelectiveSqlFilter = this.baseDas().updateSelectiveSqlFilter((BaseEo)updateEo);
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache(orderId);
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.publisher.publishEvent((Object)new SaleOrderInfoUpdateEvent(orderId));
        }
        return updateSelectiveSqlFilter;
    }

    public void cleanLogicalWarehouseInfo(Long orderId) {
        AssertUtils.notNull(orderId, "orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setId(orderId);
        updateEo.setLogicalWarehouseId(null);
        updateEo.setLogicalWarehouseCode(EMPTY);
        updateEo.setLogicalWarehouseName(EMPTY);
        updateEo.setPhysicsWarehouseId(null);
        updateEo.setPhysicsWarehouseCode(EMPTY);
        updateEo.setPhysicsWarehouseName(EMPTY);
        this.baseDas().updateSelective((BaseEo)updateEo);
        if (this.cacheWrapper() != null) {
            this.cacheWrapper().removeCache(orderId);
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.publisher.publishEvent((Object)new SaleOrderInfoUpdateEvent(orderId));
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION, classes={SaleOrderInfoUpdateEvent.class})
    public void handleAfterCompletionEvent(SaleOrderInfoUpdateEvent saleOrderInfoUpdateEvent) {
        try {
            LOGGER.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u7ed3\u675f\u540e\u4e8b\u4ef6\u3011saleOrderInfoUpdateEvent\uff0cid={}", (Object)saleOrderInfoUpdateEvent.getSaleOrderId());
            if (this.cacheWrapper() != null) {
                this.cacheWrapper().removeCache(saleOrderInfoUpdateEvent.getSaleOrderId());
                LOGGER.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u7ed3\u675f\u540e\u4e8b\u4ef6\u3011\u79fb\u9664\u6210\u529f");
            } else {
                LOGGER.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u7ed3\u675f\u540e\u4e8b\u4ef6\u3011\u65e0\u9700\u79fb\u9664");
            }
        }
        catch (Exception var3) {
            LOGGER.error("{},{}", (Object)var3.getMessage(), (Object)var3);
        }
        finally {
            LOGGER.info("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u7ed3\u675f\u540e\u4e8b\u4ef6\u3011saleOrderInfoUpdateEvent\u5220\u9664\u7ed3\u675f\uff0cid={}", (Object)saleOrderInfoUpdateEvent.getSaleOrderId());
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.BEFORE_COMMIT, classes={SaleOrderInfoUpdateEvent.class})
    public void handleBeforeCommitEvent(SaleOrderInfoUpdateEvent saleOrderInfoUpdateEvent) {
        try {
            LOGGER.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u63d0\u4ea4\u524d\u4e8b\u4ef6\u3011saleOrderInfoUpdateEvent\uff0cid={}", (Object)saleOrderInfoUpdateEvent.getSaleOrderId());
            if (this.cacheWrapper() != null) {
                this.cacheWrapper().removeCache(saleOrderInfoUpdateEvent.getSaleOrderId());
                LOGGER.debug("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u63d0\u4ea4\u524d\u4e8b\u4ef6\u3011\u79fb\u9664\u6210\u529f");
            } else {
                LOGGER.info("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u63d0\u4ea4\u524d\u4e8b\u4ef6\u3011\u65e0\u9700\u79fb\u9664");
            }
        }
        catch (Exception var3) {
            LOGGER.error("{},{}", (Object)var3.getMessage(), (Object)var3);
        }
        finally {
            LOGGER.info("\u3010\u63a5\u6536\u5230\u9500\u552e\u5355\u5185\u5bb9\u66f4\u65b0\u4e8b\u52a1\u63d0\u4ea4\u524d\u4e8b\u4ef6\u3011saleOrderInfoUpdateEvent\u5220\u9664\u7ed3\u675f\uff0cid={}", (Object)saleOrderInfoUpdateEvent.getSaleOrderId());
        }
    }
}

