/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.mode.impl.bd;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderLevelEnum;
import com.yunxi.dg.base.center.trade.constants.SaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.dao.vo.OrderItemAmoutVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleGoodsItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.mode.IDgCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.SaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.SaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleGoodsItemEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.NamedThreadLocal;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"perform.order.domain.bd.enable"}, havingValue="true")
@Component
public class DgOrigCalculatorAmountModeDomainImpl
implements IDgCalculatorAmountModeDomain {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final ThreadLocal<Map<String, BigDecimal>> CACHE_DIGIT_DIFFERENCE = new NamedThreadLocal("\u66ff\u6362\u8865\u5dee\u79ef\u5206\u548c\u91d1\u989d\u7f13\u5b58");
    private static final String ACCUMULATED_REALPAYAMOUNT = "accumulatedRealPayAmount";
    private static final String ACCUMULATED_ITEMINTEGRAL = "accumulatedItemIntegral";
    @Resource
    private IDgSaleOrderItemDomain saleOrderItemDomain;
    @Resource
    private IDgSaleGoodsItemDomain saleGoodsItemDomain;
    @Resource
    private IDgSaleOrderDomain saleOrderDomain;

    @Override
    public void calculatorGoodItemAmountForCreate(SaleOrderItemDto saleOrderItemRespDto, DgSaleGoodsItemEo saleGoodsItemEo, BigDecimal averagePayAmount, BigDecimal averageRealPayAmount, BigDecimal averageDiscountAmount, BigDecimal averageIntegral, int indexGoodItem) {
        this.LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u521b\u5efa\u8ba2\u5355\u662f\u8ba1\u7b97\u5546\u54c1\u660e\u7ec6\u884c\u91d1\u989d\uff0corderId={},skuCode={}", (Object)saleOrderItemRespDto.getOrderId(), (Object)saleOrderItemRespDto.getSkuCode());
        if (saleOrderItemRespDto.getItemNum().intValue() - 1 > indexGoodItem) {
            saleGoodsItemEo.setPayAmount(averagePayAmount);
            saleGoodsItemEo.setRealPayAmount(averageRealPayAmount);
            saleGoodsItemEo.setSurplusCanRefundPayAmount(averagePayAmount);
            saleGoodsItemEo.setDiscountAmount(averageDiscountAmount);
            saleGoodsItemEo.setItemIntegral(averageIntegral);
        } else {
            BigDecimal lastPayAmount = Optional.ofNullable(saleOrderItemRespDto.getPayAmount()).orElse(BigDecimal.ZERO).subtract(averagePayAmount.multiply(BigDecimal.valueOf(indexGoodItem)));
            BigDecimal lastRealPayAmount = Optional.ofNullable(saleOrderItemRespDto.getRealPayAmount()).orElse(BigDecimal.ZERO).subtract(averageRealPayAmount.multiply(BigDecimal.valueOf(indexGoodItem)));
            BigDecimal lastDiscountAmount = Optional.ofNullable(saleOrderItemRespDto.getDiscountAmount()).orElse(BigDecimal.ZERO).subtract(averageDiscountAmount.multiply(BigDecimal.valueOf(indexGoodItem)));
            BigDecimal lastIntegral = Optional.ofNullable(saleOrderItemRespDto.getItemIntegral()).orElse(BigDecimal.ZERO).subtract(averageIntegral.multiply(BigDecimal.valueOf(indexGoodItem)));
            saleGoodsItemEo.setPayAmount(lastPayAmount);
            saleGoodsItemEo.setRealPayAmount(lastRealPayAmount);
            saleGoodsItemEo.setSurplusCanRefundPayAmount(lastPayAmount);
            saleGoodsItemEo.setDiscountAmount(lastDiscountAmount);
            saleGoodsItemEo.setItemIntegral(lastIntegral);
            this.LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u6700\u540e\u4e00\u4e2a\u5546\u54c1\u884c\u7684\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{},\u5b9e\u4ed8\u91d1\u989d={},\u4f18\u60e0\u91d1\u989d={},\u53ef\u9000\u91d1\u989d={},\u5546\u54c1\u79ef\u5206={}", new Object[]{lastPayAmount, lastRealPayAmount, lastDiscountAmount, saleGoodsItemEo.getSurplusCanRefundPayAmount(), lastIntegral});
        }
    }

    @Override
    public void calculatorOrderAmountBySplit(List<DgPerformOrderRespDto> childOrderList) {
        for (int i = 1; i < childOrderList.size(); ++i) {
            DgPerformOrderRespDto orderRespDto = childOrderList.get(i);
            SaleOrderDto saleOrderReqDto = new SaleOrderDto();
            saleOrderReqDto.setId(orderRespDto.getId());
            saleOrderReqDto.setFreightCost(BigDecimal.ZERO);
            this.saleOrderDomain.modifySaleOrder(saleOrderReqDto);
        }
        this.calculatorOrderAmount(childOrderList);
    }

    @Override
    public void calculatorOrderAmount(List<DgPerformOrderRespDto> childOrderList) {
        this.LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u62c6\u5355\u540e\uff0c\u8ba1\u7b97\u5b50\u8ba2\u5355\u5546\u54c1\u4ef7\u683c\uff0cchildOrderList={}", (Object)JSON.toJSONString(childOrderList));
        List<Long> orderIdList = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
        List<DgSaleOrderItemRespDto> orderItemRespDtoList = this.saleOrderItemDomain.queryOrderItemByOrderIds(orderIdList);
        AssertUtils.notEmpty(orderItemRespDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a");
        Map<Long, List<SaleOrderItemDto>> orderItemsMap = orderItemRespDtoList.stream().collect(Collectors.groupingBy(SaleOrderItemDto::getOrderId));
        List<OrderItemAmoutVo> orderItemAmountList = this.saleGoodsItemDomain.calculatorOrderItemAmount(orderIdList);
        this.LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u901a\u8fc7\u5546\u54c1\u660e\u7ec6\u884c\u8ba1\u7b97\u8ba2\u5355\u5546\u54c1\u91d1\u989d\u7edf\u8ba1\u7684\u6570\u636e\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderItemAmountList));
        Map orderItemAmoutVoMap = orderItemAmountList.stream().collect(Collectors.toMap(OrderItemAmoutVo::getOrderItemId, Function.identity()));
        orderItemsMap.forEach((orderId, orderItemList) -> {
            DgPerformOrderRespDto saleOrderRespDto = this.saleOrderDomain.querySaleOrderById((Long)orderId);
            ArrayList saleOrderItemReqDtos = Lists.newArrayList();
            BigDecimal orderPayAmount = BigDecimal.ZERO;
            BigDecimal orderRealPayAmount = BigDecimal.ZERO;
            BigDecimal orderDiscountAmount = BigDecimal.ZERO;
            BigDecimal goodsTotalAmount = BigDecimal.ZERO;
            for (SaleOrderItemDto saleOrderItemRespDto : orderItemList) {
                OrderItemAmoutVo itemAmoutVo = (OrderItemAmoutVo)orderItemAmoutVoMap.get(saleOrderItemRespDto.getId());
                DgPerformOrderItemReqDto saleOrderItemReqDto = new DgPerformOrderItemReqDto();
                saleOrderItemReqDto.setId(saleOrderItemRespDto.getId());
                saleOrderItemReqDto.setPayAmount(itemAmoutVo.getOrderItemPayAmount());
                saleOrderItemReqDto.setRealPayAmount(itemAmoutVo.getOrderItemRealPayAmount());
                saleOrderItemReqDto.setSurplusCanRefundPayAmount(itemAmoutVo.getOrderItemPayAmount());
                saleOrderItemReqDto.setDiscountAmount(itemAmoutVo.getOrderItemDiscountAmount());
                saleOrderItemReqDto.setItemIntegral(itemAmoutVo.getOrderItemIntegral());
                saleOrderItemReqDtos.add(saleOrderItemReqDto);
                if (!StringUtils.equals((String)saleOrderItemRespDto.getStatus(), (String)SaleItemStatusEnum.NORMAL.getCode())) continue;
                orderPayAmount = orderPayAmount.add(itemAmoutVo.getOrderItemPayAmount());
                orderRealPayAmount = orderRealPayAmount.add(itemAmoutVo.getOrderItemRealPayAmount());
                orderDiscountAmount = orderDiscountAmount.add(itemAmoutVo.getOrderItemDiscountAmount());
                goodsTotalAmount = goodsTotalAmount.add(saleOrderItemRespDto.getSalePrice().multiply(saleOrderItemRespDto.getItemNum()));
            }
            this.saleOrderItemDomain.modifyOrderItemAmount(saleOrderItemReqDtos);
            SaleOrderDto saleOrderReqDto = new SaleOrderDto();
            saleOrderReqDto.setId(orderId);
            saleOrderReqDto.setPayAmount(orderPayAmount);
            saleOrderReqDto.setRealPayAmount(orderRealPayAmount);
            saleOrderReqDto.setDiscountAmount(orderDiscountAmount);
            saleOrderReqDto.setGoodsTotalAmount(goodsTotalAmount);
            BigDecimal merchantReceivableAmount = goodsTotalAmount.add(saleOrderRespDto.getFreightCost()).subtract(orderDiscountAmount);
            saleOrderReqDto.setMerchantReceivableAmount(merchantReceivableAmount);
            this.accumulatedOriMerchantReceivableAmount(childOrderList, saleOrderReqDto, merchantReceivableAmount);
            this.LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba2\u5355orderId:{},\u8ba1\u7b97\u5b50\u8ba2\u5355\u6210\u4ea4\u91d1\u989d={},\u5b9e\u4ed8\u91d1\u989d={},\u4f18\u60e0\u91d1\u989d={}, \u5546\u54c1\u603b\u91d1\u989d={}, \u5546\u5bb6\u5e94\u6536={},\u539f\u5546\u5bb6\u5e94\u6536={}", new Object[]{orderId, orderPayAmount, orderRealPayAmount, orderDiscountAmount, goodsTotalAmount, merchantReceivableAmount, saleOrderReqDto.getMerchantOriginReceivableAmount()});
            this.saleOrderDomain.modifySaleOrder(saleOrderReqDto);
        });
    }

    @Override
    public Boolean checkExactDivision(BigDecimal amount, BigDecimal count) {
        return IDgCalculatorAmountModeDomain.super.checkExactDivision(amount, count);
    }

    @Override
    public BigDecimal calculateAverageAmount(BigDecimal amount, BigDecimal count, int newScale, int roundingMode) {
        return IDgCalculatorAmountModeDomain.super.calculateAverageAmount(amount, count, newScale, roundingMode);
    }

    private void accumulatedOriMerchantReceivableAmount(List<? extends DgPerformOrderRespDto> childOrderList, SaleOrderDto saleOrderReqDto, BigDecimal merchantReceivableAmount) {
        DgPerformOrderRespDto saleOrderRespDto = childOrderList.get(0);
        if (childOrderList.size() == 1 && !DgSaleOrderLevelEnum.CHILD.getType().equals(saleOrderRespDto.getOrderLevel())) {
            saleOrderReqDto.setMerchantOriginReceivableAmount(merchantReceivableAmount);
        }
    }

    @Override
    public void calculatorGroupItemAmount(DgPerformOrderItemReqDto orderItemReqDto, DgPerformOrderItemDto itemEo, int index) {
        BigDecimal itemTotalSaleAmount = orderItemReqDto.getSubItemList().parallelStream().map(item -> item.getSalePrice().multiply(item.getItemNum().multiply(orderItemReqDto.getItemNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u7ec4\u5408\u5546\u54c1\u7684\u603b\u9500\u552e\u4ef7={}", (Object)itemTotalSaleAmount);
        if (orderItemReqDto.getSubItemList().size() - 1 > index) {
            BigDecimal payAmount = itemEo.getSalePrice().multiply(itemEo.getItemNum()).divide(itemTotalSaleAmount, 6, 4).multiply(itemEo.getGroupItemPayAmount()).setScale(2, 4);
            itemEo.setPayAmount(payAmount);
            itemEo.setSurplusCanRefundPayAmount(payAmount);
            ((DgPerformOrderItemReqDto)orderItemReqDto.getSubItemList().get(index)).setPayAmount(payAmount);
            BigDecimal realPayAmount = itemEo.getSalePrice().multiply(itemEo.getItemNum()).divide(itemTotalSaleAmount, 6, 4).multiply(itemEo.getGroupItemRealPayAmount()).setScale(2, 4);
            itemEo.setRealPayAmount(realPayAmount);
            ((DgPerformOrderItemReqDto)orderItemReqDto.getSubItemList().get(index)).setRealPayAmount(realPayAmount);
            BigDecimal discountAmount = itemEo.getSalePrice().multiply(itemEo.getItemNum()).divide(itemTotalSaleAmount, 6, 4).multiply(itemEo.getGroupItemDiscountAmount()).setScale(2, 4);
            itemEo.setDiscountAmount(discountAmount);
            ((DgPerformOrderItemReqDto)orderItemReqDto.getSubItemList().get(index)).setDiscountAmount(discountAmount);
            BigDecimal saleAmount = payAmount.add(discountAmount).divide(itemEo.getItemNum(), 6, 4).setScale(6, 4);
            itemEo.setSalePrice(saleAmount);
            BigDecimal price = payAmount.divide(itemEo.getItemNum(), 6, 4);
            itemEo.setPrice(price);
            itemEo.setTransactionPrice(price);
            this.LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1skuCode={},\u5546\u54c1\u6570\u91cf\uff1a{}, \u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{},\u6210\u4ea4\u5355\u4ef7={},\u5b9e\u4ed8\u5355\u4ef7={}, \u4f18\u60e0\u91d1\u989d={}, \u4f18\u60e0\u540e\u7684\u96f6\u552e\u4ef7={}", new Object[]{itemEo.getSkuCode(), itemEo.getItemNum(), payAmount, price, realPayAmount, discountAmount, saleAmount});
        } else {
            BigDecimal hadPaymentAmount = BigDecimal.ZERO;
            BigDecimal hadDiscountAmount = BigDecimal.ZERO;
            BigDecimal hadRealPaymentAmount = BigDecimal.ZERO;
            for (int i = 0; i < orderItemReqDto.getSubItemList().size() - 1; ++i) {
                DgPerformOrderItemReqDto saleOrderItemReqDto = (DgPerformOrderItemReqDto)orderItemReqDto.getSubItemList().get(i);
                hadPaymentAmount = hadPaymentAmount.add(Optional.ofNullable(saleOrderItemReqDto.getPayAmount()).orElse(BigDecimal.ZERO));
                hadDiscountAmount = hadDiscountAmount.add(Optional.ofNullable(saleOrderItemReqDto.getDiscountAmount()).orElse(BigDecimal.ZERO));
                hadRealPaymentAmount = hadRealPaymentAmount.add(saleOrderItemReqDto.getRealPayAmount());
            }
            BigDecimal payAmount = orderItemReqDto.getPayAmount().subtract(hadPaymentAmount);
            BigDecimal discountAmount = orderItemReqDto.getDiscountAmount().subtract(hadDiscountAmount);
            BigDecimal realPayAmount = orderItemReqDto.getRealPayAmount().subtract(hadRealPaymentAmount);
            BigDecimal saleAmount = payAmount.add(discountAmount).divide(itemEo.getItemNum(), 6, 4).setScale(6, 4);
            BigDecimal price = payAmount.divide(itemEo.getItemNum(), 6, 4);
            itemEo.setPayAmount(payAmount);
            itemEo.setSurplusCanRefundPayAmount(payAmount);
            itemEo.setDiscountAmount(discountAmount);
            itemEo.setSalePrice(saleAmount);
            itemEo.setPrice(price);
            itemEo.setTransactionPrice(price);
            itemEo.setRealPayAmount(realPayAmount);
            this.LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1skuCode={},\u5546\u54c1\u6570\u91cf\uff1a{}, \u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{},\u6210\u4ea4\u5355\u4ef7={},\u5b9e\u4ed8\u5355\u4ef7={}\uff0c\u4f18\u60e0\u91d1\u989d={}, \u4f18\u60e0\u540e\u7684\u96f6\u552e\u4ef7={}", new Object[]{itemEo.getSkuCode(), itemEo.getItemNum(), payAmount, price, realPayAmount, discountAmount, saleAmount});
        }
    }

    @Override
    public void calculatorOrderItemAmountForDifference(DgPerformOrderItemReqDto saleOrderItemReqDto, DgPerformOrderItemRespDto oriOrderItemEo, int index, int lastIndex) {
        BigDecimal price = saleOrderItemReqDto.getPayAmount().divide(saleOrderItemReqDto.getItemNum(), 6, 4);
        saleOrderItemReqDto.setPrice(price);
        saleOrderItemReqDto.setSurplusCanRefundPayAmount(saleOrderItemReqDto.getPayAmount());
        BigDecimal salePrice = saleOrderItemReqDto.getPayAmount().add(saleOrderItemReqDto.getDiscountAmount()).divide(saleOrderItemReqDto.getItemNum(), 6, 4);
        saleOrderItemReqDto.setSalePrice(salePrice);
        if (index < lastIndex) {
            BigDecimal realPayAmount = saleOrderItemReqDto.getPayAmount().divide(oriOrderItemEo.getPayAmount(), 6, 4).multiply(Optional.ofNullable(oriOrderItemEo.getRealPayAmount()).orElse(BigDecimal.ZERO)).setScale(2, 4);
            saleOrderItemReqDto.setRealPayAmount(realPayAmount);
            this.accumulatedRealPayAmount(realPayAmount);
            this.LOGGER.info("[\u4e00\u5143\u8865\u5dee]\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}, \u96f6\u552e\u5355\u4ef7\u4e3a\uff1a{},\u5b9e\u4ed8\u91d1\u989d\uff1a{}\uff0cskucode={}", new Object[]{price, salePrice, realPayAmount, saleOrderItemReqDto.getSkuCode()});
            BigDecimal itemIntegral = saleOrderItemReqDto.getPayAmount().divide(oriOrderItemEo.getPayAmount(), 6, 4).multiply(Optional.ofNullable(oriOrderItemEo.getItemIntegral()).orElse(BigDecimal.ZERO)).setScale(0, 1);
            this.accumulatedItemIntegral(itemIntegral);
            saleOrderItemReqDto.setItemIntegral(itemIntegral);
            this.LOGGER.info("[\u4e00\u5143\u8865\u5dee]\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}, \u96f6\u552e\u5355\u4ef7\u4e3a\uff1a{},\u5b9e\u4ed8\u91d1\u989d\uff1a{}\uff0c\u5747\u644a\u79ef\u5206\uff1a{}, skucode={}", new Object[]{price, salePrice, realPayAmount, itemIntegral, saleOrderItemReqDto.getSkuCode()});
        } else {
            BigDecimal accumulatedRealPayAmount = this.getAccumulatedDigit(ACCUMULATED_REALPAYAMOUNT);
            BigDecimal accumulatedItemIntegral = this.getAccumulatedDigit(ACCUMULATED_ITEMINTEGRAL);
            BigDecimal lastRealPayAmount = Optional.ofNullable(oriOrderItemEo.getRealPayAmount()).orElse(BigDecimal.ZERO).subtract(accumulatedRealPayAmount);
            saleOrderItemReqDto.setRealPayAmount(lastRealPayAmount);
            this.LOGGER.info("[\u4e00\u5143\u8865\u5dee]\u6700\u540e\u4e00\u4e2a\u5546\u54c1\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}, \u96f6\u552e\u5355\u4ef7\u4e3a\uff1a{},\u5b9e\u4ed8\u91d1\u989d\uff1a{}\uff0cskucode={}", new Object[]{price, salePrice, lastRealPayAmount, saleOrderItemReqDto.getSkuCode()});
            saleOrderItemReqDto.setRealPayAmount(lastRealPayAmount);
            BigDecimal lastItemIntegral = Optional.ofNullable(oriOrderItemEo.getItemIntegral()).orElse(BigDecimal.ZERO).subtract(accumulatedItemIntegral);
            saleOrderItemReqDto.setItemIntegral(lastItemIntegral);
            this.LOGGER.info("[\u4e00\u5143\u8865\u5dee]\u6700\u540e\u4e00\u4e2a\u5546\u54c1\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}, \u96f6\u552e\u5355\u4ef7\u4e3a\uff1a{},\u5b9e\u4ed8\u91d1\u989d\uff1a{}\uff0c\u79ef\u5206\uff1a{}, skucode={}", new Object[]{price, salePrice, lastRealPayAmount, lastItemIntegral, saleOrderItemReqDto.getSkuCode()});
            CACHE_DIGIT_DIFFERENCE.remove();
        }
    }

    @Override
    public BigDecimal calculateAverageIntegral(BigDecimal itemIntegral, BigDecimal itemNum) {
        return Optional.ofNullable(itemIntegral).orElse(BigDecimal.ZERO).divide(itemNum, 0, 1);
    }

    private void accumulatedRealPayAmount(BigDecimal realPayAmount) {
        Map<String, BigDecimal> accumulatedMap = CACHE_DIGIT_DIFFERENCE.get();
        if (MapUtils.isEmpty(accumulatedMap)) {
            accumulatedMap = new ConcurrentHashMap<String, BigDecimal>();
            CACHE_DIGIT_DIFFERENCE.set(accumulatedMap);
        }
        BigDecimal accumulatedRealPayAmount = Optional.ofNullable(accumulatedMap.get(ACCUMULATED_REALPAYAMOUNT)).orElse(BigDecimal.ZERO).add(realPayAmount);
        accumulatedMap.put(ACCUMULATED_REALPAYAMOUNT, accumulatedRealPayAmount);
        this.LOGGER.info("[\u4e00\u5143\u8865\u5dee]\u7d2f\u8ba1\u5b9e\u4ed8\u91d1\u989d\u4e3a\uff1a{}", (Object)accumulatedRealPayAmount);
    }

    private BigDecimal getAccumulatedDigit(String key) {
        Map<String, BigDecimal> accumulatedMap = CACHE_DIGIT_DIFFERENCE.get();
        if (accumulatedMap == null) {
            return BigDecimal.ZERO;
        }
        return Optional.ofNullable(accumulatedMap.get(key)).orElse(BigDecimal.ZERO);
    }

    private void accumulatedItemIntegral(BigDecimal itemIntegral) {
        Map<String, BigDecimal> accumulatedMap = CACHE_DIGIT_DIFFERENCE.get();
        if (MapUtils.isEmpty(accumulatedMap)) {
            accumulatedMap = new ConcurrentHashMap<String, BigDecimal>();
            CACHE_DIGIT_DIFFERENCE.set(accumulatedMap);
        }
        BigDecimal accumulatedRealPayAmount = Optional.ofNullable(accumulatedMap.get(ACCUMULATED_ITEMINTEGRAL)).orElse(BigDecimal.ZERO).add(itemIntegral);
        accumulatedMap.put(ACCUMULATED_ITEMINTEGRAL, accumulatedRealPayAmount);
        this.LOGGER.info("[\u4e00\u5143\u8865\u5dee]\u7d2f\u8ba1\u79ef\u5206\u4e3a\uff1a{}", (Object)accumulatedRealPayAmount);
    }
}

