/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.yunxi.dg.base.center.trade.cache.CachesStrategy;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableCaching
public class DgCaffeineConfig {
    public static final int DEFAULT_MAXSIZE = 10000;
    public static final int DEFAULT_TTL = 600;

    @Bean
    @Primary
    public CacheManager caffeineCacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        ArrayList<CaffeineCache> caches = new ArrayList<CaffeineCache>();
        for (CachesStrategy c : CachesStrategy.values()) {
            caches.add(new CaffeineCache(c.name(), Caffeine.newBuilder().recordStats().expireAfterWrite((long)c.getTtl(), TimeUnit.SECONDS).maximumSize((long)c.getMaxSize()).build()));
        }
        cacheManager.setCaches(caches);
        return cacheManager;
    }
}

