/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.yunxi.dg.base.center.trade.constants.SaleOrderGoodsSplitTypeEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderGoodsItemDas;
import com.yunxi.dg.base.center.trade.dao.vo.DgPerformOrderGoodsItemQueryVo;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyGoodsItemRowVo;
import com.yunxi.dg.base.center.trade.dao.vo.OrderItemAmoutVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderGoodsItemDomain;
import com.yunxi.dg.base.center.trade.domain.mode.IDgCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderGoodsItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderGoodsItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderGoodsItemEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.vo.DgPerformOrderItemChangeVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgPerformOrderGoodsItemDomainImpl
extends BaseDomainImpl<DgPerformOrderGoodsItemEo>
implements IDgPerformOrderGoodsItemDomain {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final Integer BATCH_INSERT_THRESHOLD = 2000;
    @Resource
    private IDgPerformOrderGoodsItemDas das;
    @Resource
    private IDgCalculatorAmountModeDomain calculatorAmountMode;
    @Resource
    private IDgPerformOrderGoodsItemExtDomain dgGoodsItemModeDomain;

    public ICommonDas<DgPerformOrderGoodsItemEo> commonDas() {
        return this.das;
    }

    @Override
    public List<Long> queryIdsForUpdateGoodsItems(ModifyGoodsItemRowVo updateGoodsItemsVo) {
        return this.das.queryIdsForUpdateGoodsItems(updateGoodsItemsVo);
    }

    @Override
    public int updateGoodsItemsByIds(ModifyGoodsItemRowVo updateGoodsItemsVo, List<Long> idListOfChange) {
        return this.das.updateGoodsItemsByIds(updateGoodsItemsVo, idListOfChange);
    }

    @Override
    public List<OrderItemAmoutVo> calculatorOrderItemAmount(List<Long> orderIdList) {
        return this.das.calculatorOrderItemAmount(orderIdList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyGoodsItemRelation(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getGoodsSplitType(), (String)"\u5546\u54c1\u884c\u660e\u7ec6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        SaleOrderGoodsSplitTypeEnum goodsSplitTypeEnum = SaleOrderGoodsSplitTypeEnum.enumOf((Integer)modifyGoodsItemRowVo.getGoodsSplitType());
        if (goodsSplitTypeEnum == SaleOrderGoodsSplitTypeEnum.NONE) {
            return;
        }
        this.modifyGoodsItems(modifyGoodsItemRowVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int modifyGoodsItems(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getQuerySaleOrderId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getQueryBelongOrderItemId(), (String)"\u5f52\u5c5e\u8ba2\u5355\u5546\u54c1\u884c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getChangeNum(), (String)"\u4fee\u6539\u7684\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        this.LOGGER.info("[\u4fee\u6539\u5546\u54c1\u884c]\u4fee\u6539\u5546\u54c1\u884c\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyGoodsItemRowVo));
        LambdaQueryWrapper queryGoodsItemsWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryGoodsItemsWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderGoodsItemEo::getOrderId, (Object)modifyGoodsItemRowVo.getQuerySaleOrderId())).eq(DgPerformOrderGoodsItemEo::getOrderItemId, (Object)modifyGoodsItemRowVo.getQueryBelongOrderItemId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{modifyGoodsItemRowVo.getQueryOriDeliveryStatus()})) {
            queryGoodsItemsWrapper.eq(DgPerformOrderGoodsItemEo::getDeliveryStatus, (Object)modifyGoodsItemRowVo.getQueryOriDeliveryStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{modifyGoodsItemRowVo.getQueryStatus()})) {
            queryGoodsItemsWrapper.eq(DgPerformOrderGoodsItemEo::getStatus, (Object)modifyGoodsItemRowVo.getQueryStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{modifyGoodsItemRowVo.getQueryRefundStatus()})) {
            queryGoodsItemsWrapper.eq(DgPerformOrderGoodsItemEo::getDeliveryStatus, (Object)modifyGoodsItemRowVo.getQueryRefundStatus());
        }
        int fitCount = this.das.getMapper().selectCount((Wrapper)queryGoodsItemsWrapper);
        if (modifyGoodsItemRowVo.getChangeNum() > fitCount) {
            this.LOGGER.error("[\u4fee\u6539\u5546\u54c1\u884c]\u5f53\u524d\u53ef\u4fee\u6539\u7684\u5546\u54c1\u884c\u6570\u91cf\u4e0d\u6ee1\u8db3\uff0c\u53ef\u4fee\u6539\u7684\u5546\u54c1\u884c\u6570\u91cf\u4e3a\uff1a{}", (Object)fitCount);
            throw DgPcpTradeExceptionCode.FIT_GOOD_IEM_COUNT_NOT_ENOUGHT.builderException();
        }
        List idListOfChange = this.das.queryIdsForUpdateGoodsItems(modifyGoodsItemRowVo);
        if (idListOfChange.size() != modifyGoodsItemRowVo.getChangeNum().intValue()) {
            this.LOGGER.error("[\u4fee\u6539\u5546\u54c1\u884c]\u5f53\u524d\u53ef\u4fee\u6539\u7684\u5546\u54c1\u884c\u6570\u91cf\u4e0d\u6ee1\u8db3\uff0c\u53ef\u4fee\u6539\u7684\u5546\u54c1\u884c\u6570\u91cf\u4e3a\uff1a{}", (Object)idListOfChange.size());
            throw DgPcpTradeExceptionCode.FIT_GOOD_IEM_COUNT_NOT_ENOUGHT.builderException();
        }
        int affectRow = this.das.updateGoodsItemsByIds(modifyGoodsItemRowVo, idListOfChange);
        if (affectRow != modifyGoodsItemRowVo.getChangeNum()) {
            this.LOGGER.error("[\u4fee\u6539\u5546\u54c1\u884c]\u5f53\u524d\u4fee\u6539\u751f\u6548\u7684\u5546\u54c1\u884c\u6570\u4e3a\uff1a{}\uff0c \u671f\u671b\u7684\u4fee\u6539\u884c\u6570\u4e3a\uff1a{}", (Object)affectRow, (Object)modifyGoodsItemRowVo.getChangeNum());
            throw DgPcpTradeExceptionCode.MODIFY_GOOD_IEM_FAIL.builderException();
        }
        return affectRow;
    }

    @Override
    public void saveGoodsItems(DgPerformOrderItemChangeVo saleOrderItermChangeVo) {
        this.dgGoodsItemModeDomain.saveGoodsItems(saleOrderItermChangeVo);
    }

    @Override
    public int queryDtoByOrderId(Long orderId) {
        return 0;
    }

    @Override
    public List<DgPerformOrderGoodsItemRespDto> queryAfterSaleOrderLinkGoodsItems(DgPerformOrderGoodsItemQueryVo performOrderGoodsItemQueryVo, Long firstId, Integer pageSize) {
        if (CollectionUtils.isEmpty((Collection)performOrderGoodsItemQueryVo.getOrderIds()) && CollectionUtils.isEmpty((Collection)performOrderGoodsItemQueryVo.getPlatformOrderItemNos()) && CollectionUtils.isEmpty((Collection)performOrderGoodsItemQueryVo.getMainOrderIds()) && CollectionUtils.isEmpty((Collection)performOrderGoodsItemQueryVo.getMainOrderItemIds())) {
            throw new BizException("-1", "\u67e5\u8be2\u5165\u53c2\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryGoodsItemsWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryGoodsItemsWrapper.eq(BaseEo::getDr, (Object)0)).orderByAsc(BaseEo::getId);
        if (CollectionUtils.isNotEmpty((Collection)performOrderGoodsItemQueryVo.getOrderIds())) {
            queryGoodsItemsWrapper.in(DgPerformOrderGoodsItemEo::getOrderId, (Collection)performOrderGoodsItemQueryVo.getOrderIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)performOrderGoodsItemQueryVo.getOrderItemIds())) {
            queryGoodsItemsWrapper.in(DgPerformOrderGoodsItemEo::getOrderItemId, (Collection)performOrderGoodsItemQueryVo.getOrderItemIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)performOrderGoodsItemQueryVo.getPlatformOrderItemNos())) {
            queryGoodsItemsWrapper.in(DgPerformOrderGoodsItemEo::getPlatformOrderItemNo, (Collection)performOrderGoodsItemQueryVo.getPlatformOrderItemNos());
        }
        if (CollectionUtils.isNotEmpty((Collection)performOrderGoodsItemQueryVo.getMainOrderIds())) {
            queryGoodsItemsWrapper.in(DgPerformOrderGoodsItemEo::getMainOrderId, (Collection)performOrderGoodsItemQueryVo.getMainOrderIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)performOrderGoodsItemQueryVo.getMainOrderItemIds())) {
            queryGoodsItemsWrapper.in(DgPerformOrderGoodsItemEo::getMainOrderItemId, (Collection)performOrderGoodsItemQueryVo.getMainOrderItemIds());
        }
        if (Objects.nonNull(performOrderGoodsItemQueryVo.getPlatformOrderNo())) {
            queryGoodsItemsWrapper.eq(DgPerformOrderGoodsItemEo::getPlatformOrderNo, (Object)performOrderGoodsItemQueryVo.getPlatformOrderNo());
        }
        if (firstId != null) {
            queryGoodsItemsWrapper.gt(BaseEo::getId, (Object)firstId);
        }
        if (performOrderGoodsItemQueryVo.isGourdByOrderId() && performOrderGoodsItemQueryVo.isGourdPlatformOrderItemNo() && performOrderGoodsItemQueryVo.isGourdByOrderItemId()) {
            queryGoodsItemsWrapper.groupBy((Object[])new SFunction[]{DgPerformOrderGoodsItemEo::getOrderId, DgPerformOrderGoodsItemEo::getPlatformOrderItemNo, DgPerformOrderGoodsItemEo::getOrderItemId});
        } else if (performOrderGoodsItemQueryVo.isGourdByOrderId()) {
            queryGoodsItemsWrapper.groupBy(DgPerformOrderGoodsItemEo::getOrderId);
        } else if (performOrderGoodsItemQueryVo.isGourdPlatformOrderItemNo()) {
            queryGoodsItemsWrapper.groupBy(DgPerformOrderGoodsItemEo::getPlatformOrderItemNo);
        } else if (performOrderGoodsItemQueryVo.isGourdByOrderItemId()) {
            queryGoodsItemsWrapper.groupBy(DgPerformOrderGoodsItemEo::getOrderItemId);
        }
        Page page = new Page((long)((Integer)ObjectUtil.defaultIfNull((Object)0, (Object)1)).intValue(), (long)((Integer)ObjectUtil.defaultIfNull((Object)pageSize, (Object)10)).intValue(), false);
        page = this.das.getMapper().selectPage((IPage)page, (Wrapper)queryGoodsItemsWrapper);
        ArrayList<DgPerformOrderGoodsItemRespDto> saleGoodsItemRespDtos = new ArrayList<DgPerformOrderGoodsItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)page.getRecords(), saleGoodsItemRespDtos, DgPerformOrderGoodsItemRespDto.class);
        return saleGoodsItemRespDtos;
    }

    private void insertBatchItems(List<DgPerformOrderGoodsItemEo> batchInsertEo) {
        long start = System.currentTimeMillis();
        if (CollectionUtils.isNotEmpty(batchInsertEo)) {
            this.das.insertBatch(batchInsertEo);
        }
        long end = System.currentTimeMillis();
        this.LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u5f53\u524d\u63d2\u5165:{}\u6761\uff0c\u8017\u65f6\uff1a{}", (Object)batchInsertEo.size(), (Object)(end - start));
    }

    @Override
    public void removeOrderItem(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getQueryBelongOrderItemId(), (String)"belongOrderItemId \u4e0d\u80fd\u4e3a\u7a7a");
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"order_item_id", (Object)modifyGoodsItemRowVo.getQueryBelongOrderItemId());
        wrapper.set((Object)"dr", (Object)1);
        this.das.getMapper().delete((Wrapper)wrapper);
    }
}

