/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class SplitLevelUtils {
    private static final ThreadLocal<SplitLevelHelper> LOCAL = new ThreadLocal();
    private static final String SPLIT = "-";

    public static String getSplitLevel(String splitLevel) {
        SplitLevelHelper levelHelper = LOCAL.get();
        if (levelHelper == null) {
            levelHelper = new SplitLevelHelper(splitLevel);
            LOCAL.set(levelHelper);
        }
        return levelHelper.getSplitLevelNo();
    }

    public static void removeSplitLevel() {
        LOCAL.remove();
    }

    static class SplitLevelHelper {
        private Integer parentNo;
        private AtomicInteger childLevelNo = new AtomicInteger();

        public SplitLevelHelper(String splitLevel) {
            if (StringUtils.isBlank((CharSequence)splitLevel)) {
                this.parentNo = 1;
                this.childLevelNo.set(1);
            } else {
                String[] levels = splitLevel.split(SplitLevelUtils.SPLIT);
                Integer parentNo = Integer.valueOf(levels[0]);
                this.parentNo = parentNo + 1;
                this.childLevelNo.set(1);
            }
        }

        public String getSplitLevelNo() {
            StringBuilder splitBuilder = new StringBuilder();
            splitBuilder.append(this.parentNo).append(SplitLevelUtils.SPLIT).append(this.childLevelNo.getAndIncrement());
            return splitBuilder.toString();
        }
    }
}

