/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.IdGenrator;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgAfterSaleOrderDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgOrderBusinessTypeDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgOrderChannelDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgOrderTagDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgOrderTypeDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgPerformOrderInfoDomainImpl;
import com.yunxi.dg.base.center.trade.domain.entity.impl.DgStrategyAutoCheckRuleDomainImpl;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgPerformOrderNoGreateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgPerformOrderNoGreateUtil.class);
    private static final int EXPIRETIME = 90000;
    @Resource
    private ICacheService cacheService;
    @Resource
    protected Map<String, IResetRedisNoIndexCommon> resetRedisNoIndexCommonMap;
    private static final String AFTER_SALE_ORDER_PREFIX = "AFAF";

    private static String getOrderIdPrefix(LocalDateTime now, String format) {
        return now.format(DateTimeFormatter.ofPattern(format));
    }

    private long generate(Class noServiceClzz, String key, int expireTime) {
        Long incrNo = this.cacheService.incr(key, (long)expireTime);
        if (incrNo == 1L) {
            incrNo = this.resetLastNo(noServiceClzz, key, expireTime);
        }
        return incrNo;
    }

    private Long resetLastNo(Class noServiceClzz, String key, int expireTime) {
        String beanServiceName = StringUtils.prefixToLower((String)noServiceClzz.getSimpleName(), (int)1);
        IResetRedisNoIndexCommon resetRedisNoIndexCommon = this.resetRedisNoIndexCommonMap.get(beanServiceName);
        AssertUtils.notNull((Object)resetRedisNoIndexCommon, (String)"%s\u6ca1\u6709\u5b9e\u73b0IResetRedisNoIndexCommon\u63a5\u53e3", (Object[])new Object[]{beanServiceName});
        String latestNo = resetRedisNoIndexCommon.getLatestNo();
        Long nextNo = 1L;
        if (latestNo.contains(key)) {
            Long latestNoL = Long.valueOf(latestNo.substring(key.length()));
            nextNo = latestNoL + 1L;
            LOGGER.info("\u91cd\u7f6eredis\u5355\u53f7 key\uff1a{}, no:{}", (Object)key, (Object)nextNo);
            this.cacheService.setCache(key, (Object)nextNo, expireTime);
        }
        return nextNo;
    }

    public String generateOrderNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgPerformOrderNoGreateUtil.getOrderIdPrefix(now, "yyyyMMdd");
        String prefix = "DD";
        String prefixOrderNo = prefix + orderIdPrefix;
        String orderId = prefixOrderNo + String.format("%1$07d", this.generate(DgPerformOrderInfoDomainImpl.class, prefixOrderNo, 90000));
        return orderId;
    }

    public String generateChannelNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgPerformOrderNoGreateUtil.getOrderIdPrefix(now, "yyMMdd");
        String prefix = "OC";
        String prefixRuleCode = prefix + orderIdPrefix;
        String ruleCode = prefixRuleCode + String.format("%1$02d", this.generate(DgOrderChannelDomainImpl.class, prefixRuleCode, 90000));
        return ruleCode;
    }

    public String generateOrderTypeNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgPerformOrderNoGreateUtil.getOrderIdPrefix(now, "yyMMdd");
        String prefix = "OT";
        String prefixRuleCode = prefix + orderIdPrefix;
        String ruleCode = prefixRuleCode + String.format("%1$02d", this.generate(DgOrderTypeDomainImpl.class, prefixRuleCode, 90000));
        return ruleCode;
    }

    public String generateBusinessTypeNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgPerformOrderNoGreateUtil.getOrderIdPrefix(now, "yyMMdd");
        String prefix = "BT";
        String prefixRuleCode = prefix + orderIdPrefix;
        String ruleCode = prefixRuleCode + String.format("%1$02d", this.generate(DgOrderBusinessTypeDomainImpl.class, prefixRuleCode, 90000));
        return ruleCode;
    }

    private Date getExpireAtTime(LocalDateTime now) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = now.plusDays(1L);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public String generateTagNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgPerformOrderNoGreateUtil.getOrderIdPrefix(now, "yyyyMMdd");
        String prefix = "TAG";
        String prefixRuleCode = prefix + orderIdPrefix;
        String ruleCode = prefixRuleCode + String.format("%1$04d", this.generate(DgOrderTagDomainImpl.class, prefixRuleCode, 90000));
        return ruleCode;
    }

    public String generateAfterSaleOrderNo() {
        LocalDateTime now = LocalDateTime.now();
        String prefixAfterSaleOrderNo = AFTER_SALE_ORDER_PREFIX + DgPerformOrderNoGreateUtil.getOrderIdPrefix(now, "yyyyMMdd");
        return prefixAfterSaleOrderNo + String.format("%1$06d", this.generate(DgAfterSaleOrderDomainImpl.class, prefixAfterSaleOrderNo, 90000));
    }

    public String generateDefaultPlatformNo() {
        return String.format("PN%s", IdGenrator.getDistributedId());
    }

    public String generateRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = DgPerformOrderNoGreateUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "DR";
        String prefixRuleCode = prefix + orderIdPrefix;
        String ruleCode = prefixRuleCode + String.format("%1$03d", this.generate(DgStrategyAutoCheckRuleDomainImpl.class, prefixRuleCode, 90000));
        return ruleCode;
    }
}

