/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.impl.bd;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgSaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderItemDas;
import com.yunxi.dg.base.center.trade.dao.vo.SaleOrderItermChangeVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleGoodsItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.impl.BaseExtDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.SaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.utils.DgBeanUtils;
import com.yunxi.dg.base.center.trade.vo.DgPerformOrderItemChangeVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"perform.order.domain.bd.enable"}, havingValue="true")
public class DgOrigPerformOrderItemExtDomainImpl
implements IDgPerformOrderItemExtDomain,
BaseExtDomain<DgPerformOrderItemReqDto, DgPerformOrderItemRespDto> {
    private static final Logger log = LoggerFactory.getLogger(DgOrigPerformOrderItemExtDomainImpl.class);
    @Resource
    private IDgSaleOrderItemDas das;
    @Resource
    private IDgSaleGoodsItemDomain saleGoodsItemDomain;
    @Resource
    private IDgSaleOrderItemDomain saleOrderItemDomain;

    @Override
    public void createSplitOrderItem(DgPerformOrderInfoEo origOrder, DgPerformOrderInfoEo childOrder, List<DgSplitOrderItemReqDto> goodsList) {
        DgSaleOrderEo oriSaleOrder = DgBeanUtils.eo2eo(origOrder, DgSaleOrderEo.class);
        DgSaleOrderEo childSaleOrder = DgBeanUtils.eo2eo(childOrder, DgSaleOrderEo.class);
        this.saleOrderItemDomain.createSplitOrderItem(oriSaleOrder, childSaleOrder, goodsList);
    }

    @Override
    public int optimisticModifySaleOrderItem(DgPerformOrderItemEo saleOrderItemEo, LambdaQueryWrapper<DgPerformOrderItemEo> queryWrapper, int idealCount, Integer needChangeItemNum, boolean needThrow) {
        return 0;
    }

    @Override
    public DgPerformOrderItemRespDto queryById(Long orderId) {
        return this.fillItemResult((DgSaleOrderItemEo)this.saleOrderItemDomain.selectByPrimaryKey(orderId));
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryList(DgPerformOrderItemReqDto reqDto) {
        DgSaleOrderItemEo saleOrderItemEo = new DgSaleOrderItemEo();
        CubeBeanUtils.copyProperties((Object)saleOrderItemEo, (Object)reqDto, (String[])new String[0]);
        return this.saleOrderItemDomain.selectList((BaseEo)saleOrderItemEo).stream().map(this::fillItemResult).collect(Collectors.toList());
    }

    @Override
    public PageInfo<DgPerformOrderItemExtRespDto> queryPageById(Long orderId, Integer pageNum, Integer pageSize) {
        DgSaleOrderItemEo saleOrderItemEo = new DgSaleOrderItemEo();
        saleOrderItemEo.setOrderId(orderId);
        saleOrderItemEo.setOrderBy("sku_code");
        PageInfo eoPageInfo = this.saleOrderItemDomain.selectPage((BaseEo)saleOrderItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), DgPerformOrderItemExtRespDto.class);
        return dtoPageInfo;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderId(Long orderId) {
        List<DgSaleOrderItemRespDto> saleOrderItemDtos = this.saleOrderItemDomain.queryOrderItemByOrderId(orderId);
        return saleOrderItemDtos.stream().map(this::fillItemResult).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderIds(List<Long> orderIdList) {
        List<DgSaleOrderItemRespDto> saleOrderItemDtos = this.saleOrderItemDomain.queryOrderItemByOrderIds(orderIdList);
        return saleOrderItemDtos.stream().map(this::fillItemResult).collect(Collectors.toList());
    }

    @Override
    public void modifyOrderItemAmount(List<DgPerformOrderItemReqDto> saleOrderItemReqDtos) {
        AssertUtils.notEmpty(saleOrderItemReqDtos, (String)"saleOrderItemReqDtos \u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList saleOrderItemEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemEos, saleOrderItemReqDtos, SaleOrderItemDto.class);
        for (DgSaleOrderItemEo saleOrderItemEo : saleOrderItemEos) {
            this.das.updateSelective((BaseEo)saleOrderItemEo);
        }
    }

    @Override
    public int insert(DgPerformOrderItemReqDto performOrderItemReqDto) {
        return 0;
    }

    @Override
    public int updateSelective(DgPerformOrderItemReqDto performOrderItemReqDto) {
        AssertUtils.notNull((Object)performOrderItemReqDto, (String)"performOrderItemReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)performOrderItemReqDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderItemRespDto saleOrderItemRespDto = performOrderItemReqDto.convertDto();
        return this.saleOrderItemDomain.updateSelective((BaseEo)DgBeanUtils.dto2eo(saleOrderItemRespDto, DgSaleOrderItemEo.class));
    }

    @Override
    public void reducePerformOrderReturnItemNum(Long saleOrderId, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList) {
    }

    @Override
    public void releasePerformOrderReturnItemNum(Long saleOrderId, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList) {
    }

    @Override
    public BigDecimal getOrderOutDeliveredCount(Long orderId) {
        return null;
    }

    @Override
    public void modifyOrderItemOutDeliveredResult(DgPerformOrderReqDto dgPerformOrderReqDto) {
    }

    @Override
    public void logicDelete(DgPerformOrderItemReqDto performOrderItemReqDto) {
        AssertUtils.notNull((Object)performOrderItemReqDto, (String)"performOrderItemReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)performOrderItemReqDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderItemEo saleOrderItemEo = new DgSaleOrderItemEo();
        CubeBeanUtils.copyProperties((Object)saleOrderItemEo, (Object)performOrderItemReqDto, (String[])new String[0]);
        this.saleOrderItemDomain.logicDelete((BaseEo)saleOrderItemEo);
    }

    @Override
    public void logicDeleteById(Long id) {
        AssertUtils.notNull((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.saleOrderItemDomain.logicDeleteById(id);
    }

    @Override
    public DgPerformOrderItemRespDto selectByPrimaryKey(Long id) {
        return this.fillItemResult((DgSaleOrderItemEo)this.saleOrderItemDomain.selectByPrimaryKey(id));
    }

    @Override
    public DgPerformOrderItemRespDto selectOne(DgPerformOrderItemReqDto performOrderItemReqDto) {
        DgSaleOrderItemEo saleOrderItemEo = new DgSaleOrderItemEo();
        CubeBeanUtils.copyProperties((Object)saleOrderItemEo, (Object)performOrderItemReqDto, (String[])new String[0]);
        return this.fillItemResult((DgSaleOrderItemEo)this.saleOrderItemDomain.selectOne((BaseEo)saleOrderItemEo));
    }

    @Override
    public List<DgPerformOrderItemRespDto> selectList(DgPerformOrderItemReqDto performOrderItemReqDto) {
        DgSaleOrderItemEo saleOrderItemEo = new DgSaleOrderItemEo();
        CubeBeanUtils.copyProperties((Object)saleOrderItemEo, (Object)performOrderItemReqDto, (String[])new String[0]);
        return this.saleOrderItemDomain.selectList((BaseEo)saleOrderItemEo).stream().map(this::fillItemResult).collect(Collectors.toList());
    }

    @Override
    public int insertBatch(List<DgPerformOrderItemReqDto> collection) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(collection), (String)"\u6279\u91cf\u63d2\u5165\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList saleOrderItemEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemEos, collection, DgSaleOrderItemEo.class);
        return this.saleOrderItemDomain.insertBatch(saleOrderItemEos);
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemsBySkuCodes(Long saleOrderId, List<String> skuCodeList) {
        List<DgSaleOrderItemRespDto> saleOrderItemDtos = this.saleOrderItemDomain.queryNormalItemsBySkuCodes(saleOrderId, skuCodeList);
        return saleOrderItemDtos.stream().map(this::fillItemResult).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemByOrderId(Long orderId) {
        List<DgSaleOrderItemRespDto> saleOrderItemDtos = this.saleOrderItemDomain.queryNormalItemByOrderId(orderId);
        return saleOrderItemDtos.stream().map(this::fillItemResult).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemsByOrderIds(List<Long> orderIdList) {
        List<DgSaleOrderItemRespDto> saleOrderItemDtos = this.saleOrderItemDomain.queryNormalItemsByOrderIds(orderIdList);
        return saleOrderItemDtos.stream().map(this::fillItemResult).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderItemIds(Long orderId, List<Long> orderItemIds) {
        List<DgSaleOrderItemRespDto> saleOrderItemDtos = this.saleOrderItemDomain.queryOrderItemByOrderItemIds(orderId, orderItemIds);
        return saleOrderItemDtos.stream().map(this::fillItemResult).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderItemIds(List<Long> orderItemIds) {
        List<DgSaleOrderItemRespDto> saleOrderItemDtos = this.saleOrderItemDomain.queryOrderItemByOrderItemIds(orderItemIds);
        return saleOrderItemDtos.stream().map(this::fillItemResult).collect(Collectors.toList());
    }

    @Override
    public DgPerformOrderItemChangeVo insertBatchItemVo(DgPerformOrderItemChangeVo performOrderItemChangeVo) {
        SaleOrderItermChangeVo saleOrderItermChangeVo = new SaleOrderItermChangeVo();
        CubeBeanUtils.copyProperties((Object)saleOrderItermChangeVo, (Object)performOrderItemChangeVo, (String[])new String[0]);
        List saleOrderItemEos = performOrderItemChangeVo.getPerformOrderItemRespDtos().stream().map(DgBeanUtils.dto2OrigItemEoFunc).collect(Collectors.toList());
        saleOrderItermChangeVo.setSaleOrderItemEos(saleOrderItemEos);
        SaleOrderItermChangeVo resultVo = this.saleOrderItemDomain.insertBatchItemVo(saleOrderItermChangeVo);
        DgPerformOrderItemChangeVo newVo = new DgPerformOrderItemChangeVo();
        CubeBeanUtils.copyProperties((Object)newVo, (Object)resultVo, (String[])new String[0]);
        newVo.setPerformOrderItemRespDtos(resultVo.getSaleOrderItemEos().stream().map(DgBeanUtils.origItemEo2ItemDtoFunc).collect(Collectors.toList()));
        return newVo;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItems(Long saleOrderId, List<String> skuCodeList) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderId)).eq(DgSaleOrderItemEo::getStatus, (Object)DgSaleItemStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isNotEmpty(skuCodeList)) {
            queryOrderItemWrapper.in(DgSaleOrderItemEo::getSkuCode, skuCodeList);
        }
        List resultList = this.saleOrderItemDomain.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        return resultList.stream().map(DgBeanUtils.origItemEo2ItemDtoFunc).collect(Collectors.toList());
    }

    private DgPerformOrderItemRespDto fillItemResult(DgSaleOrderItemEo saleOrderItemEo) {
        if (Objects.isNull(saleOrderItemEo)) {
            return null;
        }
        DgPerformOrderItemRespDto respDto = new DgPerformOrderItemRespDto();
        DgPerformOrderItemExtensionDto extensionDto = new DgPerformOrderItemExtensionDto();
        CubeBeanUtils.copyProperties((Object)extensionDto, (Object)saleOrderItemEo, (String[])new String[0]);
        CubeBeanUtils.copyProperties((Object)respDto, (Object)saleOrderItemEo, (String[])new String[0]);
        respDto.setPerformOrderItemExtensionDto(extensionDto);
        return respDto;
    }

    private DgPerformOrderItemRespDto fillItemResult(DgSaleOrderItemRespDto saleOrderItemRespDto) {
        if (Objects.isNull(saleOrderItemRespDto)) {
            return null;
        }
        DgPerformOrderItemRespDto respDto = new DgPerformOrderItemRespDto();
        DgPerformOrderItemExtensionDto extensionDto = new DgPerformOrderItemExtensionDto();
        CubeBeanUtils.copyProperties((Object)extensionDto, (Object)saleOrderItemRespDto, (String[])new String[0]);
        CubeBeanUtils.copyProperties((Object)respDto, (Object)saleOrderItemRespDto, (String[])new String[0]);
        respDto.setPerformOrderItemExtensionDto(extensionDto);
        return respDto;
    }
}

