/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.impl.tc;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.EasVerifyStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.GiftEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.LockStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.LockTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OmsSaleOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.PlatFormOrderSelectTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderAssignStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderLevelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryResultReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderStatusLogRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemExtRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.enums.StringCodeResultEum;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.cache.CacheWrapper;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderItemDas;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyPlanDeliveryDateVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.event.AddSaleOrderEvent;
import com.yunxi.dg.base.center.trade.domain.order.impl.tc.AbstractSaleOrderDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPlatformSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.tc.TcBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.tc.TcPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderInfoOutNoticeSyncRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.PerformRelatedOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.tc.TcPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.center.trade.utils.TrackOptLogUtils;
import com.yunxi.dg.base.center.trade.vo.DgPerformOrderItemChangeVo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@ConditionalOnProperty(name={"perform.order.domain.tc.enable"}, havingValue="true")
public class DgTcPerformOrderExtDomainImpl
extends AbstractSaleOrderDomain
implements IDgPerformOrderExtDomain {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgTcPerformOrderExtDomainImpl.class);
    private static final List<String> orderTypeList = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType(), SaleOrderTypeEnum.ACTIVITY_ORDER.getType(), SaleOrderTypeEnum.NUTRITION_INTEGRAL.getType(), SaleOrderTypeEnum.CUSTOMER_REFUNDING_ORDER.getType(), SaleOrderTypeEnum.REPLENISH_ORDER.getType(), SaleOrderTypeEnum.OTHER_OUT_STOCK.getType(), SaleOrderTypeEnum.QUALITY_REFUNDING_ORDER.getType()});
    @Resource
    private IDgSaleOrderDomain saleOrderDomain;
    @Resource
    private IDgSaleOrderDas dgSaleOrderDas;
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private IDgPerformOrderItemExtDomain dgPerformOrderItemExtDomain;
    @Resource
    private IDgSaleOrderAddrDomain dgSaleOrderAddrDomain;
    @Resource
    private CacheWrapper cacheWrapper;
    @Resource
    private IDgOrderTagRecordDomain dgOrderTagRecordDomain;
    @Resource
    private IDgSaleOrderItemDas dgSaleOrderItemDas;
    @Autowired
    private ApplicationEventPublisher publisher;

    @Override
    protected ICommonDas<DgSaleOrderEo> baseDas() {
        return this.dgSaleOrderDas;
    }

    @Override
    protected CacheWrapper cacheWrapper() {
        return this.cacheWrapper;
    }

    @Override
    public String getLatestNo() {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#addReqDto.platformOrderNo", condition="#addReqDto.platformOrderNo!=null")
    public String addCisSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        List giftList;
        this.checkPlatformOrderRepeat(addReqDto);
        ArrayList allItemList = Lists.newArrayList();
        List itemList = addReqDto.getItemList();
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            allItemList.addAll(itemList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(giftList = addReqDto.getGiftList()))) {
            allItemList.addAll(giftList);
        }
        com.yunxi.dg.base.commons.utils.AssertUtils.notEmpty((Collection)allItemList, (String)"\u5546\u54c1\u6e05\u5355\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6dfb\u52a0\u5bf9\u5e94\u7684\u5546\u54c1\uff01");
        addReqDto.setAssignStatus(SaleOrderAssignStatusEnum.ASSIGN_STATUS_0.getCode());
        if (Objects.isNull(addReqDto.getOrderBizType())) {
            addReqDto.setOrderBizType(SaleOrderBizTypeEnum.COMMON.getType());
        }
        this.setEasVerifyStatusVal(addReqDto);
        if (Objects.equals(addReqDto.getOrderType(), SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType())) {
            addReqDto.setStringCodeResult(Integer.valueOf(StringCodeResultEum.READ_SUCCESS.getCode()));
        }
        DgSaleOrderEo saleOrderEo = this.saveSaleOrder(addReqDto);
        addReqDto.setId(saleOrderEo.getId());
        if (Objects.isNull(addReqDto.getSaleCreateTime())) {
            addReqDto.setSaleCreateTime(saleOrderEo.getCreateTime());
        }
        TrackOptLogUtils.addOrderTrackOptLog(saleOrderEo.getId(), "\u521b\u5efa\u8ba2\u5355" + saleOrderEo.getSaleOrderNo());
        this.reCheckPlatformOrderRepeat(addReqDto, saleOrderEo);
        if (saleOrderEo.getId() == null) {
            LOGGER.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
            throw new BizException(PcpTradeExceptionCode.SAVE_ORDER_EXCEPTION.getCode(), PcpTradeExceptionCode.SAVE_ORDER_EXCEPTION.getMsg());
        }
        DgPerformOrderAddrReqDto orderAddrReqDto = addReqDto.getOrderAddrReqDto();
        DgSaleOrderAddrEo performOrderAddrEo = new DgSaleOrderAddrEo();
        BeanUtil.copyProperties((Object)orderAddrReqDto, (Object)performOrderAddrEo, (String[])new String[0]);
        performOrderAddrEo.setOrderId(saleOrderEo.getId());
        this.dgSaleOrderAddrDomain.insert((BaseEo)performOrderAddrEo);
        this.saveOrderItems(addReqDto, saleOrderEo);
        return saleOrderEo.getSaleOrderNo();
    }

    @Override
    public void modifySaleOrder(DgBizPerformOrderReqDto dgBizPerformOrderReqDto) {
        DgSaleOrderEo sale;
        TcBizPerformOrderReqDto tcBizPerformOrderReqDto = (TcBizPerformOrderReqDto)dgBizPerformOrderReqDto;
        SaleOrderReqDto modifyReqDto = tcBizPerformOrderReqDto.getSaleOrderReqDto();
        LOGGER.info("modifySaleOrder\u9500\u552e\u5355\u7f16\u8f91\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto));
        DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)saleOrderEo);
        LOGGER.info(JSON.toJSONString((Object)saleOrderEo));
        TrackOptLogUtils.addOrderTrackOptLog(saleOrderEo.getId(), "\u66f4\u65b0\u5185\u5bb9:" + JSON.toJSONString((Object)saleOrderEo));
        if (ObjectUtil.isNotEmpty((Object)saleOrderEo.getId()) && ObjectUtil.isNotEmpty((Object)(sale = (DgSaleOrderEo)this.dgSaleOrderDas.selectByPrimaryKey(saleOrderEo.getId()))) && StringUtils.isNotBlank((CharSequence)sale.getExtension()) && StringUtils.isNotBlank((CharSequence)saleOrderEo.getExtension())) {
            LOGGER.info("\u5408\u5e76\u6269\u5c55\u4fe1\u606f");
            Map map = (Map)JSON.parseObject((String)sale.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            Map addMap = (Map)JSON.parseObject((String)saleOrderEo.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            map.putAll(addMap);
            saleOrderEo.setExtension(JSON.toJSONString((Object)map));
        }
        super.updateSaleOrderById(saleOrderEo.getId(), saleOrderEo);
    }

    private void saveOrderItems(DgBizPerformOrderReqDto addReqDto, DgSaleOrderEo saleOrderEo) {
        ArrayList allItemList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getItemList())) {
            addReqDto.getItemList().forEach(saleOrderItemReqDto -> {
                if (addReqDto.getManualCreate().booleanValue() || Objects.equals(addReqDto.getOrderSource(), SaleOrderSourceEnum.IMPORT.getType())) {
                    saleOrderItemReqDto.setId(NoGreateUtil.getId());
                }
                if (saleOrderItemReqDto.getGift() == null) {
                    saleOrderItemReqDto.setGift(Integer.valueOf(0));
                }
            });
            allItemList.addAll(addReqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            addReqDto.getGiftList().forEach(saleOrderItemReqDto -> {
                saleOrderItemReqDto.setGift(Integer.valueOf(1));
                if (addReqDto.getManualCreate().booleanValue() || Objects.equals(addReqDto.getOrderSource(), SaleOrderSourceEnum.IMPORT.getType())) {
                    saleOrderItemReqDto.setId(NoGreateUtil.getId());
                }
            });
            allItemList.addAll(addReqDto.getGiftList());
        }
        ArrayList performOrderItemRespDtos = Lists.newArrayList();
        boolean isClaimOrder = this.isClaimOrder(saleOrderEo.getOrderType());
        Optional.ofNullable(allItemList).ifPresent(saleOrderItemEos -> saleOrderItemEos.stream().forEach(itemEo -> {
            itemEo.setOrderId(saleOrderEo.getId());
            itemEo.setChannelWarehouseCode(saleOrderEo.getChannelWarehouseCode());
            if (isClaimOrder) {
                itemEo.setLogicalWarehouseId(saleOrderEo.getLogicalWarehouseId());
                itemEo.setLogicalWarehouseCode(saleOrderEo.getLogicalWarehouseCode());
                itemEo.setLogicalWarehouseName(saleOrderEo.getLogicalWarehouseName());
            }
            itemEo.setMainOrderId(saleOrderEo.getId());
            itemEo.setMainOrderItemId(itemEo.getId());
            itemEo.setTransactionPrice(itemEo.getPayAmount().divide(itemEo.getItemNum(), 2, RoundingMode.HALF_UP));
            DgPerformOrderItemRespDto dgPerformOrderItemRespDto = new DgPerformOrderItemRespDto();
            CubeBeanUtils.copyProperties((Object)dgPerformOrderItemRespDto, (Object)itemEo, (String[])new String[]{"performOrderItemExtensionDto", "extensionDto"});
            dgPerformOrderItemRespDto.setPerformOrderItemExtensionDto(itemEo.getPerformOrderItemExtensionDto());
            performOrderItemRespDtos.add(dgPerformOrderItemRespDto);
        }));
        DgPerformOrderItemChangeVo saleOrderItermChangeVo = new DgPerformOrderItemChangeVo();
        saleOrderItermChangeVo.setOriginOrderId(saleOrderEo.getId());
        saleOrderItermChangeVo.setSaleOrderId(saleOrderEo.getId());
        saleOrderItermChangeVo.setSaleOrderNo(saleOrderEo.getSaleOrderNo());
        saleOrderItermChangeVo.setPerformOrderItemRespDtos((List)performOrderItemRespDtos);
        this.dgPerformOrderItemExtDomain.insertBatchItemVo(saleOrderItermChangeVo);
    }

    private void checkPlatformOrderRepeat(DgBizPerformOrderReqDto addReqDto) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getPlatformOrderNo())) {
            LambdaQueryWrapper queryPlatformWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryPlatformWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getPlatformOrderNo, (Object)addReqDto.getPlatformOrderNo());
            List list = this.saleOrderDomain.getMapper().selectList((Wrapper)queryPlatformWrapper);
            List saleOrderEos = Optional.ofNullable(list).orElseGet(Collections::emptyList).stream().filter(saleOrderEo -> SaleOrderLevelEnum.ORIGINAL.getType().equals(saleOrderEo.getOrderLevel()) || SaleOrderLevelEnum.MAIN.getType().equals(saleOrderEo.getOrderLevel())).filter(saleOrderEo -> !SaleOrderStatusEnum.OBSOLETE.getCode().equals(saleOrderEo.getOrderStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(saleOrderEos)) {
                LOGGER.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8be5\u5e73\u53f0\u8ba2\u5355\uff08{}\uff09\u5df2\u751f\u6210\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\uff08{}\uff09\uff0c\u4e0d\u53ef\u591a\u6b21\u751f\u6210\u9500\u552e\u5355", (Object)addReqDto.getPlatformOrderNo(), (Object)((DgSaleOrderEo)saleOrderEos.get(0)).getSaleOrderNo());
                throw new BizException(PcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.getCode(), ((DgSaleOrderEo)saleOrderEos.get(0)).getSaleOrderNo());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getOrderType()) && Objects.equals(addReqDto.getOrderType(), SaleOrderTypeEnum.MAIYOU_ALLOT.getType()) && StringUtils.isNotBlank((CharSequence)addReqDto.getAllotType())) {
            if (Objects.equals(addReqDto.getAllotType(), AllotTypeEnum.MAIYOU_BC_SAME_ORG_ALLOT.getType())) {
                com.yunxi.dg.base.commons.utils.AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)addReqDto.getAllotInWarehouseCode()), (String)"bc\u540c\u7ec4\u7ec7\u8c03\u62e8\u573a\u666f\u53c2\u6570\u7f3a\u5931\uff0c\u5fc5\u987b\u5e26\u5165\u8c03\u5165\u4ed3\u53c2\u6570");
                com.yunxi.dg.base.commons.utils.AssertUtils.isTrue((Objects.equals(addReqDto.getIfSourceWarehouseSpilt(), 0) && StringUtils.isNotBlank((CharSequence)addReqDto.getMyArrangeLogicalWarehouseCode()) || Objects.equals(addReqDto.getIfSourceWarehouseSpilt(), 1) ? 1 : 0) != 0, (String)"bc\u540c\u7ec4\u7ec7\u8c03\u62e8\u573a\u666f\u53c2\u6570\u7f3a\u5931\uff0c\u975e\u5bfb\u6e90\u60c5\u51b5\u9700\u4f20\u6307\u5b9a\u903b\u8f91\u4ed3");
            } else if (Objects.equals(addReqDto.getAllotType(), AllotTypeEnum.MAIYOU_CB_SAME_ORG_ALLOT.getType())) {
                com.yunxi.dg.base.commons.utils.AssertUtils.isTrue((boolean)addReqDto.getItemList().stream().anyMatch(it -> StringUtils.isNotBlank((CharSequence)it.getBatchNo())), (String)"cb\u540c\u7ec4\u7ec7\u8c03\u62e8\u573a\u666f\u53c2\u6570\u7f3a\u5931\uff0c\u5546\u54c1\u5fc5\u987b\u5e26\u6279\u6b21");
                com.yunxi.dg.base.commons.utils.AssertUtils.isTrue((StringUtils.isNotBlank((CharSequence)addReqDto.getAllotInWarehouseCode()) && StringUtils.isNotBlank((CharSequence)addReqDto.getAllotOutWarehouseCode()) ? 1 : 0) != 0, (String)"cb\u540c\u7ec4\u7ec7\u8c03\u62e8\u573a\u666f\u53c2\u6570\u7f3a\u5931\uff0c\u5fc5\u987b\u5e26\u5165\u8c03\u51fa/\u5165\u4ed3\u53c2\u6570");
            }
        }
    }

    private void setEasVerifyStatusVal(DgBizPerformOrderReqDto addReqDto) {
        if (orderTypeList.contains(addReqDto.getOrderType())) {
            addReqDto.setEasVerifyStatus(EasVerifyStatusEnum.NOT_VERIFY.getType());
        } else if (SaleOrderTypeEnum.BAIJIAN_DIRECT_SALES.getType().equals(addReqDto.getOrderType())) {
            addReqDto.setEasVerifyStatus(EasVerifyStatusEnum.YES.getType());
        } else if (Objects.equals(addReqDto.getOrderBizType(), SaleOrderBizTypeEnum.FINANCIAL_FRONT.getType())) {
            if (Objects.equals(addReqDto.getIfButtThirdParty(), YesOrNoEnum.NO.getType())) {
                addReqDto.setEasVerifyStatus(EasVerifyStatusEnum.NOT_VERIFY.getType());
            }
            if (Objects.isNull(addReqDto.getEasVerifyStatus())) {
                addReqDto.setEasVerifyStatus(EasVerifyStatusEnum.NO.getType());
            }
        } else {
            addReqDto.setEasVerifyStatus(EasVerifyStatusEnum.NOT_VERIFY.getType());
        }
        if (Objects.equals(addReqDto.getEasVerifyStatus(), EasVerifyStatusEnum.YES.getType())) {
            addReqDto.setEasVerifyTime(DateUtil.getSysDate());
            if (Objects.equals(addReqDto.getOrderType(), SaleOrderTypeEnum.BAIJIAN_DIRECT_SALES.getType()) && Objects.nonNull(addReqDto.getPlatformOrderId())) {
                addReqDto.setEasVerifyTime(addReqDto.getPlatformCreateTime());
            }
        }
    }

    private DgSaleOrderEo saveSaleOrder(DgBizPerformOrderReqDto addReqDto) {
        DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
        BeanUtil.copyProperties((Object)addReqDto, (Object)saleOrderEo, (String[])new String[0]);
        BeanUtil.copyProperties((Object)addReqDto.getPerformOrderSnapshotDto(), (Object)saleOrderEo, (String[])new String[0]);
        BeanUtil.copyProperties((Object)addReqDto.getPerformOrderExtensionDto(), (Object)saleOrderEo, (String[])new String[0]);
        if (StringUtils.isEmpty((CharSequence)saleOrderEo.getSaleOrderNo())) {
            saleOrderEo.setSaleOrderNo(this.noGreateUtil.generateOrderNo());
            addReqDto.setSaleOrderNo(saleOrderEo.getSaleOrderNo());
        }
        saleOrderEo.setSaleCreateTime(new Date());
        if (addReqDto.getManualCreate().booleanValue() || Objects.equals(addReqDto.getOrderSource(), SaleOrderSourceEnum.IMPORT.getType())) {
            LOGGER.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u624b\u52a8\u521b\u5efa\u9500\u552e\u8ba2\u5355\uff0c\u9700\u8981\u8ba1\u7b97\u5546\u54c1\u7684\u603b\u4ef7\u683c\u548c\u5e94\u4ed8\u91d1\u989d");
            this.calItemTotalAmount(addReqDto, saleOrderEo);
            if (Objects.isNull(saleOrderEo.getBizDate())) {
                saleOrderEo.setBizDate(saleOrderEo.getSaleCreateTime());
                addReqDto.setBizDate(saleOrderEo.getBizDate());
            }
            if (this.isClaimOrder(addReqDto.getOrderType()) && StringUtils.isEmpty((CharSequence)addReqDto.getPlatformOrderNo())) {
                saleOrderEo.setPlatformOrderNo(this.noGreateUtil.generateCkspPlatformNo());
                addReqDto.setPlatformOrderNo(saleOrderEo.getPlatformOrderNo());
            }
        }
        if (Objects.nonNull(saleOrderEo.getPlatformCreateTime())) {
            saleOrderEo.setBizDate(saleOrderEo.getPlatformCreateTime());
            addReqDto.setBizDate(saleOrderEo.getBizDate());
        }
        this.saleOrderDomain.insert((BaseEo)saleOrderEo);
        return saleOrderEo;
    }

    private void reCheckPlatformOrderRepeat(DgBizPerformOrderReqDto addReqDto, DgSaleOrderEo saleOrderEo) {
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getPlatformOrderNo())) {
            LambdaQueryWrapper queryPlatformWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryPlatformWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getPlatformOrderNo, (Object)addReqDto.getPlatformOrderNo());
            List list = this.saleOrderDomain.getMapper().selectList((Wrapper)queryPlatformWrapper);
            List saleOrderEos = Optional.ofNullable(list).orElseGet(Collections::emptyList).stream().filter(orderEo -> SaleOrderLevelEnum.ORIGINAL.getType().equals(orderEo.getOrderLevel()) || SaleOrderLevelEnum.MAIN.getType().equals(orderEo.getOrderLevel())).filter(orderEo -> !SaleOrderStatusEnum.OBSOLETE.getCode().equals(orderEo.getOrderStatus())).collect(Collectors.toList());
            if (saleOrderEos.size() > 1) {
                LOGGER.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8be5\u5e73\u53f0\u8ba2\u5355\uff08{}\uff09\u5df2\u751f\u6210\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\uff08{}\uff09\uff0c\u4e0d\u53ef\u591a\u6b21\u751f\u6210\u9500\u552e\u5355", (Object)addReqDto.getPlatformOrderNo(), (Object)((DgSaleOrderEo)saleOrderEos.get(0)).getSaleOrderNo());
                throw new BizException(PcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.getCode(), ((DgSaleOrderEo)saleOrderEos.get(0)).getSaleOrderNo());
            }
            DgSaleOrderEo insertedOrderEo = (DgSaleOrderEo)saleOrderEos.get(0);
            String hadSaleOrderNo = insertedOrderEo.getSaleOrderNo();
            if (!hadSaleOrderNo.equals(saleOrderEo.getSaleOrderNo())) {
                LOGGER.error("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5f53\u524d\u6570\u636e\u5e93\u65b0\u589e\u7684\u9500\u552e\u8ba2\u5355\u975e\u672c\u7ebf\u7a0b\u521b\u5efa\u751f\u6210\uff0c\u5f53\u524d\u7ebf\u7a0b\u751f\u6210\u7684\u8ba2\u5355\u53f7\u4e3a\uff1a{}\uff0c\u6570\u636e\u5e93\u5df2\u5b58\u5728\u7684\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)saleOrderEo.getSaleOrderNo(), (Object)hadSaleOrderNo);
                throw new BizException(PcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.getCode(), ((DgSaleOrderEo)list.get(0)).getSaleOrderNo());
            }
        }
    }

    public boolean isClaimOrder(String orderType) {
        return SaleOrderTypeEnum.CLAIM_POSTING.getType().equals(orderType) || SaleOrderTypeEnum.CLAIM_REISSUE.getType().equals(orderType);
    }

    private void calItemTotalAmount(DgBizPerformOrderReqDto addReqDto, DgSaleOrderEo saleOrderEo) {
        List itemList = addReqDto.getItemList();
        ArrayList totalGoods = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getItemList())) {
            addReqDto.getItemList().stream().forEach(dto -> {
                if (Objects.isNull(dto.getSalePrice())) {
                    dto.setSalePrice(dto.getPrice());
                }
            });
            totalGoods.addAll(addReqDto.getItemList());
            this.totalItemsAmount(addReqDto, addReqDto.getItemList(), GiftEnum.NOT_GIFT.getType());
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            addReqDto.getGiftList().stream().forEach(dto -> {
                if (Objects.isNull(dto.getSalePrice())) {
                    dto.setSalePrice(dto.getPrice());
                }
            });
            totalGoods.addAll(addReqDto.getGiftList());
            this.totalItemsAmount(addReqDto, addReqDto.getGiftList(), GiftEnum.GIFT.getType());
        }
        com.yunxi.dg.base.commons.utils.AssertUtils.notEmpty((Collection)totalGoods, (String)"itemList\u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal goodsTotalNum = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal goodsTotalAmount = BigDecimal.ZERO;
        BigDecimal orderTotalAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        if (this.isClaimOrder(saleOrderEo.getOrderType())) {
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                goodsTotalAmount = this.calItemsClaimPrice(itemList);
            }
            orderTotalAmount = goodsTotalAmount;
        } else {
            goodsTotalAmount = this.calItemsAmount(totalGoods);
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                orderTotalAmount = this.calItemsAmount(itemList);
            }
        }
        for (DgPerformOrderItemReqDto orderItem : totalGoods) {
            goodsTotalNum = goodsTotalNum.add(orderItem.getItemNum());
            discountAmount = discountAmount.add(Optional.ofNullable(orderItem.getDiscountAmount()).orElse(BigDecimal.ZERO));
            payAmount = payAmount.add(orderItem.getPayAmount());
        }
        LOGGER.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5546\u54c1\u603b\u6570\u91cf\uff1a{}\uff0c\u5546\u54c1\u603b\u91d1\u989d\uff1a{}\uff0c\u5e94\u4ed8\u91d1\u989d\uff1a{},\u4f18\u60e0\u603b\u989d\uff1a{},\u5b9e\u4ed8\u91d1\u989d\uff1a{}", new Object[]{goodsTotalNum, goodsTotalAmount, orderTotalAmount, discountAmount, payAmount});
        saleOrderEo.setGoodsTotalNum(goodsTotalNum);
        saleOrderEo.setDiscountAmount(discountAmount);
        saleOrderEo.setGoodsTotalAmount(goodsTotalAmount);
        saleOrderEo.setOrderTotalAmount(orderTotalAmount);
        saleOrderEo.setPayAmount(payAmount);
    }

    private BigDecimal calItemsClaimPrice(List<DgPerformOrderItemReqDto> itemList) {
        BigDecimal totalClaimPrice = BigDecimal.ZERO;
        for (DgPerformOrderItemReqDto orderItem : itemList) {
            com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderItem.getClaimPrice(), (String)String.format("itemId\u4e3a%s\u8ba2\u5355\u5546\u54c1\u7d22\u8d54\u4ef7\u683c\u4e3a\u7a7a\uff01", orderItem.getItemId()));
            com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderItem.getItemNum(), (String)String.format("itemId\u4e3a%s\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a\uff01", orderItem.getItemId()));
            totalClaimPrice = totalClaimPrice.add(orderItem.getClaimPrice().multiply(orderItem.getItemNum()));
        }
        return totalClaimPrice;
    }

    private BigDecimal calItemsAmount(List<DgPerformOrderItemReqDto> itemList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DgPerformOrderItemReqDto orderItem : itemList) {
            com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderItem.getPrice(), (String)String.format("itemId\u4e3a%s\u8ba2\u5355\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a\uff01", orderItem.getItemId()));
            com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderItem.getItemNum(), (String)String.format("itemId\u4e3a%s\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a\uff01", orderItem.getItemId()));
            totalAmount = totalAmount.add(orderItem.getPrice().multiply(orderItem.getItemNum()));
        }
        return totalAmount;
    }

    private void totalItemsAmount(DgBizPerformOrderReqDto addReqDto, List<DgPerformOrderItemReqDto> itemList, Integer giftFalg) {
        boolean isClaimOrder = this.isClaimOrder(addReqDto.getOrderType());
        for (DgPerformOrderItemReqDto orderItem : itemList) {
            BigDecimal totalAmount;
            if (isClaimOrder) {
                com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderItem.getClaimPrice(), (String)String.format("itemId\u4e3a%s\u7d22\u8d54\u8ba2\u5355\u5546\u54c1\u7d22\u8d54\u4ef7\u683c\u4e3a\u7a7a\uff01", orderItem.getItemId()));
                com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderItem.getItemNum(), (String)String.format("itemId\u4e3a%s\u7d22\u8d54\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a\uff01", orderItem.getItemId()));
                totalAmount = orderItem.getClaimPrice().multiply(orderItem.getItemNum());
                orderItem.setOrderTotalAmount(totalAmount);
                orderItem.setLineAmount(totalAmount);
                orderItem.setPayAmount(totalAmount);
                if (!Objects.equals(giftFalg, GiftEnum.GIFT.getType())) continue;
                orderItem.setPayAmount(BigDecimal.ZERO);
                continue;
            }
            com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderItem.getPrice(), (String)String.format("itemId\u4e3a%s\u8ba2\u5355\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a\uff01", orderItem.getItemId()));
            com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderItem.getItemNum(), (String)String.format("itemId\u4e3a%s\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a\uff01", orderItem.getItemId()));
            totalAmount = orderItem.getPrice().multiply(orderItem.getItemNum());
            orderItem.setOrderTotalAmount(totalAmount);
            orderItem.setLineAmount(totalAmount);
            orderItem.setPayAmount(totalAmount.subtract(Optional.ofNullable(orderItem.getDiscountAmount()).orElse(BigDecimal.ZERO)));
            if (!Objects.equals(giftFalg, GiftEnum.GIFT.getType())) continue;
            orderItem.setPayAmount(BigDecimal.ZERO);
        }
    }

    @Override
    public DgPerformOrderInfoEo insert(DgPerformOrderReqDto addReqDto) {
        return null;
    }

    @Override
    public int insert(DgSaleOrderEo orderEo) {
        return this.dgSaleOrderDas.insert((BaseEo)orderEo);
    }

    @Override
    public void update(DgPerformOrderReqDto updateReqDto) {
    }

    @Override
    public void logicDeleteById(Long id) {
        this.dgSaleOrderDas.logicDeleteById(id);
    }

    @Override
    public DgPerformOrderRespDto queryByDto(DgPerformOrderReqDto queryDto) {
        return null;
    }

    @Override
    public List<DgPerformOrderRespDto> queryListByDto(DgPerformOrderReqDto queryDto) {
        return null;
    }

    @Override
    public PageInfo<DgPerformOrderRespDto> queryByPage(DgPerformOrderReqDto reqDto, Integer pageNum, Integer pageSize) {
        TcPerformOrderReqDto tcPerformOrderReqDto = (TcPerformOrderReqDto)reqDto;
        DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)tcPerformOrderReqDto.getSaleOrderReqDto(), (BaseEo)saleOrderEo);
        PageInfo eoPageInfo = this.dgSaleOrderDas.selectPage((BaseEo)saleOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        BeanUtil.copyProperties((Object)eoPageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List dtoList = Optional.ofNullable(eoPageInfo.getList()).orElse(Lists.newArrayList()).stream().map(e -> {
            BizSaleOrderRespDto saleOrderRespDto = new BizSaleOrderRespDto();
            BeanUtil.copyProperties((Object)e, (Object)saleOrderRespDto, (String[])new String[0]);
            TcPerformOrderRespDto dgPerformOrderRespDto = new TcPerformOrderRespDto();
            dgPerformOrderRespDto.setBizSaleOrderRespDto(saleOrderRespDto);
            return dgPerformOrderRespDto;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public DgPerformOrderRespDto queryDtoById(Long id) {
        DgSaleOrderEo dgDgSaleOrderEo = (DgSaleOrderEo)this.dgSaleOrderDas.selectByPrimaryKey(id);
        DgPerformOrderRespDto dgPerformOrderRespDto = new DgPerformOrderRespDto();
        BeanUtil.copyProperties((Object)dgDgSaleOrderEo, (Object)dgPerformOrderRespDto, (String[])new String[0]);
        return dgPerformOrderRespDto;
    }

    @Override
    public DgPerformOrderRespDto queryDtoByOrderNo(String orderNo) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderNo, (String)"\u8ba2\u5355orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TcPerformOrderRespDto tcPerformOrderRespDto = null;
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoByNo(orderNo);
        if (saleOrderEo != null) {
            BizSaleOrderRespDto saleOrderRespDto = new BizSaleOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)saleOrderEo, (BaseVo)saleOrderRespDto);
            tcPerformOrderRespDto = new TcPerformOrderRespDto();
            tcPerformOrderRespDto.setBizSaleOrderRespDto(saleOrderRespDto);
        }
        return tcPerformOrderRespDto;
    }

    @Override
    public DgPerformOrderRespDto queryByOrderId(Long orderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo dgSaleOrderEo = super.queryDgSaleOrderEoById(orderId);
        TcPerformOrderRespDto tcPerformOrderRespDto = null;
        if (dgSaleOrderEo != null) {
            BizSaleOrderRespDto saleOrderRespDto = new BizSaleOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)dgSaleOrderEo, (BaseVo)saleOrderRespDto);
            tcPerformOrderRespDto = new TcPerformOrderRespDto();
            tcPerformOrderRespDto.setBizSaleOrderRespDto(saleOrderRespDto);
        }
        return tcPerformOrderRespDto;
    }

    @Override
    public List<PerformRelatedOrderRespDto> queryRelatedOrder(DgPerformOrderReqDto saleOrderRespDto) {
        List respDtoList = null;
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getMainOrderNo())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)"0")).eq(DgSaleOrderEo::getMainOrderNo, (Object)saleOrderRespDto.getSaleOrderNo());
            List relatedOrderList = this.dgSaleOrderDas.getMapper().selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)relatedOrderList)) {
                LOGGER.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5f53\u524d\u8ba2\u5355\u4e3a\u4e3b\u8ba2\u5355\uff08{}\uff09\uff0c\u5b50\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)relatedOrderList));
                respDtoList = relatedOrderList.stream().map(item -> {
                    PerformRelatedOrderRespDto relatedOrderRespDto = new PerformRelatedOrderRespDto();
                    relatedOrderRespDto.setId(item.getId());
                    relatedOrderRespDto.setSaleOrderNo(item.getSaleOrderNo());
                    relatedOrderRespDto.setMainOrderNo(item.getMainOrderNo());
                    relatedOrderRespDto.setOrderStatus(item.getOrderStatus());
                    relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                    relatedOrderRespDto.setOrignalOrderNo(item.getOriginalOrderNo());
                    relatedOrderRespDto.setLockStatus(item.getLockStatus());
                    relatedOrderRespDto.setLockType(item.getLockType());
                    return relatedOrderRespDto;
                }).collect(Collectors.toList());
                PerformRelatedOrderRespDto mainOrderRespDto = new PerformRelatedOrderRespDto();
                mainOrderRespDto.setId(saleOrderRespDto.getId());
                mainOrderRespDto.setSaleOrderNo(saleOrderRespDto.getSaleOrderNo());
                mainOrderRespDto.setMainOrderNo(saleOrderRespDto.getMainOrderNo());
                mainOrderRespDto.setOrderStatus(saleOrderRespDto.getOrderStatus());
                mainOrderRespDto.setMainOrder(Boolean.TRUE);
                mainOrderRespDto.setLockStatus(saleOrderRespDto.getLockStatus());
                mainOrderRespDto.setLockType(saleOrderRespDto.getLockType());
                respDtoList.add(mainOrderRespDto);
            }
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)"0")).eq(DgSaleOrderEo::getMainOrderNo, (Object)saleOrderRespDto.getMainOrderNo());
            List relatedOrderList = this.dgSaleOrderDas.getMapper().selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)relatedOrderList)) {
                LOGGER.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5f53\u524d\u8ba2\u5355\u4e3a\u5b50\u8ba2\u5355\uff08{}\uff09\uff0c\u76f8\u5173\u8054\u7684\u5144\u5f1f\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)relatedOrderList));
                respDtoList = relatedOrderList.stream().map(item -> {
                    PerformRelatedOrderRespDto relatedOrderRespDto = new PerformRelatedOrderRespDto();
                    relatedOrderRespDto.setId(item.getId());
                    relatedOrderRespDto.setSaleOrderNo(item.getSaleOrderNo());
                    relatedOrderRespDto.setMainOrderNo(item.getMainOrderNo());
                    relatedOrderRespDto.setOrderStatus(item.getOrderStatus());
                    relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                    relatedOrderRespDto.setOrignalOrderNo(item.getOriginalOrderNo());
                    relatedOrderRespDto.setLockStatus(item.getLockStatus());
                    relatedOrderRespDto.setLockType(item.getLockType());
                    return relatedOrderRespDto;
                }).collect(Collectors.toList());
                LambdaQueryWrapper queryMainWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryMainWrapper.eq(BaseEo::getDr, (Object)"0")).eq(DgSaleOrderEo::getSaleOrderNo, (Object)saleOrderRespDto.getMainOrderNo());
                List orderEoList = this.dgSaleOrderDas.getMapper().selectList((Wrapper)queryMainWrapper);
                AssertUtils.notEmpty(orderEoList, String.format("\u6570\u636e\u5f02\u5e38\uff0c\u4e3b\u8ba2\u5355(%s)\u4e0d\u5b58\u5728", saleOrderRespDto.getMainOrderNo()));
                DgSaleOrderEo mainDgSaleOrderEo = (DgSaleOrderEo)orderEoList.get(0);
                PerformRelatedOrderRespDto mainOrderRespDto = new PerformRelatedOrderRespDto();
                mainOrderRespDto.setId(mainDgSaleOrderEo.getId());
                mainOrderRespDto.setSaleOrderNo(mainDgSaleOrderEo.getSaleOrderNo());
                mainOrderRespDto.setMainOrderNo(mainDgSaleOrderEo.getMainOrderNo());
                mainOrderRespDto.setOrderStatus(mainDgSaleOrderEo.getOrderStatus());
                mainOrderRespDto.setMainOrder(Boolean.TRUE);
                mainOrderRespDto.setLockStatus(mainDgSaleOrderEo.getLockStatus());
                mainOrderRespDto.setLockType(mainDgSaleOrderEo.getLockType());
                respDtoList.add(mainOrderRespDto);
            }
        }
        LOGGER.info("[\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5]\u5173\u8054\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(respDtoList));
        return respDtoList;
    }

    @Override
    public List<DgPerformOrderRespDto> queryDtoListByOrderNo(List<String> orderNos) {
        return null;
    }

    @Override
    public DgPerformOrderInfoDto queryBaseInfoById(Long id) {
        return null;
    }

    @Override
    public DgPerformOrderInfoDto queryBaseInfoByOrderNo(String orderNo) {
        return null;
    }

    @Override
    public List<DgPerformOrderRespDto> querylistByPlatFormOrderNo(DgPlatformSaleOrderReqDto platformDto) {
        return null;
    }

    @Override
    public List<DgPerformOrderRespDto> queryNeedConfirmGoodsOrderList(Long lastOrderId, Integer pageSize) {
        return null;
    }

    @Override
    public List<DgPerformOrderItemRespDto> bundleItemDivide(DgPerformOrderItemReqDto modifyOrderItemReqDto, DgPerformOrderItemEo oriOrderItemEo, Consumer<DgPerformOrderItemDto> subItemExtendsFunc) {
        return null;
    }

    @Override
    public DgPerformOrderInfoEo createChildOrder(DgPerformOrderReqDto childOrderReqDto) {
        return null;
    }

    @Override
    public void sendMsgSaleOrderCreated(DgPerformOrderRespDto respDto) {
    }

    @Override
    public DgBizPerformOrderRespDto queryBizDtoByOrderNo(String orderNo) {
        return null;
    }

    @Override
    public List<DgPerformOrderRespDto> queryListByOrderIds(List<Long> orderIds) {
        com.yunxi.dg.base.commons.utils.AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(orderIds), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List dgSaleOrderEos = ((ExtQueryChainWrapper)this.dgSaleOrderDas.filter().in((Object)"id", orderIds)).list();
        List<DgPerformOrderRespDto> tcPerformOrderRespDtos = dgSaleOrderEos.stream().map(e -> {
            BizSaleOrderRespDto saleOrderRespDto = new BizSaleOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)e, (BaseVo)saleOrderRespDto);
            TcPerformOrderRespDto tcPerformOrderRespDto = new TcPerformOrderRespDto();
            tcPerformOrderRespDto.setBizSaleOrderRespDto(saleOrderRespDto);
            return tcPerformOrderRespDto;
        }).collect(Collectors.toList());
        return tcPerformOrderRespDtos;
    }

    @Override
    public void modifyChildOrderBySplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
    }

    @Override
    public void resetOrderBizForSplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
    }

    @Override
    public List<DgPerformOrderRespDto> queryChildByOriOrderNo(String originalOrderNo) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notBlank((String)originalOrderNo, (String)"originalOrderNo\u7236\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryChildOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryChildOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getOriginalOrderNo, (Object)originalOrderNo);
        List saleOrderEos = this.dgSaleOrderDas.getMapper().selectList((Wrapper)queryChildOrderWrapper);
        List<DgPerformOrderRespDto> list = saleOrderEos.stream().map(e -> {
            BizSaleOrderRespDto bizSaleOrderRespDto = new BizSaleOrderRespDto();
            BeanUtil.copyProperties((Object)e, (Object)bizSaleOrderRespDto, (String[])new String[0]);
            TcPerformOrderRespDto tcPerformOrderRespDto = new TcPerformOrderRespDto();
            tcPerformOrderRespDto.setBizSaleOrderRespDto(bizSaleOrderRespDto);
            return tcPerformOrderRespDto;
        }).collect(Collectors.toList());
        return list;
    }

    @Override
    public void saveOrderByDeliveredResult(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto reqDto) {
    }

    @Override
    public void modifyOrderByDeliveredResult(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto reqDto) {
    }

    @Override
    public DgPerformOrderInfoOutNoticeSyncRecordRespDto saveOutNoticeRecord(DgPerformOrderRespDto saleOrderRespDto, DgOutDeliveryResultReqDto reqDto) {
        return null;
    }

    @Override
    public void sendMsgForDeliveryResult(DgPerformOrderRespDto saleOrderRespDto, DgOmsSaleOrderStatus saleOrderStatus, DgOutDeliveryResultReqDto request) {
    }

    @Override
    public void modifyPlanDeliveryDate(ModifyPlanDeliveryDateVo modifyPlanDeliveryDateVo) {
    }

    @Override
    public void removePlanShipmentEnterpriseInfo(Long orderId) {
    }

    @Override
    public void cleanSourceData(Long orderId) {
    }

    @Override
    public void removeShipmentEnterprise(Long saleOrderId) {
    }

    @Override
    public void removeLabel(Long saleOrderId, String oriLabel, String ... optLabels) {
    }

    @Override
    public void removeAllLabel(Long saleOrderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setId(saleOrderId);
        updateEo.setOptLabel(" ");
        this.saleOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public int optimisticModifySaleOrder(DgSaleOrderEo saleOrderEo, UpdateWrapper<DgSaleOrderEo> queryWrapper, int idealCount, boolean needThrow) {
        LOGGER.info("optimisticModifySaleOrder\u5165\u53c2saleOrderEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleOrderEo), JSON.toJSONString(queryWrapper), idealCount, needThrow});
        if (queryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (((DgSaleOrderEo)queryWrapper.getEntity()).getId() == null) {
            throw new BizException("-1", "\u66f4\u65b0id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        TrackOptLogUtils.addOrderTrackOptLog(((DgSaleOrderEo)queryWrapper.getEntity()).getId(), "\u66f4\u65b0\u5185\u5bb9:" + JSON.toJSONString((Object)saleOrderEo));
        this.dgSaleOrderDas.setUpdateSystemFields((BaseEo)saleOrderEo);
        this.popOrderStatusLog(saleOrderEo, queryWrapper);
        int optCount = this.dgSaleOrderDas.getMapper().update((Object)saleOrderEo, queryWrapper);
        if (this.dgSaleOrderDas.isUseCache()) {
            DgSaleOrderEo entity = (DgSaleOrderEo)queryWrapper.getEntity();
            this.dgSaleOrderDas.removeLogicCache((BaseEo)entity);
            this.dgSaleOrderDas.removeCache((Object)entity.getId());
            this.dgSaleOrderDas.removeCacheByExample((BaseEo)entity);
        }
        this.removeCache(((DgSaleOrderEo)queryWrapper.getEntity()).getId());
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        return optCount;
    }

    @Override
    public DgPerformOrderRespDto querySaleOrderById(Long id) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)id, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.dgSaleOrderDas.selectByPrimaryKey(id);
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderEo, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
        DgPerformOrderRespDto saleOrderRespDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)saleOrderEo, (String[])new String[0]);
        return saleOrderRespDto;
    }

    @Override
    public void changeDeliveredForOrder(DgPerformOrderReqDto dgPerformOrderReqDto) {
        TcPerformOrderReqDto tcPerformOrderReqDto = (TcPerformOrderReqDto)dgPerformOrderReqDto;
        OutDeliveryResultReqDto reqDto = tcPerformOrderReqDto.getOutDeliveryResultReqDto();
        LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u4fee\u6539\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (reqDto.getTotalQuantity() != null) {
            DgSaleOrderEo updateStatusEo = new DgSaleOrderEo();
            updateStatusEo.setSecondOrderStatus(tcPerformOrderReqDto.getSecondOrderStatus());
            updateStatusEo.setDeliveryCompleteDate(tcPerformOrderReqDto.getDeliveryCompleteDate());
            updateStatusEo.setInterceptInfo("");
            DgSaleOrderEo queryEo = new DgSaleOrderEo();
            queryEo.setId(tcPerformOrderReqDto.getId());
            UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
            updateWrapper.in((Object)"order_status", new Object[]{SaleOrderStatusEnum.WAIT_DELIVERY});
            this.optimisticModifySaleOrder(updateStatusEo, (UpdateWrapper<DgSaleOrderEo>)Wrappers.update((Object)queryEo), 1, true);
            this.dgPerformOrderItemExtDomain.modifyOrderItemOutDeliveredResult((DgPerformOrderReqDto)tcPerformOrderReqDto);
        }
    }

    @Override
    public void removeLogicalWarehouseInfo(String saleOrderNo) {
        LOGGER.info("[\u6e05\u7a7a\u9500\u552e\u8ba2\u5355\u53d1\u8d27\u4ed3]\u8ba2\u5355{}\u6e05\u7a7a\u53d1\u8d27\u4ed3\u4fe1\u606f", (Object)saleOrderNo);
        DgSaleOrderEo saleOrderEo = this.queryDgSaleOrderEoByNo(saleOrderNo);
        AssertUtils.notNull(saleOrderEo, "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        this.cleanLogicalWarehouseInfo(saleOrderEo.getId());
    }

    @Override
    public List<DgSaleOrderEo> queryByPlatformOrderId(Long platformOrderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)platformOrderId, (String)"platformOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(DgSaleOrderEo::getPlatformOrderId, new Object[]{platformOrderId});
        List saleOrderEos = this.dgSaleOrderDas.getMapper().selectList((Wrapper)queryWrapper);
        return saleOrderEos;
    }

    @Override
    public List<DgSaleOrderEo> queryByPlatFormOrderNo(String platFormOrderNo, String platFormOrderSelectTypeCode) {
        AssertUtils.notBlank(platFormOrderNo, "\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank(platFormOrderSelectTypeCode, "\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        PlatFormOrderSelectTypeEnum platFormOrderSelectTypeEnum = PlatFormOrderSelectTypeEnum.forCode((String)platFormOrderSelectTypeCode);
        LambdaQueryWrapper queryChildOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryChildOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getPlatformOrderNo, (Object)platFormOrderNo);
        switch (platFormOrderSelectTypeEnum) {
            case NOW_USE: {
                queryChildOrderWrapper.ne(DgSaleOrderEo::getOrderStatus, (Object)OmsSaleOrderStatus.SPLIT.getCode());
                break;
            }
            case ORIGIN: {
                queryChildOrderWrapper.isNull(DgSaleOrderEo::getSplitLevel);
                queryChildOrderWrapper.isNull(DgSaleOrderEo::getMainOrderNo);
                break;
            }
            case ALL: {
                break;
            }
            default: {
                throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u9519\u8befplatFormOrderSelectTypeCode"});
            }
        }
        List saleOrderEos = this.dgSaleOrderDas.getMapper().selectList((Wrapper)queryChildOrderWrapper);
        return saleOrderEos;
    }

    @Override
    public void updateEasVerifyStatus(String saleOrderNo) {
        LOGGER.info("updateEasVerifyStatus==>{}", (Object)saleOrderNo);
        AssertUtils.notEmpty(saleOrderNo, "saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getSaleOrderNo, (Object)saleOrderNo);
        List saleOrderEos = this.dgSaleOrderDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            throw PcpTradeExceptionCode.MUTIL_SALE_ORDER_NOT_EXCEPTION.buildBizException(new Object[]{saleOrderNo});
        }
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)saleOrderEos.get(0);
        if (Objects.equals(saleOrderEo.getEasVerifyStatus(), EasVerifyStatusEnum.YES.getType()) && Objects.equals(saleOrderEo.getLockStatus(), LockStatusEnum.UNLOCK.getType())) {
            LOGGER.info("\u66f4\u65b0eas\u9a8c\u8bc1\u72b6\u6001{}\u4e3a\u5df2\u9a8c\u8bc1\u4e14\u672a\u6302\u8d77\uff0c\u4e0d\u5904\u7406", (Object)saleOrderEo.getSaleOrderNo());
            return;
        }
        this.updateEasVerify(saleOrderEo);
        LOGGER.info("\u66f4\u65b0eas\u9a8c\u8bc1\u72b6\u6001{}", (Object)saleOrderEo.getSaleOrderNo());
        String context = "\u66f4\u65b0\u5185\u5bb9:\u66f4\u65b0eas\u9a8c\u8bc1\u72b6\u6001";
        ArrayList sendMqDgSaleOrderEoList = Lists.newArrayList((Object[])new DgSaleOrderEo[]{saleOrderEo});
        LambdaQueryWrapper chileOrderQuery = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)chileOrderQuery.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getMainOrderNo, (Object)saleOrderNo);
        List chlieOrders = this.dgSaleOrderDas.getMapper().selectList((Wrapper)chileOrderQuery);
        if (CollectionUtils.isNotEmpty((Collection)chlieOrders)) {
            for (DgSaleOrderEo chlieOrder : chlieOrders) {
                this.updateEasVerify(chlieOrder);
                LOGGER.info("\u66f4\u65b0eas\u9a8c\u8bc1\u72b6\u6001{}", (Object)chlieOrder.getSaleOrderNo());
            }
            sendMqDgSaleOrderEoList.addAll(chlieOrders);
        }
        for (DgSaleOrderEo orderEo : sendMqDgSaleOrderEoList) {
            if (!Objects.equals(orderEo.getOrderStatus(), SaleOrderStatusEnum.WAIT_CHECK.getCode()) || !Objects.equals(orderEo.getOrderBizType(), SaleOrderBizTypeEnum.FINANCIAL_FRONT.getType())) continue;
            LOGGER.info("\u4fe1\u63a7\u66f4\u65b0eas\u9a8c\u8bc1\u72b6\u6001{}\u4e3a\u5df2\u9a8c\u8bc1\uff0c\u81ea\u52a8\u786e\u8ba4", (Object)orderEo.getSaleOrderNo());
            this.publisher.publishEvent((Object)new AddSaleOrderEvent(orderEo));
        }
    }

    @Override
    public List<DgPerformOrderRespDto> queryByParamList(DgPerformOrderReqDto dgPerformOrderReqDto) {
        TcPerformOrderReqDto tcPerformOrderReqDto = (TcPerformOrderReqDto)dgPerformOrderReqDto;
        SaleOrderQueryReqDto queryReqDto = (SaleOrderQueryReqDto)tcPerformOrderReqDto.getSaleOrderReqDto();
        LOGGER.info("\u67e5\u8be2\u9500\u552e\u5355\u8bf7\u6c42\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        LambdaQueryWrapper<DgSaleOrderEo> queryWrapper = this.queryWrapper(queryReqDto);
        List saleOrderEos = this.dgSaleOrderDas.getMapper().selectList(queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return Lists.newArrayList();
        }
        List<DgPerformOrderRespDto> resultList = saleOrderEos.stream().map(this::eo2TcDto).collect(Collectors.toList());
        return resultList;
    }

    @Override
    public DgPerformOrderRespDto queryNewestOrderByCustomerId(Long customerId) {
        BizSaleOrderRespDto saleOrderRespDto = null;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DgSaleOrderEo::getCustomerId, (Object)customerId)).in(DgSaleOrderEo::getOrderStatus, new Object[]{SaleOrderStatusEnum.COMPLETE.getCode(), SaleOrderStatusEnum.RECEIVED.getCode()})).eq(BaseEo::getDr, (Object)0)).orderByDesc(BaseEo::getCreateTime);
        List saleOrderEos = this.dgSaleOrderDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)saleOrderEos)) {
            DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)saleOrderEos.get(0);
            saleOrderRespDto = new BizSaleOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)saleOrderEo, (BaseVo)saleOrderRespDto);
            LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderEo.getId());
            List orderItemEos = this.dgSaleOrderItemDas.getMapper().selectList((Wrapper)queryItemWrapper);
            ArrayList itemList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)orderItemEos, (Collection)itemList, SaleOrderItemExtRespDto.class);
            saleOrderRespDto.setItemList((List)itemList);
        }
        TcPerformOrderRespDto tcPerformOrderRespDto = new TcPerformOrderRespDto();
        tcPerformOrderRespDto.setBizSaleOrderRespDto(saleOrderRespDto);
        return tcPerformOrderRespDto;
    }

    @Override
    public List<DgSaleOrderEo> queryEoByOrderNos(List<String> saleOrders) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEo::getDr, (Object)0);
        wrapper.in(DgSaleOrderEo::getSaleOrderNo, saleOrders);
        List saleOrderEos = this.dgSaleOrderDas.getMapper().selectList((Wrapper)wrapper);
        return saleOrderEos;
    }

    @Override
    public Boolean verifySaleOrderEntireSign(Long orderId, String saleOrderNo) {
        LOGGER.info("\u6821\u9a8c\u9500\u552e\u5355\u662f\u5426\u5b8c\u5168\u7b7e\u6536\uff1a{},{}", (Object)orderId, (Object)saleOrderNo);
        if (Objects.nonNull(orderId) && StringUtils.isBlank((CharSequence)saleOrderNo)) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38\uff0cID\u4e0e\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        DgSaleOrderEo queryEo = new DgSaleOrderEo();
        queryEo.setId(orderId);
        queryEo.setSaleOrderNo(saleOrderNo);
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.dgSaleOrderDas.selectOne((BaseEo)queryEo);
        if (Objects.isNull(saleOrderEo)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)saleOrderEo.getMainOrderNo())) {
            return saleOrderEo.getOrderStatus().equals(SaleOrderStatusEnum.RECEIVED.getCode());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        queryWrapper.eq(DgSaleOrderEo::getMainOrderNo, (Object)saleOrderEo.getMainOrderNo());
        queryWrapper.notIn(DgSaleOrderEo::getOrderStatus, new Object[]{SaleOrderStatusEnum.RECEIVED.getCode(), SaleOrderStatusEnum.SPLIT.getCode(), SaleOrderStatusEnum.OBSOLETE.getCode()});
        List saleOrderEos = this.dgSaleOrderDas.getMapper().selectList((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)saleOrderEos);
    }

    private LambdaQueryWrapper<DgSaleOrderEo> queryWrapper(SaleOrderQueryReqDto queryReqDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (Objects.nonNull(queryReqDto.getOrganizationId())) {
            wrapper.eq(DgSaleOrderEo::getOrganizationId, (Object)queryReqDto.getOrganizationId());
        }
        if (Objects.nonNull(queryReqDto.getShopId())) {
            wrapper.eq(DgSaleOrderEo::getShopId, (Object)queryReqDto.getShopId());
        }
        if (Objects.nonNull(queryReqDto.getShopChannelId())) {
            wrapper.eq(DgSaleOrderEo::getShopChannelId, (Object)queryReqDto.getShopChannelId());
        }
        if (Objects.nonNull(queryReqDto.getIsOnline())) {
            wrapper.eq(DgSaleOrderEo::getIsOnline, (Object)queryReqDto.getIsOnline());
        }
        if (Objects.nonNull(queryReqDto.getCustomerId())) {
            wrapper.eq(DgSaleOrderEo::getCustomerId, (Object)queryReqDto.getCustomerId());
        }
        if (Objects.nonNull(queryReqDto.getOrderSource())) {
            wrapper.eq(DgSaleOrderEo::getOrderSource, (Object)queryReqDto.getOrderSource());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getPlatformOrderNo())) {
            wrapper.eq(DgSaleOrderEo::getPlatformOrderNo, (Object)queryReqDto.getPlatformOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getOrderStatus())) {
            wrapper.eq(DgSaleOrderEo::getOrderStatus, (Object)queryReqDto.getOrderStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getSecondOrderStatus())) {
            wrapper.eq(DgSaleOrderEo::getSecondOrderStatus, (Object)queryReqDto.getSecondOrderStatus());
        }
        if (Objects.nonNull(queryReqDto.getPlatformOrderId())) {
            wrapper.eq(DgSaleOrderEo::getPlatformOrderId, (Object)queryReqDto.getPlatformOrderId());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getMainOrderNo())) {
            wrapper.eq(DgSaleOrderEo::getMainOrderNo, (Object)queryReqDto.getMainOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getSaleOrderNo())) {
            wrapper.eq(DgSaleOrderEo::getSaleOrderNo, (Object)queryReqDto.getSaleOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getParentOrderNo())) {
            wrapper.eq(DgSaleOrderEo::getParentOrderNo, (Object)queryReqDto.getParentOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getCustomerCode())) {
            wrapper.eq(DgSaleOrderEo::getCustomerCode, (Object)queryReqDto.getCustomerCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getSaleOrderNoList())) {
            wrapper.in(DgSaleOrderEo::getSaleOrderNo, (Collection)queryReqDto.getSaleOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getPlatformOrderIdList())) {
            wrapper.in(DgSaleOrderEo::getPlatformOrderId, (Collection)queryReqDto.getPlatformOrderIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getPlatformOrderNoList())) {
            wrapper.in(DgSaleOrderEo::getPlatformOrderNo, (Collection)queryReqDto.getPlatformOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getOrderStatusList())) {
            wrapper.in(DgSaleOrderEo::getOrderStatus, (Collection)queryReqDto.getOrderStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getNotOrderStatusList())) {
            wrapper.notIn(DgSaleOrderEo::getOrderStatus, (Collection)queryReqDto.getNotOrderStatusList());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getSplitPlatformNo())) {
            wrapper.eq(DgSaleOrderEo::getSplitPlatformNo, (Object)queryReqDto.getSplitPlatformNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getEasOrderNo())) {
            wrapper.eq(DgSaleOrderEo::getEasOrderNo, (Object)queryReqDto.getEasOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getOriginalOrderNo())) {
            wrapper.eq(DgSaleOrderEo::getOriginalOrderNo, (Object)queryReqDto.getOriginalOrderNo());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getOriginalOrderNoList())) {
            wrapper.in(DgSaleOrderEo::getOriginalOrderNo, (Collection)queryReqDto.getOriginalOrderNoList());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getCustomerCode())) {
            wrapper.eq(DgSaleOrderEo::getCustomerCode, (Object)queryReqDto.getCustomerCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getAllotType())) {
            wrapper.eq(DgSaleOrderEo::getAllotType, (Object)queryReqDto.getAllotType());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getAllotTypeList())) {
            wrapper.in(DgSaleOrderEo::getAllotType, (Collection)queryReqDto.getAllotTypeList());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getAllotInWarehouseCode())) {
            wrapper.eq(DgSaleOrderEo::getAllotInWarehouseCode, (Object)queryReqDto.getAllotInWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getAllotOutWarehouseCode())) {
            wrapper.eq(DgSaleOrderEo::getAllotOutWarehouseCode, (Object)queryReqDto.getAllotOutWarehouseCode());
        }
        wrapper.eq(BaseEo::getDr, (Object)0);
        wrapper.orderByDesc(BaseEo::getCreateTime);
        return wrapper;
    }

    private void updateEasVerify(DgSaleOrderEo saleOrderEo) {
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setEasVerifyStatus(EasVerifyStatusEnum.YES.getType());
        updateEo.setEasVerifyTime(new Date());
        if (LockStatusEnum.LOCK.getType().equals(saleOrderEo.getLockStatus()) && LockTypeEnum.EAS_CANCEL.getType().equals(saleOrderEo.getLockType())) {
            updateEo.setLockStatus(LockStatusEnum.UNLOCK.getType());
            updateEo.setLockType(LockTypeEnum.MANUAL.getType());
        }
        DgSaleOrderEo queryEo = new DgSaleOrderEo();
        queryEo.setId(saleOrderEo.getId());
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"order_status", new Object[]{saleOrderEo.getOrderStatus()});
        this.optimisticModifySaleOrder(updateEo, (UpdateWrapper<DgSaleOrderEo>)updateWrapper, 1, true);
    }

    private void popOrderStatusLog(DgSaleOrderEo saleOrderEo, UpdateWrapper<DgSaleOrderEo> updateWrapper) {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)((DgSaleOrderEo)updateWrapper.getEntity()).getId());
        DgSaleOrderEo saleOrderDasOne = (DgSaleOrderEo)this.dgSaleOrderDas.getMapper().selectOne((Wrapper)queryOrderWrapper);
        String orderSteps = saleOrderDasOne.getOrderSteps();
        List<OrderStatusLogRespDto> orderStatusLogRespDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, OrderStatusLogRespDto.class);
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getOrderStatus())) {
            OrderStatusLogRespDto orderStatusLogRespDto = new OrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(saleOrderEo.getOrderStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            saleOrderEo.setOrderSteps(JSON.toJSONString(orderStatusLogRespDtos));
        }
    }

    private DgPerformOrderRespDto eo2TcDto(DgSaleOrderEo dgSaleOrderEo) {
        BizSaleOrderRespDto bizSaleOrderRespDto = new BizSaleOrderRespDto();
        BeanUtil.copyProperties((Object)dgSaleOrderEo, (Object)bizSaleOrderRespDto, (String[])new String[0]);
        TcPerformOrderRespDto tcPerformOrderRespDto = new TcPerformOrderRespDto();
        tcPerformOrderRespDto.setBizSaleOrderRespDto(bizSaleOrderRespDto);
        return tcPerformOrderRespDto;
    }
}

