/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.constants;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.trade.constants.SaleOrderStatusFlowTemplate;
import com.yunxi.dg.base.center.trade.constants.statusflows.BdInnerTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.BdThirdpartyTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.DgB2CTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.TcTradeStatusFlow;
import com.yunxi.dg.base.center.trade.constants.statusflows.VirtualOrderTradeStatusFlow;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import java.util.List;
import java.util.Map;

public enum TradeStatusFlowSelector {
    TC("TC"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return TcTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return TcTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    BD("BD"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return BdThirdpartyTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return BdThirdpartyTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    INNER("INNER"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return BdInnerTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return BdInnerTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    VIRTUAL("VIRTUAL"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return VirtualOrderTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return VirtualOrderTradeStatusFlow.STATUS_LIST;
        }
    }
    ,
    B2C("B2C"){

        @Override
        public Map<String, SaleOrderStatusFlowTemplate> getLookup() {
            return DgB2CTradeStatusFlow.CODE_LOOKUP;
        }

        @Override
        public List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList() {
            return DgB2CTradeStatusFlow.STATUS_LIST;
        }
    };

    private String code;

    private TradeStatusFlowSelector(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static TradeStatusFlowSelector enumOf(String code) {
        for (TradeStatusFlowSelector typeEnum : TradeStatusFlowSelector.values()) {
            if (!typeEnum.getCode().equals(code)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", code, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }

    public abstract Map<String, SaleOrderStatusFlowTemplate> getLookup();

    public abstract List<SaleOrderStatusFlowTemplate> getSaleOrderStatusList();
}

