/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.constants;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.trade.constants.SaleOrderStatus;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum SaleRefundStatusEnum implements SaleOrderStatus
{
    WAIT_CHECK("WAIT_CHECK", "\u5f85\u786e\u8ba4"),
    HAD_CHECK("HAD_CHECK", "\u5df2\u786e\u8ba4"),
    PART_OUTBOUND("PART_OUTBOUND", "\u90e8\u5206\u5165\u5e93"),
    COMPLETE("COMPLETE", "\u5df2\u5b8c\u6210"),
    CANCEL("CANCEL", "\u5df2\u53d6\u6d88"),
    CANCELING("CANCELING", "\u53d6\u6d88\u4e2d"),
    CLOSE("CLOSE", "\u5df2\u5173\u95ed");

    private String code;
    private String desc;
    public static final Map<String, SaleRefundStatusEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    private SaleRefundStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SaleRefundStatusEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public static SaleRefundStatusEnum enumOf(String type) {
        for (SaleRefundStatusEnum typeEnum : SaleRefundStatusEnum.values()) {
            if (!typeEnum.getCode().equals(type)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", type, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }

    static {
        CODE_LOOKUP = Arrays.stream(SaleRefundStatusEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(SaleRefundStatusEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

