/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.constants.statusflows;

import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.constants.SaleOrderStatusFlowTemplate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum TcTradeStatusFlow implements SaleOrderStatusFlowTemplate
{
    WAIT_CHECK(DgSaleOrderStatusEnum.WAIT_CHECK.getCode(), DgSaleOrderStatusEnum.WAIT_CHECK.getDesc()),
    WAIT_PICK(DgSaleOrderStatusEnum.WAIT_PICK.getCode(), DgSaleOrderStatusEnum.WAIT_PICK.getDesc()),
    WAIT_DELIVERY(DgSaleOrderStatusEnum.WAIT_DELIVERY.getCode(), DgSaleOrderStatusEnum.WAIT_DELIVERY.getDesc()),
    COMPLETE(DgSaleOrderStatusEnum.COMPLETE.getCode(), DgSaleOrderStatusEnum.COMPLETE.getDesc()),
    RECEIVED(DgSaleOrderStatusEnum.RECEIVED.getCode(), DgSaleOrderStatusEnum.RECEIVED.getDesc());

    private String code;
    private String desc;
    public static final List<SaleOrderStatusFlowTemplate> STATUS_LIST;
    public static final Map<String, SaleOrderStatusFlowTemplate> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private TcTradeStatusFlow(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    static {
        STATUS_LIST = Arrays.stream(TcTradeStatusFlow.values()).collect(Collectors.toList());
        CODE_LOOKUP = Arrays.stream(TcTradeStatusFlow.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(TcTradeStatusFlow.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

