/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.constant;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.google.common.collect.Lists;
import java.util.List;

public enum LockStatusEnum {
    UNLOCK(0, "\u672a\u6302\u8d77"),
    LOCK(1, "\u5df2\u6302\u8d77"),
    UNLOCK_ERROR(2, "\u89e3\u6302\u5931\u8d25"),
    LOCK_ERROR(3, "\u6302\u8d77\u5931\u8d25");

    private Integer type;
    private String desc;
    public static final List<LockStatusEnum> lockList;
    public static final List<LockStatusEnum> unlockList;

    private LockStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static LockStatusEnum enumOf(Integer type) {
        for (LockStatusEnum typeEnum : LockStatusEnum.values()) {
            if (!typeEnum.getType().equals(type)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", type, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }

    static {
        lockList = Lists.newArrayList((Object[])new LockStatusEnum[]{LOCK, UNLOCK_ERROR});
        unlockList = Lists.newArrayList((Object[])new LockStatusEnum[]{UNLOCK, LOCK_ERROR});
    }
}

