/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.common;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MqConsumerAround {
    private static Logger logger = LoggerFactory.getLogger(MqConsumerAround.class);

    public static <T, R> MessageResponse aroundMqProcess(Function<T, R> function) {
        String reqId = RequestId.createReqId();
        try {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
            function.apply(null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"yes.req.requestId");
            ServiceContext.getContext().removeAttachment("yes.req.requestId");
        }
        return MessageResponse.SUCCESS;
    }

    public static <T, R> MessageResponse asyncAroundMqProcess(Function<T, R> function) {
        CompletableFuture.runAsync(() -> {
            String reqId = RequestId.createReqId();
            try {
                MDC.put((String)"yes.req.requestId", (String)reqId);
                ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                function.apply(null);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                MDC.remove((String)"yes.req.requestId");
                ServiceContext.getContext().removeAttachment("yes.req.requestId");
            }
        });
        return MessageResponse.SUCCESS;
    }
}

