/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OutDeliveryMessageDto;
import com.yunxi.dg.base.center.trade.api.order.IPerformOrderQueryApi;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryDetailResultDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.mqc.common.MqConsumerAround;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderHandleService;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.execute.DgB2BOrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.execute.DgB2COrderStatemachineExecutor;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORDER_SALE_WMS_SEND_BACK_TAG")
@ConditionalOnProperty(name={"perform.order.delivered.mq.processor.enable"}, havingValue="true", matchIfMissing=true)
public class PerformOrderDeliveredProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformOrderDeliveredProcessor.class);
    @Resource
    private IPerformOrderQueryApi performOrderQueryApi;
    @Resource
    private IDgPerformOrderHandleService performOrderHandleService;
    @Resource
    private DgB2COrderStatemachineExecutor dgB2COrderStatemachineExecutor;
    @Resource
    private DgB2BOrderStatemachineExecutor dgB2BOrderStatemachineExecutor;

    public MessageResponse process(MessageVo message) {
        return MqConsumerAround.aroundMqProcess(o -> {
            LOGGER.info("[\u63a5\u6536\u5230\u5e93\u5b58\u51fa\u5e93\u7ed3\u679c\u56de\u4f20]\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
            Object messageData = message.getData();
            try {
                OutDeliveryMessageDto csOutDeliveryMessageDto = (OutDeliveryMessageDto)messageData;
                DgOutDeliveryResultReqDto outDeliveryResultReqDto = new DgOutDeliveryResultReqDto();
                CubeBeanUtils.copyProperties((Object)outDeliveryResultReqDto, (Object)csOutDeliveryMessageDto, (String[])new String[]{"deliveryDetailMessageDtoList"});
                ArrayList deliveryDetailList = Lists.newArrayList();
                ArrayList shippingInfoReqDtoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)deliveryDetailList, (Collection)csOutDeliveryMessageDto.getDeliveryDetailMessageDtoList(), DgOutDeliveryDetailResultDto.class);
                outDeliveryResultReqDto.setDeliveryDetailList((List)deliveryDetailList);
                CubeBeanUtils.copyCollection((Collection)shippingInfoReqDtoList, (Collection)csOutDeliveryMessageDto.getShippingInfoList(), DgWmsShippingInfoReqDto.class);
                outDeliveryResultReqDto.setShippingInfoList((List)shippingInfoReqDtoList);
                DgBizPerformOrderRespDto orderRespDto = (DgBizPerformOrderRespDto)RestResponseHelper.extractData((RestResponse)this.performOrderQueryApi.queryByOrderNo(csOutDeliveryMessageDto.getOrderNo()));
                if (csOutDeliveryMessageDto.getCommonBack().booleanValue()) {
                    LOGGER.info("[\u63a5\u6536\u5230\u5e93\u5b58\u51fa\u5e93\u7ed3\u679c\u56de\u4f20]\u8ba2\u5355\uff08saleOrderNo={}\uff09\u5df2\u53d1\u8d27, \u51fa\u5e93\u4fe1\u606f\u4e3a:{}", (Object)csOutDeliveryMessageDto.getOrderNo(), (Object)JSON.toJSONString((Object)outDeliveryResultReqDto));
                    DgPerformOrderBizModelEnum performOrderBizModelEnum = (DgPerformOrderBizModelEnum)DgPerformOrderBizModelEnum.CODE_LOOKUP.get(orderRespDto.getBizModel());
                    switch (performOrderBizModelEnum) {
                        case INVOICE_ORDER: {
                            RestResponse crestResponse = Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), orderRespDto.getId(), (Object)outDeliveryResultReqDto, (Object)DgB2COrderMachineEvents.OUT_DELIVERY_RESULT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
                            RestResponseHelper.checkOrThrow((RestResponse)crestResponse);
                            break;
                        }
                        case INSIDE_SALES_ORDER: {
                            RestResponse brestResponse = Optional.ofNullable(this.dgB2BOrderStatemachineExecutor.executeStatemachine(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), orderRespDto.getId(), (Object)outDeliveryResultReqDto, (Object)DgB2BOrderMachineEvents.OUT_DELIVERY_RESULT).getActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
                            RestResponseHelper.checkOrThrow((RestResponse)brestResponse);
                            break;
                        }
                        default: {
                            throw new BizException("bizModel\u5f02\u5e38\uff0c\u4e0d\u5904\u7406\u56de\u4f20");
                        }
                    }
                } else {
                    LOGGER.info("[\u63a5\u6536\u5230\u5e93\u5b58\u51fa\u5e93\u7ed3\u679c\u56de\u4f20]\u8ba2\u5355\uff08saleOrderNo={}\uff09\u56de\u4f20\u7269\u6d41\u4fe1\u606f", (Object)csOutDeliveryMessageDto.getOrderNo());
                    RestResponse restResponse = this.performOrderHandleService.sendMsgForShipmentEnterprise(orderRespDto.getId(), outDeliveryResultReqDto);
                    RestResponseHelper.checkOrThrow((RestResponse)restResponse);
                }
                return MessageResponse.SUCCESS;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return MessageResponse.SUCCESS;
            }
        });
    }
}

