/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.tc.order;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderHandleApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryResultReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcMqMessageAction;
import com.yunxi.dg.base.center.trade.dao.mapper.DgSaleOrderMapper;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sale/handle/order"})
public class SaleOrderHandleRest
implements ISaleOrderHandleApi {
    private static final Logger log = LoggerFactory.getLogger(SaleOrderHandleRest.class);
    @Resource
    private IDgTcMqMessageAction dgTcMqMessageAction;
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private DgSaleOrderMapper dgSaleOrderMapper;
    @Resource
    private ICacheService cacheService;

    public RestResponse<Void> sendMsgForShipmentEnterprise(Long saleOrderId, OutDeliveryResultReqDto request) {
        SaleOrderRespDto saleOrderRespDto = new SaleOrderRespDto();
        saleOrderRespDto.setId(saleOrderId);
        return this.dgTcMqMessageAction.sendMsgForAllDelivery(saleOrderRespDto, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/batch/continueDeliver"}, method={RequestMethod.POST})
    public RestResponse<Integer> batchContinueDeliver(@RequestParam(value="async", defaultValue="true") boolean async) {
        List orderIds = this.dgSaleOrderMapper.selectIdsForContinueDeliver();
        if (orderIds == null || orderIds.isEmpty()) {
            return new RestResponse((Object)0);
        }
        Boolean batchContinueDeliver = this.cacheService.setIfAbsent("batchContinueDeliver", (Object)1, 3600);
        if (!batchContinueDeliver.booleanValue()) {
            return new RestResponse((Object)0);
        }
        if (async) {
            new Thread(() -> orderIds.forEach(orderId -> {
                try {
                    RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.continueDeliver(orderId));
                }
                catch (Exception e) {
                    log.error("\u6279\u91cf\u7ee7\u7eed\u53d1\u8d27\u5931\u8d25:{}", (Object)e.getMessage());
                }
            })).start();
        } else {
            try {
                orderIds.forEach(orderId -> {
                    Void cfr_ignored_0 = (Void)RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.continueDeliver(orderId));
                });
            }
            finally {
                this.cacheService.delCache("batchContinueDeliver");
            }
        }
        return new RestResponse((Object)orderIds.size());
    }
}

