/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.track.handle;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.commons.constant.TransactionStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.yunxi.dg.base.center.trade.anno.LogIntercepts;
import com.yunxi.dg.base.center.trade.dao.vo.TradeTrackDataBizVo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.track.enums.OrderOperationTypeEnum;
import com.yunxi.dg.base.center.trade.track.handle.TrackLogHandle;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@LogIntercepts(transactionStatus={TransactionStatusEnum.T_ERROR})
@Component
public class TradeExceptionHandle
implements TrackLogHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(TradeExceptionHandle.class);
    @Resource
    private ISaleOrderService saleOrderService;

    @Override
    public void intercept(List<TradeTrackDataBizVo.OptDataVo> logList) {
        logList = this.filterOrderStatusException(logList);
        if (CollectionUtils.isNotEmpty(logList = this.filterExceptionLogs(logList))) {
            LOGGER.info("[\u63a5\u53d7\u8ba2\u5355\u62e6\u51fb\u65e5\u5fd7\u4fe1\u606f]\u63a5\u53d7\u5230\u7684\u62e6\u622a\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(logList));
            TradeTrackDataBizVo.OptDataVo optDataVo = logList.get(0);
            String msgOfException = this.buildExceptionMsg(logList, optDataVo);
            if (optDataVo.getBizId() != null) {
                SaleOrderReqDto updateEo = new SaleOrderReqDto();
                updateEo.setInterceptInfo(msgOfException);
                updateEo.setId(optDataVo.getBizId());
                this.saleOrderService.modifySaleOrder(updateEo);
            }
        }
    }

    private String buildExceptionMsg(List<TradeTrackDataBizVo.OptDataVo> logList, TradeTrackDataBizVo.OptDataVo optDataVo) {
        LOGGER.info("[\u63a5\u53d7\u8ba2\u5355\u62e6\u51fb\u65e5\u5fd7\u4fe1\u606f]\u63a5\u6536\u5230\u6765\u81f3{}\u7684\u65e5\u5fd7\u62e6\u622a", (Object)optDataVo.getOperationType());
        if (OrderOperationTypeEnum.CHECKORDERCANAUTOCHECK.getDesc().equals(optDataVo.getOperationType())) {
            return optDataVo.getOptResult();
        }
        List optResultList = logList.stream().map(TradeTrackDataBizVo.OptDataVo::getOptResult).collect(Collectors.toList());
        String exceptionMsg = StringUtils.join(optResultList, (String)",");
        return exceptionMsg;
    }
}

