/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.component.track.commons.aspect.annotation.TrackLogNode;
import com.dtyunxi.cube.component.track.commons.constant.TrackLogBizDefine;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AuditTimeTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.ChannelSelectedTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.NextOptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.StrategyEnableEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.StrategyTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizStrategyAutoCheckRuleReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.StrategyAutoCheckRuleReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizCustomerRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizRegionRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTradeMessageVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.StrategyAutoCheckRuleDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.StrategyAutoCheckRuleRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderChannelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPcpOrderChannelQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dao.base.QueryWrapBuilder;
import com.yunxi.dg.base.center.trade.dao.vo.StrategyRuleQueryVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyAutoCheckChannelDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyAutoCheckConfDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyAutoCheckOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyAutoCheckRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyAutoCheckTypeDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IStrategyAutoCheckOrderTypeDomain;
import com.yunxi.dg.base.center.trade.eo.StrategyAutoCheckChannelEo;
import com.yunxi.dg.base.center.trade.eo.StrategyAutoCheckConfEo;
import com.yunxi.dg.base.center.trade.eo.StrategyAutoCheckOrderEo;
import com.yunxi.dg.base.center.trade.eo.StrategyAutoCheckOrderTypeEo;
import com.yunxi.dg.base.center.trade.eo.StrategyAutoCheckRuleEo;
import com.yunxi.dg.base.center.trade.eo.StrategyAutoCheckTypeEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.service.tc.IStrategyAutoCheckRuleService;
import com.yunxi.dg.base.center.trade.service.tc.IStrategyOptLogService;
import com.yunxi.dg.base.center.trade.track.enums.OrderOperationTypeEnum;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.center.trade.utils.ReflectionUtils;
import com.yunxi.dg.base.center.trade.utils.RuleEffectiveUtil;
import com.yunxi.dg.base.center.trade.utils.TrackOptLogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TrackLogNode(nodeBizDefine=TrackLogBizDefine.BIZ_OPERATION_LOG, nodeBizCode="strategy")
public class StrategyAutoCheckRuleServiceImpl
implements IStrategyAutoCheckRuleService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgStrategyAutoCheckRuleDomain strategyAutoCheckRuleDomain;
    @Resource
    private IDgStrategyAutoCheckTypeDomain strategyAutoCheckTypeDomain;
    @Resource
    private IDgStrategyAutoCheckConfDomain strategyAutoCheckConfDomain;
    @Resource
    private IDgStrategyAutoCheckChannelDomain strategyAutoCheckChannelDomain;
    @Resource
    private IStrategyAutoCheckOrderTypeDomain strategyAutoCheckOrderTypeDomain;
    @Resource
    private IDgStrategyAutoCheckOrderDomain strategyAutoCheckOrderDomain;
    @Resource
    private ICsLogicWarehouseQueryApi logicWarehouseExposedQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IPcpOrderChannelQueryApi orderChannelQueryApi;
    @Resource
    private IPcpRegionQueryApi regionQueryApi;
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private IStrategyOptLogService strategyOptLogService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addStrategyAutoCheckRule(BizStrategyAutoCheckRuleReqDto addReqDto) {
        this.checkAddRuleParams(addReqDto);
        addReqDto.setRuleCode(this.noGreateUtil.generateRuleNo());
        StrategyAutoCheckRuleEo strategyAutoCheckRuleEo = new StrategyAutoCheckRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)strategyAutoCheckRuleEo);
        this.strategyAutoCheckRuleDomain.insert((BaseEo)strategyAutoCheckRuleEo);
        List strategyTypeList = StrategyTypeEnum.getStrategyTypeList();
        ArrayList strategyAutoCheckTypeEos = Lists.newArrayList();
        StrategyAutoCheckTypeEo strategyAutoCheckTypeEo = null;
        for (StrategyTypeEnum strategyTypeEnum : strategyTypeList) {
            strategyAutoCheckTypeEo = new StrategyAutoCheckTypeEo();
            strategyAutoCheckTypeEo.setRuleId(strategyAutoCheckRuleEo.getId());
            strategyAutoCheckTypeEo.setStrategyType(strategyTypeEnum.getStrategyType());
            strategyAutoCheckTypeEo.setStrategyTypeName(strategyTypeEnum.getDesc());
            Object value = ReflectionUtils.getMethodValue((Object)addReqDto, (String)strategyTypeEnum.getTag());
            if (value instanceof Integer) {
                strategyAutoCheckTypeEo.setEnable((Integer)value);
            }
            strategyAutoCheckTypeEos.add(strategyAutoCheckTypeEo);
        }
        this.logger.info("[\u65b0\u589e\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u8bbe\u7f6e\u7684\u914d\u7f6e\u9879\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)strategyAutoCheckTypeEos));
        this.strategyAutoCheckTypeDomain.insertBatch((List)strategyAutoCheckTypeEos);
        List<StrategyAutoCheckConfEo> strategyAutoCheckConfEos = this.buildStrategyConfItems(addReqDto, strategyAutoCheckRuleEo);
        this.logger.info("[\u65b0\u589e\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u8bbe\u7f6e\u7684\u914d\u7f6e\u4e3a\uff1a{}", (Object)JSON.toJSONString(strategyAutoCheckConfEos));
        if (CollectionUtils.isNotEmpty(strategyAutoCheckConfEos)) {
            this.strategyAutoCheckConfDomain.insertBatch(strategyAutoCheckConfEos);
        }
        List<StrategyAutoCheckChannelEo> strategyAutoCheckChannelEos = this.buildStrategyConfRanges(addReqDto, strategyAutoCheckRuleEo);
        this.logger.info("[\u65b0\u589e\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u8bbe\u7f6e\u6e20\u9053\u5e94\u7528\u8303\u56f4\u4e3a\uff1a{}", (Object)JSON.toJSONString(strategyAutoCheckChannelEos));
        if (CollectionUtils.isNotEmpty(strategyAutoCheckChannelEos)) {
            this.strategyAutoCheckChannelDomain.insertBatch(strategyAutoCheckChannelEos);
        }
        List<StrategyAutoCheckOrderTypeEo> strategyAutoCheckOrderTypeEoList = this.buildStrategyConfOrderType(addReqDto, strategyAutoCheckRuleEo);
        this.logger.info("[\u65b0\u589e\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u8bbe\u7f6e\u8ba2\u5355\u7c7b\u578b\u5e94\u7528\u8303\u56f4\u4e3a\uff1a{}", (Object)JSON.toJSONString(strategyAutoCheckOrderTypeEoList));
        if (CollectionUtils.isNotEmpty(strategyAutoCheckOrderTypeEoList)) {
            this.strategyAutoCheckOrderTypeDomain.insertBatch(strategyAutoCheckOrderTypeEoList);
        }
        TrackOptLogUtils.addOrderTrackOptLog((Long)strategyAutoCheckRuleEo.getId(), (String)("\u521b\u5efa\u81ea\u52a8\u7b56\u7565" + strategyAutoCheckRuleEo.getRuleCode()));
        return strategyAutoCheckRuleEo.getId();
    }

    private List<StrategyAutoCheckConfEo> buildStrategyConfItems(BizStrategyAutoCheckRuleReqDto addReqDto, StrategyAutoCheckRuleEo strategyAutoCheckRuleEo) {
        ArrayList strategyAutoCheckConfEoList = Lists.newArrayList();
        if (addReqDto.getDelayAuditValue() != null) {
            StrategyAutoCheckConfEo auditTimeConfEo = new StrategyAutoCheckConfEo();
            auditTimeConfEo.setRuleId(strategyAutoCheckRuleEo.getId());
            auditTimeConfEo.setStrategyType(StrategyTypeEnum.DELAY_AUDIT.getStrategyType());
            AuditTimeTypeEnum timeTypeEnum = AuditTimeTypeEnum.enumOf((String)addReqDto.getDelayAuditType());
            auditTimeConfEo.setStrategyValue(timeTypeEnum.getType());
            auditTimeConfEo.setStrategyValue2(addReqDto.getDelayAuditValue().toString());
            strategyAutoCheckConfEoList.add(auditTimeConfEo);
        }
        if (addReqDto.getAmountRangeMaximum() != null) {
            StrategyAutoCheckConfEo amountRangeEo = new StrategyAutoCheckConfEo();
            amountRangeEo.setRuleId(strategyAutoCheckRuleEo.getId());
            amountRangeEo.setStrategyType(StrategyTypeEnum.AMOUNT_RANGE_AUDIT.getStrategyType());
            amountRangeEo.setStrategyValue(addReqDto.getAmountRangeMinimum().toString());
            amountRangeEo.setStrategyValue2(addReqDto.getAmountRangeMaximum().toString());
            strategyAutoCheckConfEoList.add(amountRangeEo);
        }
        if (Objects.nonNull(addReqDto.getLogicalWarehouseCodeOfAudit()) && CollectionUtils.isNotEmpty((Collection)addReqDto.getLogicalWarehouseCodeOfAudit().getAdd())) {
            addReqDto.getLogicalWarehouseCodeOfAudit().getAdd().forEach(item -> {
                StrategyAutoCheckConfEo logicalWarehouseCodeEo = new StrategyAutoCheckConfEo();
                logicalWarehouseCodeEo.setRuleId(strategyAutoCheckRuleEo.getId());
                logicalWarehouseCodeEo.setStrategyType(StrategyTypeEnum.LOGICAL_WAREHOUSE_AUDIT.getStrategyType());
                logicalWarehouseCodeEo.setStrategyValue(item);
                strategyAutoCheckConfEoList.add(logicalWarehouseCodeEo);
            });
        }
        if (Objects.nonNull(addReqDto.getGoodsOfAudit()) && CollectionUtils.isNotEmpty((Collection)addReqDto.getGoodsOfAudit().getAdd())) {
            addReqDto.getGoodsOfAudit().getAdd().forEach(item -> {
                StrategyAutoCheckConfEo goodsCodeEo = new StrategyAutoCheckConfEo();
                goodsCodeEo.setRuleId(strategyAutoCheckRuleEo.getId());
                goodsCodeEo.setStrategyType(StrategyTypeEnum.GOODS_AUDIT.getStrategyType());
                goodsCodeEo.setStrategyValue(item);
                strategyAutoCheckConfEoList.add(goodsCodeEo);
            });
        }
        if (Objects.nonNull(addReqDto.getCustomerIdOfAudit()) && CollectionUtils.isNotEmpty((Collection)addReqDto.getCustomerIdOfAudit().getAdd())) {
            addReqDto.getCustomerIdOfAudit().getAdd().forEach(item -> {
                StrategyAutoCheckConfEo customerCodeEo = new StrategyAutoCheckConfEo();
                customerCodeEo.setRuleId(strategyAutoCheckRuleEo.getId());
                customerCodeEo.setStrategyType(StrategyTypeEnum.CUSTOMER_AUDIT.getStrategyType());
                customerCodeEo.setStrategyValue(item);
                strategyAutoCheckConfEoList.add(customerCodeEo);
            });
        }
        if (Objects.nonNull(addReqDto.getAreaOfAudit()) && CollectionUtils.isNotEmpty((Collection)addReqDto.getAreaOfAudit().getAdd())) {
            addReqDto.getAreaOfAudit().getAdd().forEach(item -> {
                StrategyAutoCheckConfEo areaCodeEo = new StrategyAutoCheckConfEo();
                areaCodeEo.setRuleId(strategyAutoCheckRuleEo.getId());
                areaCodeEo.setStrategyType(StrategyTypeEnum.AREA_AUDIT.getStrategyType());
                areaCodeEo.setStrategyValue(item);
                strategyAutoCheckConfEoList.add(areaCodeEo);
            });
        }
        if (Objects.nonNull(addReqDto.getBuyerRemark()) && CollectionUtils.isNotEmpty((Collection)addReqDto.getBuyerRemark().getAdd())) {
            addReqDto.getBuyerRemark().getAdd().forEach(item -> {
                StrategyAutoCheckConfEo areaCodeEo = new StrategyAutoCheckConfEo();
                areaCodeEo.setRuleId(strategyAutoCheckRuleEo.getId());
                areaCodeEo.setStrategyType(StrategyTypeEnum.BUYER_REMARK_AUDIT.getStrategyType());
                areaCodeEo.setStrategyValue(item);
                strategyAutoCheckConfEoList.add(areaCodeEo);
            });
        }
        if (Objects.nonNull(addReqDto.getSellerRemark()) && CollectionUtils.isNotEmpty((Collection)addReqDto.getSellerRemark().getAdd())) {
            addReqDto.getSellerRemark().getAdd().forEach(item -> {
                StrategyAutoCheckConfEo sellerRemarkEo = new StrategyAutoCheckConfEo();
                sellerRemarkEo.setRuleId(strategyAutoCheckRuleEo.getId());
                sellerRemarkEo.setStrategyType(StrategyTypeEnum.SELLER_REMARK_AUDIT.getStrategyType());
                sellerRemarkEo.setStrategyValue(item);
                sellerRemarkEo.setStrategyValue2(addReqDto.getSellerRemark().getSellerRemarkKeyFlag());
                strategyAutoCheckConfEoList.add(sellerRemarkEo);
            });
        }
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getSellerAutoRemark())) {
            StrategyAutoCheckConfEo sellerAutoRemarkEo = new StrategyAutoCheckConfEo();
            sellerAutoRemarkEo.setRuleId(strategyAutoCheckRuleEo.getId());
            sellerAutoRemarkEo.setStrategyType(StrategyTypeEnum.SELLER_REMARK_AUTO_AUDIT.getStrategyType());
            sellerAutoRemarkEo.setStrategyValue(addReqDto.getSellerAutoRemark());
            sellerAutoRemarkEo.setStrategyValue2("1");
            strategyAutoCheckConfEoList.add(sellerAutoRemarkEo);
        }
        return strategyAutoCheckConfEoList;
    }

    private List<StrategyAutoCheckChannelEo> buildStrategyConfRanges(BizStrategyAutoCheckRuleReqDto addReqDto, StrategyAutoCheckRuleEo strategyAutoCheckRuleEo) {
        ArrayList strategyAutoCheckChannelEoList = Lists.newArrayList();
        if (ChannelSelectedTypeEnum.ALL.getCode().equals(addReqDto.getChannelSelectedType())) {
            StrategyAutoCheckChannelEo checkChannelEo = new StrategyAutoCheckChannelEo();
            checkChannelEo.setRuleId(strategyAutoCheckRuleEo.getId());
            checkChannelEo.setChannelSelectType(ChannelSelectedTypeEnum.ALL.getCode());
            strategyAutoCheckChannelEoList.add(checkChannelEo);
        } else if (Objects.nonNull(addReqDto.getApplyChannels()) && CollectionUtils.isNotEmpty((Collection)addReqDto.getApplyChannels().getAdd())) {
            List autoCheckChannelEos = addReqDto.getApplyChannels().getAdd().stream().map(item -> {
                StrategyAutoCheckChannelEo checkChannelEo = new StrategyAutoCheckChannelEo();
                checkChannelEo.setRuleId(strategyAutoCheckRuleEo.getId());
                checkChannelEo.setChannelCode(item);
                checkChannelEo.setChannelSelectType(ChannelSelectedTypeEnum.PART.getCode());
                return checkChannelEo;
            }).collect(Collectors.toList());
            strategyAutoCheckChannelEoList.addAll(autoCheckChannelEos);
        }
        return strategyAutoCheckChannelEoList;
    }

    private List<StrategyAutoCheckOrderTypeEo> buildStrategyConfOrderType(BizStrategyAutoCheckRuleReqDto addReqDto, StrategyAutoCheckRuleEo strategyAutoCheckRuleEo) {
        ArrayList strategyAutoCheckOrderTypeEoList = Lists.newArrayList();
        if (ChannelSelectedTypeEnum.ALL.getCode().equals(addReqDto.getOrderTypeSelectedType())) {
            StrategyAutoCheckOrderTypeEo checkOrderTypeEo = new StrategyAutoCheckOrderTypeEo();
            checkOrderTypeEo.setRuleId(strategyAutoCheckRuleEo.getId());
            checkOrderTypeEo.setSelectType(ChannelSelectedTypeEnum.ALL.getCode());
            strategyAutoCheckOrderTypeEoList.add(checkOrderTypeEo);
        } else if (CollectionUtils.isNotEmpty((Collection)addReqDto.getApplyOrderType())) {
            List checkOrderTypeEos = addReqDto.getApplyOrderType().stream().map(item -> {
                StrategyAutoCheckOrderTypeEo checkOrderTypeEo = new StrategyAutoCheckOrderTypeEo();
                checkOrderTypeEo.setRuleId(strategyAutoCheckRuleEo.getId());
                checkOrderTypeEo.setOrderType(item);
                checkOrderTypeEo.setSelectType(ChannelSelectedTypeEnum.PART.getCode());
                return checkOrderTypeEo;
            }).collect(Collectors.toList());
            strategyAutoCheckOrderTypeEoList.addAll(checkOrderTypeEos);
        }
        return strategyAutoCheckOrderTypeEoList;
    }

    private void checkAddRuleParams(BizStrategyAutoCheckRuleReqDto addReqDto) {
        AssertUtils.notBlank((String)addReqDto.getRuleName(), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)addReqDto.getPriority(), (String)"\u4f18\u5148\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)addReqDto.getActiveStartTime(), (String)"\u6709\u6548\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)addReqDto.getActiveEndTime(), (String)"\u6709\u6548\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyStrategyAutoCheckRule(BizStrategyAutoCheckRuleReqDto modifyReqDto) {
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"\u89c4\u5219id\u80fd\u4e3a\u7a7a\uff01");
        Boolean effective = this.checkRuleEffective(modifyReqDto.getId());
        if (effective.booleanValue()) {
            throw PcpTradeExceptionCode.STRATEGY_NOT_ALLOW_MODIFY.builderException();
        }
        ArrayList optResultList = Lists.newArrayList();
        StrategyAutoCheckRuleEo oldRuleEo = (StrategyAutoCheckRuleEo)this.strategyAutoCheckRuleDomain.selectByPrimaryKey(modifyReqDto.getId());
        if (!Objects.equals(oldRuleEo.getRuleName(), modifyReqDto.getRuleName())) {
            optResultList.add("\u7f16\u8f91\u89c4\u5219\u540d\u79f0");
        }
        if (!Objects.equals(oldRuleEo.getPriority(), modifyReqDto.getPriority())) {
            optResultList.add("\u7f16\u8f91\u89c4\u5219\u4f18\u5148\u7ea7");
        }
        if (!Objects.equals(oldRuleEo.getActiveStartTime(), modifyReqDto.getActiveStartTime()) || !Objects.equals(oldRuleEo.getActiveEndTime(), modifyReqDto.getActiveEndTime())) {
            optResultList.add("\u7f16\u8f91\u89c4\u5219\u6709\u6548\u65f6\u95f4");
        }
        StrategyAutoCheckRuleEo strategyAutoCheckRuleEo = new StrategyAutoCheckRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)strategyAutoCheckRuleEo);
        AssertUtils.notNull((Object)strategyAutoCheckRuleEo.getId(), (String)"\u89c4\u5219id\u80fd\u4e3a\u7a7a\uff01");
        this.strategyAutoCheckRuleDomain.updateSelective((BaseEo)strategyAutoCheckRuleEo);
        List strategyTypeList = StrategyTypeEnum.getStrategyTypeList();
        for (StrategyTypeEnum strategyTypeEnum : strategyTypeList) {
            StrategyAutoCheckTypeEo strategyAutoCheckTypeEo = new StrategyAutoCheckTypeEo();
            Object value = ReflectionUtils.getMethodValue((Object)modifyReqDto, (String)strategyTypeEnum.getTag());
            if (value == null || !(value instanceof Integer)) continue;
            strategyAutoCheckTypeEo.setEnable((Integer)value);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(StrategyAutoCheckTypeEo::getRuleId, (Object)modifyReqDto.getId());
            queryWrapper.eq(StrategyAutoCheckTypeEo::getStrategyType, (Object)strategyTypeEnum.getStrategyType());
            StrategyAutoCheckTypeEo oldTypeEo = (StrategyAutoCheckTypeEo)this.strategyAutoCheckTypeDomain.getMapper().selectList((Wrapper)queryWrapper).get(0);
            if (!Objects.equals(oldTypeEo.getEnable(), strategyAutoCheckTypeEo.getEnable())) {
                String enableStr = strategyAutoCheckTypeEo.getEnable() == 1 ? "\u5f00\u542f" : "\u5173\u95ed";
                optResultList.add(enableStr + oldTypeEo.getStrategyTypeName());
            }
            QueryWrapBuilder queryWrapBuilder = new QueryWrapBuilder((BaseEo)strategyAutoCheckTypeEo);
            strategyAutoCheckTypeEo = (StrategyAutoCheckTypeEo)queryWrapBuilder.eq("rule_id", (Object)modifyReqDto.getId()).eq("strategy_type", (Object)strategyTypeEnum.getStrategyType()).builder();
            this.strategyAutoCheckTypeDomain.updateSelectiveSqlFilter((BaseEo)strategyAutoCheckTypeEo);
        }
        this.modifyStrategyConfItems(modifyReqDto, optResultList);
        this.modifyStrategyChannel(modifyReqDto, strategyAutoCheckRuleEo, optResultList);
        this.modifyStrategyOrderType(modifyReqDto, strategyAutoCheckRuleEo, optResultList);
        this.strategyOptLogService.batchAddOrderLogByOptResult(OrderOperationTypeEnum.MODIFYSTRATEGYAUTOCHECKRULE, strategyAutoCheckRuleEo.getId(), optResultList);
    }

    private void modifyStrategyChannel(BizStrategyAutoCheckRuleReqDto modifyReqDto, StrategyAutoCheckRuleEo strategyAutoCheckRuleEo, List<String> optResultList) {
        if (ChannelSelectedTypeEnum.ALL.getCode().equals(modifyReqDto.getChannelSelectedType())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckChannelEo::getRuleId, (Object)modifyReqDto.getId());
            List autoCheckChannelEos = this.strategyAutoCheckChannelDomain.getMapper().selectList((Wrapper)queryWrapper);
            List channelIdLis = Optional.ofNullable(autoCheckChannelEos).orElseGet(Collections::emptyList).stream().map(BaseEo::getId).collect(Collectors.toList());
            this.strategyAutoCheckChannelDomain.logicDeleteByIds(channelIdLis);
            List channelSelectTypeList = Optional.ofNullable(autoCheckChannelEos).orElseGet(Collections::emptyList).stream().map(StrategyAutoCheckChannelEo::getChannelSelectType).collect(Collectors.toList());
            if (!channelSelectTypeList.contains(ChannelSelectedTypeEnum.ALL.getCode())) {
                optResultList.add("\u9009\u62e9\u5168\u90e8\u6e20\u9053");
            }
            StrategyAutoCheckChannelEo checkChannelEo = new StrategyAutoCheckChannelEo();
            checkChannelEo.setRuleId(strategyAutoCheckRuleEo.getId());
            checkChannelEo.setChannelSelectType(ChannelSelectedTypeEnum.ALL.getCode());
            this.strategyAutoCheckChannelDomain.insert((BaseEo)checkChannelEo);
        } else {
            LambdaQueryWrapper queryAllWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryAllWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckChannelEo::getRuleId, (Object)modifyReqDto.getId())).eq(StrategyAutoCheckChannelEo::getChannelSelectType, (Object)ChannelSelectedTypeEnum.ALL.getCode());
            StrategyAutoCheckChannelEo allCheckChannelEo = (StrategyAutoCheckChannelEo)this.strategyAutoCheckChannelDomain.getMapper().selectOne((Wrapper)queryAllWrapper);
            if (allCheckChannelEo != null) {
                this.strategyAutoCheckChannelDomain.logicDeleteById(allCheckChannelEo.getId());
                optResultList.add("\u9009\u62e9\u90e8\u5206\u6e20\u9053");
            }
            if (Objects.nonNull(modifyReqDto.getApplyChannels())) {
                this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u9002\u7528\u6e20\u9053\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getApplyChannels()));
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getApplyChannels().getDelete())) {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckChannelEo::getRuleId, (Object)strategyAutoCheckRuleEo.getId())).in(StrategyAutoCheckChannelEo::getChannelCode, (Collection)modifyReqDto.getApplyChannels().getDelete());
                    List autoCheckChannelEos = this.strategyAutoCheckChannelDomain.getMapper().selectList((Wrapper)queryWrapper);
                    List channelIdLis = Optional.ofNullable(autoCheckChannelEos).orElseGet(Collections::emptyList).stream().map(BaseEo::getId).collect(Collectors.toList());
                    this.strategyAutoCheckChannelDomain.logicDeleteByIds(channelIdLis);
                }
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getApplyChannels().getAdd())) {
                    List autoCheckChannelEos = modifyReqDto.getApplyChannels().getAdd().stream().map(item -> {
                        StrategyAutoCheckChannelEo checkChannelEo = new StrategyAutoCheckChannelEo();
                        checkChannelEo.setRuleId(strategyAutoCheckRuleEo.getId());
                        checkChannelEo.setChannelCode(item);
                        checkChannelEo.setChannelSelectType(ChannelSelectedTypeEnum.PART.getCode());
                        return checkChannelEo;
                    }).collect(Collectors.toList());
                    this.strategyAutoCheckChannelDomain.insertBatch(autoCheckChannelEos);
                }
            }
        }
    }

    private void modifyStrategyOrderType(BizStrategyAutoCheckRuleReqDto modifyReqDto, StrategyAutoCheckRuleEo strategyAutoCheckRuleEo, List<String> optResultList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckOrderTypeEo::getRuleId, (Object)modifyReqDto.getId());
        List checkOrderTypeEos = this.strategyAutoCheckOrderTypeDomain.getMapper().selectList((Wrapper)queryWrapper);
        List idList = Optional.ofNullable(checkOrderTypeEos).orElseGet(Collections::emptyList).stream().map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(idList)) {
            this.strategyAutoCheckOrderTypeDomain.logicDeleteByIds(idList);
        }
        if (Objects.equals(modifyReqDto.getOrderTypeSelectedType(), ChannelSelectedTypeEnum.PART.getCode())) {
            List selectTypeList;
            this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u9002\u7528\u8ba2\u5355\u7c7b\u578b\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getApplyOrderType()));
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getApplyOrderType())) {
                List orderTypeEos = modifyReqDto.getApplyOrderType().stream().map(item -> {
                    StrategyAutoCheckOrderTypeEo orderTypeEo = new StrategyAutoCheckOrderTypeEo();
                    orderTypeEo.setRuleId(strategyAutoCheckRuleEo.getId());
                    orderTypeEo.setOrderType(item);
                    orderTypeEo.setSelectType(ChannelSelectedTypeEnum.PART.getCode());
                    return orderTypeEo;
                }).collect(Collectors.toList());
                this.strategyAutoCheckOrderTypeDomain.insertBatch(orderTypeEos);
            }
            if ((selectTypeList = Optional.ofNullable(checkOrderTypeEos).orElseGet(Collections::emptyList).stream().map(StrategyAutoCheckOrderTypeEo::getSelectType).collect(Collectors.toList())).contains(ChannelSelectedTypeEnum.ALL.getCode())) {
                optResultList.add("\u9009\u62e9\u90e8\u5206\u8ba2\u5355\u7c7b\u578b");
            }
        } else {
            StrategyAutoCheckOrderTypeEo orderTypeEo = new StrategyAutoCheckOrderTypeEo();
            orderTypeEo.setRuleId(strategyAutoCheckRuleEo.getId());
            orderTypeEo.setSelectType(ChannelSelectedTypeEnum.ALL.getCode());
            this.strategyAutoCheckOrderTypeDomain.insert((BaseEo)orderTypeEo);
            List selectTypeList = Optional.ofNullable(checkOrderTypeEos).orElseGet(Collections::emptyList).stream().map(StrategyAutoCheckOrderTypeEo::getSelectType).collect(Collectors.toList());
            if (selectTypeList.contains(ChannelSelectedTypeEnum.PART.getCode())) {
                optResultList.add("\u9009\u62e9\u5168\u90e8\u8ba2\u5355\u7c7b\u578b");
            }
        }
    }

    private void modifyStrategyConfItems(BizStrategyAutoCheckRuleReqDto modifyReqDto, List<String> optResultList) {
        StrategyAutoCheckConfEo updateEo;
        LambdaQueryWrapper queryAuditTimeWrapper;
        if (modifyReqDto.getDelayAuditType() != null || modifyReqDto.getDelayAuditValue() != null) {
            this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u8bbe\u7f6e\u5ef6\u65f6\u5ba1\u6838\uff1a{}", (Object)modifyReqDto.getDelayAuditValue());
            queryAuditTimeWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryAuditTimeWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckConfEo::getRuleId, (Object)modifyReqDto.getId())).eq(StrategyAutoCheckConfEo::getStrategyType, (Object)StrategyTypeEnum.DELAY_AUDIT.getStrategyType());
            StrategyAutoCheckConfEo auditTimeConfEo = (StrategyAutoCheckConfEo)this.strategyAutoCheckConfDomain.getMapper().selectOne((Wrapper)queryAuditTimeWrapper);
            if (auditTimeConfEo == null) {
                auditTimeConfEo = new StrategyAutoCheckConfEo();
                auditTimeConfEo.setRuleId(modifyReqDto.getId());
                auditTimeConfEo.setStrategyType(StrategyTypeEnum.DELAY_AUDIT.getStrategyType());
                AuditTimeTypeEnum timeTypeEnum = AuditTimeTypeEnum.enumOf((String)modifyReqDto.getDelayAuditType());
                auditTimeConfEo.setStrategyValue(timeTypeEnum.getType());
                auditTimeConfEo.setStrategyValue2(modifyReqDto.getDelayAuditValue().toString());
                this.strategyAutoCheckConfDomain.insert((BaseEo)auditTimeConfEo);
            } else {
                updateEo = new StrategyAutoCheckConfEo();
                updateEo.setId(auditTimeConfEo.getId());
                if (modifyReqDto.getDelayAuditType() != null) {
                    updateEo.setStrategyValue(modifyReqDto.getDelayAuditType());
                }
                if (modifyReqDto.getDelayAuditValue() != null) {
                    updateEo.setStrategyValue2(modifyReqDto.getDelayAuditValue().toString());
                }
                this.strategyAutoCheckConfDomain.updateSelective((BaseEo)updateEo);
            }
            optResultList.add("\u4fee\u6539\u5ef6\u65f6\u5ba1\u6838:\u3010" + AuditTimeTypeEnum.enumOf((String)modifyReqDto.getDelayAuditType()).getDesc() + ":" + modifyReqDto.getDelayAuditValue().toString() + "\u3011");
        }
        if (modifyReqDto.getAmountRangeMinimum() != null || modifyReqDto.getAmountRangeMaximum() != null) {
            this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u6307\u5b9a\u91d1\u989d\u533a\u95f4\uff1a{},{}", (Object)modifyReqDto.getAmountRangeMinimum(), (Object)modifyReqDto.getAmountRangeMaximum());
            LambdaQueryWrapper queryAmountRangeWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryAmountRangeWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckConfEo::getRuleId, (Object)modifyReqDto.getId())).eq(StrategyAutoCheckConfEo::getStrategyType, (Object)StrategyTypeEnum.AMOUNT_RANGE_AUDIT.getStrategyType());
            StrategyAutoCheckConfEo amountRangeConfEo = (StrategyAutoCheckConfEo)this.strategyAutoCheckConfDomain.getMapper().selectOne((Wrapper)queryAmountRangeWrapper);
            if (amountRangeConfEo == null) {
                amountRangeConfEo = new StrategyAutoCheckConfEo();
                amountRangeConfEo.setRuleId(modifyReqDto.getId());
                amountRangeConfEo.setStrategyType(StrategyTypeEnum.AMOUNT_RANGE_AUDIT.getStrategyType());
                amountRangeConfEo.setStrategyValue(modifyReqDto.getAmountRangeMinimum().toString());
                amountRangeConfEo.setStrategyValue2(modifyReqDto.getAmountRangeMaximum().toString());
                this.strategyAutoCheckConfDomain.insert((BaseEo)amountRangeConfEo);
            } else {
                updateEo = new StrategyAutoCheckConfEo();
                updateEo.setId(amountRangeConfEo.getId());
                if (modifyReqDto.getAmountRangeMinimum() != null) {
                    updateEo.setStrategyValue(modifyReqDto.getAmountRangeMinimum().toString());
                }
                if (modifyReqDto.getAmountRangeMaximum() != null) {
                    updateEo.setStrategyValue2(modifyReqDto.getAmountRangeMaximum().toString());
                }
                this.strategyAutoCheckConfDomain.updateSelective((BaseEo)updateEo);
            }
            optResultList.add("\u6307\u5b9a\u91d1\u989d\u533a\u95f4:\u3010" + modifyReqDto.getAmountRangeMinimum() + "-" + modifyReqDto.getAmountRangeMaximum() + "\u3011");
        }
        if (Objects.nonNull(modifyReqDto.getLogicalWarehouseCodeOfAudit())) {
            this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u6307\u5b9a\u903b\u8f91\u4ed3\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getLogicalWarehouseCodeOfAudit()));
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getLogicalWarehouseCodeOfAudit().getDelete())) {
                this.deleteConfs(modifyReqDto, modifyReqDto.getLogicalWarehouseCodeOfAudit().getDelete(), StrategyTypeEnum.LOGICAL_WAREHOUSE_AUDIT);
                optResultList.add("\u5220\u9664\u903b\u8f91\u4ed3:\u3010" + modifyReqDto.getLogicalWarehouseCodeOfAudit().getDelete().stream().collect(Collectors.joining(",")) + "\u3011");
            }
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getLogicalWarehouseCodeOfAudit().getAdd())) {
                this.addStrategyConfs(modifyReqDto, modifyReqDto.getLogicalWarehouseCodeOfAudit().getAdd(), StrategyTypeEnum.LOGICAL_WAREHOUSE_AUDIT);
                optResultList.add("\u6dfb\u52a0\u903b\u8f91\u4ed3:\u3010" + modifyReqDto.getLogicalWarehouseCodeOfAudit().getAdd().stream().collect(Collectors.joining(",")) + "\u3011");
            }
        }
        if (Objects.nonNull(modifyReqDto.getGoodsOfAudit())) {
            this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u6307\u5b9a\u5546\u54c1\u957f\u7f16\u7801\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getGoodsOfAudit()));
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getGoodsOfAudit().getDelete())) {
                this.deleteConfs(modifyReqDto, modifyReqDto.getGoodsOfAudit().getDelete(), StrategyTypeEnum.GOODS_AUDIT);
                optResultList.add("\u5220\u9664\u5546\u54c1\u957f\u7f16\u7801:\u3010" + modifyReqDto.getGoodsOfAudit().getDelete().stream().collect(Collectors.joining(",")) + "\u3011");
            }
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getGoodsOfAudit().getAdd())) {
                this.addStrategyConfs(modifyReqDto, modifyReqDto.getGoodsOfAudit().getAdd(), StrategyTypeEnum.GOODS_AUDIT);
                optResultList.add("\u6dfb\u52a0\u5546\u54c1\u957f\u7f16\u7801:\u3010" + modifyReqDto.getGoodsOfAudit().getAdd().stream().collect(Collectors.joining(",")) + "\u3011");
            }
        }
        if (Objects.nonNull(modifyReqDto.getCustomerIdOfAudit())) {
            this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u6307\u5b9a\u5ba2\u6237\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getCustomerIdOfAudit()));
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getCustomerIdOfAudit().getDelete())) {
                this.deleteConfs(modifyReqDto, modifyReqDto.getCustomerIdOfAudit().getDelete(), StrategyTypeEnum.CUSTOMER_AUDIT);
                optResultList.add("\u5220\u9664\u5ba2\u6237:\u3010" + modifyReqDto.getCustomerIdOfAudit().getDelete().stream().collect(Collectors.joining(",")) + "\u3011");
            }
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getCustomerIdOfAudit().getAdd())) {
                this.addStrategyConfs(modifyReqDto, modifyReqDto.getCustomerIdOfAudit().getAdd(), StrategyTypeEnum.CUSTOMER_AUDIT);
                optResultList.add("\u6dfb\u52a0\u5ba2\u6237:\u3010" + modifyReqDto.getCustomerIdOfAudit().getAdd().stream().collect(Collectors.joining(",")) + "\u3011");
            }
        }
        if (Objects.nonNull(modifyReqDto.getAreaOfAudit())) {
            this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u6307\u5b9a\u533a\u57df\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getAreaOfAudit()));
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getAreaOfAudit().getDelete())) {
                this.deleteConfs(modifyReqDto, modifyReqDto.getAreaOfAudit().getDelete(), StrategyTypeEnum.AREA_AUDIT);
                optResultList.add("\u5220\u9664\u533a\u57df:\u3010" + modifyReqDto.getAreaOfAudit().getDelete().stream().collect(Collectors.joining(",")) + "\u3011");
            }
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getAreaOfAudit().getAdd())) {
                this.addStrategyConfs(modifyReqDto, modifyReqDto.getAreaOfAudit().getAdd(), StrategyTypeEnum.AREA_AUDIT);
                optResultList.add("\u65b0\u589e\u533a\u57df:\u3010" + modifyReqDto.getAreaOfAudit().getAdd().stream().collect(Collectors.joining(",")) + "\u3011");
            }
        }
        if (Objects.nonNull(modifyReqDto.getBuyerRemark())) {
            this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u4e70\u5bb6\u5907\u6ce8\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getBuyerRemark()));
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getBuyerRemark().getDelete())) {
                this.deleteConfs(modifyReqDto, modifyReqDto.getBuyerRemark().getDelete(), StrategyTypeEnum.BUYER_REMARK_AUDIT);
                optResultList.add("\u5220\u9664\u4e70\u5bb6\u5907\u6ce8:\u3010" + modifyReqDto.getBuyerRemark().getDelete().stream().collect(Collectors.joining(",")) + "\u3011");
            }
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getBuyerRemark().getAdd())) {
                this.addStrategyConfs(modifyReqDto, modifyReqDto.getBuyerRemark().getAdd(), StrategyTypeEnum.BUYER_REMARK_AUDIT);
                optResultList.add("\u6dfb\u52a0\u4e70\u5bb6\u5907\u6ce8:\u3010" + modifyReqDto.getBuyerRemark().getAdd().stream().collect(Collectors.joining(",")) + "\u3011");
            }
        }
        if (Objects.nonNull(modifyReqDto.getSellerRemark())) {
            this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u5356\u5bb6\u5907\u6ce8\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getSellerRemark()));
            queryAuditTimeWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryAuditTimeWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckConfEo::getRuleId, (Object)modifyReqDto.getId())).eq(StrategyAutoCheckConfEo::getStrategyType, (Object)StrategyTypeEnum.SELLER_REMARK_AUDIT.getStrategyType());
            StrategyAutoCheckConfEo sellerRemarkEo = (StrategyAutoCheckConfEo)this.strategyAutoCheckConfDomain.getMapper().selectOne((Wrapper)queryAuditTimeWrapper);
            if (sellerRemarkEo == null) {
                sellerRemarkEo = new StrategyAutoCheckConfEo();
                sellerRemarkEo.setRuleId(modifyReqDto.getId());
                sellerRemarkEo.setStrategyType(StrategyTypeEnum.SELLER_REMARK_AUDIT.getStrategyType());
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSellerRemark().getAdd())) {
                    sellerRemarkEo.setStrategyValue((String)modifyReqDto.getSellerRemark().getAdd().get(0));
                    optResultList.add("\u6dfb\u52a0\u4e70\u5bb6\u5907\u6ce8:\u3010" + sellerRemarkEo.getStrategyValue() + "\u3011");
                }
                sellerRemarkEo.setStrategyValue2(modifyReqDto.getSellerRemark().getSellerRemarkKeyFlag());
                this.strategyAutoCheckConfDomain.insert((BaseEo)sellerRemarkEo);
            } else {
                optResultList.add("\u5220\u9664\u4e70\u5bb6\u5907\u6ce8:\u3010" + sellerRemarkEo.getStrategyValue() + "\u3011");
                updateEo = new StrategyAutoCheckConfEo();
                updateEo.setId(sellerRemarkEo.getId());
                if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getSellerRemark().getAdd())) {
                    updateEo.setStrategyValue((String)modifyReqDto.getSellerRemark().getAdd().get(0));
                    optResultList.add("\u6dfb\u52a0\u4e70\u5bb6\u5907\u6ce8:\u3010" + updateEo.getStrategyValue() + "\u3011");
                }
                updateEo.setStrategyValue2(modifyReqDto.getSellerRemark().getSellerRemarkKeyFlag());
                this.strategyAutoCheckConfDomain.updateSelective((BaseEo)updateEo);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)modifyReqDto.getSellerAutoRemark())) {
            this.logger.info("[\u4fee\u6539\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u4fee\u6539\u5356\u5bb6\u5907\u6ce8\u81ea\u52a8\u5ba1\u6838\uff1a{}", (Object)modifyReqDto.getSellerAutoRemark());
            LambdaQueryWrapper queryAutoRemarkWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryAutoRemarkWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckConfEo::getRuleId, (Object)modifyReqDto.getId())).eq(StrategyAutoCheckConfEo::getStrategyType, (Object)StrategyTypeEnum.SELLER_REMARK_AUTO_AUDIT.getStrategyType());
            StrategyAutoCheckConfEo sellerAutoRemarkEo = (StrategyAutoCheckConfEo)this.strategyAutoCheckConfDomain.getMapper().selectOne((Wrapper)queryAutoRemarkWrapper);
            if (sellerAutoRemarkEo == null) {
                sellerAutoRemarkEo = new StrategyAutoCheckConfEo();
                sellerAutoRemarkEo.setRuleId(modifyReqDto.getId());
                sellerAutoRemarkEo.setStrategyType(StrategyTypeEnum.SELLER_REMARK_AUTO_AUDIT.getStrategyType());
                sellerAutoRemarkEo.setStrategyValue(modifyReqDto.getSellerAutoRemark());
                sellerAutoRemarkEo.setStrategyValue2("1");
                this.strategyAutoCheckConfDomain.insert((BaseEo)sellerAutoRemarkEo);
                optResultList.add("\u6dfb\u52a0\u5356\u5bb6\u5907\u6ce8\u81ea\u52a8\u5ba1\u6838:\u3010" + modifyReqDto.getSellerAutoRemark() + "\u3011");
            } else {
                optResultList.add("\u5220\u9664\u5356\u5bb6\u5907\u6ce8\u81ea\u52a8\u5ba1\u6838:\u3010" + sellerAutoRemarkEo.getStrategyValue() + "\u3011");
                updateEo = new StrategyAutoCheckConfEo();
                updateEo.setId(sellerAutoRemarkEo.getId());
                updateEo.setStrategyValue(modifyReqDto.getSellerAutoRemark());
                updateEo.setStrategyValue2("1");
                this.strategyAutoCheckConfDomain.updateSelective((BaseEo)updateEo);
                optResultList.add("\u4fee\u6539\u5356\u5bb6\u5907\u6ce8\u81ea\u52a8\u5ba1\u6838:\u3010" + modifyReqDto.getSellerAutoRemark() + "\u3011");
            }
        }
    }

    private void deleteConfs(BizStrategyAutoCheckRuleReqDto modifyReqDto, List<String> deleteIds, StrategyTypeEnum strategyTypeEnum) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckConfEo::getRuleId, (Object)modifyReqDto.getId())).eq(StrategyAutoCheckConfEo::getStrategyType, (Object)strategyTypeEnum.getStrategyType())).in(StrategyAutoCheckConfEo::getStrategyValue, deleteIds);
        List strategyAutoCheckConfEos = this.strategyAutoCheckConfDomain.getMapper().selectList((Wrapper)queryWrapper);
        List confIdList = Optional.ofNullable(strategyAutoCheckConfEos).orElseGet(Collections::emptyList).stream().map(BaseEo::getId).collect(Collectors.toList());
        this.strategyAutoCheckConfDomain.logicDeleteByIds(confIdList);
    }

    private void addStrategyConfs(BizStrategyAutoCheckRuleReqDto modifyReqDto, List<String> confList, StrategyTypeEnum strategyTypeEnum) {
        ArrayList insertBatchConfList = Lists.newArrayList();
        confList.forEach(item -> {
            StrategyAutoCheckConfEo goodsCodeEo = new StrategyAutoCheckConfEo();
            goodsCodeEo.setRuleId(modifyReqDto.getId());
            goodsCodeEo.setStrategyType(strategyTypeEnum.getStrategyType());
            goodsCodeEo.setStrategyValue(item);
            insertBatchConfList.add(goodsCodeEo);
        });
        this.strategyAutoCheckConfDomain.insertBatch((List)insertBatchConfList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStrategyAutoCheckRule(String id) {
        AssertUtils.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Boolean effective = this.checkRuleEffective(Long.valueOf(id));
        if (effective.booleanValue()) {
            throw PcpTradeExceptionCode.STRATEGY_NOT_ALLOW_REMOVE.builderException();
        }
        this.strategyAutoCheckRuleDomain.logicDeleteById(Long.valueOf(id));
    }

    @Override
    public StrategyAutoCheckRuleDetailRespDto queryById(Long id) {
        AssertUtils.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        StrategyAutoCheckRuleEo strategyAutoCheckRuleEo = (StrategyAutoCheckRuleEo)this.strategyAutoCheckRuleDomain.selectByPrimaryKey(id);
        StrategyAutoCheckRuleDetailRespDto strategyAutoCheckRuleRespDto = new StrategyAutoCheckRuleDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)strategyAutoCheckRuleEo, (BaseVo)strategyAutoCheckRuleRespDto);
        LambdaQueryWrapper queryCheckTypeWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryCheckTypeWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckTypeEo::getRuleId, (Object)strategyAutoCheckRuleEo.getId());
        List checkTypeEos = this.strategyAutoCheckTypeDomain.getMapper().selectList((Wrapper)queryCheckTypeWrapper);
        for (StrategyAutoCheckTypeEo autoCheckTypeEo : checkTypeEos) {
            StrategyTypeEnum strategyTypeEnum = StrategyTypeEnum.enumOf((String)autoCheckTypeEo.getStrategyType());
            ReflectionUtils.setMethod((Object)strategyAutoCheckRuleRespDto, (String)strategyTypeEnum.getTag(), (Object)autoCheckTypeEo.getEnable());
        }
        this.populateConfs(strategyAutoCheckRuleEo, strategyAutoCheckRuleRespDto);
        LambdaQueryWrapper queryChannelWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryChannelWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckChannelEo::getRuleId, (Object)strategyAutoCheckRuleEo.getId());
        List autoCheckChannelEos = this.strategyAutoCheckChannelDomain.getMapper().selectList((Wrapper)queryChannelWrapper);
        if (CollectionUtils.isNotEmpty((Collection)autoCheckChannelEos)) {
            StrategyAutoCheckChannelEo strategyAutoCheckChannelEo = (StrategyAutoCheckChannelEo)autoCheckChannelEos.get(0);
            if (ChannelSelectedTypeEnum.ALL.getCode().equals(strategyAutoCheckChannelEo.getChannelSelectType())) {
                strategyAutoCheckRuleRespDto.setChannelSelectedType(ChannelSelectedTypeEnum.ALL.getCode());
            } else {
                List channelCodeList = autoCheckChannelEos.stream().map(StrategyAutoCheckChannelEo::getChannelCode).collect(Collectors.toList());
                PcpOrderChannelReqDto orderChannelReqDto = new PcpOrderChannelReqDto();
                orderChannelReqDto.setChannelCodes(channelCodeList);
                RestResponse listRestResponse = this.orderChannelQueryApi.queryByShopChannel(orderChannelReqDto);
                List orderChannelRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
                ArrayList saleOrderChannelRespDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)saleOrderChannelRespDtos, (Collection)orderChannelRespDtos, BizSaleOrderChannelRespDto.class);
                strategyAutoCheckRuleRespDto.setApplyChannels((List)saleOrderChannelRespDtos);
                strategyAutoCheckRuleRespDto.setChannelSelectedType(ChannelSelectedTypeEnum.PART.getCode());
            }
        }
        LambdaQueryWrapper queryOrderTypeWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderTypeWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckOrderTypeEo::getRuleId, (Object)strategyAutoCheckRuleEo.getId());
        List orderTypeEos = this.strategyAutoCheckOrderTypeDomain.getMapper().selectList((Wrapper)queryOrderTypeWrapper);
        if (CollectionUtils.isNotEmpty((Collection)orderTypeEos)) {
            StrategyAutoCheckOrderTypeEo checkOrderTypeEo = (StrategyAutoCheckOrderTypeEo)orderTypeEos.get(0);
            if (ChannelSelectedTypeEnum.ALL.getCode().equals(checkOrderTypeEo.getSelectType())) {
                strategyAutoCheckRuleRespDto.setOrderTypeSelectedType(ChannelSelectedTypeEnum.ALL.getCode());
            } else {
                List orderTypeList = orderTypeEos.stream().map(StrategyAutoCheckOrderTypeEo::getOrderType).collect(Collectors.toList());
                strategyAutoCheckRuleRespDto.setApplyOrderType(orderTypeList);
                strategyAutoCheckRuleRespDto.setOrderTypeSelectedType(ChannelSelectedTypeEnum.PART.getCode());
            }
        }
        return strategyAutoCheckRuleRespDto;
    }

    private void populateConfs(StrategyAutoCheckRuleEo strategyAutoCheckRuleEo, StrategyAutoCheckRuleDetailRespDto strategyAutoCheckRuleRespDto) {
        LambdaQueryWrapper queryConfWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryConfWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckConfEo::getRuleId, (Object)strategyAutoCheckRuleEo.getId());
        List autoCheckConfEos = this.strategyAutoCheckConfDomain.getMapper().selectList((Wrapper)queryConfWrapper);
        if (CollectionUtils.isNotEmpty((Collection)autoCheckConfEos)) {
            List<StrategyAutoCheckConfEo> sellerAutoRemarkConfEoList;
            List<StrategyAutoCheckConfEo> sellerRemarkConfEoList;
            List<StrategyAutoCheckConfEo> areaConfEoList;
            List<StrategyAutoCheckConfEo> customerConfEoList;
            List<StrategyAutoCheckConfEo> goodsConfEoList;
            List<StrategyAutoCheckConfEo> logicalWarehouseConfEoList;
            List<StrategyAutoCheckConfEo> amountRangeConfEoList;
            Map<String, List<StrategyAutoCheckConfEo>> groupTypeListMap = autoCheckConfEos.stream().collect(Collectors.groupingBy(StrategyAutoCheckConfEo::getStrategyType));
            List<StrategyAutoCheckConfEo> strategyAutoCheckConfEoList = groupTypeListMap.get(StrategyTypeEnum.DELAY_AUDIT.getStrategyType());
            if (CollectionUtils.isNotEmpty(strategyAutoCheckConfEoList)) {
                StrategyAutoCheckConfEo delayAuditConfEo = strategyAutoCheckConfEoList.get(0);
                strategyAutoCheckRuleRespDto.setDelayAuditType(delayAuditConfEo.getStrategyValue());
                strategyAutoCheckRuleRespDto.setDelayAuditValue(new BigDecimal(delayAuditConfEo.getStrategyValue2()));
            }
            if (CollectionUtils.isNotEmpty(amountRangeConfEoList = groupTypeListMap.get(StrategyTypeEnum.AMOUNT_RANGE_AUDIT.getStrategyType()))) {
                StrategyAutoCheckConfEo amountRangeConfEo = amountRangeConfEoList.get(0);
                strategyAutoCheckRuleRespDto.setAmountRangeMinimum(amountRangeConfEo.getStrategyValue() != null ? new BigDecimal(amountRangeConfEo.getStrategyValue()) : null);
                strategyAutoCheckRuleRespDto.setAmountRangeMaximum(amountRangeConfEo.getStrategyValue2() != null ? new BigDecimal(amountRangeConfEo.getStrategyValue2()) : null);
            }
            if (CollectionUtils.isNotEmpty(logicalWarehouseConfEoList = groupTypeListMap.get(StrategyTypeEnum.LOGICAL_WAREHOUSE_AUDIT.getStrategyType()))) {
                List warehouseCodeList = logicalWarehouseConfEoList.stream().map(StrategyAutoCheckConfEo::getStrategyValue).collect(Collectors.toList());
                RestResponse listRestResponse = this.logicWarehouseExposedQueryApi.queryList(warehouseCodeList);
                List logicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
                ArrayList logicWarehouseRespDtos = new ArrayList();
                CubeBeanUtils.copyCollection(logicWarehouseRespDtos, (Collection)logicWarehousePageRespDtos, BizLogicWarehouseRespDto.class);
                strategyAutoCheckRuleRespDto.setLogicalWarehouseCodeList(logicWarehouseRespDtos);
            }
            if (CollectionUtils.isNotEmpty(goodsConfEoList = groupTypeListMap.get(StrategyTypeEnum.GOODS_AUDIT.getStrategyType()))) {
                List longCodeList = goodsConfEoList.stream().map(StrategyAutoCheckConfEo::getStrategyValue).collect(Collectors.toList());
                List itemSkuRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.queryBySkuCode(longCodeList));
                ArrayList goodsLongCodeList = Lists.newArrayList();
                for (ItemSkuRespDto itemSkuRespDto : itemSkuRespDtoList) {
                    BizItemRespDto bizItemRespDto = new BizItemRespDto();
                    bizItemRespDto.setCode(itemSkuRespDto.getCode());
                    bizItemRespDto.setName(itemSkuRespDto.getName());
                    bizItemRespDto.setLongCode(itemSkuRespDto.getCode());
                    goodsLongCodeList.add(bizItemRespDto);
                }
                strategyAutoCheckRuleRespDto.setGoodsList((List)goodsLongCodeList);
            }
            if (CollectionUtils.isNotEmpty(customerConfEoList = groupTypeListMap.get(StrategyTypeEnum.CUSTOMER_AUDIT.getStrategyType()))) {
                List customerIds = customerConfEoList.stream().map(StrategyAutoCheckConfEo::getStrategyValue).map(Long::valueOf).collect(Collectors.toList());
                PCPCustomerSearchReqDto customerSearchReqDto = new PCPCustomerSearchReqDto();
                customerSearchReqDto.setIds(customerIds);
                RestResponse listRestResponse = this.customerQueryApi.queryPCPCustomerDetail(customerSearchReqDto);
                List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
                ArrayList customerRespDtoList = new ArrayList();
                CubeBeanUtils.copyCollection(customerRespDtoList, (Collection)customerRespDtos, BizCustomerRespDto.class);
                strategyAutoCheckRuleRespDto.setCustomerList(customerRespDtoList);
            }
            if (CollectionUtils.isNotEmpty(areaConfEoList = groupTypeListMap.get(StrategyTypeEnum.AREA_AUDIT.getStrategyType()))) {
                List areaCodeList = areaConfEoList.stream().map(StrategyAutoCheckConfEo::getStrategyValue).collect(Collectors.toList());
                PcpRegionReqDto reqDto = new PcpRegionReqDto();
                reqDto.setCodes(areaCodeList);
                RestResponse listRestResponse = this.regionQueryApi.queryByList(reqDto);
                List regionRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
                ArrayList respDtoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)respDtoList, (Collection)regionRespDtos, BizRegionRespDto.class);
                strategyAutoCheckRuleRespDto.setAreaOfAudit((List)respDtoList);
            }
            if (CollectionUtils.isNotEmpty(sellerRemarkConfEoList = groupTypeListMap.get(StrategyTypeEnum.SELLER_REMARK_AUDIT.getStrategyType()))) {
                StrategyAutoCheckConfEo sellerRemarkConfEo = sellerRemarkConfEoList.get(0);
                strategyAutoCheckRuleRespDto.setSellerRemarkKeyWords(sellerRemarkConfEo.getStrategyValue());
                strategyAutoCheckRuleRespDto.setSellerRemarkKeyFlag(sellerRemarkConfEo.getStrategyValue2());
            }
            if (CollectionUtils.isNotEmpty(sellerAutoRemarkConfEoList = groupTypeListMap.get(StrategyTypeEnum.SELLER_REMARK_AUTO_AUDIT.getStrategyType()))) {
                StrategyAutoCheckConfEo sellerAutoRemarkConfEo = sellerAutoRemarkConfEoList.get(0);
                strategyAutoCheckRuleRespDto.setSellerAutoRemarkKeyWords(sellerAutoRemarkConfEo.getStrategyValue());
                strategyAutoCheckRuleRespDto.setSellerAutoRemarkKeyFlag(sellerAutoRemarkConfEo.getStrategyValue2());
            }
        }
    }

    @Override
    public PageInfo<StrategyAutoCheckRuleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StrategyAutoCheckRuleReqDto strategyAutoCheckRuleReqDto = (StrategyAutoCheckRuleReqDto)JSON.parseObject((String)filter, StrategyAutoCheckRuleReqDto.class);
        StrategyAutoCheckRuleEo strategyAutoCheckRuleEo = new StrategyAutoCheckRuleEo();
        DtoHelper.dto2Eo((BaseVo)strategyAutoCheckRuleReqDto, (BaseEo)strategyAutoCheckRuleEo);
        PageInfo eoPageInfo = this.strategyAutoCheckRuleDomain.selectPage((BaseEo)strategyAutoCheckRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StrategyAutoCheckRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void modifyStrategyRuleStatus(Long ruleId, Integer status) {
        AssertUtils.notNull((Object)ruleId, (String)"ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)status, (String)"status\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        StrategyEnableEnum enableEnum = StrategyEnableEnum.enumOf((Integer)status);
        StrategyAutoCheckRuleEo updateEo = new StrategyAutoCheckRuleEo();
        updateEo.setId(ruleId);
        updateEo.setRuleStatus(enableEnum.getType());
        this.strategyAutoCheckRuleDomain.updateSelective((BaseEo)updateEo);
        TrackOptLogUtils.addOrderTrackOptLog((Long)ruleId, (String)("\u4fee\u6539\u81ea\u52a8\u7b56\u7565\u72b6\u6001:" + enableEnum.getDesc()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long copyRule(Long ruleId) {
        AssertUtils.notNull((Object)ruleId, (String)"ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        StrategyAutoCheckRuleEo strategyAutoCheckRuleEo = (StrategyAutoCheckRuleEo)this.strategyAutoCheckRuleDomain.selectByPrimaryKey(ruleId);
        AssertUtils.notNull((Object)strategyAutoCheckRuleEo, (String)String.format("ruleId=%s\u7684\u89c4\u5219\u4e0d\u5b58\u5728\uff01", ruleId));
        strategyAutoCheckRuleEo.setRuleName(strategyAutoCheckRuleEo.getRuleName() + "-copy");
        strategyAutoCheckRuleEo.setRuleCode(this.noGreateUtil.generateRuleNo());
        this.restData(strategyAutoCheckRuleEo);
        this.strategyAutoCheckRuleDomain.insert((BaseEo)strategyAutoCheckRuleEo);
        LambdaQueryWrapper queryTypeEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryTypeEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckTypeEo::getRuleId, (Object)ruleId);
        List autoCheckTypeEos = this.strategyAutoCheckTypeDomain.getMapper().selectList((Wrapper)queryTypeEo);
        AssertUtils.notNull((Object)autoCheckTypeEos, (String)String.format("ruleId=%s\u7684\u89c4\u5219\u7684\u914d\u7f6e\u9879\u5b58\u5728\u5f02\u5e38\uff01", ruleId));
        autoCheckTypeEos.forEach(item -> {
            this.restData(item);
            item.setRuleId(strategyAutoCheckRuleEo.getId());
        });
        this.strategyAutoCheckTypeDomain.insertBatch(autoCheckTypeEos);
        LambdaQueryWrapper queryConfEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryConfEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckConfEo::getRuleId, (Object)ruleId);
        List checkConfEos = this.strategyAutoCheckConfDomain.getMapper().selectList((Wrapper)queryConfEo);
        if (CollectionUtils.isNotEmpty((Collection)checkConfEos)) {
            this.logger.info("[copy\u89c4\u5219]\u8fdb\u884ccopy\u914d\u7f6e\u9879");
            checkConfEos.forEach(item -> {
                this.restData(item);
                item.setRuleId(strategyAutoCheckRuleEo.getId());
            });
            this.strategyAutoCheckConfDomain.insertBatch(checkConfEos);
        }
        LambdaQueryWrapper queryChannelEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryChannelEo.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckChannelEo::getRuleId, (Object)ruleId);
        List checkChannelEos = this.strategyAutoCheckChannelDomain.getMapper().selectList((Wrapper)queryChannelEo);
        if (CollectionUtils.isNotEmpty((Collection)checkChannelEos)) {
            checkChannelEos.forEach(item -> {
                this.restData(item);
                item.setRuleId(strategyAutoCheckRuleEo.getId());
            });
            this.strategyAutoCheckChannelDomain.insertBatch(checkChannelEos);
        }
        LambdaQueryWrapper queryOrderType = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderType.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckOrderTypeEo::getRuleId, (Object)ruleId);
        List orderTypeEos = this.strategyAutoCheckOrderTypeDomain.getMapper().selectList((Wrapper)queryOrderType);
        if (CollectionUtils.isNotEmpty((Collection)orderTypeEos)) {
            orderTypeEos.forEach(item -> {
                this.restData(item);
                item.setRuleId(strategyAutoCheckRuleEo.getId());
            });
            this.strategyAutoCheckOrderTypeDomain.insertBatch(orderTypeEos);
        }
        TrackOptLogUtils.addOrderTrackOptLog((Long)strategyAutoCheckRuleEo.getId(), (String)"copy\u81ea\u52a8\u7b56\u7565");
        return strategyAutoCheckRuleEo.getId();
    }

    @Override
    @TrackLogNode(nodeBizDefine=TrackLogBizDefine.BIZ_OPERATION_LOG, nodeBizCode="saleOrder")
    public Boolean checkOrderCanAutoCheck(String orderNo) {
        AssertUtils.notBlank((String)orderNo, (String)"orderNo\u4e0d\u80fd\u4e3a\u7a7a");
        BizSaleOrderRespDto saleOrderRespDto = this.saleOrderService.queryByOrderNo(orderNo);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)String.format("orderNo=%s\u7684\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728", orderNo));
        this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u8ba2\u5355\uff08orderNo={}\uff09\u8ba2\u5355\u7684\u8be6\u60c5\u4e3a\uff1a{}", (Object)orderNo, (Object)JSON.toJSONString((Object)saleOrderRespDto));
        StrategyRuleQueryVo strategyRuleQueryVo = new StrategyRuleQueryVo();
        strategyRuleQueryVo.setChannelCode(saleOrderRespDto.getChannelCode());
        strategyRuleQueryVo.setRuleStatus(StrategyEnableEnum.ENABLE.getType());
        List ruleEoList = this.strategyAutoCheckRuleDomain.selectValidRuleList(strategyRuleQueryVo);
        if (CollectionUtils.isNotEmpty((Collection)ruleEoList)) {
            List ruleIdList = ruleEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryOrderTypeWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryOrderTypeWrapper.eq(BaseEo::getDr, (Object)0)).in(StrategyAutoCheckOrderTypeEo::getRuleId, ruleIdList);
            List orderTypeEos = this.strategyAutoCheckOrderTypeDomain.getMapper().selectList((Wrapper)queryOrderTypeWrapper);
            if (CollectionUtils.isNotEmpty((Collection)orderTypeEos)) {
                ArrayList hitRuleIdList = Lists.newArrayList();
                for (StrategyAutoCheckOrderTypeEo checkOrderTypeEo : orderTypeEos) {
                    if (ChannelSelectedTypeEnum.ALL.getCode().equals(checkOrderTypeEo.getSelectType())) {
                        hitRuleIdList.add(checkOrderTypeEo.getRuleId());
                    }
                    if (!ChannelSelectedTypeEnum.PART.getCode().equals(checkOrderTypeEo.getSelectType()) || !Objects.equals(saleOrderRespDto.getOrderType(), checkOrderTypeEo.getOrderType())) continue;
                    hitRuleIdList.add(checkOrderTypeEo.getRuleId());
                }
                this.logger.info("\u547d\u4e2d\u8ba2\u5355\u7c7b\u578b\u89c4\u5219:{}", (Object)JSON.toJSONString((Object)hitRuleIdList));
                ruleEoList = ruleEoList.stream().filter(ruleEo -> hitRuleIdList.contains(ruleEo.getId())).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isEmpty((Collection)ruleEoList)) {
            this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u8ba2\u5355\uff08orderNo={}\uff09\u6ca1\u6709\u547d\u4e2d\u81ea\u52a8\u786e\u8ba4\u89c4\u5219\uff01", (Object)orderNo);
            MessageVo messageVo = new MessageVo();
            SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
            saleTradeMessageVo.setOrderId(saleOrderRespDto.getId());
            saleTradeMessageVo.setOrderNo(saleOrderRespDto.getSaleOrderNo());
            saleTradeMessageVo.setNextOptType(NextOptTypeEnum.SALE_ORDER_CHECK.getType());
            messageVo.setData((Object)saleTradeMessageVo);
            this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219orderNo={}\u53d1\u9001mq\u6d88\u606f\uff1a{}", (Object)orderNo, (Object)JSON.toJSONString((Object)messageVo));
            this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "DELAY_AUTO_CHECK", (Object)messageVo);
            return null;
        }
        StrategyAutoCheckRuleEo strategyAutoCheckRuleEo = (StrategyAutoCheckRuleEo)ruleEoList.get(0);
        this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u8ba2\u5355\uff08orderNo={}\uff09\u4f7f\u7528\u7684\u89c4\u5219\u4e3a\uff1a{}", (Object)orderNo, (Object)JSON.toJSONString((Object)strategyAutoCheckRuleEo));
        this.saveStrategyOrder(strategyAutoCheckRuleEo.getId(), saleOrderRespDto);
        LambdaQueryWrapper queryTypeWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryTypeWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckTypeEo::getRuleId, (Object)strategyAutoCheckRuleEo.getId());
        List autoCheckTypeEos = this.strategyAutoCheckTypeDomain.getMapper().selectList((Wrapper)queryTypeWrapper);
        if (CollectionUtils.isEmpty((Collection)autoCheckTypeEos)) {
            return Boolean.TRUE;
        }
        Map<String, Integer> typeEnableMap = autoCheckTypeEos.stream().collect(Collectors.toMap(StrategyAutoCheckTypeEo::getStrategyType, StrategyAutoCheckTypeEo::getEnable));
        Boolean checkRuleResult = this.checkRule(strategyAutoCheckRuleEo.getId(), saleOrderRespDto, typeEnableMap);
        if (!checkRuleResult.booleanValue()) {
            return Boolean.FALSE;
        }
        Long delaySeconds = 0L;
        Integer delayAudit = typeEnableMap.get(StrategyTypeEnum.DELAY_AUDIT.getStrategyType());
        if (StrategyEnableEnum.ENABLE.getType().equals(delayAudit)) {
            LambdaQueryWrapper queryDelayWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryDelayWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckConfEo::getRuleId, (Object)strategyAutoCheckRuleEo.getId())).eq(StrategyAutoCheckConfEo::getStrategyType, (Object)StrategyTypeEnum.DELAY_AUDIT.getStrategyType());
            StrategyAutoCheckConfEo delayConf = (StrategyAutoCheckConfEo)this.strategyAutoCheckConfDomain.getMapper().selectOne((Wrapper)queryDelayWrapper);
            this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u914d\u7f6e\u7684\u5ef6\u65f6\u5ba1\u6838\u95f4\u4e3a\uff1a{}", (Object)strategyAutoCheckRuleEo.getId(), (Object)JSON.toJSONString((Object)delayConf));
            AssertUtils.notBlank((String)delayConf.getStrategyValue2(), (String)"\u5ef6\u8fdf\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String dateType = delayConf.getStrategyValue();
            Integer delayTime = Integer.valueOf(delayConf.getStrategyValue2());
            AuditTimeTypeEnum auditTimeTypeEnum = AuditTimeTypeEnum.enumOf((String)dateType);
            Date createTime = new Date();
            if (AuditTimeTypeEnum.SALE_CREATE_TIME.equals((Object)auditTimeTypeEnum)) {
                createTime = saleOrderRespDto.getSaleCreateTime();
            } else if (AuditTimeTypeEnum.PLATFORM_CREATE_TIME.equals((Object)auditTimeTypeEnum)) {
                createTime = saleOrderRespDto.getPlatformCreateTime();
            }
            Date sendDate = DateUtil.addMinutes((Date)createTime, (int)delayTime);
            long delayTimeSeconds = sendDate.getTime() / 1000L - new Date().getTime() / 1000L;
            delaySeconds = delayTimeSeconds > 0L ? delayTimeSeconds : 0L;
        }
        MessageVo messageVo = new MessageVo();
        SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
        saleTradeMessageVo.setOrderId(saleOrderRespDto.getId());
        saleTradeMessageVo.setOrderNo(saleOrderRespDto.getSaleOrderNo());
        saleTradeMessageVo.setNextOptType(NextOptTypeEnum.SALE_ORDER_CHECK.getType());
        saleTradeMessageVo.setRuleId(strategyAutoCheckRuleEo.getId());
        messageVo.setData((Object)saleTradeMessageVo);
        this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219orderNo={}\u53d1\u9001mq\u6d88\u606f\uff1a{}\uff0c\u5ef6\u8fdf\uff1a{}s", new Object[]{orderNo, JSON.toJSONString((Object)messageVo), delaySeconds});
        MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessage("SINGLE_TOPIC", "DELAY_AUTO_CHECK", (Object)messageVo, delaySeconds);
        this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219orderNo={}\u53d1\u9001mq\u7ed3\u679c\uff1a{}", (Object)orderNo, (Object)JSON.toJSONString((Object)messageResponse));
        return Boolean.TRUE;
    }

    private void saveStrategyOrder(Long ruleId, BizSaleOrderRespDto saleOrderRespDto) {
        this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u547d\u4e2d\u9500\u552e\u8ba2\u5355\u8bb0\u5f55\uff1aruleId={}, saleOrder={}", (Object)ruleId, (Object)JSON.toJSONString((Object)saleOrderRespDto));
        StrategyAutoCheckOrderEo strategyAutoCheckOrderEo = new StrategyAutoCheckOrderEo();
        strategyAutoCheckOrderEo.setRuleId(ruleId);
        strategyAutoCheckOrderEo.setSaleOrderId(saleOrderRespDto.getId());
        strategyAutoCheckOrderEo.setSaleOrderNo(saleOrderRespDto.getSaleOrderNo());
        strategyAutoCheckOrderEo.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        strategyAutoCheckOrderEo.setPlatformOrderId(saleOrderRespDto.getPlatformOrderId());
        strategyAutoCheckOrderEo.setHitTime(new Date());
        this.strategyAutoCheckOrderDomain.insert((BaseEo)strategyAutoCheckOrderEo);
    }

    private Boolean checkRule(Long ruleId, BizSaleOrderRespDto saleOrderRespDto, Map<String, Integer> typeEnableMap) {
        List<StrategyAutoCheckConfEo> sellerAutoRemarkConfList;
        String provinceCode = saleOrderRespDto.getOrderAddrRespDto().getProvinceCode();
        String province = saleOrderRespDto.getOrderAddrRespDto().getProvince();
        String cityCode = saleOrderRespDto.getOrderAddrRespDto().getCityCode();
        String city = saleOrderRespDto.getOrderAddrRespDto().getCity();
        String countyCode = saleOrderRespDto.getOrderAddrRespDto().getCountyCode();
        String county = saleOrderRespDto.getOrderAddrRespDto().getCounty();
        ArrayList areaCodeList = Lists.newArrayList((Object[])new String[]{provinceCode, cityCode, countyCode});
        List<StrategyAutoCheckConfEo> existAreaConf = this.existConfs(ruleId, typeEnableMap, StrategyTypeEnum.AREA_AUDIT, areaCodeList);
        if (Objects.nonNull(existAreaConf)) {
            TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)String.format("\u533a\u57df\u3010%s%s%s\u3011\u4eba\u5de5\u5ba1\u6838", province, city, county));
            this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u6307\u5b9a\u533a\u57df\u4eba\u5de5\u5ba1\u6838,\u5219\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u6307\u5b9a\u533a\u57df\u4fe1\u606f\u4e3a\uff1a{}", (Object)ruleId, (Object)JSON.toJSONString(existAreaConf));
            return Boolean.FALSE;
        }
        Long customerId = saleOrderRespDto.getCustomerId();
        List<StrategyAutoCheckConfEo> existCustomerConf = this.existConfs(ruleId, typeEnableMap, StrategyTypeEnum.CUSTOMER_AUDIT, Lists.newArrayList((Object[])new String[]{String.valueOf(customerId)}));
        if (Objects.nonNull(existCustomerConf)) {
            TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)"\u5f53\u524d\u5ba2\u6237\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u6307\u5b9a\u5ba2\u6237\u4eba\u5de5\u5ba1\u6838,\u5219\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u6307\u5b9a\u5ba2\u6237\u4fe1\u606f\u4e3a\uff1a{}", (Object)ruleId, (Object)JSON.toJSONString(existCustomerConf));
            return Boolean.FALSE;
        }
        List<String> skuCodeList = saleOrderRespDto.getItemList().stream().map(SaleOrderItemRespDto::getSkuCode).collect(Collectors.toList());
        List<StrategyAutoCheckConfEo> existSkuConf = this.existConfs(ruleId, typeEnableMap, StrategyTypeEnum.GOODS_AUDIT, skuCodeList);
        if (Objects.nonNull(existSkuConf)) {
            List skuCodes = existSkuConf.stream().map(StrategyAutoCheckConfEo::getStrategyValue).collect(Collectors.toList());
            TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)String.format("\u6307\u5b9a\u5546\u54c1\u957f\u7f16\u7801\u4e3a\uff1a%s \u9700\u8981\u4eba\u5de5\u5ba1\u6838", StringUtils.join(skuCodes, (String)",")));
            this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u6307\u5b9aSKU\u4eba\u5de5\u5ba1\u6838,\u5219\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u6307\u5b9aSKU\u4fe1\u606f\u4e3a\uff1a{}", (Object)ruleId, (Object)JSON.toJSONString(existSkuConf));
            return Boolean.FALSE;
        }
        String logicalWarehouseCode = saleOrderRespDto.getDefaultLogicalWarehouseCode();
        List<StrategyAutoCheckConfEo> existLogicalWarehouseConf = this.existConfs(ruleId, typeEnableMap, StrategyTypeEnum.LOGICAL_WAREHOUSE_AUDIT, Lists.newArrayList((Object[])new String[]{logicalWarehouseCode}));
        if (Objects.nonNull(existLogicalWarehouseConf)) {
            List logicalWarehouseCodes = existLogicalWarehouseConf.stream().map(StrategyAutoCheckConfEo::getStrategyValue).collect(Collectors.toList());
            RestResponse listRestResponse = this.logicWarehouseExposedQueryApi.queryList(logicalWarehouseCodes);
            List logicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            List logicWarehouseNameList = logicWarehousePageRespDtos.stream().map(CsLogicWarehouseRespDto::getWarehouseName).collect(Collectors.toList());
            TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)String.format("\u6307\u5b9a\u903b\u8f91\u4ed3\u4e3a\uff1a%s \u9700\u8981\u4eba\u5de5\u5ba1\u6838", StringUtils.join(logicWarehouseNameList, (String)",")));
            this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u6307\u5b9a\u903b\u8f91\u4ed3\u4eba\u5de5\u5ba1\u6838,\u5219\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u6307\u5b9a\u903b\u8f91\u4ed3\u4fe1\u606f\u4e3a\uff1a{}", (Object)ruleId, (Object)JSON.toJSONString(existLogicalWarehouseConf));
            return Boolean.FALSE;
        }
        List<StrategyAutoCheckConfEo> sellerRemarkConfList = this.existConfs(ruleId, typeEnableMap, StrategyTypeEnum.SELLER_REMARK_AUDIT, null);
        if (Objects.nonNull(sellerRemarkConfList)) {
            StrategyAutoCheckConfEo sellerRemarkConfEo = sellerRemarkConfList.get(0);
            String sellerRemark = saleOrderRespDto.getSellerRemark();
            if (StringUtils.isNotEmpty((CharSequence)sellerRemark)) {
                String strategyValue = sellerRemarkConfEo.getStrategyValue();
                String sellerRemarkKeyFlag = sellerRemarkConfEo.getStrategyValue2();
                if (Objects.equals(sellerRemarkKeyFlag, "1")) {
                    String[] split = strategyValue.split(",");
                    List<String> sellerRemarkKeyList = Arrays.asList(split);
                    for (String sellerRemarkKey : sellerRemarkKeyList) {
                        if (sellerRemark.indexOf(sellerRemarkKey) == -1) continue;
                        this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u5f00\u542f\u5546\u5bb6\u5907\u6ce8\u4e14\u914d\u7f6e\u5173\u952e\u8bcd,\u5219\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u7684\u5546\u5bb6\u5907\u6ce8\u4fe1\u606f\u4e3a\uff1a{},{}", new Object[]{ruleId, saleOrderRespDto.getSellerRemark(), sellerRemarkKey});
                        TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)String.format("\u8ba2\u5355\u5546\u5bb6\u5907\u6ce8\uff1a%s ,\u5173\u952e\u8bcd\u62e6\u622a\uff1as%\u9700\u8981\u4eba\u5de5\u5ba1\u6838", sellerRemark, sellerRemarkKey));
                        return Boolean.FALSE;
                    }
                } else {
                    this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u5f00\u542f\u5546\u5bb6\u5907\u6ce8\u4e14\u672a\u914d\u7f6e\u5173\u952e\u8bcd,\u5219\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u7684\u5546\u5bb6\u5907\u6ce8\u4fe1\u606f\u4e3a\uff1a{}", (Object)ruleId, (Object)saleOrderRespDto.getSellerRemark());
                    TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)String.format("\u8ba2\u5355\u5546\u5bb6\u5907\u6ce8\uff1a%s \u9700\u8981\u4eba\u5de5\u5ba1\u6838", sellerRemark));
                    return Boolean.FALSE;
                }
            }
        }
        if (Objects.nonNull(sellerAutoRemarkConfList = this.existConfs(ruleId, typeEnableMap, StrategyTypeEnum.SELLER_REMARK_AUTO_AUDIT, null))) {
            StrategyAutoCheckConfEo sellerAutoRemarkConfEo = sellerAutoRemarkConfList.get(0);
            String sellerRemark = saleOrderRespDto.getSellerRemark();
            if (StringUtils.isNotEmpty((CharSequence)sellerRemark)) {
                String strategyValue = sellerAutoRemarkConfEo.getStrategyValue();
                String sellerAutoRemarkKeyFlag = sellerAutoRemarkConfEo.getStrategyValue2();
                if (Objects.equals(sellerAutoRemarkKeyFlag, "1")) {
                    String[] split = strategyValue.split(",");
                    List<String> sellerAutoRemarkKeyList = Arrays.asList(split);
                    for (String sellerAutoRemarkKey : sellerAutoRemarkKeyList) {
                        if (sellerRemark.indexOf(sellerAutoRemarkKey) == -1) continue;
                        this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u5f00\u542f\u5356\u5bb6\u5907\u6ce8\u81ea\u52a8\u5ba1\u6838\u4e14\u5339\u914d\u5173\u952e\u8bcd,\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7, \u8ba2\u5355\u7684\u5546\u5bb6\u5907\u6ce8\u4fe1\u606f\u4e3a\uff1a{},{}", new Object[]{ruleId, saleOrderRespDto.getSellerRemark(), sellerAutoRemarkKey});
                        TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)String.format("\u8ba2\u5355\u5546\u5bb6\u5907\u6ce8\uff1a%s ,\u5173\u952e\u8bcd\u5339\u914d\uff1a%s\uff0c\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7", sellerRemark, sellerAutoRemarkKey));
                        return Boolean.TRUE;
                    }
                } else {
                    this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u5f00\u542f\u5356\u5bb6\u5907\u6ce8\u81ea\u52a8\u5ba1\u6838\u4e14\u672a\u914d\u7f6e\u5173\u952e\u8bcd,\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7, \u8ba2\u5355\u7684\u5546\u5bb6\u5907\u6ce8\u4fe1\u606f\u4e3a\uff1a{}", (Object)ruleId, (Object)saleOrderRespDto.getSellerRemark());
                    TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)String.format("\u8ba2\u5355\u5546\u5bb6\u5907\u6ce8\uff1a%s \u81ea\u52a8\u5ba1\u6838\u901a\u8fc7", sellerRemark));
                    return Boolean.TRUE;
                }
            }
        }
        Integer amountRange = typeEnableMap.get(StrategyTypeEnum.AMOUNT_RANGE_AUDIT.getStrategyType());
        if (StrategyEnableEnum.ENABLE.getType().equals(amountRange)) {
            LambdaQueryWrapper queryAmountWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryAmountWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckConfEo::getRuleId, (Object)ruleId)).eq(StrategyAutoCheckConfEo::getStrategyType, (Object)StrategyTypeEnum.AMOUNT_RANGE_AUDIT.getStrategyType());
            StrategyAutoCheckConfEo amountRangeConf = (StrategyAutoCheckConfEo)this.strategyAutoCheckConfDomain.getMapper().selectOne((Wrapper)queryAmountWrapper);
            BigDecimal startAmount = new BigDecimal(amountRangeConf.getStrategyValue());
            BigDecimal endAmount = new BigDecimal(amountRangeConf.getStrategyValue2());
            BigDecimal payAmount = saleOrderRespDto.getPayAmount();
            this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u914d\u7f6e\u7684\u6307\u5b9a\u91d1\u989d\u533a\u95f4\u4e3a\uff1a{}", (Object)ruleId, (Object)JSON.toJSONString((Object)amountRangeConf));
            if (payAmount.compareTo(endAmount) > 0 || payAmount.compareTo(startAmount) < 0) {
                TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)String.format("\u91d1\u989d\u4e0d\u5728\u3010%s~%s\u3011\u8303\u56f4\u5185\u62e6\u622a", startAmount, endAmount));
                this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u91d1\u989d\u4e0d\u5728\u3010{}~{}\u3011\u8303\u56f4\u5185\u62e6\u622a,\u5219\u9700\u8981\u4eba\u5de5\u5ba1\u6838", new Object[]{ruleId, startAmount, endAmount});
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private List<StrategyAutoCheckConfEo> existConfs(Long ruleId, Map<String, Integer> typeEnableMap, StrategyTypeEnum typeEnum, List<String> valueList) {
        List autoCheckConfEos;
        Integer enable = typeEnableMap.get(typeEnum.getStrategyType());
        if (StrategyEnableEnum.STOP.getType().equals(enable)) {
            this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\u672a\u5f00\u542f{}\u9879\u7684\u914d\u7f6e", (Object)ruleId, (Object)typeEnum.getStrategyType());
            return null;
        }
        LambdaQueryWrapper queryConfWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyAutoCheckConfEo::getRuleId, (Object)ruleId)).eq(StrategyAutoCheckConfEo::getStrategyType, (Object)typeEnum.getStrategyType());
        if (Objects.nonNull(valueList) && CollectionUtils.isNotEmpty(valueList)) {
            queryConfWrapper.in(StrategyAutoCheckConfEo::getStrategyValue, valueList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(autoCheckConfEos = this.strategyAutoCheckConfDomain.getMapper().selectList((Wrapper)queryConfWrapper)))) {
            this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\uff0c\u914d\u7f6e\u9879\u4e3a\uff1a{}\u547d\u4e2d\u914d\u7f6e\u9879", (Object)ruleId, (Object)typeEnum.getStrategyType());
            return autoCheckConfEos;
        }
        this.logger.info("[\u8ba2\u5355\u81ea\u52a8\u786e\u8ba4\u89c4\u5219]\u89c4\u5219ruleId={}\uff0c\u914d\u7f6e\u9879\u4e3a\uff1a{}\u672a\u547d\u4e2d\u914d\u7f6e\u9879", (Object)ruleId, (Object)typeEnum.getStrategyType());
        return null;
    }

    private <T extends BaseEo> void restData(T baseEo) {
        baseEo.setId(null);
        baseEo.setCreateTime(null);
        baseEo.setCreatePerson(null);
        baseEo.setUpdatePerson(null);
        baseEo.setUpdateTime(null);
    }

    private Boolean checkRuleEffective(Long ruleId) {
        LambdaQueryWrapper queryRuleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryRuleWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)ruleId);
        StrategyAutoCheckRuleEo autoCheckRuleEo = (StrategyAutoCheckRuleEo)this.strategyAutoCheckRuleDomain.getMapper().selectOne((Wrapper)queryRuleWrapper);
        AssertUtils.notNull((Object)autoCheckRuleEo, (String)"\u5f53\u524d\u89c4\u5219\u4e0d\u5b58\u5728");
        StrategyEnableEnum ruleEffectiveStatus = RuleEffectiveUtil.getRuleEffectiveStatus((Date)autoCheckRuleEo.getActiveStartTime(), (Date)autoCheckRuleEo.getActiveEndTime());
        if (StrategyEnableEnum.ENABLE.getType().equals(autoCheckRuleEo.getRuleStatus())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

