/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferExtAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferExtUpdateReqDto;
import com.yunxi.dg.base.center.trade.domain.entity.ISaleTransferExtDomain;
import com.yunxi.dg.base.center.trade.eo.SaleTransferExtEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleTransferExtService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleTransferExtServiceImpl
implements ISaleTransferExtService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ISaleTransferExtDomain saleTransferExtDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSaleTransferNum(List<SaleTransferExtUpdateReqDto> list) {
        for (SaleTransferExtUpdateReqDto saleTransferExtUpdateReqDto : list) {
            SaleTransferExtEo saleTransferExtEo = new SaleTransferExtEo();
            if (null == saleTransferExtUpdateReqDto.getNum()) {
                saleTransferExtUpdateReqDto.setNum(BigDecimal.ZERO);
            }
            saleTransferExtEo.setNum(saleTransferExtUpdateReqDto.getNum());
            saleTransferExtEo.setOrderId(saleTransferExtUpdateReqDto.getOrderId());
            saleTransferExtEo.setSkuCode(saleTransferExtUpdateReqDto.getSkuCode());
            this.saleTransferExtDomain.updateSaleTransferNum(saleTransferExtEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByOrderId(Long orderId) {
        this.saleTransferExtDomain.delByOrderId(orderId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(SaleTransferExtAddReqDto addReqDto) {
        List addList = addReqDto.getAddList();
        ArrayList addEoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)addEoList, (Collection)addList, SaleTransferExtEo.class);
        this.saleTransferExtDomain.batchSave(addReqDto.getOrderId(), (List)addEoList);
    }
}

