/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.mark.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dao.das.IDgOrderTagItemDas;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderTagItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderTagItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderTagItemEo;
import com.yunxi.dg.base.center.trade.service.mark.IDgOrderTagItemService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOrderTagItemServiceImpl
implements IDgOrderTagItemService {
    @Resource
    private IDgOrderTagItemDas orderTagItemDas;

    @Override
    public Long addOrderTagItem(DgOrderTagItemReqDto addReqDto) {
        DgOrderTagItemEo orderTagItemEo = new DgOrderTagItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderTagItemEo);
        this.orderTagItemDas.insert((BaseEo)orderTagItemEo);
        return orderTagItemEo.getId();
    }

    @Override
    public void modifyOrderTagItem(DgOrderTagItemReqDto modifyReqDto) {
        DgOrderTagItemEo orderTagItemEo = new DgOrderTagItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderTagItemEo);
        this.orderTagItemDas.updateSelective((BaseEo)orderTagItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderTagItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderTagItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeOrderTagItemById(Long id) {
        this.orderTagItemDas.logicDeleteById(Long.valueOf(id));
    }

    @Override
    public DgOrderTagItemRespDto queryById(Long id) {
        DgOrderTagItemEo orderTagItemEo = (DgOrderTagItemEo)this.orderTagItemDas.selectByPrimaryKey(id);
        DgOrderTagItemRespDto orderTagItemRespDto = new DgOrderTagItemRespDto();
        CubeBeanUtils.copyProperties((Object)orderTagItemRespDto, (Object)orderTagItemEo, (String[])new String[0]);
        return orderTagItemRespDto;
    }

    @Override
    public PageInfo<DgOrderTagItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DgOrderTagItemReqDto orderTagItemReqDto = (DgOrderTagItemReqDto)JSON.parseObject((String)filter, DgOrderTagItemReqDto.class);
        DgOrderTagItemEo orderTagItemEo = new DgOrderTagItemEo();
        DtoHelper.dto2Eo((BaseVo)orderTagItemReqDto, (BaseEo)orderTagItemEo);
        PageInfo eoPageInfo = this.orderTagItemDas.selectPage((BaseEo)orderTagItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), DgOrderTagItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgOrderTagItemRespDto> queryByParam(DgOrderTagItemReqDto orderTagItemReqDto) {
        List saleOrderEos;
        AssertUtils.notNull((Object)orderTagItemReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (Objects.nonNull(orderTagItemReqDto.getTagCode())) {
            queryWrapper.eq(DgOrderTagItemEo::getTagCode, (Object)orderTagItemReqDto.getTagCode());
        }
        if (Objects.nonNull(orderTagItemReqDto.getOrderId())) {
            queryWrapper.eq(DgOrderTagItemEo::getOrderId, (Object)orderTagItemReqDto.getOrderId());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderTagItemReqDto.getOrderIds())) {
            queryWrapper.in(DgOrderTagItemEo::getOrderId, (Collection)orderTagItemReqDto.getOrderIds());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderEos = this.orderTagItemDas.getMapper().selectList((Wrapper)queryWrapper)))) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgOrderTagItemRespDto.class);
        return resultList;
    }

    @Override
    public List<DgOrderTagItemRespDto> queryByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(DgOrderTagItemEo::getOrderId, orderIds);
        List saleOrderEos = this.orderTagItemDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgOrderTagItemRespDto.class);
        return resultList;
    }
}

