/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OrderTagExtendEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.TagEnableEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordAddBatchReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRecordRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dao.vo.OrderTagRecordVo;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderTagDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.eo.OrderTagEo;
import com.yunxi.dg.base.center.trade.eo.OrderTagRecordEo;
import com.yunxi.dg.base.center.trade.service.tc.IOrderTagRecordService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderOptLogService;
import com.yunxi.dg.base.center.trade.track.enums.OrderOperationTypeEnum;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderTagRecordServiceImpl
implements IOrderTagRecordService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IOrderTagRecordDomain orderTagRecordDomain;
    @Resource
    private IOrderTagDomain orderTagDomain;
    @Resource
    private ISaleOrderOptLogService saleOrderOptLogService;

    @Override
    public Long addOrderTagRecord(OrderTagRecordReqDto addReqDto) {
        OrderTagRecordEo orderTagRecordEo = new OrderTagRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderTagRecordEo);
        this.orderTagRecordDomain.insert((BaseEo)orderTagRecordEo);
        return orderTagRecordEo.getId();
    }

    @Override
    public void modifyOrderTagRecord(OrderTagRecordReqDto modifyReqDto) {
        OrderTagRecordEo orderTagRecordEo = new OrderTagRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderTagRecordEo);
        this.orderTagRecordDomain.updateSelective((BaseEo)orderTagRecordEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderTagRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderTagRecordDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeOrderTagRecordById(Long id) {
        this.orderTagRecordDomain.logicDeleteById(id);
    }

    @Override
    public OrderTagRecordRespDto queryById(Long id) {
        OrderTagRecordEo orderTagRecordEo = (OrderTagRecordEo)this.orderTagRecordDomain.selectByPrimaryKey(id);
        OrderTagRecordRespDto orderTagRecordRespDto = new OrderTagRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)orderTagRecordEo, (BaseVo)orderTagRecordRespDto);
        return orderTagRecordRespDto;
    }

    @Override
    public PageInfo<OrderTagRecordRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderTagRecordReqDto orderTagRecordReqDto = (OrderTagRecordReqDto)JSON.parseObject((String)filter, OrderTagRecordReqDto.class);
        OrderTagRecordEo orderTagRecordEo = new OrderTagRecordEo();
        DtoHelper.dto2Eo((BaseVo)orderTagRecordReqDto, (BaseEo)orderTagRecordEo);
        PageInfo eoPageInfo = this.orderTagRecordDomain.selectPage((BaseEo)orderTagRecordEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderTagRecordRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<OrderTagRecordRespDto> queryByParam(OrderTagRecordReqDto orderTagRecordReqDto) {
        List saleOrderEos;
        AssertUtils.notNull((Object)orderTagRecordReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (Objects.nonNull(orderTagRecordReqDto.getTagCode())) {
            queryWrapper.eq(OrderTagRecordEo::getTagCode, (Object)orderTagRecordReqDto.getTagCode());
        }
        if (Objects.nonNull(orderTagRecordReqDto.getOrderId())) {
            queryWrapper.eq(OrderTagRecordEo::getOrderId, (Object)orderTagRecordReqDto.getOrderId());
        }
        if (CollectionUtils.isNotEmpty((Collection)orderTagRecordReqDto.getOrderIds())) {
            queryWrapper.in(OrderTagRecordEo::getOrderId, (Collection)orderTagRecordReqDto.getOrderIds());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderEos = this.orderTagRecordDomain.getMapper().selectList((Wrapper)queryWrapper)))) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)resultList, OrderTagRecordRespDto.class);
        return resultList;
    }

    @Override
    public List<OrderTagRecordRespDto> queryByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(OrderTagRecordEo::getOrderId, orderIds);
        List saleOrderEos = this.orderTagRecordDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)resultList, OrderTagRecordRespDto.class);
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchOrderTagRecord(OrderTagRecordAddBatchReqDto addReqDto) {
        switch (addReqDto.getModel()) {
            case UPDATE: {
                this.deleteAllTagByOrderId(addReqDto);
                this.batchInsert(addReqDto);
                break;
            }
            case APPEND: {
                this.deleteSelector(addReqDto);
                this.batchInsert(addReqDto);
                break;
            }
            case DELETE: {
                this.deleteSelector(addReqDto);
                break;
            }
            default: {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u52a8\u4f5c");
            }
        }
        String content = "\u8ba2\u5355\u624b\u5de5\u6807\u8bb0: %s\u6807\u7b7e:%s";
        this.saleOrderOptLogService.batchAddOrderLogByOrderIds(addReqDto.getSaleOrderIds(), OrderOperationTypeEnum.ADDBATCHORDERTAGRECORD, String.format(content, addReqDto.getModel().getDesc(), String.join((CharSequence)",", addReqDto.getTagCodes())));
    }

    private void batchInsert(OrderTagRecordAddBatchReqDto addReqDto) {
        this.orderTagRecordDomain.insertBatch(addReqDto.getSaleOrderIds().stream().flatMap(orderId -> addReqDto.getTagCodes().stream().map(tagCode -> {
            OrderTagRecordEo orderTagRecordEo = new OrderTagRecordEo();
            orderTagRecordEo.setOrderId(orderId);
            orderTagRecordEo.setTagCode(tagCode);
            return orderTagRecordEo;
        })).collect(Collectors.toList()));
    }

    private void deleteAllTagByOrderId(OrderTagRecordAddBatchReqDto addReqDto) {
        this.orderTagRecordDomain.getMapper().delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderTagRecordEo.class).eq(BaseEo::getDr, (Object)YesOrNoEnum.NO.getType())).in(OrderTagRecordEo::getOrderId, (Collection)addReqDto.getSaleOrderIds()));
    }

    private void deleteSelector(OrderTagRecordAddBatchReqDto addReqDto) {
        this.orderTagRecordDomain.getMapper().delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrderTagRecordEo.class).eq(BaseEo::getDr, (Object)YesOrNoEnum.NO.getType())).in(OrderTagRecordEo::getOrderId, (Collection)addReqDto.getSaleOrderIds())).in(OrderTagRecordEo::getTagCode, (Collection)addReqDto.getTagCodes()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyOrderTag(Long oigOrderId, List<Long> childOrderIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(OrderTagRecordEo::getOrderId, (Object)oigOrderId);
        List saleOrderEos = this.orderTagRecordDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            this.logger.info("\u4e3b\u5355\u672a\u6709\u6807\u7b7e\u5173\u8054");
            return;
        }
        List tagCodeList = saleOrderEos.stream().map(OrderTagRecordEo::getTagCode).collect(Collectors.toList());
        LambdaQueryWrapper tagQuery = new LambdaQueryWrapper();
        tagQuery.eq(BaseEo::getDr, (Object)0);
        tagQuery.eq(OrderTagEo::getTagStatus, (Object)TagEnableEnum.ENABLE.getType());
        tagQuery.eq(OrderTagEo::getExtend, (Object)OrderTagExtendEnum.CHILD_EXTEND.getCode());
        tagQuery.in(OrderTagEo::getTagCode, tagCodeList);
        List orderTagEos = this.orderTagDomain.getMapper().selectList((Wrapper)tagQuery);
        if (CollectionUtils.isEmpty((Collection)orderTagEos)) {
            this.logger.info("\u4e3b\u5355\u5173\u8054\u7684\u6807\u7b7e\u672a\u5b58\u5728\u5b50\u5355\u7ee7\u627f\u542f\u7528\u4fe1\u606f");
            return;
        }
        ArrayList addOrderTagRecordList = Lists.newArrayList();
        for (Long orderId : childOrderIds) {
            for (OrderTagEo orderTagEo : orderTagEos) {
                OrderTagRecordEo orderTagRecordEo = new OrderTagRecordEo();
                orderTagRecordEo.setOrderId(orderId);
                orderTagRecordEo.setTagCode(orderTagEo.getTagCode());
                addOrderTagRecordList.add(orderTagRecordEo);
            }
        }
        if (CollectionUtils.isEmpty((Collection)addOrderTagRecordList)) {
            return;
        }
        this.orderTagRecordDomain.insertBatch((List)addOrderTagRecordList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void kmhTagByOrderCreate(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        OrderTagRecordEo addEo = new OrderTagRecordEo();
        addEo.setTagCode("GS001");
        addEo.setOrderId(orderId);
        this.orderTagRecordDomain.insert((BaseEo)addEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delLjddTagByOrder(Long orderId) {
        OrderTagRecordAddBatchReqDto recordReqDto = new OrderTagRecordAddBatchReqDto();
        recordReqDto.setSaleOrderIds((List)Lists.newArrayList((Object[])new Long[]{orderId}));
        recordReqDto.setTagCodes((List)Lists.newArrayList((Object[])new String[]{"GSLJ"}));
        recordReqDto.setModel(OrderTagRecordAddBatchReqDto.ActionModel.DELETE);
        try {
            this.deleteSelector(recordReqDto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveLjddTagByOrder(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.delLjddTagByOrder(orderId);
        OrderTagRecordEo addEo = new OrderTagRecordEo();
        addEo.setTagCode("GSLJ");
        addEo.setOrderId(orderId);
        this.orderTagRecordDomain.insert((BaseEo)addEo);
    }

    @Override
    public void processYphRemoveTag(Long orderId) {
        List orderTagRecordVos = this.orderTagRecordDomain.queryTagById(orderId);
        if (orderTagRecordVos.stream().anyMatch(r -> "YPH".equals(r.getTagCode()))) {
            List ids = orderTagRecordVos.stream().filter(r -> "YPH".equals(r.getTagCode())).map(OrderTagRecordVo::getId).collect(Collectors.toList());
            this.orderTagRecordDomain.getMapper().deleteBatchIds(ids);
        }
    }
}

