/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundItemRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleRefundItemDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleRefundItemEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleRefundItemService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleRefundItemServiceImpl
implements ISaleRefundItemService {
    private static final Logger logger = LoggerFactory.getLogger(SaleRefundItemServiceImpl.class);
    @Resource
    private IDgSaleRefundItemDomain dgSaleRefundItemDomain;

    @Override
    public Long addSaleRefundItem(SaleRefundItemReqDto addReqDto) {
        DgSaleRefundItemEo saleRefundItemEo = new DgSaleRefundItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)saleRefundItemEo);
        this.dgSaleRefundItemDomain.insert((BaseEo)saleRefundItemEo);
        return saleRefundItemEo.getId();
    }

    @Override
    public void modifySaleRefundItem(SaleRefundItemReqDto modifyReqDto) {
        logger.info("\u4fee\u6539\u9500\u552e\u9000\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto));
        DgSaleRefundItemEo saleRefundItemEo = new DgSaleRefundItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)saleRefundItemEo);
        if (StringUtils.isNotBlank((String)modifyReqDto.getExtension())) {
            Map map = (Map)JSON.parseObject((String)modifyReqDto.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            saleRefundItemEo.setExtension(JSON.toJSONString((Object)map));
        }
        this.dgSaleRefundItemDomain.updateSelective((BaseEo)saleRefundItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleRefundItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dgSaleRefundItemDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SaleRefundItemRespDto queryById(Long id) {
        DgSaleRefundItemEo saleRefundItemEo = (DgSaleRefundItemEo)this.dgSaleRefundItemDomain.selectByPrimaryKey(id);
        SaleRefundItemRespDto saleRefundItemRespDto = new SaleRefundItemRespDto();
        DtoHelper.eo2Dto((BaseEo)saleRefundItemEo, (BaseVo)saleRefundItemRespDto);
        return saleRefundItemRespDto;
    }

    @Override
    public PageInfo<SaleRefundItemRespDto> queryByPage(Long refundId, Integer pageNum, Integer pageSize) {
        AssertUtils.notNull((Object)refundId, (String)"refundId\u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleRefundItemEo saleRefundItemEo = new DgSaleRefundItemEo();
        saleRefundItemEo.setOrderId(refundId);
        PageInfo eoPageInfo = this.dgSaleRefundItemDomain.selectPage((BaseEo)saleRefundItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SaleRefundItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

