/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.amount.tc;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.amount.tc.ICalculatorAmountMode;
import com.yunxi.dg.base.center.trade.dao.vo.OrderItemAmoutVo;
import com.yunxi.dg.base.center.trade.eo.DgSaleGoodsItemEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleGoodsItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BDCalculatorAmountModeImpl
implements ICalculatorAmountMode {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDCalculatorAmountModeImpl.class);
    @Resource
    private ISaleOrderItemService saleOrderItemService;
    @Resource
    private ISaleGoodsItemService saleGoodsItemService;
    @Resource
    private ISaleOrderService saleOrderService;

    @Override
    public void calculatorGoodItemAmountForCreate(SaleOrderItemRespDto saleOrderItemRespDto, DgSaleGoodsItemEo saleGoodsItemEo, BigDecimal averageAmount, BigDecimal discountAmount, int indexGoodItem) {
        LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u521b\u5efa\u8ba2\u5355\u662f\u8ba1\u7b97\u5546\u54c1\u660e\u7ec6\u884c\u91d1\u989d\uff0corderId={},skuCode={}", (Object)saleOrderItemRespDto.getOrderId(), (Object)saleOrderItemRespDto.getSkuCode());
        if (saleOrderItemRespDto.getItemNum().intValue() - 1 > indexGoodItem) {
            saleGoodsItemEo.setPayAmount(averageAmount);
            saleGoodsItemEo.setDiscountAmount(discountAmount);
        } else {
            BigDecimal lastPayAmount = Optional.ofNullable(saleOrderItemRespDto.getPayAmount()).orElse(BigDecimal.ZERO).subtract(averageAmount.multiply(BigDecimal.valueOf(indexGoodItem)));
            BigDecimal lastDiscountAmount = Optional.ofNullable(saleOrderItemRespDto.getDiscountAmount()).orElse(BigDecimal.ZERO).subtract(discountAmount.multiply(BigDecimal.valueOf(indexGoodItem)));
            LOGGER.debug("[\u91d1\u989d\u8ba1\u7b97]\u6700\u540e\u4e00\u4e2a\u5546\u54c1\u884c\u7684\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}", (Object)lastPayAmount);
            saleGoodsItemEo.setPayAmount(lastPayAmount);
            saleGoodsItemEo.setDiscountAmount(lastDiscountAmount);
        }
    }

    @Override
    public void calculatorOrderAmountBySplit(List<SaleOrderRespDto> childOrderList) {
        for (int i = 1; i < childOrderList.size(); ++i) {
            SaleOrderRespDto orderRespDto = childOrderList.get(i);
            SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
            saleOrderReqDto.setId(orderRespDto.getId());
            saleOrderReqDto.setFreightCost(BigDecimal.ZERO);
            this.saleOrderService.modifySaleOrder(saleOrderReqDto);
        }
        this.calculatorOrderAmount(childOrderList);
    }

    @Override
    public void calculatorOrderAmount(List<SaleOrderRespDto> childOrderList) {
        LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u62c6\u5355\u540e\uff0c\u8ba1\u7b97\u5b50\u8ba2\u5355\u5546\u54c1\u4ef7\u683c\uff0cchildOrderList={}", (Object)JSON.toJSONString(childOrderList));
        List<Long> orderIdList = childOrderList.stream().map(SaleOrderRespDto::getId).collect(Collectors.toList());
        List<SaleOrderItemRespDto> orderItemRespDtoList = this.saleOrderItemService.queryNormalItemsByOrderIds(orderIdList);
        AssertUtils.notEmpty(orderItemRespDtoList, (String)"\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a");
        Map<Long, List<SaleOrderItemRespDto>> orderItemsMap = orderItemRespDtoList.stream().collect(Collectors.groupingBy(SaleOrderItemRespDto::getOrderId));
        List<OrderItemAmoutVo> orderItemAmountList = this.saleGoodsItemService.calculatorOrderItemAmount(orderIdList);
        LOGGER.debug("[\u91d1\u989d\u8ba1\u7b97]\u901a\u8fc7\u5546\u54c1\u660e\u7ec6\u884c\u8ba1\u7b97\u8ba2\u5355\u5546\u54c1\u91d1\u989d\u7edf\u8ba1\u7684\u6570\u636e\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderItemAmountList));
        Map orderItemAmoutVoMap = orderItemAmountList.stream().collect(Collectors.toMap(OrderItemAmoutVo::getOrderItemId, Function.identity()));
        orderItemsMap.forEach((orderId, orderItemList) -> {
            SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById((Long)orderId);
            ArrayList saleOrderItemReqDtos = Lists.newArrayList();
            BigDecimal orderPayAmount = BigDecimal.ZERO;
            BigDecimal orderDiscountAmount = BigDecimal.ZERO;
            BigDecimal goodsTotalAmount = BigDecimal.ZERO;
            for (SaleOrderItemRespDto saleOrderItemRespDto : orderItemList) {
                OrderItemAmoutVo itemAmoutVo = (OrderItemAmoutVo)orderItemAmoutVoMap.get(saleOrderItemRespDto.getId());
                SaleOrderItemReqDto saleOrderItemReqDto = new SaleOrderItemReqDto();
                saleOrderItemReqDto.setId(saleOrderItemRespDto.getId());
                saleOrderItemReqDto.setPayAmount(itemAmoutVo.getOrderItemAmount());
                saleOrderItemReqDto.setDiscountAmount(itemAmoutVo.getOrderItemDiscountAmount());
                saleOrderItemReqDtos.add(saleOrderItemReqDto);
                orderPayAmount = orderPayAmount.add(itemAmoutVo.getOrderItemAmount());
                orderDiscountAmount = orderDiscountAmount.add(itemAmoutVo.getOrderItemDiscountAmount());
                goodsTotalAmount = goodsTotalAmount.add(saleOrderItemRespDto.getSalePrice().multiply(saleOrderItemRespDto.getItemNum()));
            }
            this.saleOrderItemService.modifyOrderItemAmount(saleOrderItemReqDtos);
            SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
            saleOrderReqDto.setId(orderId);
            saleOrderReqDto.setPayAmount(orderPayAmount);
            saleOrderReqDto.setDiscountAmount(orderDiscountAmount);
            saleOrderReqDto.setGoodsTotalAmount(goodsTotalAmount);
            BigDecimal merchantReceivableAmount = goodsTotalAmount.add(saleOrderRespDto.getFreightCost()).subtract(orderDiscountAmount);
            saleOrderReqDto.setMerchantReceivableAmount(merchantReceivableAmount);
            LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba2\u5355orderId={}\uff0c\u8ba1\u7b97\u5b50\u8ba2\u5355\u6210\u4ea4\u91d1\u989d={}\uff0c\u4f18\u60e0\u91d1\u989d={}, \u5546\u54c1\u603b\u91d1\u989d={}, \u5546\u5bb6\u5e94\u6536={}", new Object[]{orderId, orderPayAmount, orderDiscountAmount, goodsTotalAmount, merchantReceivableAmount});
            this.saleOrderService.modifySaleOrder(saleOrderReqDto);
        });
    }

    @Override
    public void calculatorGroupItemAmount(SaleOrderItemReqDto orderItemReqDto, DgSaleOrderItemEo itemEo, int index) {
        LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1\u5747\u644a\u91d1\u989d\uff0c\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)orderItemReqDto));
        BigDecimal itemTotalSaleAmount = orderItemReqDto.getSubItemList().parallelStream().map(item -> item.getSalePrice().multiply(item.getItemNum())).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (orderItemReqDto.getSubItemList().size() - 1 > index) {
            BigDecimal payAmount = itemEo.getSalePrice().multiply(itemEo.getItemNum()).divide(itemTotalSaleAmount).multiply(itemEo.getGroupItemPayAmount()).setScale(2);
            itemEo.setPayAmount(payAmount);
            ((SaleOrderItemReqDto)orderItemReqDto.getSubItemList().get(index)).setPayAmount(payAmount);
            BigDecimal discountAmount = itemEo.getSalePrice().multiply(itemEo.getItemNum()).divide(itemTotalSaleAmount).multiply(itemEo.getGroupItemDiscountAmount()).setScale(2);
            itemEo.setDiscountAmount(discountAmount);
            ((SaleOrderItemReqDto)orderItemReqDto.getSubItemList().get(index)).setDiscountAmount(discountAmount);
            BigDecimal saleAmount = payAmount.add(discountAmount).divide(itemEo.getItemNum()).setScale(2);
            itemEo.setSalePrice(saleAmount);
            LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1skuCode={}, \u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}, \u4f18\u60e0\u91d1\u989d={}, \u4f18\u60e0\u540e\u7684\u96f6\u552e\u4ef7={}", new Object[]{itemEo.getSkuCode(), payAmount, discountAmount, saleAmount});
        } else {
            BigDecimal hadPaymentAmount = BigDecimal.ZERO;
            BigDecimal hadDiscountAmount = BigDecimal.ZERO;
            for (int i = 0; i < orderItemReqDto.getSubItemList().size() - 1; ++i) {
                SaleOrderItemReqDto saleOrderItemReqDto = (SaleOrderItemReqDto)orderItemReqDto.getSubItemList().get(i);
                hadPaymentAmount = hadPaymentAmount.add(saleOrderItemReqDto.getPayAmount());
                hadDiscountAmount = hadDiscountAmount.add(saleOrderItemReqDto.getDiscountAmount());
            }
            SaleOrderItemReqDto lastSaleOrderItem = (SaleOrderItemReqDto)orderItemReqDto.getSubItemList().get(orderItemReqDto.getSubItemList().size() - 1);
            BigDecimal payAmount = orderItemReqDto.getPayAmount().subtract(hadPaymentAmount);
            BigDecimal discountAmount = orderItemReqDto.getDiscountAmount().subtract(hadDiscountAmount);
            BigDecimal saleAmount = payAmount.add(discountAmount).divide(lastSaleOrderItem.getItemNum()).setScale(2);
            itemEo.setPayAmount(payAmount);
            itemEo.setDiscountAmount(discountAmount);
            itemEo.setSalePrice(saleAmount);
            LOGGER.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1skuCode={}, \u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}\uff0c\u4f18\u60e0\u91d1\u989d={}, \u4f18\u60e0\u540e\u7684\u96f6\u552e\u4ef7={}", new Object[]{itemEo.getSkuCode(), payAmount, discountAmount, saleAmount});
        }
    }
}

