/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.order.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.constants.StrategyEnableEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyContentTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyRuleSuitTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleSuitDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderOptLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgBizStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleRespDto;
import com.yunxi.dg.base.center.trade.enums.SaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleSuitEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderOptLogService;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgStrategyOrderService;
import com.yunxi.dg.base.center.trade.service.order.strategy.IDgStrategyRuleService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.StrategyHelper;
import com.yunxi.dg.base.center.trade.vo.SaleTradeMessageVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dgStrategyRuleServiceImpl")
public class DgStrategyRuleServiceImpl
implements IDgStrategyRuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgStrategyRuleServiceImpl.class);
    protected static final ThreadLocal<DgStrategyOrderReqDto> CACHE_HIT_ITEM = new ThreadLocal();
    protected static final String ALL = "ALL";
    protected static final String SELECT = "SELECT";
    protected static final String CUSTOMER = "CUSTOMER";
    protected static final String BUSINESS = "BUSINESS";
    protected static final String LABEL = "LABEL";
    protected static final String NEED_PERSON_AUDIT_BY_REMARK = "0";
    protected static final String PERSON_AUDIT_BY_MATCH_KEYWORD = "1";
    protected static final Integer HANDLE_TASK_BY_MQ_DELAY_THRESHOLD = 120;
    protected static final String MODIFY_ORDER_ITEM = "MANUAL_MODIFY_ITEMS";
    protected static final String MODIFY_ORDER_ITEM_BY_SKU = "MANUAL_MODIFY_ITEMS_SKUCODE";
    protected static final String MODIFY_ORDER_ITEM_BY_DIFFERENCE = "MANUAL_MODIFY_ITEMS_FOR_DIFFERENCE";
    protected static final String MODIFY_ORDER_ADDR = "MODIFY_ADDRESS";
    protected static final String ARRANGE_SHIPMENT_ENTERPRISE = "ARRANGE_SHIPMENT_ENTERPRISE";
    @Resource
    protected IDgStrategyRuleDomain strategyRuleDas;
    @Resource
    protected IDgStrategyConfItemDomain strategyConfItemDas;
    @Resource
    protected IDgStrategyConfItemSuitDomain strategyConfItemSuitDas;
    @Resource
    protected IDgStrategyRuleSuitDomain strategyRuleSuitDas;
    @Resource
    private IDgPerformOrderExtDomain performOrderExtDomain;
    @Resource
    protected IDgStrategyOrderService strategyOrderService;
    @Resource
    private IDgPerformOrderItemDomain dgPerformOrderItemDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgStrategyRuleDomain dgStrategyRuleDomain;
    @Resource
    private IDgPerformOrderOptLogService saleOrderOptLogService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStrategyRule(Long id) {
        DgStrategyRuleEo dgStrategyRuleEo = (DgStrategyRuleEo)this.strategyRuleDas.selectByPrimaryKey(id);
        Integer ruleStatus = dgStrategyRuleEo.getRuleStatus();
        if (ruleStatus.equals(1)) {
            throw new BizException("\u8be5\u89c4\u5219\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u5220\u9664: " + dgStrategyRuleEo.getRuleName());
        }
        this.strategyRuleDas.logicDeleteById(id);
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(id);
        this.strategyRuleSuitDas.logicDeleteByExample(dgStrategyRuleSuitEo);
        StrategyConfItemEo strategyConfItemEo = new StrategyConfItemEo();
        strategyConfItemEo.setRuleId(id);
        this.strategyConfItemDas.logicDeleteByExample(strategyConfItemEo);
        StrategyConfItemSuitEo confItemSuitEo = new StrategyConfItemSuitEo();
        confItemSuitEo.setRuleId(id);
        this.strategyConfItemSuitDas.logicDeleteByExample(confItemSuitEo);
    }

    @Override
    public void modifyRuleStatus(Long id, Integer ruleStatus) {
        AssertUtils.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DgStrategyRuleEo dgStrategyRuleEo = (DgStrategyRuleEo)this.strategyRuleDas.selectByPrimaryKey(id);
        AssertUtils.notNull((Object)dgStrategyRuleEo, (String)"\u7b56\u7565\u4e0d\u5b58\u5728");
        DgStrategyRuleEo updateEo = new DgStrategyRuleEo();
        updateEo.setId(id);
        updateEo.setRuleStatus(ruleStatus);
        this.strategyRuleDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public PageInfo<DgStrategyRuleRespDto> queryByPage(DgBizStrategyRuleReqDto strategyRuleReqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (strategyRuleReqDto.getRuleStatus() != null) {
            queryWrapper.eq(DgStrategyRuleEo::getRuleStatus, (Object)strategyRuleReqDto.getRuleStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getStrategyType())) {
            queryWrapper.eq(DgStrategyRuleEo::getStrategyType, (Object)strategyRuleReqDto.getStrategyType());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getCreateStartTime())) {
            ((LambdaQueryWrapper)queryWrapper.ge(BaseEo::getCreateTime, (Object)strategyRuleReqDto.getCreateStartTime())).le(BaseEo::getCreateTime, (Object)strategyRuleReqDto.getCreateEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getUpdateStartTime())) {
            ((LambdaQueryWrapper)queryWrapper.ge(BaseEo::getUpdateTime, (Object)strategyRuleReqDto.getUpdateStartTime())).le(BaseEo::getUpdateTime, (Object)strategyRuleReqDto.getUpdateEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getPlatForm())) {
            queryWrapper.eq(DgStrategyRuleEo::getPlatForm, (Object)strategyRuleReqDto.getPlatForm());
        }
        if (CollectionUtils.isNotEmpty((Collection)strategyRuleReqDto.getLabelNameList())) {
            queryWrapper.in(DgStrategyRuleEo::getLabelName, (Collection)strategyRuleReqDto.getLabelNameList());
        }
        if (StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getRuleName()) || StringUtils.isNotBlank((CharSequence)strategyRuleReqDto.getRuleCode())) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)wrapper.like(DgStrategyRuleEo::getRuleName, (Object)("%" + strategyRuleReqDto.getRuleName() + "%"))).or(wp -> wp.like(DgStrategyRuleEo::getRuleCode, (Object)("%" + strategyRuleReqDto.getRuleCode() + "%"))));
        }
        queryWrapper.orderByDesc(BaseEo::getUpdateTime);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List dgStrategyRuleEos = this.dgStrategyRuleDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)dgStrategyRuleEos)) {
            return new PageInfo();
        }
        PageInfo info = new PageInfo(dgStrategyRuleEos);
        PageInfo dtoPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)dtoPageInfo);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)info, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)info.getList(), dtoList, DgStrategyRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    protected DgStrategyRuleEo queryValidRule(DgPerformOrderRespDto saleOrderRespDto, String strategyType) {
        List<DgStrategyRuleEo> dgStrategyRuleEoList = this.matchStrategyRule(saleOrderRespDto, strategyType);
        if (CollectionUtils.isEmpty(dgStrategyRuleEoList)) {
            return null;
        }
        Collections.sort(dgStrategyRuleEoList, Comparator.comparing(DgStrategyRuleEo::getPriority).thenComparing(BaseEo::getUpdateTime, Comparator.reverseOrder()));
        DgStrategyRuleEo dgStrategyRuleEo = dgStrategyRuleEoList.get(0);
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7: {},\u5339\u914d\u5230\u7684\u7b56\u7565\u4fe1\u606f\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)dgStrategyRuleEo));
        DgStrategyOrderReqDto strategyOrderReqDto = this.getHitStrategyOrder();
        strategyOrderReqDto.setRuleId(dgStrategyRuleEo.getId());
        strategyOrderReqDto.setSaleOrderNo(saleOrderRespDto.getSaleOrderNo());
        strategyOrderReqDto.setSaleOrderId(saleOrderRespDto.getId());
        strategyOrderReqDto.setPlatformOrderId(saleOrderRespDto.getPlatformOrderId());
        strategyOrderReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        strategyOrderReqDto.setType(strategyType);
        strategyOrderReqDto.setHitTime(new Date());
        Long id = this.strategyOrderService.addStrategyOrder(strategyOrderReqDto);
        strategyOrderReqDto.setId(id);
        return dgStrategyRuleEo;
    }

    protected List<DgStrategyRuleEo> matchStrategyRule(DgPerformOrderRespDto saleOrderRespDto, String strategyType) {
        return this.matchStrategyRule(saleOrderRespDto, DgCisStrategyOrderTypeEnum.forCode((String)strategyType));
    }

    protected List<DgStrategyRuleEo> matchStrategyRule(DgPerformOrderRespDto saleOrderRespDto, DgCisStrategyOrderTypeEnum strategyType) {
        LambdaQueryWrapper queryRuleSuitWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryRuleSuitWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgStrategyRuleSuitEo::getStrategyType, (Object)strategyType);
        switch (strategyType) {
            case CUSTOMER: 
            case BUSINESS: {
                queryRuleSuitWrapper.and(wrapper -> ((LambdaQueryWrapper)wrapper.eq(DgStrategyRuleSuitEo::getSuitKey, (Object)ALL)).or(wp -> ((LambdaQueryWrapper)wp.eq(DgStrategyRuleSuitEo::getSuitType, (Object)DgStrategyRuleSuitTypeEnum.SUITTYPE_SHOP.getCode())).eq(DgStrategyRuleSuitEo::getSuitKey, (Object)saleOrderRespDto.getPerformOrderSnapshotDto().getShopCode())));
                break;
            }
            case PICK: {
                break;
            }
            case ORDER_REVIEW: 
            case ORDER_CONFIRM: 
            case AUTOMATIC_ALLOCATION: 
            case AUTOMATIC_DELIVERY: {
                queryRuleSuitWrapper.and(wrapper -> {
                    String orgCode;
                    String customerCode;
                    String orderType;
                    String warehouseCode;
                    wrapper.eq(DgStrategyRuleSuitEo::getSuitSelectType, (Object)ALL);
                    String channelCode = saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode();
                    if (StringUtils.isNotBlank((CharSequence)channelCode)) {
                        wrapper.or(wp -> ((LambdaQueryWrapper)wp.eq(DgStrategyRuleSuitEo::getSuitType, (Object)DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL.getCode())).eq(DgStrategyRuleSuitEo::getSuitKey, (Object)saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(warehouseCode = Optional.ofNullable(saleOrderRespDto.getLogicalWarehouseCode()).orElse(saleOrderRespDto.getDeliveryLogicalWarehouseCode())))) {
                        wrapper.or(wp -> ((LambdaQueryWrapper)wp.eq(DgStrategyRuleSuitEo::getSuitType, (Object)DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL_WAREHOUSE.getCode())).eq(DgStrategyRuleSuitEo::getSuitKey, (Object)warehouseCode));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(orderType = saleOrderRespDto.getOrderType()))) {
                        wrapper.or(wp -> ((LambdaQueryWrapper)wp.eq(DgStrategyRuleSuitEo::getSuitType, (Object)DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode())).eq(DgStrategyRuleSuitEo::getSuitKey, (Object)saleOrderRespDto.getOrderType()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(customerCode = saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode()))) {
                        wrapper.or(wp -> ((LambdaQueryWrapper)wp.eq(DgStrategyRuleSuitEo::getSuitType, (Object)DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode())).eq(DgStrategyRuleSuitEo::getSuitKey, (Object)saleOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(orgCode = saleOrderRespDto.getPerformOrderSnapshotDto().getOrganizationCode()))) {
                        wrapper.or(wp -> ((LambdaQueryWrapper)wp.eq(DgStrategyRuleSuitEo::getSuitType, (Object)DgStrategyRuleSuitTypeEnum.SUITTYPE_ORG.getCode())).eq(DgStrategyRuleSuitEo::getSuitKey, (Object)saleOrderRespDto.getPerformOrderSnapshotDto().getOrganizationCode()));
                    }
                });
                break;
            }
            default: {
                throw new BizException("\u8be5\u9002\u7528\u7c7b\u578b\u672a\u914d\u7f6e\u67e5\u8be2\u6761\u4ef6");
            }
        }
        List dgStrategyRuleSuitEos = this.strategyRuleSuitDas.list(queryRuleSuitWrapper);
        if (CollectionUtils.isEmpty((Collection)dgStrategyRuleSuitEos)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u9002\u7528\u5e97\u94fa\u6ca1\u6709\u5339\u914d\u4e0a\u7b56\u7565\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
            return Collections.emptyList();
        }
        HashSet ruleIdSet = new HashSet();
        switch (strategyType) {
            case CUSTOMER: 
            case BUSINESS: 
            case PICK: {
                dgStrategyRuleSuitEos.forEach(eo -> ruleIdSet.add(eo.getRuleId()));
                break;
            }
            case ORDER_REVIEW: 
            case ORDER_CONFIRM: 
            case AUTOMATIC_ALLOCATION: 
            case AUTOMATIC_DELIVERY: {
                Map<Long, List<DgStrategyRuleSuitEo>> groupList = dgStrategyRuleSuitEos.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getRuleId));
                groupList.forEach((k, v) -> {
                    if (this.matchAllSuitCode((List<DgStrategyRuleSuitEo>)v)) {
                        ruleIdSet.add(k);
                    }
                });
                break;
            }
            default: {
                throw new BizException("\u8be5\u9002\u7528\u7c7b\u578b\u672a\u914d\u7f6e\u67e5\u8be2\u6761\u4ef6");
            }
        }
        if (CollectionUtils.isEmpty(ruleIdSet)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u9002\u7528\u5e97\u94fa\u6ca1\u6709\u5339\u914d\u4e0a\u7b56\u7565\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryStrategyWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryStrategyWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, ruleIdSet)).eq(DgStrategyRuleEo::getRuleStatus, (Object)StrategyEnableEnum.ENABLE.getType());
        List dgStrategyRuleEoList = this.strategyRuleDas.list(queryStrategyWrapper);
        if (CollectionUtils.isEmpty((Collection)dgStrategyRuleEoList)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u6ca1\u6709\u5339\u914d\u4e0a\u7b56\u7565\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
            return Collections.emptyList();
        }
        return dgStrategyRuleEoList;
    }

    private boolean matchAllSuitCode(List<DgStrategyRuleSuitEo> strategyRuleSuitEos) {
        Map<String, List<DgStrategyRuleSuitEo>> clueSuitAttributeRespDtoMap = strategyRuleSuitEos.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitType));
        List<DgStrategyRuleSuitEo> hisChannel = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL.getCode());
        List<DgStrategyRuleSuitEo> hisCustomer = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CLEINT.getCode());
        List<DgStrategyRuleSuitEo> hisWareHouse = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_CHANNEL_WAREHOUSE.getCode());
        List<DgStrategyRuleSuitEo> hisOrderType = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_ORDER_TYPE.getCode());
        List<DgStrategyRuleSuitEo> hisOrg = clueSuitAttributeRespDtoMap.get(DgStrategyRuleSuitTypeEnum.SUITTYPE_ORG.getCode());
        return !CollectionUtils.isEmpty(hisChannel) && !CollectionUtils.isEmpty(hisCustomer) && !CollectionUtils.isEmpty(hisWareHouse) && !CollectionUtils.isEmpty(hisOrderType) && !CollectionUtils.isEmpty(hisOrg);
    }

    protected Boolean checkRule(List<StrategyConfItemEo> strategyConfItemEoList, DgPerformOrderRespDto saleOrderRespDto) {
        for (StrategyConfItemEo confItemEo : strategyConfItemEoList) {
            CisStrategyConfItemTypeEnum strategyTypeEnum = CisStrategyConfItemTypeEnum.forCode((String)confItemEo.getStrategyType());
            Boolean checkResult = Boolean.TRUE;
            switch (strategyTypeEnum) {
                case NEEDLESS_PERSON_AUDIT: {
                    Boolean result = this.checkPersonAudit(saleOrderRespDto, confItemEo);
                    if (!result.booleanValue()) break;
                    DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
                    hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getCode());
                    hitStrategyOrder.setHitConfItemName(CisStrategyConfItemTypeEnum.NEEDLESS_PERSON_AUDIT.getDesc());
                    return Boolean.TRUE;
                }
                case SPECIAL_AMOUNT: {
                    checkResult = this.checkSpecialAmount(confItemEo, saleOrderRespDto);
                    break;
                }
                case SPECIAL_PAYTIME: {
                    checkResult = this.checkSpecialPaytime(confItemEo, saleOrderRespDto);
                    break;
                }
                case SPECIAL_WAREHOUSE: {
                    checkResult = this.checkSpecialWarehouse(confItemEo, saleOrderRespDto);
                    break;
                }
                case SPECIAL_SKU: {
                    checkResult = this.checkSpecialSku(confItemEo, saleOrderRespDto);
                    break;
                }
                case SPECIAL_AREA: {
                    break;
                }
                case BUYER_REMARK: {
                    checkResult = this.checkBuyerRemark(confItemEo, saleOrderRespDto);
                    break;
                }
                case SELLER_REMARK: {
                    checkResult = this.checkSellerRemark(confItemEo, saleOrderRespDto);
                    break;
                }
                case INTERNAL_REMARK: {
                    checkResult = this.checkInternalRemark(confItemEo, saleOrderRespDto);
                    break;
                }
                case MANUAL_ORDER_NEED_PERSON_AUDIT: {
                    checkResult = this.checkManualOrderAudit(confItemEo, saleOrderRespDto);
                    break;
                }
                case IMPORT_ORDER_NEED_PERSON_AUDIT: {
                    checkResult = this.checkImportOrderAudit(confItemEo, saleOrderRespDto);
                    break;
                }
                case MODIFY_ITEM_NEED_PERSON_AUDIT: {
                    checkResult = this.checkModifyOrderItem(confItemEo, saleOrderRespDto);
                    break;
                }
                case MODIFY_ADDR_NEED_PERSON_AUDIT: {
                    checkResult = this.checkModifyOrderAddr(confItemEo, saleOrderRespDto);
                    break;
                }
                case MODIFY_SHIPMENT_NEED_PERSON_AUDIT: {
                    checkResult = this.checkModifyOrderShipment(confItemEo, saleOrderRespDto);
                    break;
                }
            }
            if (!Boolean.FALSE.equals(checkResult)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkModifyOrderShipment(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        List<DgPerformOrderOptLogRespDto> saleOrderOptLogRespDtos;
        long isMatch;
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u4fee\u6539\u8ba2\u5355\u7269\u6d41\u505a\u4eba\u5de5\u5ba1\u6838");
        if (confItemEo != null && (isMatch = (saleOrderOptLogRespDtos = this.saleOrderOptLogService.queryBySaleOrderId(saleOrderRespDto.getId())).stream().filter(saleOrderOptLogRespDto -> ARRANGE_SHIPMENT_ENTERPRISE.equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn())).count()) > 0L) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.MODIFY_SHIPMENT_NEED_PERSON_AUDIT.getCode());
            hitStrategyOrder.setHitConfItemName(CisStrategyConfItemTypeEnum.MODIFY_SHIPMENT_NEED_PERSON_AUDIT.getDesc());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u4fee\u6539\u7269\u6d41\u5747\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkModifyOrderAddr(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        List<DgPerformOrderOptLogRespDto> saleOrderOptLogRespDtos;
        long isMatch;
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u4fee\u6539\u8ba2\u5355\u5730\u5740\u505a\u4eba\u5de5\u5ba1\u6838");
        if (confItemEo != null && (isMatch = (saleOrderOptLogRespDtos = this.saleOrderOptLogService.queryBySaleOrderId(saleOrderRespDto.getId())).stream().filter(saleOrderOptLogRespDto -> MODIFY_ORDER_ADDR.equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn())).count()) > 0L) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.MODIFY_ADDR_NEED_PERSON_AUDIT.getCode());
            hitStrategyOrder.setHitConfItemName(CisStrategyConfItemTypeEnum.MODIFY_ADDR_NEED_PERSON_AUDIT.getDesc());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u4fee\u6539\u5730\u5740\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkModifyOrderItem(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        List<DgPerformOrderOptLogRespDto> dgPerformOrderOptLogRespDtos;
        long isMatch;
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u4fee\u6539\u8ba2\u5355\u5546\u54c1\u505a\u4eba\u5de5\u5ba1\u6838");
        if (confItemEo != null && (isMatch = (dgPerformOrderOptLogRespDtos = this.saleOrderOptLogService.queryBySaleOrderId(saleOrderRespDto.getId())).stream().filter(saleOrderOptLogRespDto -> MODIFY_ORDER_ITEM.equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn()) || MODIFY_ORDER_ITEM_BY_SKU.equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn()) || MODIFY_ORDER_ITEM_BY_DIFFERENCE.equalsIgnoreCase(saleOrderOptLogRespDto.getOptTypeEn())).count()) > 0L) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.MODIFY_ITEM_NEED_PERSON_AUDIT.getCode());
            hitStrategyOrder.setHitConfItemName(CisStrategyConfItemTypeEnum.MODIFY_ITEM_NEED_PERSON_AUDIT.getDesc());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u624b\u5de5\u4fee\u6539\u5546\u54c1\u4fe1\u606f\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkImportOrderAudit(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u5bfc\u5165\u8ba2\u5355/\u5bfc\u5165\u8d60\u54c1\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838");
        if (confItemEo != null && SaleOrderSourceEnum.IMPORT.getType().equals(saleOrderRespDto.getOrderSource())) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.IMPORT_ORDER_NEED_PERSON_AUDIT.getCode());
            hitStrategyOrder.setHitConfItemName(CisStrategyConfItemTypeEnum.IMPORT_ORDER_NEED_PERSON_AUDIT.getDesc());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u5bfc\u5165\u8ba2\u5355/\u5bfc\u5165\u8d60\u54c1\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkManualOrderAudit(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u624b\u5de5\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838");
        if (confItemEo != null && StrategyEnableEnum.ENABLE.getType().equals(confItemEo.getEnable()) && SaleOrderSourceEnum.CREATE.getType().equals(saleOrderRespDto.getOrderSource())) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.MANUAL_ORDER_NEED_PERSON_AUDIT.getCode());
            hitStrategyOrder.setHitConfItemName(CisStrategyConfItemTypeEnum.MANUAL_ORDER_NEED_PERSON_AUDIT.getDesc());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u624b\u5de5\u8ba2\u5355\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkInternalRemark(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={},\u5185\u90e8\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838", (Object)saleOrderRespDto.getSaleOrderNo());
        Boolean checkRemark = this.checkRemark(confItemEo, saleOrderRespDto, saleOrderRespDto.getRemark());
        if (!checkRemark.booleanValue()) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.INTERNAL_REMARK.getCode());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u5185\u90e8\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
        }
        return checkRemark;
    }

    private Boolean checkSellerRemark(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={}, \u5356\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838", (Object)saleOrderRespDto.getSaleOrderNo());
        Boolean checkRemark = this.checkRemark(confItemEo, saleOrderRespDto, saleOrderRespDto.getSellerRemark());
        if (!checkRemark.booleanValue()) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.SELLER_REMARK.getCode());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u5356\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
        }
        return checkRemark;
    }

    private Boolean checkBuyerRemark(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={},\u4e70\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838", (Object)saleOrderRespDto.getSaleOrderNo());
        Boolean checkRemark = this.checkRemark(confItemEo, saleOrderRespDto, saleOrderRespDto.getBuyerRemark());
        if (!checkRemark.booleanValue()) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.BUYER_REMARK.getCode());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u4e70\u5bb6\u5907\u6ce8\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
        }
        return checkRemark;
    }

    private Boolean checkRemark(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto, String remark) {
        Map map = (Map)JSON.parseObject((String)confItemEo.getContent(), Map.class);
        String remarkType = MapUtils.getString((Map)map, (Object)"remarkType");
        if (StringUtils.equals((CharSequence)remarkType, (CharSequence)NEED_PERSON_AUDIT_BY_REMARK)) {
            if (StringUtils.isNotBlank((CharSequence)remark)) {
                LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u6709\u5907\u6ce8\u5747\u505a\u4eba\u5de5\u5ba1\u6838\u547d\u4e2d\u914d\u7f6e\u9879\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
                DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
                hitStrategyOrder.setHitConfItemName("\u6709\u5907\u6ce8\u5747\u505a\u4eba\u5de5\u5ba1\u6838");
                return Boolean.FALSE;
            }
        } else {
            String[] keyworks;
            String keyWords = MapUtils.getString((Map)map, (Object)"keyWords");
            for (String keywork : keyworks = keyWords.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)remark) || !remark.contains(keywork)) continue;
                LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u547d\u4e2d\u5173\u952e\u8bcd\u505a\u4eba\u5de5\u5ba1\u6838\u547d\u4e2d\u914d\u7f6e\u9879\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838");
                DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
                hitStrategyOrder.setHitConfItemName("\u547d\u4e2d\u5173\u952e\u8bcd\u505a\u4eba\u5de5\u5ba1\u6838");
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private Boolean checkSpecialSku(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        List skuCodeList = Optional.ofNullable(this.dgPerformOrderItemDomain.queryNormalItemByOrderId(saleOrderRespDto.getId())).orElseGet(Collections::emptyList).stream().map(DgPerformOrderItemDto::getSkuCode).collect(Collectors.toList());
        LambdaQueryWrapper queryConfItemSuitEoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemSuitEoWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)confItemEo.getRuleId())).eq(StrategyConfItemSuitEo::getSuitType, (Object)confItemEo.getStrategyType())).in(StrategyConfItemSuitEo::getSuitValue, skuCodeList);
        List strategyConfItemSuitEos = this.strategyConfItemSuitDas.list(queryConfItemSuitEoWrapper);
        if (CollectionUtils.isNotEmpty((Collection)strategyConfItemSuitEos)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u5f00\u542f\u5e76\u547d\u4e2d\u300a\u6307\u5b9aSKU\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.SPECIAL_SKU.getCode());
            hitStrategyOrder.setHitConfItemName(CisStrategyConfItemTypeEnum.SPECIAL_SKU.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkSpecialWarehouse(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        LambdaQueryWrapper queryConfItemSuitEoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemSuitEoWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemSuitEo::getRuleId, (Object)confItemEo.getRuleId())).eq(StrategyConfItemSuitEo::getSuitType, (Object)confItemEo.getStrategyType())).eq(StrategyConfItemSuitEo::getSuitValue, (Object)saleOrderRespDto.getLogicalWarehouseCode());
        List strategyConfItemSuitEos = this.strategyConfItemSuitDas.list(queryConfItemSuitEoWrapper);
        if (CollectionUtils.isNotEmpty((Collection)strategyConfItemSuitEos)) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u547d\u4e2d\u300a\u6307\u5b9a\u5b9e\u7269\u4ed3\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getCode());
            hitStrategyOrder.setHitConfItemName(CisStrategyConfItemTypeEnum.SPECIAL_WAREHOUSE.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkSpecialPaytime(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        if (saleOrderRespDto.getPerformOrderPaymentDto().getPayTime() == null) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={}, \u8ba2\u5355\u6ca1\u6709\u652f\u4ed8\u65f6\u95f4", (Object)saleOrderRespDto.getSaleOrderNo());
            return Boolean.TRUE;
        }
        Map map = (Map)JSON.parseObject((String)confItemEo.getContent(), Map.class);
        Date startTime = DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"startTime"), (String)"yyyy-MM-dd HH:mm:ss");
        Date endTime = DateUtil.parse((String)MapUtils.getString((Map)map, (Object)"endTime"), (String)"yyyy-MM-dd HH:mm:ss");
        if (saleOrderRespDto.getPerformOrderPaymentDto().getPayTime().compareTo(startTime) >= 0 && saleOrderRespDto.getPerformOrderPaymentDto().getPayTime().compareTo(endTime) <= 0) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u547d\u4e2d\u300a\u6307\u5b9a\u65f6\u95f4\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}", (Object)saleOrderRespDto.getSaleOrderNo());
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.SPECIAL_PAYTIME.getCode());
            hitStrategyOrder.setHitConfItemName(CisStrategyConfItemTypeEnum.SPECIAL_PAYTIME.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkSpecialAmount(StrategyConfItemEo confItemEo, DgPerformOrderRespDto saleOrderRespDto) {
        Map map = (Map)JSON.parseObject((String)confItemEo.getContent(), Map.class);
        BigDecimal minAmount = new BigDecimal(MapUtils.getString((Map)map, (Object)"minAmount"));
        BigDecimal maxAmount = new BigDecimal(MapUtils.getString((Map)map, (Object)"maxAmount"));
        if (minAmount.compareTo(saleOrderRespDto.getMerchantReceivableAmount()) >= 0 || saleOrderRespDto.getMerchantReceivableAmount().compareTo(maxAmount) >= 0) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u547d\u4e2d\u300a\u6307\u5b9a\u91d1\u989d\u505a\u4eba\u5de5\u5ba1\u6838\u300b\uff0c\u9700\u8981\u4eba\u5de5\u5ba1\u6838, \u8ba2\u5355\u53f7={}\uff0c\u5546\u5bb6\u5e94\u6536\u5c0f\u4e8e\u7b49\u4e8e\u914d\u7f6e\u6700\u5c0f\u91d1\u989d,\u9700\u8981\u4eba\u5de5\u5ba1\u6838\uff0c\u5546\u5bb6\u5e94\u6536\u4e3a\uff1a{}\uff0c\u914d\u7f6e\u7684\u6700\u5c0f\u91d1\u989d\u4e3a\uff1a{},\u914d\u7f6e\u6700\u5927\u91d1\u989d\u4e3a\uff1a{}", new Object[]{saleOrderRespDto.getSaleOrderNo(), saleOrderRespDto.getMerchantReceivableAmount(), minAmount, maxAmount});
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            hitStrategyOrder.setHitConfItemType(CisStrategyConfItemTypeEnum.SPECIAL_AMOUNT.getCode());
            hitStrategyOrder.setHitConfItemName(CisStrategyConfItemTypeEnum.SPECIAL_AMOUNT.getDesc());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected List<StrategyConfItemEo> queryValidRuleConfItemList(DgStrategyRuleEo dgStrategyRuleEo) {
        LambdaQueryWrapper queryConfItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryConfItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(StrategyConfItemEo::getRuleId, (Object)dgStrategyRuleEo.getId())).eq(StrategyConfItemEo::getEnable, (Object)StrategyEnableEnum.ENABLE.getType());
        List strategyConfItemEos = this.strategyConfItemDas.list(queryConfItemWrapper);
        LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u7b56\u7565\u4e2d\u751f\u6548\u7684\u914d\u7f6e\u9879\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)strategyConfItemEos));
        AssertUtils.notEmpty((Collection)strategyConfItemEos, (String)(dgStrategyRuleEo.getRuleCode() + "\u7b56\u7565\u7684\u914d\u7f6e\u9879\u5747\u4e3a\u5173\u95ed"));
        return strategyConfItemEos;
    }

    private Boolean checkPersonAudit(DgPerformOrderRespDto saleOrderRespDto, StrategyConfItemEo confItemEo) {
        if (confItemEo != null && StrategyEnableEnum.ENABLE.getType().equals(confItemEo.getEnable())) {
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u8ba2\u5355\u53f7={}, \u7b56\u7565\u5f00\u542f\u4e86\u300a\u8ba2\u5355\u5747\u4e0d\u505a\u4eba\u5de5\u5ba1\u6838\u300b", (Object)saleOrderRespDto.getSaleOrderNo());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected void handleDelayAuditByConf(StrategyConfItemEo strategyConfItemEo, DgPerformOrderRespDto saleOrderRespDto, Date startTime, DgCisStrategyOrderTypeEnum dgCisStrategyOrderTypeEnum) {
        String content = Optional.ofNullable(strategyConfItemEo.getContent()).orElse(NEED_PERSON_AUDIT_BY_REMARK);
        Integer delayTimeExe = 0;
        if (Objects.isNull(strategyConfItemEo.getContentType()) || strategyConfItemEo.getContentType().equals(CisStrategyContentTypeEnum.NUMBER.getCode())) {
            delayTimeExe = Integer.valueOf(Optional.ofNullable(content).orElse(NEED_PERSON_AUDIT_BY_REMARK));
        } else if (strategyConfItemEo.getContentType().equals(CisStrategyContentTypeEnum.STRING.getCode()) && StringUtils.isNotEmpty((CharSequence)content)) {
            HashMap map = (HashMap)JSON.parseObject((String)content, HashMap.class);
            delayTimeExe = Integer.valueOf(Optional.ofNullable(map.get("value").toString()).orElse(NEED_PERSON_AUDIT_BY_REMARK));
        }
        Date planExeTime = DateUtil.addMinutes((Date)startTime, (int)delayTimeExe);
        if (DateUtil.getDifferMinute((Date)new Date(), (Date)planExeTime) > HANDLE_TASK_BY_MQ_DELAY_THRESHOLD) {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            DgStrategyOrderReqDto updateReqDto = new DgStrategyOrderReqDto();
            updateReqDto.setId(hitStrategyOrder.getId());
            updateReqDto.setPlanExeTime(planExeTime);
            updateReqDto.setDelayExe(delayTimeExe);
            updateReqDto.setHitConfItemType(hitStrategyOrder.getHitConfItemType());
            updateReqDto.setHitConfItemName(hitStrategyOrder.getHitConfItemName());
            this.strategyOrderService.modifyStrategyOrder(updateReqDto);
        } else {
            DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
            DgStrategyOrderReqDto updateReqDto = new DgStrategyOrderReqDto();
            updateReqDto.setId(hitStrategyOrder.getId());
            updateReqDto.setDelayExe(delayTimeExe);
            updateReqDto.setHitConfItemType(hitStrategyOrder.getHitConfItemType());
            updateReqDto.setHitConfItemName(hitStrategyOrder.getHitConfItemName());
            this.strategyOrderService.modifyStrategyOrder(updateReqDto);
            MessageVo messageVo = new MessageVo();
            SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
            saleTradeMessageVo.setOrderId(saleOrderRespDto.getId());
            saleTradeMessageVo.setRuleId(strategyConfItemEo.getRuleId());
            saleTradeMessageVo.setStrategyOrderId(hitStrategyOrder.getId());
            saleTradeMessageVo.setNextOptType(StrategyHelper.chooseNextOptTypeByStrategyType(dgCisStrategyOrderTypeEnum));
            AssertUtils.notBlank((String)saleTradeMessageVo.getNextOptType(), (String)"nextOptType \u4e0d\u80fd\u4e3a\u7a7a");
            messageVo.setData((Object)saleTradeMessageVo);
            long delayTimeSeconds = planExeTime.getTime() / 1000L - new Date().getTime() / 1000L;
            long delaySeconds = Math.max(delayTimeSeconds, 0L);
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u89c4\u5219orderNo={}\u53d1\u9001mq\u6d88\u606f\uff1a{}\uff0c\u5ef6\u8fdf\uff1a{}s", new Object[]{saleOrderRespDto.getSaleOrderNo(), JSON.toJSONString((Object)messageVo), delaySeconds});
            MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessage("DELAY_AUTO_AUDIT_TAG", (Object)messageVo, Long.valueOf(delaySeconds));
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u89c4\u5219orderNo={}\u53d1\u9001mq\u7ed3\u679c\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)messageResponse));
        }
    }

    protected void saveHitConfItem() {
        DgStrategyOrderReqDto hitStrategyOrder = this.getHitStrategyOrder();
        DgStrategyOrderReqDto updateReqDto = new DgStrategyOrderReqDto();
        updateReqDto.setId(hitStrategyOrder.getId());
        updateReqDto.setHitConfItemType(hitStrategyOrder.getHitConfItemType());
        updateReqDto.setHitConfItemName(hitStrategyOrder.getHitConfItemName());
        this.strategyOrderService.modifyStrategyOrder(updateReqDto);
        if (hitStrategyOrder.getSaleOrderId() != null) {
            DgPerformOrderReqDto modifyReqDto = new DgPerformOrderReqDto();
            modifyReqDto.setId(hitStrategyOrder.getSaleOrderId());
            modifyReqDto.setInterceptType(hitStrategyOrder.getType() + "_" + hitStrategyOrder.getHitConfItemType());
            CisStrategyConfItemTypeEnum cisStrategyConfItemTypeEnum = CisStrategyConfItemTypeEnum.forCode((String)hitStrategyOrder.getHitConfItemType());
            StringBuilder builder = new StringBuilder();
            builder.append("\u547d\u4e2d\u300a").append(cisStrategyConfItemTypeEnum.getDesc()).append("\u300b\u7b56\u7565\u914d\u7f6e\u9879");
            modifyReqDto.setInterceptReason(builder.toString());
            LOGGER.info("[\u81ea\u52a8\u7b56\u7565]\u4fee\u6539\u8ba2\u5355\u7684\u62e6\u622a\u4fe1\u606f\u4e3a {}", (Object)JSON.toJSONString((Object)modifyReqDto));
            this.performOrderExtDomain.update(modifyReqDto);
        }
    }

    protected void setHitStrategyOrder(DgStrategyOrderReqDto strategyOrderReqDto) {
        AssertUtils.notNull((Object)strategyOrderReqDto, (String)"strategyOrderReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        CACHE_HIT_ITEM.set(strategyOrderReqDto);
    }

    protected DgStrategyOrderReqDto getHitStrategyOrder() {
        DgStrategyOrderReqDto strategyOrderReqDto = CACHE_HIT_ITEM.get();
        if (strategyOrderReqDto == null) {
            strategyOrderReqDto = new DgStrategyOrderReqDto();
            CACHE_HIT_ITEM.set(strategyOrderReqDto);
        }
        return strategyOrderReqDto;
    }

    protected void cleanHitStrategyOrder() {
        CACHE_HIT_ITEM.remove();
    }

    public static class MatchStrategyResult {
        private Boolean matchStrategy = Boolean.TRUE;
        private Boolean intercepted = Boolean.FALSE;

        public Boolean getMatchStrategy() {
            return this.matchStrategy;
        }

        public void setMatchStrategy(Boolean matchStrategy) {
            this.matchStrategy = matchStrategy;
        }

        public Boolean getIntercepted() {
            return this.intercepted;
        }

        public void setIntercepted(Boolean intercepted) {
            this.intercepted = intercepted;
        }
    }
}

