/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.tc.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.enums.UpdateOrderInventoryEnum;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcPerformOrderAction;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcPerformOrderHandleAction;
import com.yunxi.dg.base.center.trade.baseservice.BInventoryApiServcie;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.SaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgSaleOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.utils.TrackOptLogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgTcPerformOrderHandleActionImpl
implements IDgTcPerformOrderHandleAction {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private BInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemDomain;
    @Resource
    private IDgSaleOrderItemDomain dgSaleOrderItemDomain;
    @Resource
    private IDgTcPerformOrderAction dgTcPerformOrderAction;
    @Resource
    private ISaleOrderService saleOrderService;

    @Override
    public void setTargetWarehouse(DgBizPerformOrderReqDto addReqDto) {
        String storagePlace = addReqDto.getStoragePlace();
        if (StringUtils.isEmpty((CharSequence)storagePlace)) {
            return;
        }
        List<CsLogicWarehouseRespDto> csLogicWarehouseRespDtos = this.inventoryApiServcie.queryByCode(storagePlace);
        if (CollectionUtils.isEmpty(csLogicWarehouseRespDtos)) {
            this.logger.info("\u4f9b\u8d27\u4ed3\u672a\u5173\u8054\u903b\u8f91\u4ed3\u4fe1\u606f");
            return;
        }
        List targetLogic = csLogicWarehouseRespDtos.stream().filter(logic -> logic.getOrganizationCode().equals(addReqDto.getPerformOrderSnapshotDto().getOrganizationCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(targetLogic)) {
            this.logger.info("\u4f9b\u8d27\u4ed3\u4e0b\u7684\u5173\u8054\u903b\u8f91\u4ed3\u5e93\u5b58\u7ec4\u7ec7\u540c\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        List<String> logicCodeList = targetLogic.stream().map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
        List<CsLogicWarehousePageRespDto> logicInfoList = this.inventoryApiServcie.queryCsLogicWarehousePageRespDtoListByCodeList(logicCodeList);
        if (CollectionUtils.isEmpty(logicInfoList)) {
            this.logger.info("\u4f9b\u8d27\u4ed3\u4e0b\u7684\u5173\u8054\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
            return;
        }
        addReqDto.setTargetLogicalWarehouseCode(logicInfoList.get(0).getWarehouseCode());
        addReqDto.setTargetLogicalWarehouseName(logicInfoList.get(0).getWarehouseName());
        addReqDto.setTargetPhysicsWarehouseCode(logicInfoList.get(0).getSubordinatePhysicsWarehouseCode());
        addReqDto.setTargetPhysicsWarehouseName(logicInfoList.get(0).getSubordinatePhysicsWarehouseName());
    }

    @Override
    public RestResponse<Void> updateOrderInventory(DgPerformOrderRespDto dgPerformOrderRespDto, List<BizSaleOrderRespDto> childOrderList, SplitOrderReqDto reqDto, List<Long> deliveryOrderIdList) {
        try {
            DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
            saleOrderEo.setSaleOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
            saleOrderEo.setOrderType(dgPerformOrderRespDto.getOrderType());
            saleOrderEo.setPlatformOrderNo(dgPerformOrderRespDto.getPlatformOrderNo());
            saleOrderEo.setStoragePlace(dgPerformOrderRespDto.getStoragePlace());
            this.logger.info("\u62c6\u5355\u6210\u529f\u91ca\u653e\u4e3b\u5355\u9884\u5360\uff0c\u91cd\u65b0\u6309\u5b50\u5355\u9884\u5360\u5f00\u59cb:{}", (Object)dgPerformOrderRespDto.getSaleOrderNo());
            this.inventoryApiServcie.updateOrderInventory(UpdateOrderInventoryEnum.PARENT_CHILD, saleOrderEo, null, childOrderList);
            this.logger.info("\u62c6\u5355\u6210\u529f\u91ca\u653e\u4e3b\u5355\u9884\u5360\uff0c\u91cd\u65b0\u6309\u5b50\u5355\u9884\u5360\u6210\u529f:{}", (Object)dgPerformOrderRespDto.getSaleOrderNo());
        }
        catch (Exception e) {
            this.logger.error("\u62c6\u5355\u6210\u529f\u91ca\u653e\u4e3b\u5355\u9884\u5360\uff0c\u91cd\u65b0\u6309\u5b50\u5355\u9884\u5360\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            TrackOptLogUtils.addOrderTrackOptLog((Long)dgPerformOrderRespDto.getId(), (String)("\u62c6\u5355\u66f4\u65b0\u5e93\u5b58\u5931\u8d25:" + e.getMessage()));
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> batchReleaseChannel(List<SaleOrderRespDto> orderList) {
        this.inventoryApiServcie.batchReleaseInventory(orderList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> releaseChildPreemptMainStock(DgPerformOrderRespDto dgPerformOrderRespDto, List<SaleOrderRespDto> childOrderList) {
        ArrayList mainOrderList = Lists.newArrayList();
        DgBizSaleOrderRespDto saleOrderRespDto = new DgBizSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)dgPerformOrderRespDto, (String[])new String[0]);
        List dgSaleOrderItemRespDtos = this.dgSaleOrderItemDomain.queryOrderItemByOrderId(dgPerformOrderRespDto.getId());
        ArrayList itemExtList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemExtList, (Collection)dgSaleOrderItemRespDtos, DgSaleOrderItemExtRespDto.class);
        saleOrderRespDto.setItemList((List)itemExtList);
        mainOrderList.add(saleOrderRespDto);
        try {
            this.logger.info("\u91ca\u653e\u5b50\u5355\u5e93\u5b58\u9884\u5360\u4e3b\u5355\u6e20\u9053\u4ed3\u5e93\u5b58:{}", (Object)dgPerformOrderRespDto.getSaleOrderNo());
            this.inventoryApiServcie.preemptAndReleaseStock(mainOrderList, childOrderList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> releaseLogicStock(List<SaleOrderRespDto> saleOrderRespDtos) {
        if (CollectionUtils.isNotEmpty(saleOrderRespDtos)) {
            try {
                List<String> saleOrderNoList = saleOrderRespDtos.stream().map(SaleOrderRespDto::getSaleOrderNo).distinct().collect(Collectors.toList());
                this.logger.info("\u5b50\u5355\u903b\u8f91\u4ed3\u5e93\u5b58\u5355\u636e:{}", JSON.toJSON(saleOrderNoList));
                this.inventoryApiServcie.batchCancelLogicAndPhysicsOrder(saleOrderNoList, new ArrayList<String>());
            }
            catch (Exception e) {
                this.logger.info("\u91ca\u653e\u5b50\u5355\u903b\u8f91\u4ed3\u5e93\u5b58\u5355\u636e\u5f02\u5e38:{}", (Object)e.getMessage());
                this.logger.warn("{},{}", (Object)e.getMessage(), (Object)e);
                for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
                    TrackOptLogUtils.addOrderTrackOptLog((Long)saleOrderRespDto.getId(), (String)("\u91ca\u653e\u903b\u8f91\u4ed3\u5e93\u5b58\u5931\u8d25" + e.getMessage()));
                }
            }
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelPhysicsOrder(String saleOrderNo) {
        this.inventoryApiServcie.cancelPhysicsOrder(saleOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelLogicOrder(String saleOrderNo) {
        this.inventoryApiServcie.cancelLogicOrder(saleOrderNo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> preemptOrderInventoryBatch(Long orderId, List<BizSaleOrderRespDto> childorderRespDtos) {
        try {
            this.logger.info("\u5bfb\u6e90\u62c6\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355");
            this.inventoryApiServcie.preemptOrderInventoryBatch(childorderRespDtos);
            this.logger.info("\u5bfb\u6e90\u62c6\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.info("\u5bfb\u6e90\u62c6\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5f02\u5e38:{}", (Object)e.getMessage());
            this.logger.warn("{},{}", (Object)e.getMessage(), (Object)e);
            TrackOptLogUtils.addOrderTrackOptLog((Long)orderId, (String)PcpTradeExceptionCode.SALE_ORDER_DELIVERY_INVENTORY.buildBizException(new Object[]{e.getMessage()}).toString());
            throw PcpTradeExceptionCode.SALE_ORDER_DELIVERY_INVENTORY.buildBizException(new Object[]{e.getMessage()});
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> supplyByChannelWarehouseCodeByOrder(Long orderId) {
        DgSaleOrderEo dgSaleOrderEo = this.saleOrderService.queryEoById(orderId);
        if (Objects.isNull(dgSaleOrderEo)) {
            this.logger.info("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728={}", (Object)orderId);
            return RestResponse.VOID;
        }
        String channelWarehouseCode = dgSaleOrderEo.getChannelWarehouseCode();
        List dgSaleOrderItemRespDtos = this.dgSaleOrderItemDomain.queryOrderItemByOrderId(orderId);
        List<String> skuCodeList = dgSaleOrderItemRespDtos.stream().map(SaleOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
        this.inventoryApiServcie.supplyByChannelWarehouseCode(channelWarehouseCode, skuCodeList);
        return RestResponse.VOID;
    }
}

